#!/usr/bin/env python

import os
import sys
import json
import string
import shutil
import re
from pprint import pprint
import BaseClass

import xml.etree.ElementTree as ET

class CheckVer():
    
    def __init__(self):
        print ""

    ###########################################################################
    #
    # extractRpms(rpms)
    # Release: Y
    ###########################################################################
    def extractRpms(self, rpms):
        if os.path.exists('opt'):
           shutil.rmtree('opt')
           
        RPMCMD = 'rpm2cpio ' 
        for rpm in rpms:
          extractRPM = RPMCMD + 'rpms/%s' % rpm + ' | cpio -idm --quiet'    
          os.system(extractRPM)
          
    
    ###########################################################################
    #
    # checkIfDirs(path)
    # Release: Y
    ###########################################################################
    def checkIfDirs(self, path):
       workflows = '/opt/tandbergtv/cms/workflow/imported/'
    
       path = workflows + path
       return os.path.isdir(path)
     
    ###########################################################################
    #
    # templateFilter(templateName)
    # Release: Y
    ###########################################################################
    def templateFilter(self, templateName):
        reg = g_templateName + ' - v' + '\d+'
    	
        if re.match(reg, templateName) != None:
           return True
        return False
    		
    ###########################################################################
    #
    # getTemplateRunningVer(templateName)
    # Release: Y
    ###########################################################################		
    def getTemplateRunningVer(self, templateName):
        workflows = '/opt/tandbergtv/cms/workflow/imported/'
        
        templates = filter(self.checkIfDirs, os.listdir(workflows))
    
        global g_templateName
        g_templateName = templateName
    
        templates = filter(self.templateFilter, templates)
        if len(templates)==0 :
           return None 
        templates.sort(reverse=True)
        
        latestTemplate = templates.pop(0)
        version = re.match(r"(.+)(- v)(\d+)", latestTemplate).group(3)
        return string.atoi(version)
        
    
    ###########################################################################
    #
    # getVersion()
    # Release: Y
    ###########################################################################
    def getVersion(self, plugin):
        tree = ET.parse(plugin)
        root = tree.getroot()
    
        pluginversion = root.get('version')   
        return string.atoi(pluginversion)      

    ###########################################################################
    #
    # setResourceVer(plugin, version)
    # Release: N
    ###########################################################################
    def setResourceVer(self, plugin, version):
        tree = ET.parse(plugin)
        root = tree.getroot()
    
        root.set('version', str(version))
        tree.write(plugin)
        
    ###########################################################################
    #
    # prepareTemplates()
    # Release: Y
    ###########################################################################  
    def prepareTemplates(self):
        basedir = 'opt/tandbergtv/cms/workflow/templates/'
        
        expectResourceVer = dict()
        templates = os.listdir(basedir)
        print("Templates in the upgrade package: ")
        print(templates)
        
        unzipCMD = 'unzip -oq '
        conflictTemplates = dict()
        for template in templates:
            templateName = template[0:-4]
            tempalteFolder = basedir + templateName
            templatePar = '\"' + basedir + template + '\"'
            if not os.path.exists(tempalteFolder):
                os.mkdir(tempalteFolder)
            tempalteFolder = '\"' + tempalteFolder + '\"'
            CMD = unzipCMD + templatePar + ' -d ' + tempalteFolder
    
            os.system(CMD)
            
            #get template version in the package
            jpdlFile =  basedir + templateName + '/' + templateName + '.jpdl'
            packageVersion = self.getVersion(jpdlFile)
            
            #get template running version
            runningVersion = self.getTemplateRunningVer(templateName)
            if runningVersion!=None:
               #print(templateName + " version in the package: " + str(packageVersion))
               #print(templateName + " running version: " + str(runningVersion))
               
               if packageVersion<=runningVersion:
                  conflictTemplates[templateName] = str(packageVersion) + ',' + str(runningVersion)
            else:
               print(templateName + ' currently is not installed')
        return conflictTemplates
               
    
    ###########################################################################
    #
    # prepareResources()
    # Release: Y
    ###########################################################################
    def prepareResources(self):
        basedir = 'opt/tandbergtv/cms/workflow/plugins/subsystems/'
    
        conflictResources = dict()
        resources = os.listdir(basedir)
        print("Resources in the upgrade package: ")
        print(resources)
    
        ## Looking for plugin version which has lower than the running version
        for resource in resources:
            pluginName = basedir + resource + '/plugin.xml'
    
            packageVer = self.getVersion(pluginName)
            if os.path.exists('/'+pluginName):
               runningVer = self.getVersion('/'+pluginName)
    
               if packageVer<=runningVer :
                  conflictResources[resource] = str(packageVer) + ',' + str(runningVer)
    
        return conflictResources   

    ###########################################################################
    #
    # installRources(resources)
    # Release: N
    ###########################################################################
    def installRources(self, resources):
        print('')
        basedir = 'opt/tandbergtv/cms/workflow/plugins/subsystems/'
    
        resourcesName = resources.keys()
        for resource in resourcesName: 
            print("Installing resource: " + resource)
    
            pluginName = basedir + resource + '/plugin.xml'   
            self.setResourceVer(pluginName, resources[resource]) 
            print("  -->updating plugin version to " + str(resources[resource]))
    
            #os.mkdir('/root/'+resource)
            #os.system('cp ' + pluginName + ' /root/'+resource)
            
    
    ###########################################################################
    #
    # validateVersions(rpms)
    # Release: Y
    ###########################################################################
#    @staticmethod
#    @classmethod
    def validateVersions(self, rpms):
    
        self.extractRpms(rpms)
        conflictResources = self.prepareResources()
        conflictTemplates = self.prepareTemplates()
        conflicted = False
        
        if len(conflictResources):
           conflicted = True
           print('The following resources have lower verion than the running one: ')
           print('===============================================================')
           print('|    Resources         | Upgrade Version |   Running Version  |')
           resources = conflictResources.keys()       
           for resource in resources:
               version = conflictResources[resource]
               upgradeVer = version.split(',')[0]
               runningVer = version.split(',')[1]
               print('| ' + resource + '          |      ' + upgradeVer + \
                    '      |      ' +  runningVer + '      |')
           print('===============================================================')
                  
        print('')    
        if len(conflictTemplates):
           conflicted = True
           print('The following templates have lower verion than the running one: ')
           print('================================================================')
           print('|     Templates     |   Upgrade Version   |   Running Version   |')
           templates = conflictTemplates.keys()       
           for template in templates:
               version = conflictTemplates[template]
               upgradeVer = version.split(',')[0]
               runningVer = version.split(',')[1]
               print('| ' + template + '  |      ' + upgradeVer + \
                    '      |      ' +  runningVer + '      |')
           print('===============================================================')   
               
        if os.path.exists('opt'):
           shutil.rmtree('opt')
    
        return conflicted

###########################################################################
#
# Main
#
###########################################################################
def main():
    rpms = ['content-processing-workflows-*.rpm','envivio-adapter-*.rpm']
    checkVer = CheckVer()
    checkVer.validateVersions(rpms)
    
if __name__ == "__main__":
        main()            
        
