#!/usr/bin/env python
#
# Copyright (c) 2012 Ericsson, Inc.  All Rights Reserved.
#
# This module contains unpublished, confidential, proprietary
# material.  The use and dissemination of this material are
# governed by a license.  The above copyright notice does not
# evidence any actual or intended publication of this material.
#
# Author: Jerish Lin
# Created: Oct 17, 2013
# Description:
# Common base class

import sys
reload(sys)
sys.setdefaultencoding("utf-8")

from distutils.dir_util import copy_tree, remove_tree
import AlertNames
import Alerts
from BaseClass import BaseClass
import CustomFields
import CustomFieldsGroups
import Partners
import ProcessDefinitions
import ReportPublisher
import MeSubsProfile
import MeSubsProfileParameter
import MeFieldDefinition
import MeIdentifierCriteria
import MeEnhancedField
import EnhancementRuleset
import Resources
import Rulesets
import SelectorKeys
import SiteParameters
import Sites
import json
import os
import shutil
import socket
import time
from InstallHelper import InstallHelper
from HttpRequestDecorator import HttpRequestDecorator
from CMSVersionDeploymentPolicy import CMSVersionDeploymentPolicy,\
    PrepackDeploymentPolicy
from APPService import *

class Common(object):
    COMPONENTS_PATH_PREFIX = ""
    COMMON_SHARED_FOLDER = '/data/backupFiles'
    BACKUP_FULL_DIRS=["/opt/tandbergtv/cms/workflow/plugins/subsystems",
                      "/opt/tandbergtv/cms/workflow/plugins/groups",
                      "/opt/tandbergtv/cms/workflow/lib",
                      "/opt/tandbergtv/watchpoint/tomcat/webapps/ffmpeg",
                      "/opt/tandbergtv/cms/conf/ffmpeg",
                      "/opt/tandbergtv/watchpoint/tomcat/webapps/filemanager",
                      "/opt/tandbergtv/cms/conf/filemanager",
                      "/opt/tandbergtv/watchpoint/tomcat/webapps/imagemagick",
                      "/opt/tandbergtv/cms/conf/imagemagick",
                      "/opt/tandbergtv/watchpoint/tomcat/webapps/watchfolder",
                      "/opt/tandbergtv/cms/conf/watchfolder"]
    
    ROLLBACK_JSON="rollback.json"
    BASE_JSON="base.json"
    installMode = None
    
    ITEM_KEYS = {
        "PARTNER":{"keys":["PROVIDERID","NAME","PARTNERTYPE","CONTENTCLASSNAME"],"uniqueKeys":["PROVIDERID"],"jsonKey":"partners"},
        "PARTNER_CONTENTCLASS":{"keys":[],"uniqueKeys":[],"jsonKey":"CONTENTCLASSNAME","parent":"PARTNER","mergeNeeded":True},
        "SITE":{"keys":["NAME","EXTERNALID","ACTIVE","DISTRIBUTION_OPTION","METADATA_FORMAT","FILE_LOOKUP_KEYS","DIST_TEMPLATE_NAME","ALERT_DELAY_PERIOD","TYPE","ASSOCIATE_RESOURCE","PARAMETERS"],"uniqueKeys":["NAME"],"jsonKey":"sites"},
        "SITE_PARAMETER":{"keys":["NAME","VALUE"],"uniqueKeys":["NAME"],"jsonKey":"PARAMETERS","parent":"SITE"},
        "SELECOTRKEY":{"keys":["SELECTIONKEY","TEMPLATE"],"uniqueKeys":["SELECTIONKEY","TEMPLATE"],"jsonKey":"selectorKeys"},
        "RESOURCE":{"keys":["NAME","RESOURCETYPENAME","RESOURCEGROUPNAME","CONNECTIONSTRING","MAXCONCURRENTUSERS","HEARTBEATCONNECTIONSTRING","HEARTBEATFREQUENCY","USERNAME"],"uniqueKeys":["NAME"],"jsonKey":"resources"},
        "CUSTOMFIELDGROUP":{"keys":["DISPLAY_NAME","ASSET_PATH","UUID","FIELDS"],"uniqueKeys":["DISPLAY_NAME","ASSET_PATH"],"jsonKey":"customFields"},
        "CUSTOMFIELD":{"keys":["NAME","DATA_TYPE","JOB_PARAMETER","JOB_SCHEDULE_PARAMETER","DISPLAY_NAME","MULTIVALUE","FIELD_TYPE",],"uniqueKeys":["NAME"],"jsonKey":"FIELDS","parent":"CUSTOMFIELDGROUP","mergeNeeded":True},
        "ALERTNAME":{"keys":["ALERT_NAME","PATTERN","ALERTS"],"uniqueKeys":["ALERT_NAME"],"jsonKey":"alerts"},
        "ALERT":{"keys":["IDENTIFIER","THRESH_COUNT","THRESH_SECS","FREQ_COUNT","FREQ_SECS","SNMP_TRAP","EMAIL"],"uniqueKeys":["IDENTIFIER"],"jsonKey":"ALERTS","parent":"ALERTNAME"},
        "CONTENTCLASSES":{"keys":["NAME","DESCRIPTION","CONTENTCLASSFILES"],"uniqueKeys":["NAME"],"jsonKey":"contentClasses"},
        "CONTENTCLASSFILES":{"keys":["FILENAME",],"uniqueKeys":["FILENAME"],"jsonKey":"CONTENTCLASSFILES","parent":"CONTENTCLASSES","mergeNeeded":True},
        "CONTENTCLASSESTODELETE":{"keys":["NAME","DESCRIPTION","CONTENTCLASSFILES"],"uniqueKeys":["NAME"],"jsonKey":"contentClassesToDelete"},
        "CONTENTCLASSFILESTODELETE":{"keys":["FILENAME",],"uniqueKeys":["FILENAME"],"jsonKey":"CONTENTCLASSFILES","parent":"CONTENTCLASSESTODELETE","mergeNeeded":True},
        "RESOURCEHOSTS":{"keys":["NAME","VALUE"],"uniqueKeys":["NAME"],"jsonKey":"resourceHosts"},
        "WATCHFOLDER":{"keys":["path","filter","frequency","processClass","messageUID","commandParameter","messageParameter", "routingDir","failureDir","looseFileNamePattern","events","threads"],"uniqueKeys":["path","filter"],"jsonKey":"watchfolders"},
        "DISTTEMPLATE":{"keys":["NAME","GROUPS"],"uniqueKeys":["NAME"],"jsonKey":"distTemplates"},
        "FTPCONFIG":{"keys":["HOST","USER","PASSWORD"],"uniqueKeys":["HOST"],"jsonKey":"ftpConfig"},
        "PARAMS":{"keys":["NAME","VALUE"],"uniqueKeys":["NAME"],"jsonKey":"params"},
        
        "3.0_REPORTCONFIG_CATEGORY":{"keys":["CATEGORY","REPORTS"],"uniqueKeys":["CATEGORY"],"jsonKey":"3.0_reports"},
        "3.0_REPORTCONFIG":{"keys":["TITLE","CATALOGNAME","REPORTNAME"],"uniqueKeys":["TITLE"],"jsonKey":"REPORTS","parent":"3.0_REPORTCONFIG_CATEGORY","mergeNeeded":True},
        "ABOVE_3.0_REPORTCONFIG_CATEGORY":{"keys":["CATEGORY","REPORTS"],"uniqueKeys":["CATEGORY"],"jsonKey":"above_3.0_reports"},
        "ABOVE_3.0_REPORTCONFIG":{"keys":["TITLE","CATALOGNAME","REPORTNAME"],"uniqueKeys":["TITLE"],"jsonKey":"REPORTS","parent":"ABOVE_3.0_REPORTCONFIG_CATEGORY","mergeNeeded":True},
        
        "MESUBSPROFILE":{"keys":["NAME","PLUGIN_NAME","CRITERIA","ENHANCEDFIELD","PARAMETER"],"uniqueKeys":["NAME"],"jsonKey":"meprofiles"},
        "CRITERIA":{"keys":["NAME","MAPPING","DATATYPE","PATH","ASSET_TYPE","VALUE_FIELD_PATH"],"uniqueKeys":["NAME"],"jsonKey":"CRITERIA","parent":"MESUBSPROFILE","mergeNeeded":True},
        "ENHANCEDFIELD":{"keys":["NAME","MAPPING","DATATYPE","PATH"],"uniqueKeys":["NAME"],"jsonKey":"ENHANCEDFIELD","parent":"MESUBSPROFILE","mergeNeeded":True},
        "PARAMETER":{"keys":["NAME","VALUE"],"uniqueKeys":["NAME"],"jsonKey":"PARAMETER","parent":"MESUBSPROFILE","mergeNeeded":True}
    }
    
    def __init__(self):
        self.config = ""
        self.name = ""
        self.installerVersion = ""
        self.backupVersion = ""
        self.handleItemObjects = {}
        self.helper = InstallHelper()
    
    def getHandleItemObj(self, itemType):
        if not self.handleItemObjects.has_key(itemType):
            if itemType == "PARTNER":
                self.handleItemObjects[itemType] = Partners.Partners()
            if itemType == "SITE":
                self.handleItemObjects[itemType] = Sites.Sites()
            if itemType == "SITE_PARAMETER":
                self.handleItemObjects[itemType] = SiteParameters.SiteParameters()
            if itemType == "SELECOTRKEY":
                self.handleItemObjects[itemType] = SelectorKeys.SelectorKeys()
            if itemType == "RESOURCE":
                self.handleItemObjects[itemType] = Resources.Resources()
            if itemType == "CUSTOMFIELDGROUP":
                self.handleItemObjects[itemType] = CustomFieldsGroups.CustomFieldsGroups()
            if itemType == "CUSTOMFIELD":
                self.handleItemObjects[itemType] = CustomFields.CustomFields()
            if itemType == "ALERTNAME":
                self.handleItemObjects[itemType] = AlertNames.AlertNames()
            if itemType == "ALERT":
                self.handleItemObjects[itemType] = Alerts.AlertPolicyForCMS3X()
            if itemType == "MESUBSPROFILE":
                self.handleItemObjects[itemType] = MeSubsProfile.MeSubsProfile()
            if itemType == "CRITERIA":
                self.handleItemObjects[itemType] = MeIdentifierCriteria.MeIdentifierCriteria()
            if itemType == "ENHANCEDFIELD":
                self.handleItemObjects[itemType] = MeEnhancedField.MeEnhancedField()
            if itemType == "PARAMETER":
                self.handleItemObjects[itemType] = MeSubsProfileParameter.MeSubsProfileParameter()
                
        return self.handleItemObjects[itemType]
    
    def loadJsonConfig(self, inputfile, mergeBaseConfig=False, mergeWithExisting=False):
        self.output("Config File: " + inputfile)
        json_data = open(inputfile)
        tmpConfig = json.load(json_data)
        json_data.close()
        if mergeWithExisting:
            self.config = self.mergeConfig(self.config, tmpConfig)
        else:
            self.config = tmpConfig
        
        if mergeBaseConfig and Common.isFreshInstall() and os.path.exists(Common.BASE_JSON):
            base_data = open(Common.BASE_JSON)
            base_config = json.load(base_data)
            base_data.close()
            self.config = self.mergeConfig(self.config, base_config)
    
    def initPolicy(self):
        CMSVersionDeploymentPolicy.setCMSVersion(self.getCMSWathpointVersion())
        
        dbconfig = None
        if CMSVersionDeploymentPolicy.getCMSVersion() < 4.0:
            dbconfig = self.getConfig("oracle")
        else:
            dbconfig = self.getConfig("postgresql")
        if not dbconfig:
            raise Exception('No database configuration is found!')
        CMSVersionDeploymentPolicy.getPrepackDepolymentPolicy().initDbProvider(
                dbconfig["sid"], dbconfig["user"], dbconfig["password"], dbconfig["host"], dbconfig["port"])
    
    def initParameters(self):
        self.wrapAllConfigWithFullAttributes()
        self.name = self.getConfig("name")
        self.installerVersion = self.getConfig("version")
        self.backupVersion = self.getConfig("backupVersion")
        Common.installMode = self.getConfig("mode")
    
    def findItemKeyByJsonKey(self, jsonKey):
        for keyType in self.ITEM_KEYS:
            if jsonKey == self.ITEM_KEYS[keyType]["jsonKey"]:
                return (keyType, self.ITEM_KEYS[keyType])
        return (None, None)
    
    def findItemKeysByParent(self, parent):
        itemKeyList = []
        for keyType in self.ITEM_KEYS:
            if self.ITEM_KEYS[keyType].has_key("parent") and parent == self.ITEM_KEYS[keyType]["parent"]:
                itemKeyList.append((keyType, self.ITEM_KEYS[keyType]))
        return itemKeyList
    
    def compareItemWithKey(self, attr, item1, item2):
        keyType, itemKeys = self.findItemKeyByJsonKey(attr)
        
        keyColumn = None
        if itemKeys:
            keyColumn = itemKeys["uniqueKeys"]
        else:
            keyColumn = item1
        for column in keyColumn:
            if item1[column] != item2[column]:
                return False
        return True
        
    def findItemInList(self, attr, item, itemList):
        if type(item) == type(dict()):
            for eachItem in itemList:
                if self.compareItemWithKey(attr, item, eachItem):
                    return eachItem
        else:
            for eachItem in itemList:
                if eachItem == item:
                    return eachItem
        return None
    
    def mergeConfig(self, config1, config2):
        for attr in config2:
            if not config1.has_key(attr):
                config1[attr] = config2[attr]
            else:
                if config2[attr]:
                    if type(config2[attr]) == type(list()):
                        newItemList = []
                        for item in config2[attr]:
                            matchedItem = self.findItemInList(attr, item, config1[attr]) 
                            if matchedItem:
                                if self.getChildMergeNeeded(attr, matchedItem):
                                    self.mergeConfig(matchedItem, item)
                            else:
                                newItemList.append(item)
                        config1[attr] = newItemList + config1[attr]
        return config1
    
    def getChildMergeNeeded(self,attr,childNode):
        if type(childNode) != type(dict()):
            return False
        keyType, itemKeys = self.findItemKeyByJsonKey(attr)
        if keyType:
            for childAttr in childNode:
                for eachKeyType in self.ITEM_KEYS:
                    if self.ITEM_KEYS[eachKeyType].has_key("parent") and keyType == self.ITEM_KEYS[eachKeyType]["parent"]:
                        if childAttr == self.ITEM_KEYS[eachKeyType]["jsonKey"]:
                            return self.ITEM_KEYS[eachKeyType].has_key("mergeNeeded") and self.ITEM_KEYS[eachKeyType]["mergeNeeded"]
        return False

    def getBackupDir(self):
        return self.helper.getBackupDir(self.backupVersion)
    
    def getFileBackupDir(self):
        return self.helper.getFileBackupDir(self.backupVersion)
    
    def getPrepackInfoBackupDir(self):
        return self.helper.getPrepackInfoBackupDir(self.backupVersion)
    
    def backupFile(self, fileName):
        if os.path.exists(fileName):
            shutil.copy(fileName, fileName + '_ORIG_' + time.strftime('%Y%m%d%H%M%S'))
    
    def makeDir(self, directory):
        if not os.path.exists(directory):
            os.makedirs(directory)
            self.output("Directory not exists, make directory: " + directory)
    
    def chown(self, user, group, path, recursive=False):
        os.popen("chown %s%s:%s %s" % (["", "-R "][recursive], user, group, path))

    def checkDelVer(self, rc):
        if rc.has_key("IS_DELETE"):
            if rc["IS_DELETE"].lower() == 'true':
                return True
            else:
                return False
        else:
            return False
            
    def createSymlink(self, source, target):
        if not os.path.exists(target):
            os.symlink(source, target)
    
    def insertPartners(self, partners):
        if partners is None or not len(partners):
            return
        partner = Partners.Partners()
        for p in partners:
            for provider in p["PROVIDERID"]:
                partner.handle(provider,p["NAME"], p["PARTNERTYPE"],1,p["CONTENTCLASSNAME"],self.getIsDelete(p))
    
    def insertSites(self, sites):
        if sites is None or not len(sites):
            return
        site = Sites.Sites()
        sp = SiteParameters.SiteParameters()
        for s in sites:
            deleteSite = self.getIsDelete(s)
            site.handle(s["NAME"],s["EXTERNALID"],s["ACTIVE"],s["DISTRIBUTION_OPTION"],s["METADATA_FORMAT"],s["FILE_LOOKUP_KEYS"],s["DIST_TEMPLATE_NAME"],s["ALERT_DELAY_PERIOD"],s["TYPE"],s["ASSOCIATE_RESOURCE"], deleteSite)

            if not deleteSite and s.has_key("PARAMETERS") and s["PARAMETERS"] is not None:
                for p in s["PARAMETERS"]: 
                    sp.handle(p["NAME"], s["NAME"], p["VALUE"],self.getIsDelete(p)) 
    
    def insertSelectorKeys(self, selectorKeys):
        if selectorKeys is None or not len(selectorKeys):
            return
        
        selectorKey = SelectorKeys.SelectorKeys()
        for sk in selectorKeys:
            selectorKey.handle(sk["SELECTIONKEY"],sk["TEMPLATE"],self.getIsDelete(sk))
            
    
    def insertCustomFieldsGroups(self, cfgs):
        if cfgs is None or not len(cfgs):
            return
        customFieldsGroups = CustomFieldsGroups.CustomFieldsGroups()
        for cfg in cfgs:
            isDelete = self.getIsDelete(cfg)
            customFieldsGroups.handle(cfg["DISPLAY_NAME"],cfg["ASSET_PATH"],cfg["UUID"],isDelete)
            if not isDelete:
                self.insertCustomFields(cfg["DISPLAY_NAME"],cfg["ASSET_PATH"],cfg["FIELDS"]) 
    
    def insertCustomFields(self, groupName,assetPath,cfs):
        if cfs is None or not len(cfs):
            return
        customFields = CustomFields.CustomFields()
        for cf in cfs:
            customFields.handle(cf["NAME"],groupName,assetPath,cf["DATA_TYPE"],cf["JOB_PARAMETER"],cf["JOB_SCHEDULE_PARAMETER"],cf["DISPLAY_NAME"],cf["MULTIVALUE"],cf["FIELD_TYPE"],self.getIsDelete(cf))
    
    def insertResources(self, rs):
        if rs is None or not len(rs):
            return
        resources = Resources.Resources()
        for r in rs:
            ## CMS2.5 has extra FUNCTIONALTYPE at end -> not enough values
            resources.handle(r["NAME"],r["RESOURCETYPENAME"],r["RESOURCEGROUPNAME"],r["CONNECTIONSTRING"],r["MAXCONCURRENTUSERS"],2,2,r["HEARTBEATCONNECTIONSTRING"],r["HEARTBEATFREQUENCY"],1,1,r["USERNAME"],'',self.getIsDelete(r))
                
    def insertAlerts(self, alerts):
        if alerts is None or not len(alerts):
            return
        
        CMSVersionDeploymentPolicy.getPrepackDepolymentPolicy().insertAlerts(alerts, self)

    def handleMeSubsProfiles(self, meprofiles):
        if meprofiles is None or not len(meprofiles):
            return
        profile = MeSubsProfile.MeSubsProfile()
        for meProfile in meprofiles:
            
            if (not self.getIsDelete(meProfile)):
                profile.handle(meProfile["NAME"], meProfile["PLUGIN_NAME"], self.getIsDelete(meProfile))
                self.handleMeIdentifirerCriteria(meProfile["NAME"], meProfile["CRITERIA"])
                self.handleMeEnhancedField(meProfile["NAME"], meProfile["ENHANCEDFIELD"])
                self.handleMeSubsProfileParameter(meProfile["NAME"], meProfile["PARAMETER"])
            else:
                profile.handle(meProfile["NAME"], meProfile["PLUGIN_NAME"], True)
                
    def handleMeIdentifirerCriteria(self, meProfileName, criterias):
        if criterias is None or not len(criterias):
            return
        criteria = MeIdentifierCriteria.MeIdentifierCriteria()
        for c in criterias:
            criteria.handle(c["NAME"], meProfileName, c["MAPPING"], c["DATATYPE"], c["PATH"], c["ASSET_TYPE"], c["VALUE_FIELD_PATH"], self.getIsDelete(c))
            
    def handleMeEnhancedField(self, meProfileName, enhancedFields):
        if enhancedFields is None or not len(enhancedFields):
            return
        enhancedField = MeEnhancedField.MeEnhancedField()
        for ef in enhancedFields:
            enhancedField.handle(ef["NAME"], meProfileName, ef["MAPPING"], ef["DATATYPE"], ef["PATH"], self.getIsDelete(ef))
            
    def handleMeSubsProfileParameter(self, meProfileName, parameters):
        if parameters is None or not len(parameters):
            return
        parameter = MeSubsProfileParameter.MeSubsProfileParameter()
        for p in parameters:
            parameter.handle(p["NAME"], meProfileName, p["VALUE"], self.getIsDelete(p))
                
    #===========================================================================
    # Export specify ruleSet to file
    #===========================================================================
    def exportRules(self, ruleSetId, outputPath, username, password):
        """
        ruleSetId     The id of ruleSet
                      export all rules if ruleSetId == '-101'
        outputPath    The rules XML output path
        username      login user name of rest service 
        password      login password of rest service 
        """
        rsService = CMSVersionDeploymentPolicy.getPrepackDepolymentPolicy().getRuleServiceProvider()
        rsService.exportRulesetById(ruleSetId, outputPath, username, password)
        
    def importRules(self, ruleSets,username,password):
        if ruleSets is None or not len(ruleSets):
            return

        enhancementRuleset = EnhancementRuleset.EnhancementRuleset()        
        for rs in ruleSets:
            filePath = rs["FILENAME"]
            self.output("import ruleSets " + filePath)
            
            if enhancementRuleset.hasMetadataEnhancementRuleset(filePath):
                enhancementRuleset.replaceWithProfileId(filePath)
            
            self.importRulesFromXml(rs["FILENAME"], username, password)
                    
    def importRulesFromXml(self, path, username, password):
        rsService = CMSVersionDeploymentPolicy.getPrepackDepolymentPolicy().getRuleServiceProvider()
        rsService.importRulesets(path, username, password)
        
    # End importRules
    
    def enableRuleset(self, rulename):
        rulesets = Rulesets.Rulesets(self.config["cms"]["user"], self.config["cms"]["password"])
        tempList = []
        tempList.append(rulename.replace("'", "''"))
        rulesets.enable(tempList)
        
    def sortRuleSet(self):
        print "Sorting ruleset"
        cwd = os.path.dirname(os.path.realpath(__file__))
        inputfile = os.path.dirname(cwd) + '/components/BASE/ruleset_order_config.json'
        if not os.path.exists(inputfile):
            return False;
        json_data = open(inputfile)
        ruleset_config = json.load(json_data)
        json_data.close()
        uuids = [r['uuid'] for r in ruleset_config['sorted_ruleset_uuids']]
        rulesets = Rulesets.Rulesets(self.config["cms"]["user"], self.config["cms"]["password"])
        return rulesets.sortByUuids(uuids)
    
    def deleteRuleSets(self, ruleSetFiles):
        if ruleSetFiles:
            rulesets = Rulesets.Rulesets(self.config["cms"]["user"], self.config["cms"]["password"])
            for ruleSetFile in ruleSetFiles:
                uuids = rulesets.getUuidsFromXml(self.getItemConfigValue(ruleSetFile, "FILENAME"))
                if not rulesets.deleteRulSetsByUuid(uuids):
                    print 'Failed to delete rule set: ', uuids
        
    
    def disableProcessDefinitions(self, templates):
        if templates is None or not len(templates):
            return
        pds = ProcessDefinitions.ProcessDefinitions()
        for tpl in templates:
            pds.disable(tpl)
    
    def configureDatabase(self, queries):
        if queries is None or not len(queries):
            return
        connection = CMSVersionDeploymentPolicy.getPrepackDepolymentPolicy().getDatabaseConnection()
        for query in queries:
            try:
                print query["QUERY"]
                connection.cursor().execute(query["QUERY"])
                if query["COMMIT"] is not None and str(query["COMMIT"]).lower() == "true":
                    connection.commit()
            except Exception, e:
                print e
                connection.rollback()                
        time.sleep(.1)
     
    def unstallRpms(self, rpms):
        CMD_UNINSTALL = "rpm -ev "
        if rpms:
            for rpm in rpms:
                CMD = CMD_UNINSTALL + rpm
                print CMD
                os.system(CMD)
        return True
    
    def _rollbackFiles(self, fileOrDirToDeleteConfigName, targetBackupDir):
        """
        roll back files (including directory)
        """
        files = []
        if self.config.has_key(fileOrDirToDeleteConfigName):
            files = self.config[fileOrDirToDeleteConfigName]
            
        for file in files:
            # Delete files
            print "Deleting file or directory: " + file
            if os.path.isdir(file):
                remove_tree(file)
            elif os.path.isfile(file):
                os.remove(file)
                
        # Copy original files/dirs back
        if os.path.exists(targetBackupDir):
            for f in os.listdir(targetBackupDir):
                dest = os.sep + f
                src = targetBackupDir + dest
                if os.path.isdir(src):
                    print "Copying " + src + " --> " + dest
                    try:
                        cp_cmd = 'rsync -K -a "%s" "%s"' % (src, os.sep)
                        os.popen(cp_cmd)
                    except Exception, e:
                        #Ignore the error, gennerally, it's due to file already exist
                        print e
                        pass                        
            # Change ownership to nobody
            try:
                for path, dirs, files in os.walk(os.path.abspath(targetBackupDir+os.sep+"opt")):
                    for dir in dirs:
                        # handle directories containing space
                        absDir = "\"" + os.path.join(path[path.index('opt',3)-1:], dir) + "\""
                        self.chown("nobody", "nobody", absDir, True)
        
                    for file in files:
                        # handle files containing space
                        absFile = "\"" + os.path.join(path[path.index('opt',3)-1:], file) + "\""
                        self.chown("nobody", "nobody", absFile, True)    
            except Exception:
                pass
            
    def rollbackFiles(self):
        fileBackupDir = self.getFileBackupDir()
        self._rollbackFiles("fileOrDirToDelete", fileBackupDir)
    
    def executeScripts(self, scripts):
        if scripts is None or not len(scripts):
            return
        for script in scripts:
            print os.popen("sh " + script, "r").read()
            
    def output(self, outputstr):
        '''Writes print statements to log as well as to screen'''
        print outputstr
    
    # End output
    
    def ip(self, hostname):
        return socket.gethostbyname(hostname)
    
    def getConfig(self, name):
        if self.config.has_key(name):
            return self.config[name]
    
    def wrapConfigWithFullAttributes(self,configItem, type):
        for attr in self.ITEM_KEYS[type]["keys"]:
            if not configItem.has_key(attr):
                configItem[attr] = None
        return configItem 
    
    def wrapConfigListWithFullAttributes(self, configList, type):
        if configList is None:
            return
        for configItem in configList:
            self.wrapConfigWithFullAttributes(configItem, type)
    
    def wrapAllConfigWithFullAttributes(self):
        for itemKey in self.ITEM_KEYS:
            itemKeyObj = self.ITEM_KEYS[itemKey]
            if itemKeyObj.has_key("parent"):
                parentConfig = self.getConfig(self.ITEM_KEYS[itemKeyObj["parent"]]["jsonKey"])
                if parentConfig is not None:
                    for parentConfigItem in parentConfig:
                        if parentConfigItem.has_key(itemKeyObj["jsonKey"]):
                            self.wrapConfigListWithFullAttributes(parentConfigItem[itemKeyObj["jsonKey"]],itemKey)
            else:
                self.wrapConfigListWithFullAttributes(self.getConfig(itemKeyObj["jsonKey"]),itemKey)
    
    def getItemKeyArray(self, type):
        return self.ITEM_KEYS[type]["keys"]
    
    def getItemJsonKey(self, type):
        return self.ITEM_KEYS[type]["jsonKey"]
    
    def getItemUniqueKeyArray(self, type):
        return self.ITEM_KEYS[type]["uniqueKeys"]
    
    @staticmethod
    def isUpgradeMode():
        return Common.installMode is not None and Common.installMode.upper() == 'UPGRADE'
    
    @staticmethod
    def isPatchMode():
        return Common.installMode is not None and Common.installMode.upper() == 'PATCH'
    
    @staticmethod
    def isFreshInstall():
        return not Common.isUpgradeMode() and not Common.isPatchMode()
        
    def restartAlerts(self):
        self.output("restarting alerts")
        if CMSVersionDeploymentPolicy.getCMSVersion() < 4.0:
            os.popen("service alerts restart", "r")
        else:
            from SSHCommander import SSHCommander 
            
            # nohup will redirect stdout/stderr to a waste file anyway,
            # so I squelch it here, and only check its "status" below
            cmdstr = "su root -c 'nohup /sbin/service logstash restart > /dev/null 2>&1'"
            csnodes = self.getConfig("cluster_service_nodes");
            
            for nd in csnodes:
                print "restarting logstash on " + nd['ip']
                client = None
                try:
                    client = SSHCommander(nd['ip'], nd['user'], nd['password'])
                    status, output = client.execute_interactive(cmdstr, nd['rootPasswd'])
                    if status != 0:
                        print("failed to restart logstash on " + nd['ip'])
                except Exception:
                    raise   # NOP
                finally:
                    if client:
                        client.logout()

    def buildServiceObjectsByName(self, serviceName, nodes_conf_name):
        arr_nodes = self.getConfig(nodes_conf_name);
        
        clusterServices = []
         
        if arr_nodes == None:
            return clusterServices       
    
        for node in arr_nodes:
            rootPassword = None
            if node.has_key("rootPasswd"):
                rootPassword = node["rootPasswd"]
            
            service = None
            if serviceName == 'cms':
                service = CMSService(node["ip"], node["user"], node["password"], rootPassword)
            elif serviceName == 'tomcat':
                service = TomcatService(node["ip"], node["user"], node["password"], rootPassword)
            elif serviceName == 'vsftpd':
                service = FTPService(node["ip"], node["user"], node["password"], rootPassword)
            elif serviceName == 'workflow' and CMSVersionDeploymentPolicy.getCMSVersion() >= 5.0:
                service = WorkflowService(node["ip"], node["user"], node["password"], rootPassword)
            elif serviceName == 'workflow' and CMSVersionDeploymentPolicy.getCMSVersion() < 5.0:
                service = None
            else:
                service = GenericService(serviceName, node["ip"], node["user"], node["password"], rootPassword)
            
            if service is not None:
                clusterServices.append(service)
                
        return clusterServices      
    
    def stopServiceInClusterNodes(self, services, nodes_conf_name="cluster_app_nodes"):
        for serviceName in services:
            clusterServiceObjects = self.buildServiceObjectsByName(serviceName, nodes_conf_name)
            
            for service in clusterServiceObjects:
                service.stop()
        
    def startServiceInClusterNodes(self, services, waitForUp=True, nodes_conf_name="cluster_app_nodes"):
        for serviceName in services:
            clusterServiceObjects = self.buildServiceObjectsByName(serviceName, nodes_conf_name)
                    
            for service in clusterServiceObjects:
                if service is not None:
                    service.start()
                    
            if waitForUp:
                for service in clusterServiceObjects:
                    if not service.waitforServiceUp():
                        raise Exception('Failed to startup a service.')

    def restartServiceInClusterNodes(self, services, waitForUp=True, nodes_conf_name="cluster_app_nodes"):
        for serviceName in services:
            clusterServiceObjects = self.buildServiceObjectsByName(serviceName, nodes_conf_name)
                    
            for service in clusterServiceObjects:
                if service is not None:
                    service.restart()
                    
            if waitForUp:
                for service in clusterServiceObjects:
                    if not service.waitforServiceUp():
                        raise Exception('Failed to startup a service.')
        
    def stopLocalServices(self, services):
        for serviceName in services:
            service = self._getLocalServiceObject(serviceName)
            if service is None:
                continue
            
            print "stopping %s service on localhost" % serviceName
            service.stop()
        
    def restartLocalServices(self, services, waitForUp=True):
        for serviceName in services:
            service = self._getLocalServiceObject(serviceName)
            if service is None:
                continue
            
            print "restarting %s service on localhost, this can take a few minutes" % serviceName
            service.restart()
            if not waitForUp:
                return True
            
            service.waitforServiceUp()
    
    def _getLocalServiceObject(self, serviceName):
        service = None
        
        if serviceName == 'cms':
            service = CMSService(isNative=True)
        elif serviceName == 'tomcat':
            service = TomcatService(isNative=True)
        elif serviceName == 'vsftpd':
            service = FTPService(isNative=True)
        elif serviceName == 'workflow' and CMSVersionDeploymentPolicy.getCMSVersion() >= 5.0:
            service = WorkflowService(isNative=True)
        elif serviceName == 'workflow' and CMSVersionDeploymentPolicy.getCMSVersion() < 5.0:
            service = None
        else:
            service = GenericService(svcname=serviceName, isNative=True)  
        
        return service
            
    def waitForOtherServersAvailable(self):
        return ReportPublisher.ReportPublisher.checkAndWaitReportServerAvailable() and \
            Rulesets.Rulesets.checkAndWaitRullServiceAvailable() and \
            Sites.Sites.checkAndWaitSiteServiceAvailable()
    
    def getCMSWathpointVersion(self):    
        versionString = os.popen("rpm -qi watchpoint-cms  | grep Version | awk '{print $3}'", "r").read().strip() 
        if versionString is not None and len(versionString) > 0:
            # After 3.1, RPM is used instead of conary to manage CMS package
            return versionString
        else:
            # If reach this point, it means the cms version is before 3.1
            versionString = os.popen("conary q | grep watchpoint-cms | awk '{print $1}' | cut -d '=' -f2", "r").read().strip()
            return versionString
    
    #get list of file info objects for files of particular extensions 
    def listDirectory(self, directory, fileExtList):
        fileList = [os.path.normcase(f) 
                for f in os.listdir(directory)]             
        fileList = [os.path.join(directory, f) 
                for f in fileList 
                if os.path.splitext(f)[1] in fileExtList]
        return fileList
    
    def getItemConfigValue(self, item, name):
        if not item.has_key(name):
            return None
        else:
            return item[name]
    
    def getIsDelete(self, item):
        isDelete = self.getItemConfigValue(item, "IS_DELETE")
        return isDelete is not None and str(isDelete).lower() == "true"
    
    def getRaname(self, item):
        rename = self.getItemConfigValue(item, "RENAME")
        return rename
