from UnittestBase import UnittestBase
from ComponentSelectionConfig import ComponentSelectionConfig
from InstallComponentBuilder import InstallComponentBuilder

class ComponentSelectionConfigTest(UnittestBase):
    
    def testConvertComponentSelectionConfig(self):
        componentSelectionConfig = ComponentSelectionConfig.fromJson(self.createFullComponentSelectionConfigs())
        self.assertEqual(componentSelectionConfig.rootSelection[0], "DOWNSTREAMS")
        self.assertEqual(componentSelectionConfig.rootSelection[1], "DEVICES")
        
        deviceConfig = componentSelectionConfig.getSelectionConfig("DEVICES")
        self.assertEqual(deviceConfig.displayName, "Devices")
        self.assertEqual(len(deviceConfig.selections), 4)
        self.assertEqual(deviceConfig.selections[0], "QC")
        self.assertEqual(deviceConfig.selections[1], "TRANSCODE")
        self.assertEqual(deviceConfig.selections[2], "ENCRYPTION")
        self.assertEqual(deviceConfig.selections[3], "COMBINER")
        self.assertFalse(deviceConfig.singleSelection)
        self.assertTrue(deviceConfig.availableComponents is None)
        self.assertTrue(deviceConfig.autoSelectComponents is None)
        
        xpmpConfig = componentSelectionConfig.getSelectionConfig("XPMP") 
        self.assertEqual(xpmpConfig.displayName, "XPMP")
        self.assertEqual(len(xpmpConfig.selections), 0)
        self.assertTrue(xpmpConfig.singleSelection)
        self.assertEqual(len(xpmpConfig.availableComponents), 2)
        self.assertEqual(len(xpmpConfig.autoSelectComponents), 2)

        backConfig = componentSelectionConfig.getSelectionConfig("BACK") 
        self.assertEqual(backConfig.displayName, "Back To Last")
    
    def testConstructInstallComponentsByComponentSelections(self):
        componentSelectionConfig = ComponentSelectionConfig.fromJson(self.createFullComponentSelectionConfigs())
        
        installComponents = componentSelectionConfig.constructInstallComponents().getSubComponents()
        self.assertEqual(2, len(installComponents))
        self.assertEqual("DOWNSTREAMS", installComponents[0].componentName)
        self.assertEqual(6, len(installComponents[0].getSubComponents()))
        self.assertEqual("DEVICES", installComponents[1].componentName)
        self.assertEqual(4, len(installComponents[1].getSubComponents()))
        
        self.assertEqual("QC", installComponents[1].getSubComponents()[0].componentName)
        self.assertEqual(3, len(installComponents[1].getSubComponents()[0].getSubComponents()))
        self.assertEqual("TRANSCODE", installComponents[1].getSubComponents()[1].componentName)
        self.assertEqual(5, len(installComponents[1].getSubComponents()[1].getSubComponents()))
        self.assertEqual("ENCRYPTION", installComponents[1].getSubComponents()[2].componentName)
        self.assertEqual(1, len(installComponents[1].getSubComponents()[2].getSubComponents()))
        
        self.assertEqual("BATON", installComponents[1].getSubComponents()[0].getSubComponents()[0].componentName)
        self.assertEqual(0, len(installComponents[1].getSubComponents()[0].getSubComponents()[0].getSubComponents()))
        self.assertEqual("CERIFY", installComponents[1].getSubComponents()[0].getSubComponents()[1].componentName)
        self.assertEqual(0, len(installComponents[1].getSubComponents()[0].getSubComponents()[1].getSubComponents()))
        
        self.assertEqual("ENVIVIO", installComponents[1].getSubComponents()[1].getSubComponents()[0].componentName)
        self.assertEqual(0, len(installComponents[1].getSubComponents()[1].getSubComponents()[0].getSubComponents()))
        self.assertEqual("ELEMENTAL", installComponents[1].getSubComponents()[1].getSubComponents()[1].componentName)
        self.assertEqual(0, len(installComponents[1].getSubComponents()[1].getSubComponents()[1].getSubComponents()))
        self.assertEqual("TITAN", installComponents[1].getSubComponents()[1].getSubComponents()[2].componentName)
        self.assertEqual(0, len(installComponents[1].getSubComponents()[1].getSubComponents()[2].getSubComponents()))
        self.assertEqual("RHOZET", installComponents[1].getSubComponents()[1].getSubComponents()[3].componentName)
        self.assertEqual(0, len(installComponents[1].getSubComponents()[1].getSubComponents()[3].getSubComponents()))
        self.assertEqual("DIGITALRAPID", installComponents[1].getSubComponents()[1].getSubComponents()[4].componentName)
        self.assertEqual(0, len(installComponents[1].getSubComponents()[1].getSubComponents()[4].getSubComponents()))
        
        self.assertEqual("VERIMATRIX", installComponents[1].getSubComponents()[2].getSubComponents()[0].componentName)
        self.assertEqual(0, len(installComponents[1].getSubComponents()[2].getSubComponents()[0].getSubComponents()))
        
        self.assertEqual("AMS", installComponents[0].getSubComponents()[0].componentName)
        self.assertEqual(0, len(installComponents[0].getSubComponents()[0].getSubComponents()))
        self.assertEqual("MEDIAROOM", installComponents[0].getSubComponents()[1].componentName)
        self.assertEqual(0, len(installComponents[0].getSubComponents()[1].getSubComponents()))
        self.assertEqual("OTT", installComponents[0].getSubComponents()[2].componentName)
        self.assertEqual(0, len(installComponents[0].getSubComponents()[2].getSubComponents()))
        self.assertEqual("MSMW_MDMS", installComponents[0].getSubComponents()[3].componentName)
        self.assertEqual(0, len(installComponents[0].getSubComponents()[3].getSubComponents()))
        self.assertEqual("MSMW_OS", installComponents[0].getSubComponents()[4].componentName)
        self.assertEqual(0, len(installComponents[0].getSubComponents()[4].getSubComponents()))
        self.assertEqual("XPMP", installComponents[0].getSubComponents()[5].componentName)
        self.assertEqual(0, len(installComponents[0].getSubComponents()[5].getSubComponents()))    
    
    def testConstructComponentSelectionsByComponents(self):
        installComponents = self.buildInstallComponet()
        componentSelectionConfig = ComponentSelectionConfig.constructFromInstallComponents(installComponents, ComponentSelectionConfig.fromJson(self.createFullComponentSelectionConfigs()))
        
        self.assertEqual(componentSelectionConfig.rootSelection[0], "DEVICES")
        self.assertEqual(componentSelectionConfig.rootSelection[1], "DOWNSTREAMS")
        
        deviceConfig = componentSelectionConfig.getSelectionConfig("DEVICES")
        self.assertEqual(deviceConfig.displayName, "Devices")
        self.assertEqual(len(deviceConfig.selections), 2)
        self.assertEqual(deviceConfig.selections[0], "QC")
        self.assertEqual(deviceConfig.selections[1], "TRANSCODE")
        self.assertFalse(deviceConfig.singleSelection)
        self.assertTrue(deviceConfig.availableComponents is None)
        self.assertTrue(deviceConfig.autoSelectComponents is None)
        
        self.assertEqual(len(componentSelectionConfig.getSelectionConfig("QC").selections), 2)
        self.assertEqual(len(componentSelectionConfig.getSelectionConfig("BATON").selections), 0)
        self.assertEqual(len(componentSelectionConfig.getSelectionConfig("CERIFY").selections), 0)
        
        self.assertEqual(len(componentSelectionConfig.getSelectionConfig("TRANSCODE").selections), 2)
        self.assertEqual(len(componentSelectionConfig.getSelectionConfig("ELEMENTAL").selections), 0)
        self.assertEqual(len(componentSelectionConfig.getSelectionConfig("ENVIVIO").selections), 0)
        
        self.assertEqual(len(componentSelectionConfig.getSelectionConfig("DOWNSTREAMS").selections), 3)
        self.assertEqual(len(componentSelectionConfig.getSelectionConfig("AMS").selections), 0)
        self.assertEqual(len(componentSelectionConfig.getSelectionConfig("MEDIAROOM").selections), 0)
        
        xpmpConfig = componentSelectionConfig.getSelectionConfig("XPMP") 
        self.assertEqual(xpmpConfig.displayName, "XPMP")
        self.assertEqual(len(xpmpConfig.selections), 0)
        self.assertTrue(xpmpConfig.singleSelection)
        self.assertEqual(len(xpmpConfig.availableComponents), 2)
        self.assertEqual(len(xpmpConfig.autoSelectComponents), 2)
    
    def testCollectAvailableComponentsForSelectedItems(self):
        componentSelectionConfig = ComponentSelectionConfig.fromJson(self.createFullComponentSelectionConfigs())
        selectedItems = ["XPMP"]
        availableComponents = componentSelectionConfig.collectAvailableComponentsForSelectedItems(selectedItems).getSubComponents()
        self.assertEqual("DEVICES", availableComponents[0].componentName)
        self.assertEqual(2, len(availableComponents[0].getSubComponents()))
        
        self.assertEqual("QC", availableComponents[0].getSubComponents()[0].componentName)
        self.assertEqual(1, len(availableComponents[0].getSubComponents()[0].getSubComponents()))
        self.assertEqual("COMBINER", availableComponents[0].getSubComponents()[1].componentName)
        self.assertEqual(0, len(availableComponents[0].getSubComponents()[1].getSubComponents()))
        
        self.assertEqual("VERIFIER", availableComponents[0].getSubComponents()[0].getSubComponents()[0].componentName)
        self.assertEqual(0, len(availableComponents[0].getSubComponents()[0].getSubComponents()[0].getSubComponents()))
        
        selectedItems = ["AMS"]
        availableComponents = componentSelectionConfig.collectAvailableComponentsForSelectedItems(selectedItems).getSubComponents()
        self.assertEqual("DEVICES", availableComponents[1].componentName)
        self.assertEqual(3, len(availableComponents[1].getSubComponents()))
        
        self.assertEqual("QC", availableComponents[1].getSubComponents()[0].componentName)
        self.assertEqual(3, len(availableComponents[1].getSubComponents()[0].getSubComponents()))
        self.assertEqual("TRANSCODE", availableComponents[1].getSubComponents()[1].componentName)
        self.assertEqual(5, len(availableComponents[1].getSubComponents()[1].getSubComponents()))
        self.assertEqual("ENCRYPTION", availableComponents[1].getSubComponents()[2].componentName)
        self.assertEqual(1, len(availableComponents[1].getSubComponents()[2].getSubComponents()))
        
    
    def buildInstallComponet(self):
        return InstallComponentBuilder().buildInstallComponents([
            "DEVICES/QC/BATON",
            "DEVICES/QC/CERIFY",
            "DEVICES/TRANSCODE/ELEMENTAL",
            "DEVICES/TRANSCODE/ENVIVIO",
            "DOWNSTREAMS/AMS",
            "DOWNSTREAMS/MEDIAROOM",
            "DOWNSTREAMS/XPMP"
        ])
    
    def createFullComponentSelectionConfigs(self):
        return {
            "selectionItems": [
                "DOWNSTREAMS",
                "DEVICES"
            ],
            
            "DEVICES":{
                "displayName":"Devices",
                "selections" : [
                    "QC",
                    "TRANSCODE",
                    "ENCRYPTION",
                    "COMBINER"
                ]
            },
        
            "QC":{
                "displayName":"QC",
                "selections":[
                    "BATON",
                    "CERIFY",
                    "VERIFIER"
                ]
            },
            
            "TRANSCODE":{
                "displayName":"Transcoder",
                "selections":[
                    "ENVIVIO",
                    "ELEMENTAL",
                    "TITAN",
                    "RHOZET",
                    "DIGITALRAPID"
                ]
            },
            
            "ENCRYPTION":{
                "displayName":"Encryptor",
                "selections":[
                    "VERIMATRIX"
                ]
            },
            
            "COMBINER":{
                "displayName":"Combiner"
            },
            
            "BATON":{
                "displayName":"Baton"
            },
            
            "CERIFY":{
                "displayName":"Cerify"
            },
            
            "VERIFIER":{
                "displayName":"Verifier"
            },
        
            "ENVIVIO":{
                "displayName":"Envivio"
            },
            
            "ELEMENTAL":{
                "displayName":"Elemental"
            },
            
            "TITAN":{
                "displayName":"Titan"
            },
            
            "RHOZET":{
                "displayName":"Rhozet"
            },
            
            "DIGITALRAPID":{
                "displayName":"DigitalRapid"
            },
            
            "VERIMATRIX":{
                "displayName":"Verimatrix"
            },
            
            "DOWNSTREAMS":{
                "displayName":"Downstreams",
                "selections" : [
                    "AMS",
                    "MEDIAROOM",
                    "OTT",
                    "MSMW_MDMS",
                    "MSMW_OS",
                    "XPMP"
                ]
            },
            
            "AMS":{
                "displayName":"AMS",
                "unAvailableComponents":[
                    "DEVICES/COMBINER"
                ],
            },
            
            "MEDIAROOM":{
                "displayName":"Mediaroom"
            },
            
            "OTT":{
                "displayName":"OTT"
            },
            
            "MSMW_MDMS":{
                "displayName":"Msmw with MDMS"
            },
            
            "MSMW_OS":{
                "displayName":"Msmw with Openstream"
            },
            
            "XPMP":{
                "displayName":"XPMP",
                "availableComponents":[
                    "DEVICES/QC/VERIFIER",
                    "DEVICES/COMBINER"
                ],
                "autoSelectComponents":[
                    "DEVICES/QC/VERIFIER",
                    "DEVICES/COMBINER"
                ],
                "singleSelection": True
            },
            
            "BACK":{
                "displayName":"Back To Last"
            }
        }