#
# Copyright (c) 2013 Ericsson, Inc.  All Rights Reserved.
#
# This module contains unpublished, confidential, proprietary
# material.  The use and dissemination of this material are
# governed by a license.  The above copyright notice does not
# evidence any actual or intended publication of this material.
#
# Author: Jackie Li
# Created: Dec 30, 2013
# Description: A class Test ContentClassDiffer
import unittest
from ContentClassDiffer import ContentClassDiffer
from UnittestBase import UnittestBase

class ContentClassDifferTest(UnittestBase):
    def setUp(self):
        UnittestBase.setUp(self)

    def testCompareSameContentClassFiles(self):
        srcContentClassFile = "res/contentClassDifferTestData/ContentClassesSrc.xml"
        targetContentClassFile = srcContentClassFile
        result = dict()
        ContentClassDiffer.diffContentClassFiles(srcContentClassFile, targetContentClassFile,result)
        if len(result.keys()) != 0:
            raise RuntimeError("Test Failed: Expected no difference in these two files")

    def testAssetAttributeAdd_Delete_Update(self):
        srcContentClassFile = "res/contentClassDifferTestData/ContentClassesSrc.xml"
        targetContentClassFile = "res/contentClassDifferTestData/ContentClassesAssetAttributesModified.xml"
        result = dict()
        ContentClassDiffer.diffContentClassFiles(srcContentClassFile, targetContentClassFile,result)
        if (result.get("/contentClass/metadata/PACKAGE/MOVIE/LOGICALCLIP/hideFileView") != "attribute value is different: src(true) vs target(false)" 
        or result.get("/contentClass/metadata/PACKAGE/max") != "attribute value is different: src(1) vs target(2)"
        or result.get("/contentClass/metadata/PACKAGE/BARKER/New Attributes Found") != "hideFileView"
        or result.get("/contentClass/metadata/PACKAGE/TITLE/Attributes Not Found") != "hideFileView"):
            raise RuntimeError("Test Failed")
        
    def testFieldOptionAdd_Delete_Update(self):
        srcContentClassFile = "res/contentClassDifferTestData/ContentClassesSrc.xml"
        targetContentClassFile = "res/contentClassDifferTestData/ContentClassesFieldOptionModified.xml"
        result = dict()
        ContentClassDiffer.diffContentClassFiles(srcContentClassFile, targetContentClassFile,result)
        if (result.get("/contentClass/metadata/PACKAGE/Fields/CreationInfo/Sources/Source/Role/Name/Director") != "option value is different: src(DIRECTOR) vs target(DIRECTOR_Updated)" 
        or result.get("/contentClass/metadata/PACKAGE/ENCRYPTED/Fields/CreationInfo/Sources/Source/Role/Name/Options Not Found") != "Host,Executive Producer"
        or result.get("/contentClass/metadata/PACKAGE/Fields/CreationInfo/Sources/Source/Role/Name/Options Not Found") != "Creator,Author,Actor"
        or result.get("/contentClass/metadata/PACKAGE/Fields/CreationInfo/Sources/Source/Role/Name/New Options Found") != "CreatorNew,AuthorNew"
        or result.get("/contentClass/metadata/PACKAGE/ENCRYPTED/Fields/CreationInfo/Sources/Source/Role/Name/New Options Found") != "Executive Producer New"
        or result.get("/contentClass/metadata/PACKAGE/ENCRYPTED/Fields/CreationInfo/Sources/Source/Role/Name/Actor") != "option value is different: src(ACTOR) vs target(ACTOR_Updated)"):
            raise RuntimeError("Test Failed")
        
        
    def testFieldsAdd_Delete_Update(self):
        srcContentClassFile = "res/contentClassDifferTestData/ContentClassesSrc.xml"
        targetContentClassFile = "res/contentClassDifferTestData/ContentClassesAssetFieldAdd_Delete_Modified.xml"
        result = dict()
        ContentClassDiffer.diffContentClassFiles(srcContentClassFile, targetContentClassFile,result)
        if (result.get("/contentClass/metadata/PACKAGE/TITLE/Fields/CustomFields/CustomField[@name=CP_Profile]/@value/value/Value Modified") != "Value is different: src(None) vs target(Default)" 
        or result.get("/contentClass/metadata/PACKAGE/PREVIEW/LOGICALCLIP/Fields/AssetClass/value/Value Modified") != "Value is different: src(logical clip) vs target(logical clip Modified)"
        or result.get("/contentClass/metadata/PACKAGE/TITLE/Children Not Found") != "/contentClass/metadata/PACKAGE/TITLE/Fields/CustomFields/CustomField[@name=Creation_Date],/contentClass/metadata/PACKAGE/TITLE/Fields/CustomFields/CustomField[@name=Update_Retarget_Mode],/contentClass/metadata/PACKAGE/TITLE/Fields/CustomFields/CustomField[@name=Creation_Date]/@value,/contentClass/metadata/PACKAGE/TITLE/Fields/CustomFields/CustomField[@name=Update_Retarget_Mode]/@value"
        or result.get("/contentClass/metadata/PACKAGE/TITLE/New Children Found") != "/contentClass/metadata/PACKAGE/TITLE/Fields/CustomFields/CustomField[@name=Update_Retarget_Mode_New]/@value,/contentClass/metadata/PACKAGE/TITLE/Fields/CustomFields/CustomField[@name=Update_Retarget_Mode_New]"):
            raise RuntimeError("Test Failed")     
            
    def testPartnerAdd_Delete(self): 
        srcContentClassFile = "res/contentClassDifferTestData/ContentClassesSrc.xml"
        targetContentClassFile = "res/contentClassDifferTestData/ContentClassesPartnerAdd_Delete_Update.xml"
        result = dict()
        ContentClassDiffer.diffContentClassFiles(srcContentClassFile, targetContentClassFile,result) 
        if (result.get("/contentClass/New Partners Found") != "ZHUJIANG Digital,Roger" 
        or result.get("/contentClass/Partners Not Found") != "TTV"):
            raise RuntimeError("Test Failed")               
    
    
if __name__ == "__main__":
    unittest.main()