#!/usr/bin/env python
import BaseClass

import uuid

from xml.dom.minidom import parseString
from CMSVersionDeploymentPolicy import CMSVersionDeploymentPolicy


class CustomFieldsGroups(BaseClass.BaseClass):
	def __init__(self):
		BaseClass.BaseClass.__init__(self)
		
		self.columns = "DISPLAY_NAME, ASSET_PATH, UUID"
		self.table = "MDM_CUSTOM_FIELD_GROUP"
		
		self.setSelectStatement()
	
	
	def checkExistence(self, data):
		groupName = data[0]
		assetPath = data[1]
		if CMSVersionDeploymentPolicy.getCMSVersion() >= 3.0:
			self.cursor.execute("SELECT GROUP_ID FROM MDM_CUSTOM_FIELD_GROUP WHERE DISPLAY_NAME='%s' AND ASSET_PATH='%s'" % (groupName, assetPath))
			rows = self.cursor.fetchall()
			if len(rows):
				return rows[0][0]
			else:
				return False
		else:
			f = file("/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/definition.xml", "r").read()
			dom = parseString(f)
			
			customFields = filter(lambda variable : variable.getAttribute("name") == "CustomFields", dom.getElementsByTagName("variable"))
			paths = map(lambda element : element.parentNode.parentNode.firstChild.nextSibling.firstChild.nodeValue, customFields)
			
			if assetPath != "PACKAGE":
				assetPath = assetPath.replace("PACKAGE/", "")
			try:
				return customFields[paths.index(assetPath)]
			except ValueError:
				return False
		
		
	def getNextId(self):
		if CMSVersionDeploymentPolicy.getCMSVersion() >= 3.0:
			self.cursor.execute("SELECT WFS.MDM_CUSTOM_FIELD_GROUP_SEQ.NEXTVAL FROM DUAL")
			return self.cursor.fetchall()[0][0]
		else:
			return 1
	
	def insert(self, id_, data):
		if CMSVersionDeploymentPolicy.getCMSVersion() >= 3.0:
			if len(data) == 3:
				u = data[2]
			else:
				u = self.generateUUID(data[0], data[1])
			try:
				statement = "INSERT INTO MDM_CUSTOM_FIELD_GROUP (GROUP_ID, DISPLAY_NAME, ASSET_PATH, UUID) VALUES %s" % self.tupleToStr([id_] + list(data[:2]) + [u])
				print statement 
				self.cursor.execute(statement)
				
				return self.commit()
			except Exception, e:
				print e
				return self.rollback()
		else:
			fin = file("/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/definition.xml", "r").read()
			dom = parseString(fin)
			
			assetName = data[1].split("/")[-1]
			asset = filter(lambda element : element.firstChild.nextSibling.firstChild.nodeValue == assetName, dom.getElementsByTagName("title"))[0]
			metadata = filter(lambda element : element.nodeName == "metadata", asset.childNodes)[0]
			
			cfElement = dom.createElement("variable")
			cfElement.setAttribute("name", "CustomFields")
			cfElement.setAttribute("displayName", "metadata.customFields")
			cfElement.setAttribute("xsi:type", "complexVariableType")
			cfElement.appendChild(dom.createTextNode("\n"))
			
			metadata.appendChild(cfElement)
			
			fout = file("/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/definition.xml", "w")
			dom.writexml(fout, encoding="UTF-8")
			
			fout.close()

	def update(self, data):
		if CMSVersionDeploymentPolicy.getCMSVersion() >= 3.0:
			if len(data) == 3:
				u = data[2]
				try:
					statement = "UPDATE MDM_CUSTOM_FIELD_GROUP SET UUID='%s' WHERE DISPLAY_NAME='%s' AND ASSET_PATH='%s'" % (u, data[0], data[1])
					print statement 
					self.cursor.execute(statement)
					
					return self.commit()
				except Exception, e:
					print e
					return self.rollback()
		else:
			pass
			#TODO 
			#Handle update for custom field for version before 3.0 (2.5)	
			
	def delete(self, data):
		"""delete the custom field group from table 'MDM_CUSTOM_FIELD_GROUP'.
		if the custom field group has custom fields, all the custom fields under
		this group will be deleted as well.
		data[0]: display name
		data[1]: asset path
		
		for example, 
		delete('Custom Fields', 'PACKAGE/PREVIEW')
		"""
		groupName = data[0]
		assetPath = data[1]
		groupId = self.checkExistence(data)
		
		if groupId == False:
			return
		
		try:
			# Delete all the custom fields under this group
			statement = "DELETE FROM MDM_CUSTOM_FIELD WHERE GROUP_ID = '%s'" % groupId
			print statement 
			self.cursor.execute(statement)
			
			# Delete the custom field group
			statement = "DELETE FROM MDM_CUSTOM_FIELD_GROUP WHERE GROUP_ID = '%s'" % groupId
			print statement 
			self.cursor.execute(statement)
					
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()
			
	def generateUUID(self, *data):
		return str(uuid.uuid5(uuid.NAMESPACE_DNS, str(data)))
	
	#args[0]: DISPLAY_NAME
	#args[1]: ASSET_PATH
	def backUpExisting(self, args):
		statement ="SELECT DISPLAY_NAME, ASSET_PATH, UUID FROM MDM_CUSTOM_FIELD_GROUP WHERE DISPLAY_NAME='%s' AND ASSET_PATH='%s'"
		if len(args) >= 2:
			self.cursor.execute(statement % (args[0], args[1]))
			rows = self.cursor.fetchall()
			return rows[0]
		return ""
	
	def backup(self, *args):
		if type(args[0]) == type(tuple()):
			args = args[0]
		if self.isDelete(args) or self.checkExistence(args[0:len(args)-1]):
			return (False, self.backUpExisting(args[0:len(args)-1]))
		else:
			return (True, (args[0:2]))
			
def main():
	#BaseClass.BaseClass.setCMSVersion("2.5.000.271")
	cfg = CustomFieldsGroups()
	#cfg.add("testscript", "PACKAGE/PREVIEW")
	#cfg.export("/tmp/cfg.tdf")
	cfg.add(("Custom Fields", "PACKAGE/ENCRYPTED",'asdfasfasfasdfasdfsa'))
	
if __name__ == "__main__":
	main()
