#!/usr/bin/env python
import BaseClass
import os
import xml

from xml.dom.minidom import parseString

class DistTemplateConfiguration(BaseClass.BaseClass):
    filePath="/opt/tandbergtv/cms/conf/site/dist-templates.xml"

    def __init__(self):
        BaseClass.BaseClass.__init__(self)
        pass
    
    def checkExistence(self, data):
        if not os.path.exists(self.filePath):
            return False
        f = file(self.filePath, "r").read()
        try:
            dom = parseString(f)
        except xml.parsers.expat.ExpatError as err:
            return False
        item = filter(lambda element : self.trim(element.getElementsByTagName("templateName")[0].firstChild.nodeValue) == data[0], dom.getElementsByTagName("distributionTemplate"))
        try:
            return item[0]
        except:
            return False
        
    def getNextId(self):
        return 0
    
    def insert(self, id_, data):
        print "Adding dist template name '%s' to dist-templates.xml..." % data[0]
        self.initFileIfNotExists()
        
        fin = file(self.filePath, "r").read()
        dom = parseString(fin)
        root = dom.getElementsByTagName("distributionTemplates")[0]
        distTempElement = dom.createElement("distributionTemplate")
        templateNameElemement = dom.createElement("templateName")
        templateNameElemement.appendChild(dom.createTextNode(data[0]))
        distTempElement.appendChild(templateNameElemement)
        if len(data) == 2:
            for group in data[1]:
                associatedResourceGroupNameElement = dom.createElement("associatedResourceGroupName")
                associatedResourceGroupNameElement.appendChild(dom.createTextNode(group))
                distTempElement.appendChild(associatedResourceGroupNameElement)
        root.appendChild(distTempElement)
        
        fout = file(self.filePath, "w")
        prettyxml = self.prettyxml(dom)
        fout.write(prettyxml)
        fout.close()
    
    def update(self, data):
        print "Updating dist template name '%s' to dist-templates.xml..." % data[0]
        fin = file(self.filePath, "r").read()
        dom = parseString(fin)
        item = filter(lambda element : self.trim(element.getElementsByTagName("templateName")[0].firstChild.nodeValue) == data[0], dom.getElementsByTagName("distributionTemplate"))
        
        associatedResourceGroupNames = item[0].getElementsByTagName("associatedResourceGroupName")
        for group in associatedResourceGroupNames:
            item[0].removeChild(group)
        if len(data) == 2:
            for group in data[1]:
                associatedResourceGroupNameElement = dom.createElement("associatedResourceGroupName")
                associatedResourceGroupNameElement.appendChild(dom.createTextNode(group))
                item[0].appendChild(associatedResourceGroupNameElement)
        
        fout = file(self.filePath, "w")
        prettyxml = self.prettyxml(dom)
        fout.write(prettyxml)
        fout.close()

    def delete(self, data):
        """ delete a template from the site dropdown list
        data[0]: template name      
        """
        print "Delete template configuration '%s' from dist-templates.xml..." % (data[0])
        
        fin = file(self.filePath, "r").read()
        dom = parseString(fin)
        item = filter(lambda element :self.trim(element.getElementsByTagName("templateName")[0].firstChild.nodeValue) == data[0], dom.getElementsByTagName("distributionTemplate"))
        
        if item is not None and len(item):
            dom.getElementsByTagName("distributionTemplates")[0].removeChild(item[0])
        
            fout = file(self.filePath, "w")
            prettyxml = self.prettyxml(dom)
            fout.write(prettyxml)
            fout.close()
                  
    def initFileIfNotExists(self):
        if not os.path.exists(self.filePath):
            self.initFile()
        else:
            f = file(self.filePath, "r").read()
            try:
                dom = parseString(f)
            except  xml.parsers.expat.ExpatError as err:
                self.initFile()
        
    def initFile(self):
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><distributionTemplates/>"
        self.createFile(self.filePath, xml)

def main():
    cf = DistTemplateConfiguration()
    cf.insert(0, ("MDMS Distribution Template",["aa","cc"]))
    cf.checkExistence(("MDMS Distribution Template",))
    
if __name__ == "__main__":
    main()
