#!/usr/bin/env python
import re
import os
import xml
from MeSubsProfile import MeSubsProfile
from Rulesets import Rulesets

import xml.etree.ElementTree as ET
from xml.etree.ElementTree import ElementTree


class EnhancementRuleset(object):
	
 	def __init__(self):
 		pass

 	def __isMetadataEnhancementRuleset__(self, ruleSet):
		isMeRuleset = False
		
		for param in ruleSet.findall("rules/rule/actions/action/params/param"):
			nameElement = param.findall("name")
			valueElement = param.findall("value")
					
			# verify if this a Enhancement rule
			if nameElement and valueElement	and nameElement[0].text == 'fieldType' \
					and valueElement[0].text == 'ENHANCEMENT':
				isMeRuleset = True
				break
	 	
	 	return isMeRuleset

 	def __getMetadataEnhancementRulesets__(self, filePath):
 		if not os.path.exists(filePath):
 			return []
 		
 		tree = ET.parse(filePath)
		root = tree.getroot()
		ruleSets = []
		
		for ruleSet in root.findall("ruleSets/ruleSet"):
			if self.__isMetadataEnhancementRuleset__(ruleSet):
				ruleSets.append(ruleSet)
				
		return ruleSets

 	def __getMetadataEnhancementRulesetsInTree__(self, tree):
		root = tree.getroot()
		ruleSets = []
		
		for ruleSet in root.findall("ruleSets/ruleSet"):
			if self.__isMetadataEnhancementRuleset__(ruleSet):
				ruleSets.append(ruleSet)
				
		return ruleSets

 	def __getUuidOfMeRulesets__(self, filePath):
 	 	"""
 	 	Description: find the uuids of the me rule set in the specified xml
 	 	
 	 	@param filePath: the rule set xml which may contains multiple rule sets
 	 	"""
 	 	meRuleSets = self.__getMetadataEnhancementRulesets__(filePath)
 	 	uuids = []
 	 	
 	 	for ruleSet in meRuleSets:
 	 		uuidElement = ruleSet.find("uuid")
 	 		if uuidElement is not None and uuidElement.text:
 	 			uuids.append(uuidElement.text)

 	 	return uuids

 	def hasMetadataEnhancementRuleset(self, filePath):
 		if not os.path.exists(filePath):
 			return False
 		
 		tree = ET.parse(filePath)
		root = tree.getroot()
		
		for ruleSet in root.findall("ruleSets/ruleSet"):
			if self.__isMetadataEnhancementRuleset__(ruleSet):
				return True

	def extractMetadataEnhancementRuleset(self, xmlPathOfRuleset, newXmlPath):
		"""
		Description: extract the ME ruleset from the xml file and save to a new file.
					
		@param xmlPathOfRuleset: the xml file which contains many rule sets
		"""
 		
 		xmlTemplateString = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><ruleSetsListing><ruleSets>" \
 							"</ruleSets></ruleSetsListing>"
 		meRulesets = self.__getMetadataEnhancementRulesets__(xmlPathOfRuleset)
 		
 		if len(meRulesets):
 			tree =ElementTree(ET.fromstring(xmlTemplateString)) 
 			root = tree.getroot()
 			rulesetsElement = root.find("ruleSets")
 			
 			for ruleset in meRulesets:
 		 		rulesetsElement.append(ruleset)
 		 	tree.write(newXmlPath, "UTF-8")
# 		  	print ET.tostring(root)
			return True
		
		return False
 			  	
 	def replaceWithProfileName(self, filePath):
 		"""
 		Description:
 			Replace all the profile ids in the @filePath with the actual 
 			profile name.
 		"""
 		if not os.path.exists(filePath):
 			return False
		
		tree = ET.parse(filePath)
		root = tree.getroot()
		meProfile = MeSubsProfile()
		changed = False
		
		for ruleSet in self.__getMetadataEnhancementRulesetsInTree__(tree):
			for action in ruleSet.findall("rules/rule/actions/action"):
				params = action.find("params")
				if params is not None:
					isMetaDataEnhancement = False
					for param in params.findall("param"):
						nameElement = param.findall("name")
						valueElement = param.findall("value")
							
						# verify if this a Enhancement rule
						if nameElement and valueElement	and nameElement[0].text == 'fieldType' \
							and valueElement[0].text == 'ENHANCEMENT':
							isMetaDataEnhancement = True
							
						# Get the profile Id and replace with the profile name
						if nameElement and valueElement	and nameElement[0].text == 'sectionType' \
							and isMetaDataEnhancement:
							profileId = valueElement[0].text
							profileName = meProfile.getProfileNameById(int(profileId))
							
							if profileName:
								valueElement[0].text = profileName
								changed = True
							else:
								print "[Warning]EnhancementRuleset:replaceWithProfileName: unknown profile Id " + profileId
						
		if changed:
			tree.write(filePath, "UTF-8")
			
	def replaceWithProfileId(self, filePath):
 		"""
 		Description:
 			Replace all the profile names in the @filePath with the actual 
 			profile id.
 		"""
 		if not os.path.exists(filePath):
 			return False
 		
 		tree = ET.parse(filePath)
		root = tree.getroot()
		meProfile = MeSubsProfile()
		changed = False
		
		for ruleSet in self.__getMetadataEnhancementRulesetsInTree__(tree):
			for action in ruleSet.findall("rules/rule/actions/action"):
				params = action.find("params")
				if params is not None:		
					isMetaDataEnhancement = False
					for param in params.findall("param"):
						nameElement = param.findall("name")
						valueElement = param.findall("value")
							
						# verify if this a Enhancement rule
						if nameElement and valueElement	and nameElement[0].text == 'fieldType' \
							and valueElement[0].text == 'ENHANCEMENT':
							isMetaDataEnhancement = True
							
						# Get the profile Id and replace with the profile name
						if nameElement and valueElement	and nameElement[0].text == 'sectionType' \
							and isMetaDataEnhancement:
							profileName = valueElement[0].text
							profileId = meProfile.getProfileIdByName(profileName)
							
							if profileId:
								valueElement[0].text = str(profileId)
								changed = True
							else:
								print"[Warning]EnhancementRuleset:replaceWithProfileId: unknown profile name " + profileName
						
		if changed:
			tree.write(filePath, "UTF-8")
 		
def main():
	enhance = EnhancementRuleset()
	
# 	enhance.replaceWithProfileName("C:\Users\elichon\Desktop\MD_RuleSet.xml")
	print enhance.hasMetadataEnhancementRuleset("C:\Users\elichon\Desktop\MD_RuleSet.xml")
	print enhance.__getUuidOfMeRulesets__("C:\Users\elichon\Desktop\MD_RuleSet.xml")
	enhance.extractMetadataEnhancementRuleset("C:\Users\elichon\Desktop\MD_RuleSet.xml", "C:\Users\elichon\Desktop\ME_Ruleset.xml")

if __name__ == "__main__":
	main()