#!/usr/bin/env python
import BaseClass
import os
import re

from xml.dom.minidom import parseString

class FTPConfiguration(BaseClass.BaseClass):
    filePath="/opt/tandbergtv/watchpoint/tomcat/webapps/filemanager/WEB-INF/classes/com/tandbergtv/workflow/webservice/filesubsystem/ftpconfiguration.txt"

    def __init__(self):
        BaseClass.BaseClass.__init__(self)
        pass
    
    def checkExistence(self, data):
        if not os.path.exists(self.filePath):
            return False
        fin = file(self.filePath, "r").read()
        
        hostRegex = r'(^|\s*)%s\s'
        return re.search(hostRegex % (data[0]), fin) is not None
        
    def getNextId(self):
        return 0
    
    def insert(self, id_, data):
        print "Adding ftp configuration '%s' to ftpconfiguration.txt..." % data[0]
        self.initFileIfNotExists()
        
        fin = file(self.filePath, "r").read()

        fout = file(self.filePath, "w")
        fout.write(fin + "\n%s\t%s\t%s" % (data[0], data[1], data[2]))
        fout.close()
    
    def update(self, data):
        print "Updating ftp configuration '%s' to ftpconfiguration.txt..." % data[0]
        
        fin = file(self.filePath, "r").read()
        
        hostRegex = r'(^|\s*)%s\s.*$'
        fin = re.sub(hostRegex % (data[0]), "\n%s\t%s\t%s" % (data[0], data[1], data[2]), fin)
        
        fout = file(self.filePath, "w")
        fout.write(fin)
        fout.close()
        
    def initFileIfNotExists(self):
        if not os.path.exists(self.filePath):
            self.initFile()
        
    def initFile(self):
        self.createFile(self.filePath, "")
            

def main():
    cf = FTPConfiguration()
    cf.add(("azuki", "cms", "cms12345"))
    
if __name__ == "__main__":
    main()
