#
# Copyright (c) 2013 Ericsson, Inc.  All Rights Reserved.
#
# This module contains unpublished, confidential, proprietary
# material.  The use and dissemination of this material are
# governed by a license.  The above copyright notice does not
# evidence any actual or intended publication of this material.
#
# Author: Simon Meng
# Created: Dec 2, 2013
# Description: A class Test ContentClassAssembler
import sys
import unittest
import xml.etree.ElementTree as ET


from FileAssembler import ContentClassAssembler
from FileAssembler import DefinintionAssembler
from UnittestBase import UnittestBase
class ContentClassAssemblerTest(UnittestBase):

    def setUp(self):
        UnittestBase.setUp(self)
        self.assembler = ContentClassAssembler()
        
    #For compatible with python 2.6
    def assertIsNotNone(self, obj, msg=None):
        """Included for symmetry with assertIsNone."""
        if obj is None:
            if msg is None:
                msg = 'test failure'
            raise RuntimeError(msg)

    #For compatible with python 2.6
    def assertIsNone(self, obj, msg=None):
        """Same as self.assertTrue(obj is None), with a nicer default message."""
        if obj is not None:
            if msg is None:
                msg = 'test failure'
            raise RuntimeError(msg)
    
    #For compatible with python 2.6
    def getElementWithAttrFilter(self, nodeElement,path,arrname,arrvalue):
        nodes = nodeElement.findall(path)
        if nodes:
            for n in nodes:
                if n.attrib[arrname] == arrvalue:
                    return n

    def testMergeContentCalsses(self):
        result = 'res/__content_class_merge_result.xml'

        self.assembler.mergeWith('res/content_class_base.xml')
        self.assembler.mergeWith('res/content_class_merge.xml')
        self.assembler.write2file(result)
        tree = ET.parse(result)

        # add new asset
        self.assertIsNotNone(self.getElementWithAttrFilter(tree.getroot(), 'metadata/asset','path', 'PACKAGEXXXXXX'))
        #self.assertIsNotNone(tree.getroot().find('metadata/asset[@path="PACKAGEXXXXXX"]'))

        # add new field
        #self.assertIsNotNone(self.getElementWithAttrFilter(tree, 'metadata/asset','path', 'PACKAGEXXXXXX'))
        
        package = self.getElementWithAttrFilter(tree.getroot(), 'metadata/asset','path', 'PACKAGE')
        newField = self.getElementWithAttrFilter(package, 'field','path', '/Fields/CreationInfo/Sources/Source/Contact/AddressXXXX')
        self.assertIsNotNone(newField)
        #self.assertIsNotNone(tree.getroot().find('metadata/asset[@path="PACKAGE"]/field[@path="/Fields/CreationInfo/Sources/Source/Contact/AddressXXXX"]'))

        # field is updated
        
        package = self.getElementWithAttrFilter(tree.getroot(), 'metadata/asset','path', 'PACKAGE')
        newField = self.getElementWithAttrFilter(package, 'field','path', '/Fields/ProviderInfo/Identifier/Locator/Description')
        
        #field = tree.getroot().find('metadata/asset[@path="PACKAGE"]/field[@path="/Fields/ProviderInfo/Identifier/Locator/Description"]')
        self.assertEqual('truexxxx', newField.attrib["isHidden"])
        
        self.assertEqual('2', package.attrib["max"])
        
        if sys.version_info > (2,7,0):
            field = tree.getroot().find('metadata/asset[@path="PACKAGE/TITLE"]/field[@path="/Fields/CustomFields/CustomField[@name=CP_Profile]/@value"]')
            opts = field.findall('options/option[value="New"]')
            self.assertTrue(len(opts) > 0)

    def testDeleteContentClass(self):

        result = 'res/__content_class_merge_result.xml'
        self.assembler.loadDefault('res/content_class_base.xml')
        
        org_tree = ET.parse('res/content_class_base.xml')
        #self.assertIsNotNone(org_tree.getroot().find('metadata/asset[@path="PACKAGE/TITLE"]'))
        self.assertIsNotNone(self.getElementWithAttrFilter(org_tree.getroot(), 'metadata/asset','path', 'PACKAGE/MOVIESEGMENTGROUP'))
        #self.assertIsNotNone(org_tree.getroot().find('metadata/asset[@path="PACKAGE"]/field[@path="/Fields/ProviderInfo/Identifier/Locator/Description"]'))
        
        if sys.version_info > (2,7,0):
            field = org_tree.getroot().find('metadata/asset[@path="PACKAGE/TITLE"]/field[@path="/Fields/CustomFields/CustomField[@name=CP_Profile]/@value"]/options/option[value="be_delete"]')
            self.assertTrue(field is not None)
        
        
        self.assembler.deleteBy('res/content_class_delete.xml')
        self.assembler.write2file(result)
        tree = ET.parse(result)
        
        
        #test delete asset
        #self.assertIsNone(tree.getroot().find('metadata/asset[@path="PACKAGE/TITLE"]'))
        self.assertIsNone(self.getElementWithAttrFilter(tree.getroot(), 'metadata/asset','path', 'PACKAGE/MOVIESEGMENTGROUP'))
        
        #test delete asset
        #self.assertIsNone(tree.getroot().find('metadata/asset[@path="PACKAGE/TITLENoExists"]'))
        self.assertIsNone(self.getElementWithAttrFilter(tree.getroot(), 'metadata/asset','path', 'PACKAGE/TITLENoExists'))
        
        #test delete exist field
        #self.assertIsNone(tree.getroot().find('metadata/asset[@path="PACKAGE"]/field[@path="/Fields/ProviderInfo/Identifier/Locator/Description"]'))
        
        #test delete exist field
        #self.assertIsNone(tree.getroot().find('metadata/asset[@path="PACKAGE"]/field[@path="/Fields/ProviderInfo/Identifier/Locator/DescriptionNoExists"]'))

        package = self.getElementWithAttrFilter(tree.getroot(), 'metadata/asset','path', 'PACKAGE')
        newField = self.getElementWithAttrFilter(package, 'field','path', '/Fields/ProviderInfo/Identifier/Locator/Description')
        self.assertIsNone(newField)
        
        newField = self.getElementWithAttrFilter(package, 'field','path', '/Fields/ProviderInfo/Identifier/Locator/DescriptionNoExists')
        self.assertIsNone(newField)

        if sys.version_info > (2,7,0):
            field = tree.getroot().find('metadata/asset[@path="PACKAGE/TITLE"]/field[@path="/Fields/CustomFields/CustomField[@name=CP_Profile]/@value"]/options/option[value="be_delete"]')
            self.assertTrue(field is None)
            print 'delete option success'

    def testFormatXml(self):
        self.assembler = ContentClassAssembler(sortTags = True, fix_isHidden_field=True,fix_includeInBatch_field=True)
        self.assembler.mergeWith('res/ContentClasses.AMS.xml')
        self.assembler.mergeWith('res/ContentClasses.Azuki_Mediaroom.xml')
        self.assembler.mergeWith('res/ContentClasses.XPMP.xml')
        self.assembler.mergeWith('res/ContentClasses.Default_msmw.xml')
        self.assembler.mergeWith('res/ContentClasses.Mediaroom.xml')
        self.assembler.mergeWith('res/ContentClasses.OTT.xml')
        self.assembler.write2file('res/__ContentClasses.FULL.xml')
        
        ###############################################
        self.assembler.loadDefault('res/ContentClasses.AMS.xml')
        self.assembler.write2file('res/__ContentClasses.AMS.xml')
        
        self.assembler.loadDefault('res/ContentClasses.Azuki_Mediaroom.xml')
        self.assembler.write2file('res/__ContentClasses.Azuki_Mediaroom.xml')
        
        self.assembler.loadDefault('res/ContentClasses.Default_msmw.xml')
        self.assembler.write2file('res/__ContentClasses.Default_msmw.xml')
        
        self.assembler.loadDefault('res/ContentClasses.Mediaroom.xml')
        self.assembler.write2file('res/__ContentClasses.Mediaroom.xml')
        
        self.assembler.loadDefault('res/ContentClasses.OTT.xml')
        self.assembler.write2file('res/__ContentClasses.OTT.xml')
        
        
        self.assembler.loadDefault('res/definition_default.xml')
        self.assembler.write2file('res/__definition_default.xml')
        self.assembler.loadDefault('res/definition_mwmw.xml')
        self.assembler.write2file('res/__definition_mwmw.xml')
        
        ###############################################
        
    def testMergeDefinition(self):
        er = DefinintionAssembler()
        er.mergeWith('res/definition_mwmw.xml')
        er.mergeWith('res/definition_default.xml')
        er.write2file('res/__definition_FULL.xml')
        
if __name__ == "__main__":
    unittest.main()
