#!/usr/bin/env python
import json
import os
import os.path
import re
import shutil

class GenerateTar(object):
	def __init__(self):
		self.regex = r'(.*)-(\d\.\d\.\d\d\d\.\d)\.rpm'
		
	def mkdir(self, dirName):
		if os.path.exists(dirName):
			shutil.rmtree(dirName)
		os.mkdir(dirName)
	
	def generateTar(self, jsonFile):
		config = json.load(open(jsonFile))
		name = config["name"].replace(" ", "-")
		version = config["version"]
		
		dirName = os.path.join("..", "packages", "%s-%s" % (name, version))
		self.mkdir(dirName)
		
		pom = file("%s/pom.xml" % dirName, "w")
		pom.write('<?xml version="1.0" encoding="UTF-8"?>\n'\
			'<project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi='\
			'"http://www.w3.org/2001/XMLSchema-instance"\n'\
			'\txsi:schemaLocation="http://maven.apache.org/POM/4.0.0 '\
			'http://maven.apache.org/maven-v4_0_0.xsd">\n\n'
		)
		pom.write('\t<parent>\n'\
			'\t\t<groupId>com.ericsson.cms</groupId>\n'\
			'\t\t<artifactId>prepack-baseline</artifactId>\n'\
			'\t\t<version>%s</version>\n'\
			'\t\t<relativePath>../../../prepack-baseline/pom.xml</relativePath>\n'\
			'\t</parent>\n\n' % version
		)
		pom.write('\t<modelVersion>4.0.0</modelVersion>\n'\
			'\t<groupId>com.ericsson.cms</groupId>\n'\
			'\t<artifactId>%s</artifactId>\n'\
			'\t<name>%s</name>\n'\
			'\t<packaging>pom</packaging>\n'\
			'\t<description>AMS PrePack for CMS</description>\n\n' % (name, version)
		)
		pom.write('\t<dependencies>\n')
		for rpm in config["rpms"]:
			self.addRPMtoPom(pom, rpm)
		
		pom.write('\t</dependencies>\n\n')
		#self.addPackaging(pom)
		
		pom.write('\t<build>\n'\
			'\t\t<plugins>\n'\
			'\t\t\t<plugin>\n'\
			'\t\t\t\t<artifactId>maven-assembly-plugin</artifactId>\n'\
			'\t\t\t\t<executions>\n'\
			'\t\t\t\t\t<execution>\n'\
			'\t\t\t\t\t\t<id>make-assembly</id>\n'\
			'\t\t\t\t\t\t<phase>package</phase>\n'\
			'\t\t\t\t\t\t<goals>\n'\
			'\t\t\t\t\t\t\t<goal>single</goal>\n'\
			'\t\t\t\t\t\t</goals>\n'\
			'\t\t\t\t\t</execution>\n'\
			'\t\t\t\t</executions>\n'\
			'\t\t\t\t<configuration>\n'\
			'\t\t\t\t\t<descriptor>prepackzip.xml</descriptor>\n'\
			'\t\t\t\t</configuration>\n'\
			'\t\t\t</plugin>\n'\
			'\t\t</plugins>\n'\
			'\t</build>\n'
		)
		
		pom.write('</project>\n')
		pom.close()
		
		self.addPackaging(dirName, jsonFile)
		
		currentDir = os.getcwd()
		os.chdir(dirName)
		self.runSystemCommand("mvn clean package")
		
		tarName = "%s-%s-release.tar.gz" % (name, version)
		
		os.rename("target/%s" % tarName, os.path.join("..", tarName))
		os.chdir(currentDir)
		shutil.rmtree(dirName)
		
	def addRPMtoPom(self, pom, rpm):
		match = re.match(self.regex, rpm)
		if match:
			name, version = match.group(1), match.group(2)
			print "Adding '%s-%s' to pom.xml" % (name, version)
			pom.write('\t\t<dependency>\n'\
				'\t\t\t<groupId>${project.parent.groupId}</groupId>\n'\
			'\t\t\t<artifactId>%s</artifactId>\n'\
			'\t\t\t<version>%s</version>\n'\
			'\t\t\t<type>rpm</type>\n'\
			'\t\t</dependency>\n' % (name, version)
			)
	
	def addPackaging(self, dirName, jsonFile):
		config = json.load(open(jsonFile))
		prepack = file("%s/prepackzip.xml" % dirName, "w")
		prepack.write('<assembly xmlns="'\
			'http://maven.apache.org/plugins/maven-assembly-plugin/assembly/1.1.2"\n'\
			'xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"\n'\
			'xsi:schemaLocation="http://maven.apache.org/plugins/maven-assembly-plugin/assembly/1.1.2 '\
			'http://maven.apache.org/xsd/assembly-1.1.2.xsd">\n\n'\
			'\t<id>release</id>\n'\
			'\t<formats>\n'\
			'\t\t<format>tar.gz</format>\n'\
			'\t</formats>\n'\
			'\t<includeBaseDirectory>true</includeBaseDirectory>\n\n'
		)
		prepack.write('\t<dependencySets>\n'\
			'\t\t<dependencySet>\n'\
			'\t\t\t<outputDirectory>rpms</outputDirectory>\n'\
			'\t\t\t<useProjectArtifact>true</useProjectArtifact>\n'\
			'\t\t\t<unpack>false</unpack>\n'\
			'\t\t\t<useTransitiveDependencies>false</useTransitiveDependencies>\n'\
			'\t\t</dependencySet>\n'\
			'\t</dependencySets>\n'
		)
		
		rules = "".join(map(lambda ruleSet : '\t\t\t\t<include>%s</include>\n' % ruleSet["FILENAME"], config["ruleSets"] + config["contentClasses"]))
		
		prepack.write('\t<fileSets>\n'\
			'\t\t<fileSet>\n'\
			'\t\t\t<directory>../../../configurations</directory>\n'\
			'\t\t\t<includes>\n'\
			'\t\t\t\t<include>pysetup/**</include>\n'\
			'\t\t\t\t<include>scripts/**</include>\n'\
			'\t\t\t\t<include>deploy.sh</include>\n'\
			'\t\t\t</includes>\n'\
			'\t\t\t<outputDirectory>/</outputDirectory>\n'\
			'\t\t</fileSet>\n'
		)
		
		prepack.write('\t\t<fileSet>\n'\
			'\t\t\t<directory>../../../configurations/resources</directory>\n'\
			'\t\t\t<includes>\n'\
			'%s'\
			'\t\t\t</includes>\n'\
			'\t\t\t<outputDirectory>resources</outputDirectory>\n'\
			'\t\t</fileSet>\n' % rules
		)
		
		jsonDir = jsonFile[ : jsonFile.rindex("/")]
		jsonName = jsonFile.split("/")[-1]
		prepack.write('\t\t<fileSet>\n'\
			'\t\t\t<directory>../%s</directory>\n'\
			'\t\t\t<includes>\n'\
			'\t\t\t\t<include>%s</include>\n'\
			'\t\t\t</includes>\n'\
			'\t\t\t<outputDirectory>/</outputDirectory>\n'\
			'\t\t</fileSet>\n' % (jsonDir, jsonName)
		)
		prepack.write('\t</fileSets>\n')
		prepack.write('\t</assembly>\n')
		prepack.close()
	
	def runSystemCommand(self,command):
		print "Running '%s'..." % command
		output = os.popen(command, "r").read()
		print output

def main():
	gt = GenerateTar()
	
	gt.generateTar("../../prepack-ams/src/main/resources/base.json")
	
if __name__ == "__main__":
	main()