#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import urllib2
import httplib2
import socket

class HttpRequestDecorator(object):
    '''A simple wrapper for HTTP/URL request.'''
    
    @staticmethod
    def request(req_url, method="GET", body=None, headers=None):
        '''Catches some unexcepted errors raised by httplib2.Http.request which may need to be ignored.'''
        resp = None
        max_num = 5
        h = httplib2.Http(".cache", disable_ssl_certificate_validation=True, timeout=300)
        h.force_exception_to_status_code=True
        
        for i in range(max_num):
            try:
                resp = h.request(req_url , method, body, headers)
            except httplib2.SSLHandshakeError:  # (httplib2.SSLHandshakeError, Exception) / httplib2.SSLHandshakeError
                # this may be an unexcepted error which needs to be ignored
                print("An error of httplib2.SSLHandshakeError has been catched, ignore it %d/%d and retry..." % (i+1, max_num))
                pass
        
        return resp
    
    @staticmethod
    def urlopen(url, data=None, timeout=socket._GLOBAL_DEFAULT_TIMEOUT):
        '''Catches some unexcepted errors raised by urllib2.urlopen which may need to be ignored.'''
        resp = None
        max_num = 5
        
        for i in range(max_num):
            try:
                resp = urllib2.urlopen(url, data, timeout)
            except urllib2.URLError:
                # this may be an unexcepted error which needs to be ignored
                print("An error of urllib2.URLError has been catched, ignore it %d/%d and retry..." % (i+1, max_num))
                pass
        
        return resp

def main():
    resp1 = HttpRequestDecorator.request("https://10.116.5.121:8443/portal/")
    print(resp1)
    
#     req = urllib2.Request("https://10.116.5.41:8443/jreport/admin/logout.jsp")
#     resp2 = HttpRequestDecorator.urlopen(req)
#     print(resp2.read())

if __name__ == '__main__':
    main()
    