import os
from InstallComponent import InstallComponent

class InstallComponentBuilder(object):
    
    def buildInstallComponents(self, componentList):
        builtComponents = InstallComponent.createEmptyInstallComponent()
        for component in componentList:
            self.buildComponentRecursively(builtComponents, component.split("/"))
        return builtComponents
            
    def buildComponentRecursively(self, builtComponents, componentArray):
        if componentArray:
            sub = builtComponents.getInstallComponentByName(componentArray[0])
            if not sub:
                sub = InstallComponent(componentArray[0])
                builtComponents.addSubComponent (sub)
            if len(componentArray) > 1:
                self.buildComponentRecursively(sub, componentArray[1:])