import unittest
from InstallComponentCollector import InstallComponentCollector
from InstallComponentBuilder import InstallComponentBuilder
from UnittestBase import UnittestBase
from ComponentSelectionConfig import ComponentSelectionConfig
class InstallComponentCollectorTest(UnittestBase):
    def setUp(self):
        UnittestBase.setUp(self)
        self.installComponentCollector = InstallComponentCollector()
        self.installComponentCollector.fullComponentSelectionConfig=ComponentSelectionConfig.fromJson(self.createFullComponentSelectionConfigs())
        self.installComponentCollector.fullInstallComponents = self.installComponentCollector.fullComponentSelectionConfig.constructInstallComponents().resolveLeaves()
    
    def testFilterDownstremsFromtempSelectedComponents(self):
        pass


    def testFilterDownsteamsFromPreConfig(self):
        preConfiguredSelection = {
            "mode":"DELTA",
            "TO_INSTALL": [
                "DEVICES/TRANSCODE/ELEMENTAL",
                "DOWNSTREAMS/MEDIAROOM"
            ],
            "TO_DELETE": [
                "DEVICES/QC/BATON",
                "DOWNSTREAMS/AMS"
            ]
        }
        
        self.assertEqual(True, 'DOWNSTREAMS/MEDIAROOM'  in preConfiguredSelection["TO_INSTALL"])
        self.assertEqual(True, 'DOWNSTREAMS/AMS'  in preConfiguredSelection["TO_DELETE"])
        
        #filter down streams
        if preConfiguredSelection.get("TO_INSTALL"):
            to_installs = filter(lambda x: not x.startswith('DOWNSTREAMS') , preConfiguredSelection.get("TO_INSTALL"))
            preConfiguredSelection["TO_INSTALL"] = to_installs
        if preConfiguredSelection.get("TO_DELETE"):
            to_installs = filter(lambda x: not x.startswith('DOWNSTREAMS') , preConfiguredSelection.get("TO_DELETE"))
            preConfiguredSelection["TO_DELETE"] = to_installs
            
        self.assertEqual(True, 'DOWNSTREAMS/MEDIAROOM' not in preConfiguredSelection["TO_INSTALL"])
        self.assertEqual(True, 'DOWNSTREAMS/AMS' not in preConfiguredSelection["TO_DELETE"])
        
    
    
    def testLoadSelectionFromPreConfiguredFileUsingDeltaMode(self):
        installedComponents = InstallComponentBuilder().buildInstallComponents([
            "DEVICES/QC/BATON",
            "DEVICES/QC/CERIFY",
            "DEVICES/TRANSCODE/ENVIVIO",
            "DOWNSTREAMS/AMS",
        ])
        preConfiguredSelection = {
            "mode":"DELTA",
            "TO_INSTALL": [
                "DEVICES/TRANSCODE/ELEMENTAL",
                "DOWNSTREAMS/MEDIAROOM"
            ],
            "TO_DELETE": [
                "DEVICES/QC/BATON",
                "DOWNSTREAMS/AMS"
            ]
        }
        componentsToDelete, componentsToInstall = self.installComponentCollector.loadSelectionFromPreConfiguration(preConfiguredSelection, installedComponents)
        self.assertEqual(1, len(componentsToInstall.getInstallComponentByName("DEVICES").getSubComponents()))
        self.assertEqual(1, len(componentsToInstall.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getSubComponents()))
        self.assertEqual(False, componentsToInstall.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getInstallComponentByName("ELEMENTAL") is None)
        self.assertEqual(1, len(componentsToInstall.getInstallComponentByName("DOWNSTREAMS").getSubComponents()))
        self.assertEqual(False, componentsToInstall.getInstallComponentByName("DOWNSTREAMS").getInstallComponentByName("MEDIAROOM") is None)
        
        self.assertEqual(1, len(componentsToDelete.getInstallComponentByName("DEVICES").getSubComponents()))
        self.assertEqual(1, len(componentsToDelete.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").getSubComponents()))
        self.assertEqual(False, componentsToDelete.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").getInstallComponentByName("BATON") is None)
        self.assertEqual(1, len(componentsToDelete.getInstallComponentByName("DOWNSTREAMS").getSubComponents()))
        self.assertEqual(False, componentsToDelete.getInstallComponentByName("DOWNSTREAMS").getInstallComponentByName("AMS") is None)
    
    def testLoadSelectionFromPreConfiguredFileUsingFullMode(self):
        installedComponents = InstallComponentBuilder().buildInstallComponents([
            "DEVICES/QC/BATON",
            "DEVICES/QC/CERIFY",
            "DEVICES/TRANSCODE/ENVIVIO",
            "DOWNSTREAMS/AMS",
        ])
        preConfiguredSelection = {
            "mode":"FULL",
            "TO_INSTALL": [
                "DEVICES/QC/CERIFY",
                "DEVICES/TRANSCODE/ENVIVIO",
                "DEVICES/TRANSCODE/ELEMENTAL",
                "DOWNSTREAMS/MEDIAROOM"
            ],
        }
        componentsToDelete, componentsToInstall = self.installComponentCollector.loadSelectionFromPreConfiguration(preConfiguredSelection, installedComponents)
        self.assertEqual(1, len(componentsToInstall.getInstallComponentByName("DEVICES").getSubComponents()))
        self.assertEqual(1, len(componentsToInstall.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getSubComponents()))
        self.assertEqual(False, componentsToInstall.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getInstallComponentByName("ELEMENTAL") is None)
        self.assertEqual(1, len(componentsToInstall.getInstallComponentByName("DOWNSTREAMS").getSubComponents()))
        self.assertEqual(False, componentsToInstall.getInstallComponentByName("DOWNSTREAMS").getInstallComponentByName("MEDIAROOM") is None)
        
        self.assertEqual(1, len(componentsToDelete.getInstallComponentByName("DEVICES").getSubComponents()))
        self.assertEqual(1, len(componentsToDelete.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").getSubComponents()))
        self.assertEqual(False, componentsToDelete.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").getInstallComponentByName("BATON") is None)
        self.assertEqual(1, len(componentsToDelete.getInstallComponentByName("DOWNSTREAMS").getSubComponents()))
        self.assertEqual(False, componentsToDelete.getInstallComponentByName("DOWNSTREAMS").getInstallComponentByName("AMS") is None)
    
    def createFullComponentSelectionConfigs(self):
        return {
            "selectionItems": [
                "DOWNSTREAMS",
                "DEVICES"
            ],
            
            "DEVICES":{
                "displayName":"Devices",
                "selections" : [
                    "QC",
                    "TRANSCODE",
                    "ENCRYPTION",
                    "COMBINER"
                ]
            },
        
            "QC":{
                "displayName":"QC",
                "selections":[
                    "BATON",
                    "CERIFY",
                    "VERIFIER"
                ]
            },
            
            "TRANSCODE":{
                "displayName":"Transcoder",
                "selections":[
                    "ENVIVIO",
                    "ELEMENTAL",
                    "TITAN",
                    "RHOZET",
                    "DIGITALRAPID"
                ]
            },
            
            "ENCRYPTION":{
                "displayName":"Encryptor",
                "selections":[
                    "VERIMATRIX"
                ]
            },
            
            "COMBINER":{
                "displayName":"Combiner"
            },
            
            "BATON":{
                "displayName":"Baton"
            },
            
            "CERIFY":{
                "displayName":"Cerify"
            },
            
            "VERIFIER":{
                "displayName":"Verifier"
            },
        
            "ENVIVIO":{
                "displayName":"Envivio"
            },
            
            "ELEMENTAL":{
                "displayName":"Elemental"
            },
            
            "TITAN":{
                "displayName":"Titan"
            },
            
            "RHOZET":{
                "displayName":"Rhozet"
            },
            
            "DIGITALRAPID":{
                "displayName":"DigitalRapid"
            },
            
            "VERIMATRIX":{
                "displayName":"Verimatrix"
            },
            
            "DOWNSTREAMS":{
                "displayName":"Downstreams",
                "selections" : [
                    "AMS",
                    "MEDIAROOM",
                    "OTT",
                    "MSMW_MDMS",
                    "MSMW_OS",
                    "XPMP"
                ]
            },
            
            "AMS":{
                "displayName":"AMS",
                "unAvailableComponents":[
                    "DEVICES/COMBINER"
                ],
            },
            
            "MEDIAROOM":{
                "displayName":"Mediaroom"
            },
            
            "OTT":{
                "displayName":"OTT"
            },
            
            "MSMW_MDMS":{
                "displayName":"Msmw with MDMS"
            },
            
            "MSMW_OS":{
                "displayName":"Msmw with Openstream"
            },
            
            "XPMP":{
                "displayName":"XPMP",
                "availableComponents":[
                    "DEVICES/QC/VERIFIER",
                    "DEVICES/COMBINER",
                    "DEVICES/QC/BATON",
                ],
                "autoSelectComponents":[
                    "DEVICES/QC/VERIFIER",
                    "DEVICES/COMBINER"
                ],
                "singleSelection": True
            },
            
            "BACK":{
                "displayName":"Back To Last"
            }
        }
    
    def createPartialInstallComponents(self):
        return {
            "componentName":"ROOT",
            "subComponents":[
                {
                    "componentName": "DEVICES", 
                    "subComponents": [{
                            "componentName": "QC", 
                            "subComponents": [{"componentName": "BATON"}, {"componentName": "CERIFY"}]
                        }, 
                        {
                            "componentName": "TRANSCODE", 
                            "subComponents": [{"componentName": "ELEMENTAL"}]
                        }
                    ]
                }, 
                {
                    "componentName": "DOWNSTREAMS", 
                    "subComponents": [{"componentName": "AMS"}]
                }
            ]
        }  
        
    def testResolveAvailalbeComponentsWithDependencies(self):
        installedComponents = InstallComponentBuilder().buildInstallComponents([
            "DOWNSTREAMS/XPMP",
            "DEVICES/QC/VERIFIER",
            "DEVICES/COMBINER"
        ])
        availableInstallComponents = self.installComponentCollector.fullInstallComponents.substract(installedComponents).removeNonLeafComponentIfNoSubcomponents()
        availableInstallComponents = self.installComponentCollector.resolveAvailalbeComponentsWithDependencies(installedComponents, availableInstallComponents)
        self.assertEqual(1, len(availableInstallComponents.getInstallComponentByName("DEVICES").getSubComponents()))
        self.assertEqual(1, len(availableInstallComponents.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").getSubComponents()))
        self.assertEqual(0, len(availableInstallComponents.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").getInstallComponentByName("BATON").getSubComponents()))
        self.assertEqual(True, availableInstallComponents.getInstallComponentByName("DOWNSTREAMS") is None)
        
    def testResolveSingleSelection(self):
        installedComponents = InstallComponentBuilder().buildInstallComponents([
            "DOWNSTREAMS/XPMP",
            "DEVICES/QC/VERIFIER",
            "DEVICES/COMBINER"
        ])
        availableInstallComponents = self.installComponentCollector.fullInstallComponents.substract(installedComponents).removeNonLeafComponentIfNoSubcomponents()
        self.installComponentCollector.resolveSingleSelection(installedComponents, availableInstallComponents)  
        self.assertEqual(3, len(availableInstallComponents.getInstallComponentByName("DEVICES").getSubComponents()))
        self.assertEqual(True, availableInstallComponents.getInstallComponentByName("DOWNSTREAMS") is None)
    
    def xtestCollectAllUpgradeComponentsViaDirectories(self):
        self.installComponentCollector.collectAllUpgradeComponentsViaDirectories("components", r"..\Upgrade\1.0-2.0")
                                     
if __name__ == "__main__":
    unittest.main()

    
                                                  
