import unittest 
import os
from InstallComponentBuilder import InstallComponentBuilder
from InstallComponent import InstallComponent
from UnittestBase import UnittestBase

class InstallComponentTest(UnittestBase):
    def setUp(self):
        UnittestBase.setUp(self)
        pass
    
    def testGetConfigLocation(self):
        installComponent = self.buildInstallComponet()
        batonComponentLocation = installComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").getInstallComponentByName("BATON").getConfigLocation()
        self.assertEqual("DEVICES" + os.sep + "QC" + os.sep + "BATON" + os.sep, batonComponentLocation)
         
        amsComponentLocation = installComponent.getInstallComponentByName("DOWNSTREAMS").getInstallComponentByName("AMS").getConfigLocation()
        self.assertEqual("DOWNSTREAMS" + os.sep + "AMS" + os.sep, amsComponentLocation)
         
    def testResolveLeaves(self):
        installComponent = self.buildInstallComponet().resolveLeaves()
        self.assertEqual(True, installComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").getInstallComponentByName("BATON").isFinalLeaf)
        self.assertEqual(True, installComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").getInstallComponentByName("CERIFY").isFinalLeaf)
        self.assertEqual(False, installComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").isFinalLeaf)
        self.assertEqual(True, installComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getInstallComponentByName("ELEMENTAL").isFinalLeaf)
        self.assertEqual(True, installComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getInstallComponentByName("ENVIVIO").isFinalLeaf)
        self.assertEqual(False, installComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").isFinalLeaf)
        self.assertEqual(False, installComponent.getInstallComponentByName("DEVICES").isFinalLeaf)
        self.assertEqual(True, installComponent.getInstallComponentByName("DOWNSTREAMS").getInstallComponentByName("AMS").isFinalLeaf)
        self.assertEqual(True, installComponent.getInstallComponentByName("DOWNSTREAMS").getInstallComponentByName("MEDIAROOM").isFinalLeaf)
        self.assertEqual(False, installComponent.getInstallComponentByName("DOWNSTREAMS").isFinalLeaf)
        
    def testResolveLeavesWithFullComponents(self):
        fullInstallComponent = self.buildInstallComponet().resolveLeaves()
        partailComponents = InstallComponentBuilder().buildInstallComponents([
            "DEVICES/QC/CERIFY",
            "DEVICES/TRANSCODE",
            "DOWNSTREAMS"
        ])
        partailComponents.resolveLeaves(fullInstallComponent)
        self.assertEqual(True, partailComponents.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").getInstallComponentByName("CERIFY").isFinalLeaf)
        self.assertEqual(False, partailComponents.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").isFinalLeaf)
        self.assertEqual(False, partailComponents.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").isFinalLeaf)
        self.assertEqual(False, partailComponents.getInstallComponentByName("DEVICES").isFinalLeaf)
        self.assertEqual(False, partailComponents.getInstallComponentByName("DOWNSTREAMS").isFinalLeaf)

    def testMerge(self):
        installComponent = self.buildInstallComponet()
        anotherComponent = InstallComponentBuilder().buildInstallComponents([
            "DEVICES/QC/BATON",
            "DEVICES/TRANSCODE/ELEMENTAL",
            "DEVICES/TRANSCODE/TITAN",
            "DEVICES/ENCRYPTION/VERIMATRIX",
            "DOWNSTREAMS/AMS",
            "DOWNSTREAMS/MSMW_MDMS"
        ]) 
        mergedComponet = installComponent.merge(anotherComponent)
        self.assertEqual("BATON", mergedComponet.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").getInstallComponentByName("BATON").componentName)
        self.assertEqual("ELEMENTAL", mergedComponet.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getInstallComponentByName("ELEMENTAL").componentName)
        self.assertEqual("TITAN", mergedComponet.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getInstallComponentByName("TITAN").componentName)
        self.assertEqual("VERIMATRIX", mergedComponet.getInstallComponentByName("DEVICES").getInstallComponentByName("ENCRYPTION").getInstallComponentByName("VERIMATRIX").componentName)
        self.assertEqual("AMS", mergedComponet.getInstallComponentByName("DOWNSTREAMS").getInstallComponentByName("AMS").componentName)
        self.assertEqual("MSMW_MDMS", mergedComponet.getInstallComponentByName("DOWNSTREAMS").getInstallComponentByName("MSMW_MDMS").componentName)
    
    def testCopy(self):
        installComponent = self.buildInstallComponet().resolveLeaves()
        copiedInstallComponent = installComponent.copy()
        self.assertEqual(True, copiedInstallComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").getInstallComponentByName("BATON").isFinalLeaf)
        self.assertEqual(True, copiedInstallComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").getInstallComponentByName("CERIFY").isFinalLeaf)
        self.assertEqual(False, copiedInstallComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").isFinalLeaf)
        self.assertEqual(True, copiedInstallComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getInstallComponentByName("ELEMENTAL").isFinalLeaf)
        self.assertEqual(True, copiedInstallComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getInstallComponentByName("ENVIVIO").isFinalLeaf)
        self.assertEqual(False, copiedInstallComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").isFinalLeaf)
        self.assertEqual(False, copiedInstallComponent.getInstallComponentByName("DEVICES").isFinalLeaf)
        self.assertEqual(True, copiedInstallComponent.getInstallComponentByName("DOWNSTREAMS").getInstallComponentByName("AMS").isFinalLeaf)
        self.assertEqual(True, copiedInstallComponent.getInstallComponentByName("DOWNSTREAMS").getInstallComponentByName("MEDIAROOM").isFinalLeaf)
        self.assertEqual(False, copiedInstallComponent.getInstallComponentByName("DOWNSTREAMS").isFinalLeaf)
     
    def testSubstract(self):
        installComponent = self.buildInstallComponet().resolveLeaves()
        anotherComponent = InstallComponentBuilder().buildInstallComponents([
            "DEVICES/QC/BATON",
            "DEVICES/TRANSCODE/ELEMENTAL",
            "DEVICES/TRANSCODE/ENVIVIO",
            "DOWNSTREAMS/AMS",
            "DOWNSTREAMS/MSMW_MDMS"
        ]) 
        substractedComponet = installComponent.substract(anotherComponent)
        self.assertEqual(True, substractedComponet.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").getInstallComponentByName("BATON") is None)
        self.assertEqual("CERIFY", substractedComponet.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").getInstallComponentByName("CERIFY").componentName)
        self.assertEqual(True, substractedComponet.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE") is None)
        self.assertEqual("MEDIAROOM", substractedComponet.getInstallComponentByName("DOWNSTREAMS").getInstallComponentByName("MEDIAROOM").componentName)
        self.assertEqual(True, substractedComponet.getInstallComponentByName("DOWNSTREAMS").getInstallComponentByName("AMS") is None)
        
    def testSubstractCase2(self):
        installedComponents = InstallComponentBuilder().buildInstallComponents([
            "DEVICES/QC/BATON",
            "DEVICES/TRANSCODE/ELEMENTAL",
            "DEVICES/TRANSCODE/ENVIVIO",
            "DEVICES/ENCRYPTION/VERIMATRIX",
            "DOWNSTREAMS/AMS"
        ]).resolveLeaves()
        componentsToDelete = InstallComponentBuilder().buildInstallComponents([
            "DEVICES/QC/BATON",
            "DEVICES/TRANSCODE/ENVIVIO",
            "DEVICES/ENCRYPTION/VERIMATRIX"
        ]) 
        substractedComponet = installedComponents.substract(componentsToDelete)
        self.assertEqual(True, substractedComponet.getInstallComponentByName("DEVICES").getInstallComponentByName("QC") is None)
        self.assertEqual("ELEMENTAL", substractedComponet.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getInstallComponentByName("ELEMENTAL").componentName)
        self.assertEqual(True, substractedComponet.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getInstallComponentByName("ENVIVIO") is None)
        self.assertEqual(True, substractedComponet.getInstallComponentByName("DEVICES").getInstallComponentByName("ENCRYPTION") is None)
        self.assertEqual("AMS", substractedComponet.getInstallComponentByName("DOWNSTREAMS").getInstallComponentByName("AMS").componentName)
            
    def testSubstractAll(self):
        installComponent = self.buildInstallComponet().resolveLeaves()
        anotherComponent = installComponent.copy()
        substractedComponet = installComponent.substract(anotherComponent)
        self.assertEqual(False, substractedComponet.hasSubComponent())

    def testIntersect(self):
        installComponent = self.buildInstallComponet().resolveLeaves()
        anotherComponent = InstallComponentBuilder().buildInstallComponents([
            "DEVICES/QC/BATON",
            "DEVICES/TRANSCODE",
            "DEVICES/ENCRYPTION/VERIMATRIX",
            "DOWNSTREAMS/AMS"
        ]) 
        intersectionComponent = installComponent.intersect(anotherComponent)
        self.assertEqual("BATON", intersectionComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").getInstallComponentByName("BATON").componentName)
        self.assertEqual(True, intersectionComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").getInstallComponentByName("CERIFY") is None)
        self.assertEqual("TRANSCODE", intersectionComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").componentName)
        self.assertEqual(True, intersectionComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getInstallComponentByName("ELEMENTAL") is None)
        self.assertEqual(True, intersectionComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getInstallComponentByName("ENVIVIO") is None)
        self.assertEqual("AMS", intersectionComponent.getInstallComponentByName("DOWNSTREAMS").getInstallComponentByName("AMS").componentName)
        self.assertEqual(True, intersectionComponent.getInstallComponentByName("DOWNSTREAMS").getInstallComponentByName("MEDIAROOM") is None)
        
        intersectionComponent = anotherComponent.intersect(installComponent)
        self.assertEqual("BATON", intersectionComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").getInstallComponentByName("BATON").componentName)
        self.assertEqual(True, intersectionComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").getInstallComponentByName("CERIFY") is None)
        self.assertEqual("TRANSCODE", intersectionComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").componentName)
        self.assertEqual(True, intersectionComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getInstallComponentByName("ELEMENTAL") is None)
        self.assertEqual(True, intersectionComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getInstallComponentByName("ENVIVIO") is None)
        self.assertEqual("AMS", intersectionComponent.getInstallComponentByName("DOWNSTREAMS").getInstallComponentByName("AMS").componentName)
        self.assertEqual(True, intersectionComponent.getInstallComponentByName("DOWNSTREAMS").getInstallComponentByName("MEDIAROOM") is None)
        
        anotherComponent = InstallComponent.createEmptyInstallComponent()
        intersectionComponent = installComponent.intersect(anotherComponent)
        self.assertEqual(False, intersectionComponent.hasSubComponent())

    def testIntersectCase2(self):
        installedComponents = InstallComponentBuilder().buildInstallComponents([
            "DEVICES/QC/BATON",
            "DEVICES/TRANSCODE/ELEMENTAL",
            "DEVICES/TRANSCODE/ENVIVIO",
            "DEVICES/ENCRYPTION/VERIMATRIX",
            "DOWNSTREAMS/AMS"
        ]).resolveLeaves()
        availableUpgradeComponents = InstallComponentBuilder().buildInstallComponents([
            "DEVICES/QC/BATON",
            "DEVICES/QC/CERIFY",
            "DEVICES/TRANSCODE/ELEMENTAL",
            "DOWNSTREAMS"
        ])
        intersectionComponent = installedComponents.intersect(availableUpgradeComponents)
        self.assertEqual("BATON", intersectionComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").getInstallComponentByName("BATON").componentName)
        self.assertEqual(True, intersectionComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").getInstallComponentByName("CERIFY") is None)
        self.assertEqual("ELEMENTAL", intersectionComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getInstallComponentByName("ELEMENTAL").componentName)
        self.assertEqual(True, intersectionComponent.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getInstallComponentByName("ENVIVIO") is None)
        self.assertEqual("DOWNSTREAMS", intersectionComponent.getInstallComponentByName("DOWNSTREAMS").componentName)
        self.assertEqual(True, intersectionComponent.getInstallComponentByName("DOWNSTREAMS").getInstallComponentByName("AMS") is None)
        
    def testIntersectCase3(self):
        installedComponents = InstallComponentBuilder().buildInstallComponents([
            "DEVICES/QC/BATON",
            "DEVICES/TRANSCODE/ELEMENTAL",
            "DEVICES/TRANSCODE/ENVIVIO",
            "DOWNSTREAMS/AMS"
        ]).resolveLeaves()
        availableUpgradeComponents = InstallComponentBuilder().buildInstallComponents([
            "DEVICES/ENCRYPTION/VERIMATRIX",
        ])
        intersectionComponent = installedComponents.intersect(availableUpgradeComponents).removeNonLeafComponentIfNoSubcomponents()
        self.assertEqual(False, intersectionComponent.hasSubComponent())
        
    def buildInstallComponet(self):
        return InstallComponentBuilder().buildInstallComponents([
            "DEVICES/QC/BATON",
            "DEVICES/QC/CERIFY",
            "DEVICES/TRANSCODE/ELEMENTAL",
            "DEVICES/TRANSCODE/ENVIVIO",
            "DOWNSTREAMS/AMS",
            "DOWNSTREAMS/MEDIAROOM"
        ])
    
if __name__ == "__main__":
    unittest.main()     