import os

class InstallConfigItemPathResolver(object):
    RESOLVE_ITEMS = ["ruleSets.FILENAME","ruleSetsToDelete.FILENAME","contentClasses.CONTENTCLASSFILES.FILENAME","contentClassesToDelete.CONTENTCLASSFILES.FILENAME"]

    def __init__(self):
        self.pathPrefix = ""
        
    def resolvePaths(self, config, pathPrefix):
        self.pathPrefix = pathPrefix
        for itemAttributeTree in self.RESOLVE_ITEMS:
            ConfigItemLocator().locateItemsAndExcute(itemAttributeTree, config, self)
            
    def execute(self, locatedItem, lastAttributeName):
        if type(dict()) == type(locatedItem):
            if locatedItem.has_key(lastAttributeName) and locatedItem[lastAttributeName]:
                if type(list()) == type(locatedItem[lastAttributeName]):
                    for i in range(0,len(locatedItem[lastAttributeName])):
                        locatedItem[lastAttributeName][i] = self.pathPrefix + locatedItem[lastAttributeName][i]
                elif isinstance(locatedItem[lastAttributeName], basestring):
                    locatedItem[lastAttributeName] = self.pathPrefix + locatedItem[lastAttributeName]
        elif type(list()) == type(locatedItem):
            for item in locatedItem:
                self.execute(item, lastAttributeName)

class InstallScriptsPathResolver(InstallConfigItemPathResolver):
    RESOLVE_ITEMS = ["preInstallationScripts","postInstallationScripts"]
    SCRIPT_PATH = "scripts"
    
    def __init__(self):
        InstallConfigItemPathResolver.__init__(self)
        
    def resolveScriptPaths(self, config, pathPrefix):
        self.resolvePaths(config, pathPrefix + self.SCRIPT_PATH + os.sep)   
    
class InstallDataPatchSqlFilePathResolver(InstallConfigItemPathResolver):
    RESOLVE_ITEMS = ["dataPatchSqlFiles"]
    DATAPATCH_PATH = "datapatch"
    
    def __init__(self):
        InstallConfigItemPathResolver.__init__(self)
        
    def resolveSqlFilePaths(self, config, pathPrefix):
        self.resolvePaths(config, pathPrefix + self.DATAPATCH_PATH + os.sep)  

class InstallConfigFileDirResolver(object):
    CONF_DIR="conf" + os.sep
    CONFIG_FILE_DIRS = "configFileDirs"
    CONFIG_FILE_TODELETE_DIRS = "configFileToDeleteDirs"
    
    def resolveConfigFileDir(self, config, pathPrefix, isDelete):
        confFullPath = pathPrefix + self.CONF_DIR
        if os.path.isdir(confFullPath):
            if isDelete:
                config[self.CONFIG_FILE_TODELETE_DIRS] = [confFullPath]
            else:
                config[self.CONFIG_FILE_DIRS] = [confFullPath]
            
class ConfigItemLocator(object):
    def locateItemsAndExcute(self, itemAttributeTree, config, executor): 
        attributes = itemAttributeTree.split(".")
        allLocatedItems = []
        if len(attributes) == 1:
            allLocatedItems.append(config)
        else:
            self.locateItemsRecursively(allLocatedItems, attributes[0:len(attributes)-1], config)
        lastAttributeName = attributes[len(attributes)-1]
        for locatedItem in allLocatedItems:
            executor.execute(locatedItem, lastAttributeName)
            
    def locateItemsRecursively(self,allLocatedItems, attributes, config):
        values = self.getValuesOfAttributes(attributes[0], config)
        if len(attributes) == 1:
            allLocatedItems.extend(values)
        else:
            for value in values:
                self.locateItemsRecursively(allLocatedItems, attributes[1:len(attributes)], value)

    def getValuesOfAttributes(self, attribute, config):
        values = []
        if type(dict()) == type(config):
            if config.has_key(attribute) and config[attribute]:
                values.append(config[attribute])
        elif type(list()) == type(config):
            for item in config:
                values.extend(self.getValuesOfAttributes(attribute, item))
        return values
            