import unittest 
import os
from InstallConfigItemResolver import InstallConfigItemPathResolver 
from InstallConfigItemResolver import ConfigItemLocator
from InstallConfigItemResolver import InstallConfigFileDirResolver
from InstallConfigItemResolver import InstallScriptsPathResolver
from InstallConfigItemResolver import InstallDataPatchSqlFilePathResolver
from UnittestBase import UnittestBase

class InstallConfigItemPathResolverTest(UnittestBase):
    def setUp(self):
        UnittestBase.setUp(self)
        self.resolver = InstallConfigItemPathResolver()
    
    def testResolvePathsBase(self):
        config = {
            "contentClasses": [
                "ContentClasses.ABC.xml",
                "ContentClasses.BCD.xml"
            ],
            "ruleSets": [
                "CMS_2_0_CableLabs.xml"
            ],
        }
        self.resolver.RESOLVE_ITEMS=["contentClasses","ruleSets"]
        self.resolver.resolvePaths(config, "DEVICES/TRANSCODE/ELEMENTAL/")
        self.assertEqual("DEVICES/TRANSCODE/ELEMENTAL/ContentClasses.ABC.xml", config["contentClasses"][0])
        self.assertEqual("DEVICES/TRANSCODE/ELEMENTAL/ContentClasses.BCD.xml", config["contentClasses"][1])
        self.assertEqual("DEVICES/TRANSCODE/ELEMENTAL/CMS_2_0_CableLabs.xml", config["ruleSets"][0])
    
    def testResolvePaths(self):
        config = {
            "contentClasses": [
                {"NAME":"Default", "CONTENTCLASSFILES":[{"FILENAME":"ContentClasses.ABC.xml"}]}
            ],
            "ruleSets": [
                {"FILENAME":"CMS_2_0_CableLabs.xml"}
            ],
            "test":[
                {"FILENAME":"ABC.xml"}
            ]
                
        }
        self.resolver.resolvePaths(config, "DEVICES/TRANSCODE/ELEMENTAL/")
        self.assertEqual("DEVICES/TRANSCODE/ELEMENTAL/ContentClasses.ABC.xml", config["contentClasses"][0]["CONTENTCLASSFILES"][0]["FILENAME"])
        self.assertEqual("DEVICES/TRANSCODE/ELEMENTAL/CMS_2_0_CableLabs.xml", config["ruleSets"][0]["FILENAME"])
        self.assertEqual("ABC.xml", config["test"][0]["FILENAME"])
        
    def testResolveScriptsPaths(self):
        config = {
            "preInstallationScripts": [
                "script1.sh",
                "script2.sh"
            ],
            "postInstallationScripts": [
                "script3.sh"
            ],
            "contentClasses": [
                {"FILENAME":"ContentClasses.ABC.xml"}
            ],
        }
        InstallScriptsPathResolver().resolveScriptPaths(config, "DEVICES/TRANSCODE/ELEMENTAL/")
        self.assertEqual("DEVICES/TRANSCODE/ELEMENTAL/scripts" + os.sep + "script1.sh", config["preInstallationScripts"][0])
        self.assertEqual("DEVICES/TRANSCODE/ELEMENTAL/scripts" + os.sep + "script2.sh", config["preInstallationScripts"][1])
        self.assertEqual("DEVICES/TRANSCODE/ELEMENTAL/scripts" + os.sep + "script3.sh", config["postInstallationScripts"][0])
        self.assertEqual("ContentClasses.ABC.xml", config["contentClasses"][0]["FILENAME"])

    def testResolveSqlFIlePaths(self):
         config = {
             "dataPatchSqlFiles": [
                 "script1.sql",
                 "script2.sql"
             ],
            "contentClasses": [
                 {"FILENAME":"ContentClasses.ABC.xml"}
             ],
         }
         InstallDataPatchSqlFilePathResolver().resolveSqlFilePaths(config, "DEVICES/TRANSCODE/ELEMENTAL/")
         self.assertEqual("DEVICES/TRANSCODE/ELEMENTAL/datapatch" + os.sep + "script1.sql", config["dataPatchSqlFiles"][0])
         self.assertEqual("DEVICES/TRANSCODE/ELEMENTAL/datapatch" + os.sep + "script2.sql", config["dataPatchSqlFiles"][1])
         self.assertEqual("ContentClasses.ABC.xml", config["contentClasses"][0]["FILENAME"])
        
    def testResolvePathsCase2(self):
        config = {
            "contentClasses": [
                {"FILENAME":{"abc":"ContentClasses.ABC.xml"}},
                {"FILENAME":{"abc":"ContentClasses.DEF.xml"}},
                {"FILENAME":{"abc":"ContentClasses.GHI.xml"}}
            ],
            "ruleSets": {"FILENAME":["CMS_2_0_CableLabs1.xml","CMS_2_0_CableLabs.xml"]},
            "test":[
                "ABC.xml",
                "123.xml"
            ],
            "test1":[
                {"FILENAME":"ABC.xml"}
            ]
                
        }
        self.resolver.RESOLVE_ITEMS=["contentClasses.FILENAME.abc","ruleSets.FILENAME","test"]
        self.resolver.resolvePaths(config, "DEVICES/TRANSCODE/ELEMENTAL/")
        self.assertEqual("DEVICES/TRANSCODE/ELEMENTAL/ContentClasses.ABC.xml", config["contentClasses"][0]["FILENAME"]["abc"])
        self.assertEqual("DEVICES/TRANSCODE/ELEMENTAL/ContentClasses.DEF.xml", config["contentClasses"][1]["FILENAME"]["abc"])
        self.assertEqual("DEVICES/TRANSCODE/ELEMENTAL/ContentClasses.GHI.xml", config["contentClasses"][2]["FILENAME"]["abc"])
        self.assertEqual("DEVICES/TRANSCODE/ELEMENTAL/CMS_2_0_CableLabs1.xml", config["ruleSets"]["FILENAME"][0])
        self.assertEqual("DEVICES/TRANSCODE/ELEMENTAL/CMS_2_0_CableLabs.xml", config["ruleSets"]["FILENAME"][1])
        self.assertEqual("DEVICES/TRANSCODE/ELEMENTAL/ABC.xml", config["test"][0])
        self.assertEqual("DEVICES/TRANSCODE/ELEMENTAL/123.xml", config["test"][1])
        self.assertEqual("ABC.xml", config["test1"][0]["FILENAME"])
   
    def testGetValuesOfAttributes(self):
        locator = ConfigItemLocator()
        config1 = ""
        values = locator.getValuesOfAttributes("",config1)
        self.assertEqual(0, len(values))
        
        config1 = {
            "contentClasses": "Test",
        }
        values = locator.getValuesOfAttributes("contentClasses",config1)
        self.assertEqual(1, len(values))
        self.assertEqual("Test", values[0])
        
        config2 = [
            {"contentClasses": "Test"},
            {"contentClasses": "Test1"}
        ]
        values = locator.getValuesOfAttributes("contentClasses",config2)
        self.assertEqual(2, len(values))
        self.assertEqual("Test", values[0])
        self.assertEqual("Test1", values[1])
        
        config3 = [
            "Test",
            "Test1"
        ]
        values = locator.getValuesOfAttributes("contentClasses",config3)
        self.assertEqual(0, len(values))
        
        config4 = {
            "contentClasses": ["Test","Test2"],
        }
        values = locator.getValuesOfAttributes("contentClasses",config4)
        self.assertEqual(1, len(values))
        self.assertEqual(2, len(values[0]))
        
        config5 = [
            {"contentClasses": {"a":"Test"}},
            {"contentClasses": {"a":"Test1"}}
        ]
        values = locator.getValuesOfAttributes("contentClasses",config5)
        self.assertEqual(2, len(values))
        self.assertEqual("Test", values[0]["a"])
        self.assertEqual("Test1", values[1]["a"])
   
    def testLocateItemsRecursively(self):
        locator = ConfigItemLocator()
        allLocatedItems = []
        config = {
            "contentClasses": [
                {"FILENAME":[{"abc":"ContentClasses.ABC.xml"},{"abc":"ContentClasses.DEF.xml"}]},
                {"FILENAME":[{"abc":"ContentClasses.123.xml"}]}
            ]
        }
        locator.locateItemsRecursively(allLocatedItems, ["contentClasses","FILENAME","abc"],config)
        self.assertEqual(3, len(allLocatedItems))
        self.assertEqual("ContentClasses.ABC.xml", allLocatedItems[0])
        self.assertEqual("ContentClasses.DEF.xml", allLocatedItems[1])
        self.assertEqual("ContentClasses.123.xml", allLocatedItems[2])
        
    def testLocateItemsAndExcute(self):
        locator = ConfigItemLocator()
        store = {}
        config = {
            "contentClasses": [
                {"FILENAME":[{"abc":"ContentClasses.ABC.xml"},{"abc":"ContentClasses.DEF.xml"}]},
                {"FILENAME":[{"abc":"ContentClasses.123.xml"}]}
            ]
        }
        excutor = testExecutor(store)
        locator.locateItemsAndExcute("contentClasses.FILENAME.abc",config, excutor)
        self.assertEqual("abc", store["attribute"])
        self.assertEqual("ContentClasses.ABC.xml", store["allLocatedItems"][0]["abc"])
        self.assertEqual("ContentClasses.DEF.xml", store["allLocatedItems"][1]["abc"])
        self.assertEqual("ContentClasses.123.xml", store["allLocatedItems"][2]["abc"])
    
    def testResolveConfigFileDir(self):
        config = {
            "contentClasses": [
                {"FILENAME":{"abc":"ContentClasses.ABC.xml"}},
                {"FILENAME":{"abc":"ContentClasses.DEF.xml"}},
                {"FILENAME":{"abc":"ContentClasses.GHI.xml"}}
            ]
        }
        InstallConfigFileDirResolver().resolveConfigFileDir(config, "DEVICES/TRANSCODE/ELEMENTAL/", True)
#         self.assertEqual("DEVICES/TRANSCODE/ELEMENTAL/conf" + os.sep, config["configFileToDeleteDirs"][0])
        self.assertEqual(False, config.has_key("configFileDirs"))
        
        config = {
            "contentClasses": [
                {"FILENAME":{"abc":"ContentClasses.ABC.xml"}},
                {"FILENAME":{"abc":"ContentClasses.DEF.xml"}},
                {"FILENAME":{"abc":"ContentClasses.GHI.xml"}}
            ]
        }
        InstallConfigFileDirResolver().resolveConfigFileDir(config, "DEVICES/TRANSCODE/ELEMENTAL/", False)
#         self.assertEqual("DEVICES/TRANSCODE/ELEMENTAL/conf" + os.sep, config["configFileDirs"][0])
        self.assertEqual(False, config.has_key("configFileToDeleteDirs"))
        
class testExecutor(object):
    def __init__(self, store):
        self.store = store
        self.store["allLocatedItems"]=[]
    
    def execute(self, allLocatedItems, lastAttributeName):
        self.store["attribute"] = lastAttributeName
        self.store["allLocatedItems"].extend(allLocatedItems)

if __name__ == "__main__":
    unittest.main()         