import os
import json
from InstallComponent import InstallComponent
from InstallConfigItemResolver import InstallConfigItemPathResolver
from InstallConfigItemResolver import InstallConfigFileDirResolver
from InstallConfigItemResolver import InstallScriptsPathResolver
from InstallConfigItemResolver import InstallDataPatchSqlFilePathResolver
from InstallComponentCollector import ComponentPathBuilder
from Common import Common
from CMSVersionDeploymentPolicy import CMSVersionDeploymentPolicy

class InstallConfigObjectConstructor(Common):    
    CONFIG_JSON = "config.json"
    REMOVE_CONFIG_JSON = "remove.json"

    def __init__(self, fullInstallComponents, installedComponents, componentsToDelete, componentsToInstall, availableUpgradeComponents):
        Common.__init__(self)
        self.fullInstallComponents = fullInstallComponents.resolveLeaves()
        self.installedComponents = installedComponents.resolveLeaves(self.fullInstallComponents)
        self.componentsToDelete = componentsToDelete.resolveLeaves(self.fullInstallComponents)
        self.componentsToInstall = componentsToInstall.resolveLeaves(self.fullInstallComponents)
        if availableUpgradeComponents:
            self.availableUpgradeComponents = availableUpgradeComponents.resolveLeaves(fullInstallComponents)
        else:
            self.availableUpgradeComponents = InstallComponent.createEmptyInstallComponent()
    
    def getInstallStatus(self):
        isInstallNewOrRemove = False
        isUpgradeOnly = False
        isInvolveNothing = False
        if self.componentsToInstall.hasSubComponentExceptBase() or self.componentsToDelete.hasSubComponentExceptBase():
            isInstallNewOrRemove = True
        else:
            componentsToUpgrade =  self.installedComponents.copy().intersect(self.availableUpgradeComponents)
            if componentsToUpgrade.hasSubComponent():
                isUpgradeOnly = True
            else:
                isInvolveNothing = True
        return (isInstallNewOrRemove, isUpgradeOnly, isInvolveNothing)
    
    def constructFinalJsonObj(self, pathPrefix, upgradePath=None):
        allComponentsToHandle = self.mergeAllComponentsToHandle()
        return self.mergeComponentConfigRecursively(allComponentsToHandle.getSubComponents(), pathPrefix, upgradePath)
    
    def mergeAllComponentsToHandle(self):
        componentsToUpgrade =  self.installedComponents.copy().intersect(self.availableUpgradeComponents)
        newCurrentInstalledComponents = self.installedComponents.copy().substract(self.componentsToDelete).merge(self.componentsToInstall)
        #Get the full set of Components To Handle First
        allComponentsToHandle = componentsToUpgrade.copy().merge(self.componentsToInstall).merge(self.componentsToDelete)
        #Then resolve the keyword f each component
        self.resolveKeywordOfComponent(allComponentsToHandle, self.installedComponents, self.componentsToInstall, componentsToUpgrade, newCurrentInstalledComponents)
        return allComponentsToHandle
    
    def resolveKeywordOfComponent(self,compontsToHandle, installedComponents, componentToInstall, componentToUpgrade, newInstalledComponent):
        if compontsToHandle.componentName != "ROOT":
            if newInstalledComponent:
                if componentToUpgrade:
                    compontsToHandle.setAsUpgrade()
                elif componentToInstall and not installedComponents:
                    compontsToHandle.setAsInstall()
            else:
                compontsToHandle.setAsDelete()
        if compontsToHandle.hasSubComponent():
            for subComponent in compontsToHandle.getSubComponents():
                subInstalledComponents = None 
                if installedComponents:
                    subInstalledComponents = installedComponents.getInstallComponentByName(subComponent.componentName)
                
                subComponentToInstall = None 
                if componentToInstall:
                    subComponentToInstall = componentToInstall.getInstallComponentByName(subComponent.componentName)
                    
                subComponentToUpgrade = None 
                if componentToUpgrade:
                    subComponentToUpgrade = componentToUpgrade.getInstallComponentByName(subComponent.componentName)
                    
                subNewInstalledComponent = None 
                if newInstalledComponent:
                    subNewInstalledComponent = newInstalledComponent.getInstallComponentByName(subComponent.componentName)
                    
                self.resolveKeywordOfComponent(subComponent, subInstalledComponents, subComponentToInstall, subComponentToUpgrade, subNewInstalledComponent)
          
    def mergeComponentConfigRecursively(self, installComponents, pathPrefix, upgradePath):
        base = {}
        for component in installComponents:
            if component.hasSubComponent():
                base = self.mergeConfig(base, self.mergeComponentConfigRecursively(component.getSubComponents(), pathPrefix, upgradePath))
            actualPath = self.getActualConfigLocation(component, pathPrefix, upgradePath)
            
            for configPath in self.getVersionSpecifiedConfigLocation(actualPath):
                base = self.mergeConfig(base, self.getAndModifyConfigs(configPath, component))
        return base
                    
    def getAndModifyConfigs(self, actualPath, component):
        if not component.keyWord:
            return {}
        jsonPath = ""
        
        if component.isDelete():
            jsonPath = actualPath + self.REMOVE_CONFIG_JSON
        else:
            jsonPath = actualPath + self.CONFIG_JSON
            
        componentConfig = {}
        if os.path.exists(jsonPath):
            print 'merging file: ' + jsonPath
            json_data = open(jsonPath)
            componentConfig = json.load(json_data)
            json_data.close()
            InstallConfigItemPathResolver().resolvePaths(componentConfig, actualPath)
            InstallScriptsPathResolver().resolveScriptPaths(componentConfig, actualPath)
            InstallDataPatchSqlFilePathResolver().resolveSqlFilePaths(componentConfig, actualPath)

        # "conf" directory is auto detected, so even no JSON file exists, we also need to do the detection
        # and add the "conf" directory to JSON object
        InstallConfigFileDirResolver().resolveConfigFileDir(componentConfig, actualPath, component.isDelete())
        return componentConfig
    
    def getVersionSpecifiedConfigLocation(self, path):
        currentVersion = CMSVersionDeploymentPolicy.getCMSVersion()
        
        searchPath = [path]
        
        if currentVersion < 4.0:
            commonDir = path+"CMS_3_0_1" + os.sep
            searchPath.append(commonDir)
            specifiedDir = commonDir + ("CMS_" + str(currentVersion)).replace(".", "_") + os.sep
            searchPath.append(specifiedDir)
        elif currentVersion > 3.1:
            commonDir = path+"CMS_4_X"+os.sep
            searchPath.append(commonDir)
            specifiedDir = commonDir + ("CMS_" + str(currentVersion)).replace(".", "_") + os.sep
            searchPath.append(specifiedDir)

        #Reverse the order to handle merge issue for version specified config
        searchPath.reverse()
        
        return searchPath
            
    def getActualConfigLocation(self,component, pathPrefix, upgradePath):
        if not component.isUpgrade() and not Common.isPatchMode():
            upgradePath = ""
        return ComponentPathBuilder.getComponentsPathPrefix(pathPrefix, upgradePath)  + component.getConfigLocation()