import unittest 
import os
from InstallConfigObjectConstructor import InstallConfigObjectConstructor
from InstallComponent import InstallComponent
from InstallComponentBuilder import InstallComponentBuilder
from UnittestBase import UnittestBase

class InstallConfigObjectConstructorTest(UnittestBase):
    def setUp(self):
        UnittestBase.setUp(self)
    
    def testGetActualConfigLocation(self):
        constructor = InstallConfigObjectConstructor(InstallComponent.createEmptyInstallComponent(),InstallComponent.createEmptyInstallComponent(),
                                                     InstallComponent.createEmptyInstallComponent(),InstallComponent.createEmptyInstallComponent(),InstallComponent.createEmptyInstallComponent())
        component = InstallComponentBuilder().buildInstallComponents([
            "DEVICES/TRANSCODE/ELEMENTAL",
            "DEVICES/TRANSCODE/TITAN",
            "DOWNSTREAMS/AMS",
        ])
        
        constructor.__class__.__base__.installMode = "UPGRADE"
        component.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getInstallComponentByName("ELEMENTAL").setAsDelete()
        component.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getInstallComponentByName("TITAN").setAsUpgrade()
        self.assertEqual("pathPrefix" + os.sep + "components" + os.sep + "DEVICES" + os.sep + "TRANSCODE" + os.sep + "ELEMENTAL" + os.sep, 
                         constructor.getActualConfigLocation(component.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getInstallComponentByName("ELEMENTAL"), "pathPrefix","1.0-2.0"))
        self.assertEqual("1.0-2.0" + os.sep + "components" + os.sep  + "DEVICES" + os.sep + "TRANSCODE" + os.sep + "TITAN" + os.sep, 
                         constructor.getActualConfigLocation(component.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getInstallComponentByName("TITAN"), "","1.0-2.0"))
        self.assertEqual("pathPrefix" + os.sep + "components" + os.sep + "DOWNSTREAMS" + os.sep + "AMS" + os.sep, 
                         constructor.getActualConfigLocation(component.getInstallComponentByName("DOWNSTREAMS").getInstallComponentByName("AMS"), "pathPrefix",None))
    
    def testMergeAllComponentsToHandle(self):
        fullInstallComponents = InstallComponentBuilder().buildInstallComponents([
            "DEVICES/QC/BATON",
            "DEVICES/QC/CERIFY",
            "DEVICES/TRANSCODE/ELEMENTAL",
            "DEVICES/TRANSCODE/ENVIVIO",
            "DEVICES/TRANSCODE/TITAN",
            "DEVICES/ENCRYPTION/VERIMATRIX",
            "DOWNSTREAMS/AMS",
            "DOWNSTREAMS/MEDIAROOM"
        ])
        installedComponents = InstallComponentBuilder().buildInstallComponents([
            "DEVICES/QC/BATON",
            "DEVICES/TRANSCODE/ELEMENTAL",
            "DEVICES/TRANSCODE/ENVIVIO",
            "DEVICES/ENCRYPTION/VERIMATRIX",
            "DOWNSTREAMS/AMS"
        ])
        componentsToDelete = InstallComponentBuilder().buildInstallComponents([
            "DEVICES/QC/BATON",
            "DEVICES/TRANSCODE/ENVIVIO",
            "DEVICES/ENCRYPTION/VERIMATRIX"
        ]) 
        componentsToInstall = InstallComponentBuilder().buildInstallComponents([
            "DEVICES/QC/CERIFY",
            "DEVICES/TRANSCODE/TITAN",
            "DOWNSTREAMS/MEDIAROOM"
        ])
        availableUpgradeComponents = InstallComponentBuilder().buildInstallComponents([
            "DEVICES/QC/BATON",
            "DEVICES/QC/CERIFY",
            "DEVICES/TRANSCODE/ELEMENTAL",
            "DOWNSTREAMS"
        ])
         
        constructor = InstallConfigObjectConstructor(fullInstallComponents,installedComponents,componentsToDelete,componentsToInstall,availableUpgradeComponents)
        mergedComponents = constructor.mergeAllComponentsToHandle()
        self.assertEqual("DELETE", mergedComponents.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").getInstallComponentByName("BATON").keyWord)
        self.assertEqual("INSTALL", mergedComponents.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").getInstallComponentByName("CERIFY").keyWord)
        self.assertEqual("UPGRADE", mergedComponents.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").keyWord)
        self.assertEqual("UPGRADE", mergedComponents.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getInstallComponentByName("ELEMENTAL").keyWord)
        self.assertEqual("DELETE", mergedComponents.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getInstallComponentByName("ENVIVIO").keyWord)
        self.assertEqual("INSTALL", mergedComponents.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getInstallComponentByName("TITAN").keyWord)
        self.assertEqual("UPGRADE", mergedComponents.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").keyWord)
        self.assertEqual("DELETE", mergedComponents.getInstallComponentByName("DEVICES").getInstallComponentByName("ENCRYPTION").getInstallComponentByName("VERIMATRIX").keyWord)
        self.assertEqual("DELETE", mergedComponents.getInstallComponentByName("DEVICES").getInstallComponentByName("ENCRYPTION").keyWord)
        self.assertEqual(True, mergedComponents.getInstallComponentByName("DOWNSTREAMS").getInstallComponentByName("AMS") is None)
        self.assertEqual("INSTALL", mergedComponents.getInstallComponentByName("DOWNSTREAMS").getInstallComponentByName("MEDIAROOM").keyWord)
    
    def testMergeAllComponentsToHandleCase2(self):
        fullInstallComponents = InstallComponentBuilder().buildInstallComponents([
            "DEVICES/QC/BATON",
            "DEVICES/QC/CERIFY",
            "DEVICES/TRANSCODE/ELEMENTAL",
            "DEVICES/TRANSCODE/ENVIVIO",
            "DEVICES/TRANSCODE/TITAN",
            "DEVICES/ENCRYPTION/VERIMATRIX",
            "DOWNSTREAMS/AMS",
            "DOWNSTREAMS/MEDIAROOM"
        ])
        installedComponents = InstallComponentBuilder().buildInstallComponents([
            "DEVICES/QC/BATON",
            "DEVICES/TRANSCODE/ELEMENTAL",
            "DEVICES/TRANSCODE/ENVIVIO",
            "DEVICES/ENCRYPTION/VERIMATRIX",
            "DOWNSTREAMS/AMS"
        ])
        componentsToDelete = InstallComponentBuilder().buildInstallComponents([
            "DEVICES/QC/BATON",
            "DEVICES/TRANSCODE/ENVIVIO",
            "DEVICES/ENCRYPTION/VERIMATRIX"
        ]) 
        componentsToInstall = InstallComponentBuilder().buildInstallComponents([
            "DEVICES/QC/CERIFY",
            "DEVICES/TRANSCODE/TITAN",
            "DOWNSTREAMS/MEDIAROOM"
        ])
        availableUpgradeComponents = InstallComponent.createEmptyInstallComponent()
         
        constructor = InstallConfigObjectConstructor(fullInstallComponents,installedComponents,componentsToDelete,componentsToInstall,availableUpgradeComponents)
        mergedComponents = constructor.mergeAllComponentsToHandle()
        self.assertEqual("DELETE", mergedComponents.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").getInstallComponentByName("BATON").keyWord)
        self.assertEqual("INSTALL", mergedComponents.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").getInstallComponentByName("CERIFY").keyWord)
        self.assertEqual("", mergedComponents.getInstallComponentByName("DEVICES").getInstallComponentByName("QC").keyWord)
        self.assertEqual(True, mergedComponents.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getInstallComponentByName("ELEMENTAL") is None)
        self.assertEqual("DELETE", mergedComponents.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getInstallComponentByName("ENVIVIO").keyWord)
        self.assertEqual("INSTALL", mergedComponents.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").getInstallComponentByName("TITAN").keyWord)
        self.assertEqual("", mergedComponents.getInstallComponentByName("DEVICES").getInstallComponentByName("TRANSCODE").keyWord)
        self.assertEqual("DELETE", mergedComponents.getInstallComponentByName("DEVICES").getInstallComponentByName("ENCRYPTION").getInstallComponentByName("VERIMATRIX").keyWord)
        self.assertEqual("DELETE", mergedComponents.getInstallComponentByName("DEVICES").getInstallComponentByName("ENCRYPTION").keyWord)
        self.assertEqual(True, mergedComponents.getInstallComponentByName("DOWNSTREAMS").getInstallComponentByName("AMS") is None)
        self.assertEqual("INSTALL", mergedComponents.getInstallComponentByName("DOWNSTREAMS").getInstallComponentByName("MEDIAROOM").keyWord)
    
    def testMergeConfig(self):
        config1 = {
            "contentClasses": [
                 ##{"FILENAME":"ContentClasses.ABC.xml"}
                 {"NAME":"Default", "CONTENTCLASSFILES":[{"FILENAME":"ContentClasses.Base.xml"},{"FILENAME":"ContentClasses.CustomFields.xml"}]}
             ],
             "ruleSets": [
                 {"FILENAME":"CMS_2_0_CableLabs.xml"}
             ],
             "test":[
                 "ABC.xml"
             ]       
        }
        config2 = {
             "contentClasses": [
                 {"NAME":"Default", "CONTENTCLASSFILES":[{"FILENAME":"ContentClasses.QC.xml"}]}
             ],
             "ruleSets": [
                 {"FILENAME":"CMS_2_1_CableLabs.xml"}
             ],
             "test":[
                 "BCD.xml"
             ]      
        }
        constructor = InstallConfigObjectConstructor(InstallComponent.createEmptyInstallComponent(),InstallComponent.createEmptyInstallComponent(),
                                                     InstallComponent.createEmptyInstallComponent(),InstallComponent.createEmptyInstallComponent(),InstallComponent.createEmptyInstallComponent())
        mergedConfig = constructor.mergeConfig(config1, config2)
        contentClassfiles=[]
        for ct_cls_item in mergedConfig["contentClasses"][0]["CONTENTCLASSFILES"]:
            contentClassfiles=contentClassfiles+ct_cls_item.values()
        print ('mergedConfig:',mergedConfig)
        self.assertEqual(1, len(mergedConfig["contentClasses"]))
        self.assertTrue("ContentClasses.Base.xml" in contentClassfiles)
        self.assertTrue("ContentClasses.QC.xml" in contentClassfiles)
        self.assertEqual(2, len(mergedConfig["ruleSets"]))
        self.assertEqual("CMS_2_1_CableLabs.xml", mergedConfig["ruleSets"][0]["FILENAME"])
        self.assertEqual("CMS_2_0_CableLabs.xml", mergedConfig["ruleSets"][1]["FILENAME"])
        self.assertEqual(2, len(mergedConfig["test"]))
        self.assertEqual("BCD.xml", mergedConfig["test"][0])
        self.assertEqual("ABC.xml", mergedConfig["test"][1])
    def testMergePartner(self):
        config1 = {
           "partners": [
            {"NAME":"indemand",    "PARTNERTYPE":2,    "CONTENTCLASSNAME":["Default"],    "PROVIDERID":["indemand.com"]},
            {"NAME":"WARNER",    "PARTNERTYPE":2,    "CONTENTCLASSNAME":["Default"],    "PROVIDERID":["WARNER"]},
            {"NAME":"Ericsson",    "PARTNERTYPE":2,    "CONTENTCLASSNAME":["Default"],    "PROVIDERID":["ericsson.com","Local"]}
           ]       
        }
        config2 = {
           "partners": [
            {"NAME":"indemand",    "PARTNERTYPE":2,    "CONTENTCLASSNAME":["Default"],    "PROVIDERID":["indemand.com"]},
            {"NAME":"WARNER",    "PARTNERTYPE":2,    "CONTENTCLASSNAME":["Default"],    "PROVIDERID":["WARNER"]},
            {"NAME":"Ericsson",    "PARTNERTYPE":2,    "CONTENTCLASSNAME":["Showtime"],    "PROVIDERID":["ericsson.com","Local"]}
           ]       
        }  
        constructor = InstallConfigObjectConstructor(InstallComponent.createEmptyInstallComponent(),InstallComponent.createEmptyInstallComponent(),
                                                     InstallComponent.createEmptyInstallComponent(),InstallComponent.createEmptyInstallComponent(),InstallComponent.createEmptyInstallComponent())
        mergedConfig = constructor.mergeConfig(config1, config2) 
        self.assertEqual(3, len(mergedConfig["partners"]))
        partners=[]
        for partner_item in mergedConfig["partners"]:
            if partner_item["NAME"]=="Ericsson":
                partners=partner_item["CONTENTCLASSNAME"]
        self.assertTrue("Default" in partners)    
        self.assertTrue("Showtime" in partners)   
            
            
if __name__ == "__main__":
    unittest.main()     