#!/usr/bin/env python
import BaseClass
import os
import xml
import re

from xml.dom.minidom import parseString

class JreportDataSourceConfiguration(BaseClass.BaseClass):
        
    REPORT_CATALOG_DATA_SOURCE_FILEPATH = "/opt/tandbergtv/jreport/workspace/bin/datasource.xml"
    
    def __init__(self, filepath):
        BaseClass.BaseClass.__init__(self)
        JreportDataSourceConfiguration.REPORT_CATALOG_DATA_SOURCE_FILEPATH = filepath
        pass
    
#     Change catalog connection data source, default data source is Oracle which 
#     defined in catalog via Jreport Designer. 
#     Hard code this connection as this connection is unique for 
#     prepack-catalog and ott-report, and both are "ConnectionWFS" which is reasonable. 
    def configureJreportCatalogDataSource(self):
        self.initFileIfNotExists()
        
        fin = file(JreportDataSourceConfiguration.REPORT_CATALOG_DATA_SOURCE_FILEPATH, "r").read()
        dom = parseString(fin)
        root = dom.getElementsByTagName("datasource-mapping")[0]
        datasource = dom.createElement("datasource")
        
        catalogConnectionNameElemement = dom.createElement("catalog-connection-name")
        catalogConnectionNameElemement.appendChild(dom.createTextNode("ConnectionWFS"))
        datasource.appendChild(catalogConnectionNameElemement)
        
        driverElement = dom.createElement("driver")
        driverElement.appendChild(dom.createTextNode("com.edb.Driver"))
        datasource.appendChild(driverElement)
        
        connectionTypeElement = dom.createElement("connection-type")
        connectionTypeElement.appendChild(dom.createTextNode("jdbc"))
        datasource.appendChild(connectionTypeElement)
        
        urlElement = dom.createElement("url")
        urlElement.appendChild(dom.createTextNode("jdbc:edb://dbserver:5444/ttv"))
        datasource.appendChild(urlElement)
        
        userElement = dom.createElement("user")
        userElement.appendChild(dom.createTextNode("wfs"))
        datasource.appendChild(userElement)
        
        passwordElement = dom.createElement("password")
        passwordElement.appendChild(dom.createTextNode("Wf$1234"))
        datasource.appendChild(passwordElement)

        root.appendChild(datasource)
        
        fout = file(JreportDataSourceConfiguration.REPORT_CATALOG_DATA_SOURCE_FILEPATH, "w")
        prettyxml = self.prettyxml(dom)
        fout.write(prettyxml)
        fout.close()
        
    def initFileIfNotExists(self):
        if not os.path.exists(JreportDataSourceConfiguration.REPORT_CATALOG_DATA_SOURCE_FILEPATH):
            self.initFile()
        else:
            f = file(JreportDataSourceConfiguration.REPORT_CATALOG_DATA_SOURCE_FILEPATH, "r").read()
            try:
                dom = parseString(f)
            except  xml.parsers.expat.ExpatError as err:
                self.initFile()
                
    def initFile(self):
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><datasource-mapping/>"
        self.createFile(JreportDataSourceConfiguration.REPORT_CATALOG_DATA_SOURCE_FILEPATH, xml)
        
    def prettyxml(self, dom):
        regex = r''
        uglyXml = parseString(re.sub(regex, "", dom.toxml(encoding="UTF-8"))).toprettyxml(encoding="UTF-8")
        prettyxml = re.sub(r'>\n\t*([^<]+)\n\t*<', r'>\1<', uglyXml)
        return prettyxml
               
         
def main():
    catalogDataSourceConfiguration = JreportDataSourceConfiguration("./dataSource2.xml")
    catalogDataSourceConfiguration.configureJreportCatalogDataSource()
    pass    

if __name__=="__main__":
    main()
 
         