import os
import json
from InstallComponent import InstallComponent 
from ComponentSelectionConfig import ComponentSelectionConfig

class ListInstalledComponents(object):
    PREPACK_DIR = "/opt/tandbergtv/cms/prepack"
    INSTALLED_COMPONENTS_FILE_NAME = "installedcomponent.json"
    INSTALLED_COMPONENTS = PREPACK_DIR + os.sep + INSTALLED_COMPONENTS_FILE_NAME
    COMPONENT_SELECTION_CONFIG = "component-selections.json"

    def __init__(self):
        if os.path.exists(self.COMPONENT_SELECTION_CONFIG):
            self.fullComponentSelectionConfig = ComponentSelectionConfig.fromJson(ListInstalledComponents.loadFromJson(self.COMPONENT_SELECTION_CONFIG))
            self.fullInstallComponents = self.fullComponentSelectionConfig.constructInstallComponents().resolveLeaves()
    
    @staticmethod
    def loadFromJson(jsonFile):
        if not os.path.exists(jsonFile):
            return None
        json_data = open(jsonFile)
        jsonObject = json.load(json_data)
        json_data.close()
        return jsonObject
    
    def getInstalledComponents(self):
        installedComponents = InstallComponent.createEmptyInstallComponent()
        if os.path.exists(self.INSTALLED_COMPONENTS):
            installedComponents = InstallComponent.fromJsonObject(ListInstalledComponents.loadFromJson(self.INSTALLED_COMPONENTS))
        return installedComponents
    
    def printInstallComponents(self, components, intent=""):
        if components.isRoot() and not components.hasSubComponent():
            print "    No Component is selected" 
        if not components.isRoot() and not components.isBase():
            intent = intent + '--|-'
            print intent + self.fullComponentSelectionConfig.getSelectionConfig(components.componentName).displayName
        for subComponent in components.getSubComponents():
            self.printInstallComponents(subComponent, intent)
    
if __name__ == "__main__":
    collector = ListInstalledComponents()
    collector.printInstallComponents(collector.getInstalledComponents())
    
