#!/usr/bin/env python
import BaseClass
import MeSubsProfile
from MeFieldDefinition import MeCriteriaFieldDefinition, MeFieldDefinition

class MeIdentifierCriteria(BaseClass.BaseClass):
	"""
		data[0]: NAME			RunTime
		data[1]: meProfileName	SD
		data[2]: MAPPING		TITLE
		data[3]: DATATYPE		time
		data[4]: PATH			/Fields/Duration/Duration
		data[5]: ASSET_TYPE		PACKAGE/TITLE
		data[6]: VALUE_FIELD_PATH /Fields/Duration/Duration
	"""
	
	def __init__(self):
		BaseClass.BaseClass.__init__(self)

	def getNextId(self):
		return 1
	
	def checkExistence(self, data):
		"""
		data[0]: fieldName
		data[1]: ME profile Name
		"""		
		fieldName 		= data[0]
		meProfileName	= data[1]
		meProfileId 	= self.getMeProfileId(meProfileName)
		if meProfileId == False:
			return False
		
		statement = "select CR.ID from ME_IDENTIFIER_CRITERIA CR " \
					"join ME_FIELD_DEFINITION FD on (FD.ID = CR.KEY_FIELD_ID)" \
					"where FD.NAME = '%s' and CR.PROFILE_ID = %d" % (fieldName, meProfileId)
		self.cursor.execute(statement)
		rows = self.cursor.fetchall()
		if len(rows):
			return rows[0][0]
		else:
			return False
		
	def backUpExisting(self, data):
		"""
		data[0]: Field Name
		data[1]: ME Profile Name
		
		return an array contains (NAME,MAPPING,DATATYPE,PATH,ASSET_TYPE,VALUE_FIELD_PATH) of the given profile name specified by data[1]
		
		"""
		if len(data) >= 2:
			fieldName = data[0]
			meProfileName = data[1]
		
			meProfileId = self.getMeProfileId(meProfileName)
			fieldId = self.getFieldId(fieldName, meProfileName)
			
			if meProfileId == False or fieldId == False:
				return []
			
			fieldValue = MeFieldDefinition().getFields(fieldId)
			
			statement = "SELECT ASSET_TYPE, VALUE_FIELD_PATH FROM ME_IDENTIFIER_CRITERIA WHERE PROFILE_ID=%d AND KEY_FIELD_ID=%d" % (meProfileId, fieldId)
			self.cursor.execute(statement)
			rows = self.cursor.fetchall()
			if len(rows) == 0:
				return []
			else:
				fieldValue = fieldValue + rows[0]
				return fieldValue
		else:
			print("MeIdentifierCriteria::backUpExisting:The number of parameters is not correct")
			return []

	def backUpAllExisting(self, profileName):
		"""
		backup all the Criteria fields of a given profile
		"""
		profileId = self.getMeProfileId(profileName)
		
		if profileId == False:
			print "[Error]MeIdentifierCriteria::backUpAllExisting: profile %s not found!" % profileName
			return []
		
		criteriaFieldKeyArray = ["NAME", "MAPPING", "DATATYPE", "PATH", "ASSET_TYPE","VALUE_FIELD_PATH"]
		
		statement = "SELECT FD.NAME, FD.MAPPING, FD.DATATYPE, FD.PATH, IC.ASSET_TYPE, IC.VALUE_FIELD_PATH FROM ME_FIELD_DEFINITION FD" \
					" JOIN ME_IDENTIFIER_CRITERIA IC ON (FD.ID = IC.KEY_FIELD_ID)" \
					" WHERE IC.PROFILE_ID = %d" % profileId
		self.cursor.execute(statement)
		
		rows = self.cursor.fetchall()
		if len(rows):
			criteriaFields = []
			for row in rows:
				criteriaField = {}
				for i in range(0, len(criteriaFieldKeyArray)):
					if row[i] == None:
						criteriaField[criteriaFieldKeyArray[i]] = ""
					else:
						criteriaField[criteriaFieldKeyArray[i]] = row[i]
				criteriaFields.append(criteriaField)
		return criteriaFields
					
	def insert(self, id_, data):
		try:
			fieldName 			= data[0]
			meProfileName		= data[1]
			mapping				= data[2]
			datatype			= data[3]
			path				= data[4]
			assetType			= data[5]
			valueFieldPath		= data[6]
			
			meProfileId 	= self.getMeProfileId(meProfileName)
			if meProfileId == False:
				return False
			
			fieldId = self.insertFieldDefinition(data)
			if fieldId == False:
				return False			
			
			statement = "INSERT INTO ME_IDENTIFIER_CRITERIA (PROFILE_ID, KEY_FIELD_ID, ASSET_TYPE, VALUE_FIELD_PATH) VALUES %s" % self.tupleToStr([meProfileId, fieldId, assetType, valueFieldPath])
			print statement 
			self.cursor.execute(statement)	
			
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()
		
	def update(self, data):
		try:
			assetType			= data[5]
			valueFieldPath		= data[6]
			
			criterialId = self.checkExistence(data)
			if criterialId == False:
				return False
			
			self.updateFieldDefinition(data)
			
			statement = "UPDATE ME_IDENTIFIER_CRITERIA SET ASSET_TYPE='%s', VALUE_FIELD_PATH='%s' WHERE ID = %d" % (assetType, valueFieldPath, criterialId)
			print statement
			self.cursor.execute(statement)
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()

	def delete(self, data):
		fieldName 		= data[0]
		meProfileName	= data[1]
		
		criteriaId = self.checkExistence(data)
		fieldId = self.getFieldId(fieldName, meProfileName)
		
		try: 
			# delete from table ME_ENHANCED_FIELD first
			if criteriaId != False:
				statement = "DELETE FROM ME_IDENTIFIER_CRITERIA WHERE ID = %d" % criteriaId
				print statement
				self.cursor.execute(statement)
			
			if fieldId != False:
				self.deleteFieldDefinition(fieldId)
			
			if criteriaId != False or fieldId != False:
				return self.commit()
		except Exception, e:
			print e
			return self.rollback()
	
	def deleteAll(self, profileId):
		"""
		Description: delete all the criteria field of the profile
		"""
		# delete from table ME_IDENTIFIER_CRITERIA first
		statement = "DELETE FROM ME_IDENTIFIER_CRITERIA WHERE PROFILE_ID = %d" % profileId
		print statement
		self.cursor.execute(statement)
			
	def insertFieldDefinition(self, data):
		fieldDefinition = MeCriteriaFieldDefinition()
		return fieldDefinition.insert(data)

	def updateFieldDefinition(self, data):
		fieldDefinition = MeCriteriaFieldDefinition()
		fieldDefinition.update(data)
		
	def deleteFieldDefinition(self, fieldId):
		fieldDefinition = MeCriteriaFieldDefinition()
		fieldDefinition.delete(fieldId)
			
	def getMeProfileId(self, *data):
		return MeSubsProfile.MeSubsProfile().checkExistence(data)
	
	def getFieldId(self, *data):
		return MeCriteriaFieldDefinition().getId(data)
	
	def getIsDelete(self, item):
		if not item.has_key("IS_DELETE"):
			return False
		else:
			return item["IS_DELETE"].lower() == "true"

def main():
	meIC = MeIdentifierCriteria()
	
if __name__ == "__main__":
	main()