#!/usr/bin/env python
import BaseClass
import MeSubsProfile

class MeSubsProfileParameter(BaseClass.BaseClass):
	"""
		data[0]: meProfileName	SD
		data[1]: NAME			PackageType
		data[2]: VALUE			MOD
	"""

	def __init__(self):
		BaseClass.BaseClass.__init__(self)

	def checkExistence(self, data):
		"""
		data[0]: parameter name
		data[1]: profile name
		"""
		paraName = data[0]
		meProfileName = data[1]
		meProfileId = self.getMeProfileId(meProfileName)
		if meProfileId == False:
			return False
		self.cursor.execute("SELECT ID FROM ME_SUBS_PROFILE_PARAMETER WHERE PROFILE_ID=%d AND NAME='%s'" % (meProfileId, paraName))
		rows = self.cursor.fetchall()
		if len(rows):
			return rows[0][0]
		else:
			return False

	def getNextId(self):
		return 1
	
	def backUpExisting(self, data):
		"""
		data[0]: Parameter Name
		data[1]: ME Profile Name
		
		return an array contains (NAME,VAlUE) of the given profile name specified by data[1]
		
		"""
		if len(data) >= 2:
			paraName = data[0]
			meProfileName = data[1]
		
			meProfileId = self.getMeProfileId(meProfileName)
			if meProfileId == False:
				return False
		
			profileParStatement = "SELECT NAME, VALUE FROM ME_SUBS_PROFILE_PARAMETER WHERE PROFILE_ID=%d AND NAME='%s'" % (meProfileId, paraName)
			self.cursor.execute(profileParStatement)
			rows = self.cursor.fetchall()
			if len(rows) == 0:
				return []
			else:
				return rows[0]
		else:
			print("MeSubsProfileParameter::backUpExisting:The number of parameters is not correct")

	def backUpAllExisting(self, profileName):
		"""
		backup all the parameters of a given profile
		"""
		profileId = self.getMeProfileId(profileName)
		
		if profileId == False:
			print "[Error]MeSubsProfileParameter::backUpAllExisting: profile %s not found!" % profileName
			return []
		
		parameterKeyArray = ["NAME","VALUE"]
		statement = "SELECT PP.NAME, PP.VALUE FROM ME_SUBS_PROFILE_PARAMETER PP" \
					" WHERE PP.PROFILE_ID = %d" % profileId
		self.cursor.execute(statement)
		
		rows = self.cursor.fetchall()
		if len(rows):
			parameters = []
			for row in rows:
				parameter = {}
				for i in range(0, len(parameterKeyArray)):
					if row[i] == None:
						parameter[parameterKeyArray[i]] = ""
					else:
						parameter[parameterKeyArray[i]] = row[i]
				parameters.append(parameter)
		return parameters
				
	def insert(self, id_, data):
		"""
		data[0]: Parameter Name
		data[1]: ME Profile Name
		data[2]: Parameter Value		
		"""
		try:
			paraName = data[0]
			meProfileName = data[1]
			paraValue = data[2]
			meProfileId = self.getMeProfileId(meProfileName)
			if meProfileId == False:
				return False
			
			statement = "INSERT INTO ME_SUBS_PROFILE_PARAMETER (PROFILE_ID, NAME, VALUE) VALUES %s" % self.tupleToStr([meProfileId, paraName, paraValue])
			print statement 
			self.cursor.execute(statement)	
			
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()

	def update(self, data):
		"""
		data[0]: Parameter Name
		data[1]: ME Profile Name
		data[2]: Parameter Value		
		"""		
		try:
			paraName = data[0]
			meProfileName = data[1]
			paraValue = data[2]
			meProfileId = self.getMeProfileId(meProfileName)
			if meProfileId == False:
				return False
			
			statement = "UPDATE ME_SUBS_PROFILE_PARAMETER SET VALUE='%s' WHERE PROFILE_ID=%d AND NAME='%s'" % (paraValue, meProfileId, paraName)
			print statement
			self.cursor.execute(statement)	
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()
		
	def delete(self, data):
		"""
		data[0]: Parameter Name
		data[1]: ME Profile Name
		data[2]: Parameter Value		
		"""	
		paraName = data[0]
		meProfileName = data[1]
		paraValue = data[2]
		
		parameterId = self.checkExistence(data)
		if parameterId == False:
			return
		
		statement = "DELETE FROM ME_SUBS_PROFILE_PARAMETER WHERE ID = %d" % parameterId
		print statement

		try:
			self.cursor.execute(statement)
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()		

	def deleteAll(self, profileId):
		"""
		Description: delete all the parameters of the profile
		"""
		# delete from table ME_ENHANCED_FIELD first
		statement = "DELETE FROM ME_SUBS_PROFILE_PARAMETER WHERE PROFILE_ID = %d" % profileId
		print statement
		self.cursor.execute(statement)		

	def getMeProfileId(self, *data):
		return MeSubsProfile.MeSubsProfile().checkExistence(data)
	
	def getIsDelete(self, item):
		if not item.has_key("IS_DELETE"):
			return False
		else:
			return item["IS_DELETE"].lower() == "true"

def main():
	meSubsPP = MeSubsProfileParameter()
	meSubsPP.add('SD', 'PackageType', 'MOD')

if __name__ == "__main__":
	main()
