#!/usr/bin/env python
import BaseClass
import ContentClassPartners
from fnmatch import fnmatch
from CMSVersionDeploymentPolicy import CMSVersionDeploymentPolicy

class Partners(BaseClass.BaseClass):
	def __init__(self):
		BaseClass.BaseClass.__init__(self)
		
		self.columns = "NAME, PARTNERTYPE, PROVIDERID, LOOKUPKEY"
		self.table = "PMM_PARTNER"
		self.setSelectStatement()
		self.selectStatement += " WHERE PARTNERTYPE!=1 AND ISACTIVE=1"
	
	def checkExistence(self, data):
		providerId = data[0]
		#Fix issue of different behavior between PostgreSQL and Oracle on handling ""
		#In Oracle, it will treat "" as null when insert; However, in PostgreSQL, it will really insert "" treated as a value
		if providerId=="":
			return False
		self.cursor.execute("SELECT ID_ FROM PMM_PARTNER WHERE PROVIDERID='%s' AND ISACTIVE=1" % providerId)
		rows = self.cursor.fetchall()
		if len(rows):
			return rows[0][0]
		else:
			return False
		
	def getNextId(self):
		
		self.cursor.execute("SELECT WFS.PMM_CONTEXT_SEQ.NEXTVAL FROM DUAL")
		self.cursor.execute("SELECT WFS.PMM_PARTNER_SEQ.NEXTVAL FROM DUAL")
		self.cursor.execute("SELECT WFS.PMM_CONTACT_SEQ.NEXTVAL FROM DUAL")
		return self.cursor.fetchall()[0][0]
	
	def insert(self, id_, data):
		"""data: (PROVIDERID,NAME,PARTNERTYPE,LOOKUPKEY,CONTENTCLASSNAME,IS_DELETE)"""
		cp = ContentClassPartners.ContentClassPartners()
		try:
			
			providerId = data[0]
			statement = "INSERT INTO PMM_CONTEXT (ID_, CONTAINERTYPEID) VALUES (%s, 1)" % id_
			print statement
			self.cursor.execute(statement)
			
			if CMSVersionDeploymentPolicy.getCMSVersion() > 4.0:
				statement = "INSERT INTO PMM_PARTNER (ID_, CONTEXTID, AFFILIATION_CODE, PROVIDERID, NAME, PARTNERTYPE, LOOKUPKEY, ISACTIVE) "\
								"VALUES %s" % self.tupleToStr([id_] * 2 + ["%05d"%id_] + list(data[:4]) + [1])
			else:
				statement = "INSERT INTO PMM_PARTNER (ID_, CONTEXTID, PROVIDERID, NAME, PARTNERTYPE, LOOKUPKEY, ISACTIVE) "\
								"VALUES %s" % self.tupleToStr([id_] * 2 + list(data[:4]) + [1])
			print statement
			self.cursor.execute(statement)
			
			statement = "INSERT INTO PMM_CONTACT (ID_, PARTNERID) VALUES (%s, %s)" % (id_, id_)
			print statement
			self.cursor.execute(statement)
				
			"""Insert into content class partner table"""						
			for contentClass in data[4]:
				if not cp.checkExistence((providerId,contentClass)):
					cp.insert(providerId,contentClass)	
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()

	def update(self, data):
		"""data: (PROVIDERID, NAME,PARTNERTYPE,LOOKUPKEY,CONTENTCLASSNAME,IS_DELETE)"""
		cp = ContentClassPartners.ContentClassPartners()
		try: 
			providerId = data[0]
			statement = "UPDATE PMM_PARTNER SET NAME='%s', PARTNERTYPE='%s', LOOKUPKEY='%s' WHERE PROVIDERID='%s' " % (data[1], data[2],data[3], providerId)
			print statement
			self.cursor.execute(statement)
			""" To update contentClassPartners, 
			Step 1. Remove all association between content class partners and the specified providerId"""						
			cp.delete([providerId])
			
			""" To update contentClassPartners, 
			Step 2. Insert new association between content class partners and the specified providerId"""		
			for contentClass in data[4]:
				if not cp.checkExistence((providerId,contentClass)):
					cp.insert(providerId,contentClass)
			
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()
					
	def delete(self, data):
		"""
		data[0]: Provider Id

		"""
		providerId = data[0]
		
		partnerId = self.checkExistence((providerId,))
		
		if partnerId == False:
			return
					
		try:
			statement = "DELETE FROM PMM_CONTACT WHERE PARTNERID='%s'" % partnerId
			print statement
			self.cursor.execute(statement)
				
			statement = "SELECT CONTEXTID FROM PMM_PARTNER WHERE ID_='%s'" % partnerId
			print statement
			self.cursor.execute(statement)
				
			row = self.cursor.fetchone()
			if len(row):
				contextId = row[0]
			else:
				contextId = -1	
				
			# delete dependency firstly
			cp = ContentClassPartners.ContentClassPartners()
			cp.delete([providerId])
			
			# Make sure no title is associated with the partner, otherwise, can not delete
			statement = "DELETE FROM PMM_PARTNER WHERE ID_='%s'" % partnerId
			print statement
			self.cursor.execute(statement)
							
			if contextId != -1:
				statement = "DELETE FROM PMM_CONTEXT WHERE ID_='%s'" % contextId
				print statement
				self.cursor.execute(statement)
				
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()
		
	def deleteDistributionPartner(self, partnerName, partnerType):
		"""this delete method is only used to delete partner whose partner type is DISTRIBUTION"""
		try:
			statement = "SELECT ID_ FROM PMM_PARTNER WHERE NAME = '%s' AND PARTNERTYPE = '%s'" % (partnerName, partnerType)
			print statement
			self.cursor.execute(statement)
			row = self.cursor.fetchone()
			partnerId = row[0]
			
			statement = "DELETE FROM PMM_CONTACT WHERE PARTNERID='%s'" % partnerId
			print statement
			self.cursor.execute(statement)
				
			statement = "SELECT CONTEXTID FROM PMM_PARTNER WHERE ID_='%s'" % partnerId
			print statement
			self.cursor.execute(statement)
			row = self.cursor.fetchone()
			contextId = row[0]			
			
			statement = "DELETE FROM PMM_PARTNER WHERE ID_='%s'" % partnerId
			print statement
			self.cursor.execute(statement)	

			statement = "DELETE FROM PMM_CONTEXT WHERE ID_='%s'" % contextId
			print statement
			self.cursor.execute(statement)		
			
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()

  	#args[2]: PROVIDERID list 
	def backUpExisting(self, args):	
		"""
		Input:
			args[0]: ProviderId
		"""	
		partnersStatement = "SELECT  ID_, NAME, PARTNERTYPE FROM PMM_PARTNER WHERE PROVIDERID='%s' AND ISACTIVE=1" 
		contentClassStatement = "SELECT CC.NAME AS CONTENTCLASSNAME "\
		"FROM PMM_CONTENT_CLASS_PARTNER CCP "\
		"JOIN PMM_CONTENT_CLASS CC ON (CCP.CONTENT_CLASS_ID = CC.ID) "\
		"JOIN PMM_PARTNER P ON (CCP.PARTNER_ID = P.ID_) "\
		"WHERE P.PROVIDERID='%s'"
    	#UPDATE PMM_PARTNER SET NAME='%s', PARTNERTYPE='%s', LOOKUPKEY='%s' WHERE PROVIDERID='%s'
		if args[0] is None or not len(args[0]):
			return		
		
		providerId = args[0]
		self.cursor.execute(contentClassStatement%providerId)
		contentClasses = []
		contentClassNamesRows = self.cursor.fetchall()
		for contentClassRow in contentClassNamesRows:
			contentClasses.append(contentClassRow[0])
		
		self.cursor.execute(partnersStatement%providerId)
		partner = self.cursor.fetchall()
		partnerName = ""
		partnerType = ""
		if len(partner) and len(partner[0]) >= 2:
			partnerName = partner[0][1]
			partnerType = partner[0][2]
			
		result = [[providerId],] + [partnerName,partnerType]+[contentClasses,]
		return result
    	
#	def _export(self):
#		statement = "SELECT NAME, PROVIDERID, PARTNERTYPE, LOOKUPKEY FROM PMM_PARTNER WHERE PARTNERTYPE!=1"
#		header = "NAME, PROVIDERID, PARTNERTYPE, LOOKUPKEY".replace(", ", "\t")
#		print statement
#		self.execute(statement)
#		rows = self.fetchall()
#		
#		output = header + "\n"
#		for row in rows:
#			output += "\t".join(self.noneToNull(row)) + "\n"
#		
#		return output.strip()

    	
def main():
	p = Partners()
	p.delete("indemand", 2, "indemand.com", 1)
	p.add("testscript.com", 2, "testscript.com",1)
# 	p.export("/tmp/partners.tdf")
	#p.importFromFile("/tmp/partners.tdf")
	
if __name__ == "__main__":
	main()