import sys
import json
import BaseClass
import InstallComponentBuilder

"""
Prepack_Sites_Tree
        |- AMS
        |    |- WatchfolderSite
        |    |- DistributionToFTP
        |    |- ADIDistribution
        |
        |- MEDIAROOM_OTT
        |    |- Azuki
        |    |- Media Room
        |
        |- MSMW_MDMS
        |    |- MDMS
        |
        |- MSMW_OS
        |    |- RTSP Distribution
        |    |- HLS Distribution
"""

class PrepackInstalledDecider(BaseClass.BaseClass):
    INSTALLED_PREPACK_COMPONENTS_DIR = "legacyPrepack/"
    EXTENSION = ".json"
    
    PrepackNameToSites = [{"PrepackName":"AMS", "Sites":["WatchfolderSite", "DistributionToFTP", "ADIDistribution"]},
                          {"PrepackName":"MEDIAROOM_OTT", "Sites":["Azuki", "Media Room"]},
                          {"PrepackName":"MSMW_MDMS", "Sites":["MDMS"]},
                          {"PrepackName":"MSMW_OS", "Sites":["RTSP Distribution", "HLS Distribution"]}]
    
    def isAnyPrepackInstalled(self):
        self.cursor.execute("select NAME from SITES_SITE")
        rows = self.cursor.fetchall()
        isPrepackInstalled = len(rows) > 0
        return isPrepackInstalled
    
    def getInstalledPrepackName(self):
        self.cursor.execute("select NAME from SITES_SITE")
        rows = self.cursor.fetchall()
        for row in rows:
            for prepackInfo in self.PrepackNameToSites:
                if row[0] in prepackInfo["Sites"]:
                    return prepackInfo["PrepackName"]
    
    def getInstalledComponentsByPrepackName(self, prepackName):
        installedPrepackComponentsFile = self.INSTALLED_PREPACK_COMPONENTS_DIR + prepackName + self.EXTENSION
        json_data = open(installedPrepackComponentsFile)
        installedPrepackComponentJsonObject = json.load(json_data)
        json_data.close()
        builder = InstallComponentBuilder.InstallComponentBuilder()        
        return builder.buildInstallComponents(installedPrepackComponentJsonObject)
    
def main():
    decider = PrepackInstalledDecider()
    if decider.isAnyPrepackInstalled():
        prepackName = decider.getInstalledPrepackName()
        print ("Prepack Name: " + prepackName)
        installedComponents = decider.getInstalledComponentsByPrepackName(prepackName)
        installedComponents.printMe()
    sys.exit(0)
    
if __name__ == "__main__":
    main()            

        