import Common
from ReportPublisher import ReportPublisher
from ReportCategoryConfiguration import ReportCategoryConfiguration
from ReportConfiguration import ReportConfiguration
from JreportDataSourceConfiguration import JreportDataSourceConfiguration

import os
import shutil
from distutils.dir_util import remove_tree

class PrepackReportInstaller(Common.Common):
    JSON_TAG_JREPORT = "jreports"
    JSON_TAG_REPORTS = "reports"
    JSON_TAG_UNUSED_REPORTS = "unused_reports"
    
    def __init__(self, config=None):
        Common.Common.__init__(self)
        self.cmsReportConfigurationFilePath = "/opt/tandbergtv/cms/conf/report/report-config.xml"
        self.reportCatalogDataSourceFilePath = "/opt/tandbergtv/jreport/workspace/bin/datasource.xml"
    
        self.jreportPath = ""
        self.config = config
    
    # Entry point to install and configure report in CMS
    def startDepoyReports(self):
        self.removeUnusedReports()
        self.configureCategoryAndReports()
        self.configureReportOnCMSServer()
        self.configureJreportCatalogDataSource()
               
    # publish reports
    def configureJreportServer(self):
        pass
     
    # Change catalog connection data source, default data source is Oracle which 
    # defined in catalog via Jreport Designer     
    def configureJreportCatalogDataSource(self):
        pass
    
    # configure report-config.xml    
    def configureReportOnCMSServer(self):
        reports = self.getConfig(PrepackReportInstaller.JSON_TAG_REPORTS)
        
        if reports is None:
            return
        
        rcc = ReportCategoryConfiguration()
        rc = ReportConfiguration()
        self.backupFile(rcc.filePath)
        for category in reports:
            isDelete = self.getIsDelete(category)
            rcc.handle(category["CATEGORY"], self.getRaname(category), isDelete)
                
            if isDelete:
                continue
            
            for report in category["REPORTS"]:
                rc.handle(category["CATEGORY"], report["TITLE"],report["CATALOGNAME"],report["REPORTNAME"],"1",self.getIsDelete(report));
    
    # remove unused reports
    def removeUnusedReports(self):
        unusedReportSet = self.getConfig(PrepackReportInstaller.JSON_TAG_UNUSED_REPORTS)
        
        if unusedReportSet is None or len(unusedReportSet)==0:
            return
        
        reportFileExtension = ['.cls']
        installPackageReportFileList = ['']
        unusedReportFileList = ['']
        
        for reportSet in unusedReportSet:
            catalogName = reportSet["CATALOGNAME"]
            reports = reportSet["REPORTS"]
            
            unusedReportFileList = []
            for report in reports:
                unusedReportFileList.append(report["REPORTNAME"])
            catalogPath = self.jreportPath + catalogName
            if not os.path.exists(catalogPath):
                continue
            installPackageReportFileList = self.listDirectory(catalogPath, reportFileExtension)
            
            for item in installPackageReportFileList:
                if os.path.split(item)[1] in unusedReportFileList:
                    os.remove(item)
                
    def getDeploymentPath(self):
        return self.jreportPath
    
    def getReportConfigureFilePath(self):
        return self.cmsReportConfigurationFilePath
    
    def getJreportCatalogDataSourceFilePath(self):
        return self.reportCatalogDataSourceFilePath
    
    def configureCategoryAndReports(self):
        pass

class CMS3_0_PrepackReportInstaller(PrepackReportInstaller):
    
    def __init__(self, config=None):
        PrepackReportInstaller.__init__(self,config)
        self.jreportPath = "/opt/tandbergtv/jreport/workspace/jreports/"    
        
    def configureCategoryAndReports(self):
        username = self.config["cms"]["user"]
        password = self.config["cms"]["password"]
        if self.config["cms"].has_key('jreport_user'):
            username = self.config["cms"]["jreport_user"]
        if self.config["cms"].has_key('jreport_password'):
            password = self.config["cms"]["jreport_password"]
        rp = ReportPublisher("localhost", username, password)
        categories = self.getConfig(PrepackReportInstaller.JSON_TAG_JREPORT)
        reports = self.getConfig(PrepackReportInstaller.JSON_TAG_REPORTS)
        
        """configure the category"""
        if categories is not None:
            for category in categories:
                rp.unPublishCategory(self.getItemConfigValue(category, "NAME"))
                if not self.getIsDelete(category):
                    rp.publish(self.getItemConfigValue(category, "PATH"), self.getItemConfigValue(category, "NAME"), self.getItemConfigValue(category, "DESC"))
                else:
                    path = self.getItemConfigValue(category, "PATH")
                    if os.path.exists(path):
                        remove_tree(path)
            
        """delete the report"""
        if reports is not None:
            for r in reports:
                for report in r["REPORTS"]:
                    reportName = report["REPORTNAME"]
                    if self.getIsDelete(report) and reportName:
                        resp = rp.unPublishReport(reportName)
                
        rp.logout()    

class Above_CMS3_0_PrepackReportInstaller(PrepackReportInstaller):
    
    def __init__(self, config=None):
        PrepackReportInstaller.__init__(self, config)
        self.jreportPath = "/opt/tandbergtv/jreport/deploy/"
       
    def configureCategoryAndReports(self):
        categories = self.getConfig(PrepackReportInstaller.JSON_TAG_JREPORT)
        
        if categories is None:
            return
        
        """configure the category"""
        for category in categories:
            if self.getIsDelete(category):
                path = self.getItemConfigValue(category, "PATH")
                if os.path.exists(path):
                    remove_tree(path)   
                    
                    
class CMS4_0_PrepackReportInstaller(Above_CMS3_0_PrepackReportInstaller):
    def __init__(self, config=None):
        Above_CMS3_0_PrepackReportInstaller.__init__(self, config)

    def configureJreportCatalogDataSource(self):
        catalogDataSourceConfiguration = JreportDataSourceConfiguration(self.reportCatalogDataSourceFilePath)
        catalogDataSourceConfiguration.configureJreportCatalogDataSource()
        
class CMS4_1_PrepackReportInstaller(CMS4_0_PrepackReportInstaller):
    def __init__(self, config=None):
        CMS4_0_PrepackReportInstaller.__init__(self, config)
        self.jreportPath = "/opt/tandbergtv/cms/conf/jreport/deploy/"
   
  
def main():
    pass

if __name__ == "__main__":
    main()          
