#!/usr/bin/env python
'''
Created on Jan 4, 2013

@author: ebracox
'''

import paramiko
import socket
import traceback

class RemoteDatabaseConnection(object):
	'''
	classdocs
	'''

	def __init__(self):
		'''
		Constructor
		'''
		username = "cms"
		password = "cms1234"
		host = "dbserver"
		port = 22
		
		self.client = paramiko.SSHClient()
		self.client.load_system_host_keys()
		
		self.client.set_missing_host_key_policy(paramiko.AutoAddPolicy())
		print "*** Connecting..."
		self.client.connect(host, port, username, password)
		#self.transport = self.client.get_transport()
		#self.channel = self.transport.open_session()
		self.channel = self.client.invoke_shell()
		
		self.channel.settimeout(1.0)
		self.flush()

		self.send("su")
		self.send("root1234")
		self.send("su - oracle")
		self.send("source /home/oracle/.bash_profile")
		
		self.send("$ORACLE_HOME/bin/sqlplus /nolog")
		self.send("connect / as sysdba")
		self.send("set feedback on")
	
	def commit(self):
		self.send("commit;")
		
	def execute(self, query, commit=False):
		self.send(query)
		if str(commit).lower() == "true":
			self.commit()
	
	def logout(self):
		self.send("quit;")
		self.channel.close()
		#self.transport.close()
		self.client.close()
	
	def flush(self):
		#self.channel.recv_ready()
		while 1:
			try:
				#resp = self.channel.in_buffer.read(1024, .1)
				resp = self.channel.recv(1024)
				print resp
			except paramiko.buffered_pipe.PipeTimeout:
				break
			except socket.timeout:
				break
			
		
	def send(self, command, addLF=True):
		#print "Sending %s bytes..." % (len(command) + 1)
		bytesSent = self.channel.send(command + ["", "\n"][addLF])
		#print "Actually sent %s bytes." % bytesSent

		#self.channel.sendall(command + ["", "\n"][addLF])
		self.flush()
		self.flush()

def main(query):
	import json
	f = json.load(open("../azuki.json"))
	try:
		rdc = RemoteDatabaseConnection()
		for query in f["queries"]:
			rdc.execute(query["QUERY"], True)
		rdc.logout()
	except Exception, e:
		traceback.print_exc()
		print e
		rdc.logout()
		
if __name__ == "__main__":
	query = """create or replace view wfs.title_ingestion_info as 
SELECT distinct extractvalue(sys_nc_rowinfo$,'/ECMFSpec/Package/Fields/ProviderInfo/Identifier/Id') as provider_id,
              extractvalue(sys_nc_rowinfo$,'/ECMFSpec/Package/Fields/ProviderInfo/Name') as provider_name,
              extractvalue(sys_nc_rowinfo$,'/ECMFSpec/@documentId') as document_id,
              extractvalue(sys_nc_rowinfo$,'/ECMFSpec/Package/Title/Fields/Title/ShortTitle/Value') as title_brief, 
              extractvalue(sys_nc_rowinfo$,'/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowStart') as License_start_date, 
              extractvalue(sys_nc_rowinfo$,'/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowEnd') as license_end_date,
              count(x.assetid) over (PARTITION BY t.id_ order by t.id_) as asset_count,  --count(x.assetid) as asset_count,
              to_date(to_char(pi.start_,'yyyy-mm-dd'),'yyyy-mm-dd') as wo_start,
              to_date(to_char(pi.end_  ,'yyyy-mm-dd'),'yyyy-mm-dd') as wo_end,
              (pi.end_ - pi.start_) day(2) to second(0) ingestion_time,
              round((extract(second from (pi.end_ - pi.start_))+
              extract(minute from (pi.end_ - pi.start_))*60 +
              extract(hour from (pi.end_ - pi.start_))*60*60 +
              extract(day from (pi.end_ - pi.start_))*60*60*24),0) as ingestion_time_seconds
FROM wfs.MDM_METADATA m, xmltable('/ECMFSpec/*/*/@assetId' passing m.object_value columns assetid number path '.') x,
           wfs.pmm_title t, wfs.jbpm_variableinstance vi, wfs.jbpm_processinstance pi, wfs.jbpm_processdefinition pd 
 where t.mdmdocid=extractvalue(sys_nc_rowinfo$,'/ECMFSpec/@documentId')
     and t.originaltitle_id is null
     and t.id_ = vi.stringvalue_ 
     and vi.name_='titleId'
     and vi.processinstance_ = pi.id_
     and pi.operationalprocessstatusid=6
     and pd.id_ = pi.processdefinition_
     and pd.name_='Ingest Template';"""
	main(query)