#!/usr/bin/env python
import BaseClass
import os
import xml

from xml.dom.minidom import parseString
import fnmatch

from CMSVersionDeploymentPolicy import CMSVersionDeploymentPolicy

class ReportCategoryConfiguration(BaseClass.BaseClass):
    filePath="/opt/tandbergtv/cms/conf/report/report-config.xml"

    def __init__(self):
        BaseClass.BaseClass.__init__(self)
        
        self.jreportDeployPath = CMSVersionDeploymentPolicy.getReportDeploymentPath()
        
    
    def checkExistence(self, data):
        if not os.path.exists(self.filePath):
            return False
        f = file(self.filePath, "r").read()
        try:
            dom = parseString(f)
        except  xml.parsers.expat.ExpatError as err:
            return False
        
        item = filter(lambda element : element.getAttribute("name") == data[0], dom.getElementsByTagName("reportCategory"))
        try:
            return item[0]
        except:
            return False
        
    def getNextId(self):
        return 0
    
    def insert(self, id_, data):
        print "Adding Report Category '%s' to report-config.xml..." % (data[0])
        self.initFileIfNotExists()
        
        fin = file(self.filePath, "r").read()
        dom = parseString(fin)
        root = dom.getElementsByTagName("reports")[0]
        
        reportCategoryElement = dom.createElement("reportCategory")
        reportCategoryElement.setAttribute("name", data[0])
        root.appendChild(reportCategoryElement)
        
        fout = file(self.filePath, "w")
        prettyxml = self.prettyxml(dom)
        fout.write(prettyxml)
        fout.close()
    
    def update(self, data):
        if (len(data) < 2 or data[len(data)-1] == None):
            print "WARNING: Parameters passed in invalid!!!"
            return 
        
        if not os.path.exists(self.filePath):
            print "WARNING: '%s' does not exist!!!"
            return
        
        print "Rename Report Category '%s' to '%s' in report-config.xml..." % (data[0], data[1])
        
        fin = file(self.filePath, "r").read()
        dom = parseString(fin)
        root = dom.getElementsByTagName("reports")[0]
        reportCategoryElements = root.getElementsByTagName("reportCategory")
        for element in reportCategoryElements:
            if element.getAttribute("name") == data[0]:
                element.setAttribute("name", data[1])
        
        fout = file(self.filePath, "w")
        prettyxml = self.prettyxml(dom)
        fout.write(prettyxml)
        fout.close()
    
    def delete(self, data):
        """ delete a category from the configuration file
        data[0]: catalog name
        """
        catName = data[0]
        print "Delete report '%s' from report-config.xml..." % (catName)
        
        fin = file(self.filePath, "r").read()
        dom = parseString(fin)
        category = filter(lambda element : element.getAttribute("name") == catName, dom.getElementsByTagName("reportCategory"))
        
        if category is not None and len(category):
            dom.getElementsByTagName("reports")[0].removeChild(category[0])
        
            fout = file(self.filePath, "w")
            prettyxml = self.prettyxml(dom)
            fout.write(prettyxml)
            fout.close()     
    
    def backup(self, *data):
        """  only do this for CMS3.0
        data[0]: category list
        """
        catalogList = []
        for category in data[0]:
            path = category["PATH"]
            # mark the category to be deleted during rollback if the path does not exist
            if not os.path.exists(path):
                catalogPair = ()
                oneCatalog = []
                #NAME
                oneCatalog.append(category["NAME"])
                #DESC
                oneCatalog.append(category["DESC"])
                #PATH
                oneCatalog.append(category["PATH"])  
                catalogPair = (True, oneCatalog)
                catalogList.append(catalogPair)                              
        
        execlueFilters = ["*SampleReports", "*WPCatalog"]
        
        # Backup existing categories
        for f in os.listdir(self.jreportDeployPath):
            path = self.jreportDeployPath + os.sep + f
            if not os.path.isdir(path):
                continue
            
            if not self.matchFile(path, execlueFilters):
                catalogPair = ()
                oneCatalog = []
                # NAME
                oneCatalog.append(f)
                #DESC
                oneCatalog.append(f)
                #PATH
                oneCatalog.append(path)
                
                catalogPair = (False, oneCatalog)
                catalogList.append(catalogPair)
                
        return catalogList

    def matchFile(self, file, filters):
        for pattern in filters:
            if fnmatch.fnmatch(file, pattern):
                return True
        return False                
        
    def initFileIfNotExists(self):
        if not os.path.exists(self.filePath):
            self.initFile()
        else:
            f = file(self.filePath, "r").read()
            try:
                dom = parseString(f)
            except  xml.parsers.expat.ExpatError as err:
                self.initFile()
        
    def initFile(self):
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<reports baseURL=\"/jreport/jinfonet/tryView.jsp?jrs.auth_uid=cms&amp;jrs.auth_pwd=cms&amp;\"/>"
        self.createFile(self.filePath, xml)

def main():
    cf = ReportCategoryConfiguration()
    cf.add(("Content Reports1"))
    
if __name__ == "__main__":
    main()
