import unittest 
import xml
from xml.dom.minidom import parseString

from mock import Mock

import sys
sys.modules['SSHCommander'] = Mock()

from UnittestBase import UnittestBase

from ReportCategoryConfiguration import ReportCategoryConfiguration

class ReportCategoryConfigurationTest(UnittestBase):
    REPORT_CONFIG_PATH = "res/report-config.xml"
    REPORT_CONFIG_PATH_INVALID = "res/report-config-invalid.xml"
    
    def setUp(self):
        '''        
        fake_module = mock.MagicMock()
        sys.modules['Crypto.Util._counter']=fake_module
        sys.modules['Crypto.Cipher._AES']=fake_module

        setattr(Crypto.Util, '_counter', fake_module) 
        setattr(Crypto.Cipher, '_AES', fake_module) 
        
        win_random=winrandom
        win_random.new=MagicMock()
        '''
        UnittestBase.setUp(self)
        self.rcc = ReportCategoryConfiguration()
        self.rcc.filePath = ReportCategoryConfigurationTest.REPORT_CONFIG_PATH
    
    def teardown(self):
        unittest.TestCase.tearDown(self)
    
    def testUpdateReportCategorySuccessfully(self):
        oldCategoryName = 'Content Reports'
        newCategoryName = 'Prepack Reports'
        data = ['Content Reports','Prepack Reports']
        self.rcc.update(data)
        
        dom = None
        f = file(ReportCategoryConfigurationTest.REPORT_CONFIG_PATH, "r").read()
        try:
            dom = parseString(f)
        except  xml.parsers.expat.ExpatError as err:
            return False
        
        self.assertEqual(dom.getElementsByTagName("reportCategory")[0].getAttribute('name'), newCategoryName)

        self.assertNotEqual(dom.getElementsByTagName("reportCategory")[0].getAttribute('name'), "Content Reports")
        
    def testUpdateReportCategoryFileNotExisted(self):
        
        self.rcc.filePath = ReportCategoryConfigurationTest.REPORT_CONFIG_PATH_INVALID
        oldCategoryName = 'Content Reports'
        newCategoryName = 'Prepack Reports'
        data = ['Content Reports','Prepack Reports']
        ret = self.rcc.update(data)       
        
    def testUpdateReportCategoryInvalidParameters(self):
        data = ['Content Reports']
        self.rcc.update(data)
        
    def testUpdateReportCategoryInvalidParametersNone(self):
        data = ['Content Reports', None]
        self.rcc.update(data)
   
if __name__ == "__main__":
    unittest.main()  
 