#!/usr/bin/env python
import BaseClass
import os
import xml

from xml.dom.minidom import parseString
from CMSVersionDeploymentPolicy import CMSVersionDeploymentPolicy

class ReportConfiguration(BaseClass.BaseClass):

    def __init__(self):
        BaseClass.BaseClass.__init__(self)
        self.filePath = CMSVersionDeploymentPolicy.getReportConfigurationFilePath()
        pass
    
    def checkExistence(self, data):
        if not os.path.exists(self.filePath):
            return False
        f = file(self.filePath, "r").read()
        try:
            dom = parseString(f)
        except  xml.parsers.expat.ExpatError as err:
            return False
        
        categories = filter(lambda element : element.getAttribute("name") == data[0], dom.getElementsByTagName("reportCategory"))
        reports = filter(lambda element : self.trim(element.getElementsByTagName("title")[0].firstChild.nodeValue) == data[1], categories[0].getElementsByTagName("report"))
        try:
            return reports[0]
        except:
            return False
        
    def getNextId(self):
        return 0
    
    def insert(self, id_, data):
        print "Adding report configuration '%s' to report-config.xml..." % (data[1])
        
        fin = file(self.filePath, "r").read()
        dom = parseString(fin)
        
        self.insertDom(dom, data)
        
        fout = file(self.filePath, "w")
        prettyxml = self.prettyxml(dom)
        fout.write(prettyxml)
        fout.close()
    
    def update(self, data):
        print "Updating report configuration '%s' to report-config.xml..." % (data[1])
        
        fin = file(self.filePath, "r").read()
        dom = parseString(fin)
        categories = filter(lambda element : element.getAttribute("name") == data[0], dom.getElementsByTagName("reportCategory"))
        reports = filter(lambda element : self.trim(element.getElementsByTagName("title")[0].firstChild.nodeValue) == data[1], categories[0].getElementsByTagName("report"))
        
        categories[0].removeChild(reports[0])
        self.insertDom(dom, data)
        
        fout = file(self.filePath, "w")
        prettyxml = self.prettyxml(dom)
        fout.write(prettyxml)
        fout.close()
        
    def insertDom(self, dom, data):   
        category = filter(lambda element : element.getAttribute("name") == data[0], dom.getElementsByTagName("reportCategory"))[0]
        
        reportElement = dom.createElement("report")
         
        titleElement = dom.createElement("title")
        titleElement.appendChild(dom.createTextNode(data[1]))
        reportElement.appendChild(titleElement)
        
        catalogNameElement = dom.createElement("catalogName")
        catalogNameElement.appendChild(dom.createTextNode(data[2]))
        reportElement.appendChild(catalogNameElement)
        
        reportNameElement = dom.createElement("reportName")
        reportNameElement.appendChild(dom.createTextNode(data[3]))
        reportElement.appendChild(reportNameElement)
        
        reportVersionElement = dom.createElement("reportVersion")
        reportVersionElement.appendChild(dom.createTextNode(data[4]))
        reportElement.appendChild(reportVersionElement)
        
        category.appendChild(reportElement)
        
    def delete(self, data):
        """ delete a report from the configuration file
        data[0]: catalog name
        data[1]: title
        """
        print "Delete report '%s' from report-config.xml..." % (data[1])
        
        catName = data[0]
        title = data[1]
        
        fin = file(self.filePath, "r").read()
        dom = parseString(fin)
        
        for catElem in dom.getElementsByTagName("reportCategory"):
            name = catElem.getAttribute("name")
            if catName == name:
                for reportTitle in catElem.getElementsByTagName("title"):
                    if reportTitle.firstChild.nodeValue == title:
                        catElem.removeChild(reportTitle.parentNode)

        fout = file(self.filePath, "w")
        prettyxml = self.prettyxml(dom)
        fout.write(prettyxml)
        fout.close()

def main():
    cf = ReportConfiguration()
    cf.add(("Content Reports", "Content Ingest Report", "/prepack-catalog/PrePackCatalog.cat", "/prepack-catalog/PrePackContentIngestionRep.cls", "1"))
    
if __name__ == "__main__":
    main()
