#!/usr/bin/env python
'''
Created on Jan 3, 2013

@author: ebracox
'''
import base64
import cookielib
import sys
import urllib
import urllib2
import os
import time
from HttpRequestDecorator import HttpRequestDecorator

class ReportPublisher(object):
	REPORT_SERVER_ROOTURL = "https://%s:8443/jreport/admin/index.jsp"
	
	def __init__(self, host="localhost", username="admin", password="admin"):
		self.host = host
		self.rootUrl = self.REPORT_SERVER_ROOTURL % host
		#rootUrl = "https://%s:8443/jreport/admin/index.jsp" % host
		self.postUrl = "https://%s:8443/jreport/admin/saveNodeProperties.jsp?jrs.cmd=jrs.import_resource" % host
		self.permUrl = "https://%s:8443/jreport/admin/savePermissions.jsp" % host
		self.logoutUrl = "https://%s:8443/jreport/admin/logout.jsp" % host
		self.deleteUrl = "https://%s:8443/jreport/admin/deleteNode.jsp?" % host
		
		self.TAG_PATH = "jrs.path"
		self.TAG_PAGE_STYLE = "jrs.page_style"
		
		self.cj = cookielib.CookieJar()
		self.opener = urllib2.build_opener(urllib2.HTTPCookieProcessor(self.cj), urllib2.HTTPSHandler())
		urllib2.install_opener(self.opener)
		
		request = urllib2.Request(self.rootUrl)
		auth = "Basic %s" % base64.b64encode("%s:%s" % (username, password))
		request.add_header("Authorization", auth)
		try:
			urllib2.urlopen(request).read() #Fails, but returns cookie which will allow for future authentication success
		except Exception:
			try:
				HttpRequestDecorator.urlopen(request).read()
				print 'Report Server Authorization OK'
			except Exception, e:
				print e
				raise Exception, "Failed to correctly authenticate."
			
	def publish(self, reportPath, reportName, reportDesc):	
		values = {
			'jrs.deploy_from_file': reportPath, 
			'jrs.node_name': reportName, 
			'jrs.node_desc': reportDesc, 
			'jrs.only_deploy_files': 'false', 
			'jrs.deploy_from_rpt': '', 
			'jrs.node_real_path': '', 
			'jrs.node_type': 3, 
			'jrs.need_maxversion': 'true', 
			'jrs.cmd': 'jrs.import_resource', 
			'autoConvert': 'true', 
			'jrs.auth_uid': 'admin', 
			'jrs.only_deploy_files_and_subfolders': 'false', 
			'jrs.folder_with_contents': 'true', 
			'jrs.archive_new_version': 'true', 
			'jrs.path': '/', 
			'jrs.deploy_local_font_dir': '', 
			'jrs.maxversion': 0, 
			'cmd': 'jrs.import_resource', 
			'userPermission': '', 
			'permission_key': 'permission1357655588494', 
			'jrs.page_style': 1, 
			'jrs.deploy_local_style_dir': ''
		}
		
		req = urllib2.Request(self.postUrl, urllib.urlencode(values))
		resp = HttpRequestDecorator.urlopen(req)
		resp.read()
		
		self.setPermissions("/" + reportName)
		
		return resp
	
	def unPublishCategory(self, *data):
		""" delete category from jreport"""
		categoryName = data[0]
		categoryPath = "/" + categoryName
		return self.deleteNode(categoryName, categoryPath)
		
	def unPublishReport(self, *data):
		""" delete report from jreport"""
		reportPath = data[0]
		reportName = os.path.split(reportPath)[1]
		return self.deleteNode(reportName, reportPath)
	
	def deleteNode(self, nodeName, tagPath):
		""" delete the category or report from jreport server
		delete category:
			nodeName: category name(prepack-catalog)
			tagPath: category path(/prepack-catalog)
		delete report:
			data[0]: reportName(/prepack-catalog/PrePackContentIngestionRep.cls)
			nodeName: report name(PrePackContentIngestionRep.cls)
			tagPath: report path(/prepack-catalog/PrePackContentIngestionRep.cls)
		Limitations: 
	    1. Support deleting report, catalog
		2. only support in CMS3.0
		3. make sure corresponding reports are deleted from report-config.xml(restart CMS)
		"""
		parameters = "delNodeName=" + nodeName + "&" + self.TAG_PATH + "=" + tagPath + "&" + self.TAG_PAGE_STYLE + "=1"
		
		requestUrl = self.deleteUrl + parameters
		
		req = urllib2.Request(requestUrl, None)
		resp = HttpRequestDecorator.urlopen(req)
		resp.read()
		
		return True
	
	def setPermissions(self, reportName):
		values = {
			'jrs.path': reportName,
			'rolecomm': '',
			'jrs.version_number': 'null',
			'r$everyone': 'true',
			'jrs.role_permission$everyone.visible': 'true',
			'is_prop': 'true',
			'removedRoles': '',
			'role1': 'r$everyone;',
			'currgroup': '',
			'jrs.role_permission$everyone.read': 'true',
			'jrs.role_permission$everyone.execute': 'true',
			'currrole': 'r$everyone;',
			'isVersion': 'false',
			'permissionsValue': '',
			'hidePathInfo': 'false',
			'removedUsers': '',
			'curruser': '',
			'is_schedule': 'false',
			'jrs.define_permission': 'true',
			'cmd': '',
			'permission_key': 'null',
			'temprole1': '',
			'removedGroups': ''
		}
		
		req = urllib2.Request(self.permUrl, urllib.urlencode(values))
		resp = HttpRequestDecorator.urlopen(req)
		resp.read()
		
		return resp
	
	def logout(self):
		req = urllib2.Request(self.logoutUrl)
		resp = HttpRequestDecorator.urlopen(req)
		resp.read()
		
	@staticmethod
	def checkAndWaitReportServerAvailable(waitForUp = True, interval = 5, timeout = 60, host="localhost"):
		timeToWait = timeout
		while waitForUp and timeToWait > 0:
			try:
				resp = HttpRequestDecorator.request(ReportPublisher.REPORT_SERVER_ROOTURL  % host, "GET")
				if resp[0]["status"] == '401' or resp[0]["status"] == '400':
					print "Report Server is up"
					return True
				else:
					print "Report Server is not up yet, wait for " + str(interval) + " seconds to check again."
			except Exception:
				pass
			time.sleep(interval)
			timeToWait = timeToWait -interval
		print "Report Server is still not up after " + str(timeout) + " seconds. Please check the network."
		return False

def main():
# 	rp = ReportPublisher()
#  	resp = rp.publish("/tmp/azuki", "AzukiCatalog", "AzukiCatalog")
	
# 	rp.logout()
	ReportPublisher.checkAndWaitReportServerAvailable(host="10.116.5.99")

if __name__ == '__main__':
	main()