#!/usr/bin/env python
import BaseClass
import ResourceGroupMembership

class Resources(BaseClass.BaseClass):
	def __init__(self):
		BaseClass.BaseClass.__init__(self)
		
		self.columns = "NAME, RESOURCETYPENAME, CONNECTIONSTRING, MAXCONCURRENTUSERS, ADMINISTRATIVERESOURCESTATUSID, "\
			"OPERATIONALRESOURCESTATUSID, HEARTBEATCONNECTIONSTRING, HEARTBEATFREQUENCY, ISACTIVE, IGNORETIMEOUT, USER_NAME, FUNCTIONALTYPE"
		self.selectStatement = "SELECT R.NAME, RT.NAME AS RESOURCETYPENAME, R.CONNECTIONSTRING, R.MAXCONCURRENTUSERS, R.ADMINISTRATIVERESOURCESTATUSID, R.OPERATIONALRESOURCESTATUSID, R.HEARTBEATCONNECTIONSTRING, R.HEARTBEATFREQUENCY, R.ISACTIVE, R.IGNORETIMEOUT, R.USER_NAME, R.FUNCTIONALTYPE "\
			"FROM TTV_RESOURCE R "\
			"JOIN TTV_RESOURCETYPE RT "\
    		"ON (R.RESOURCETYPEID = RT.RESOURCETYPEID)"
	
	
	def checkExistence(self, data):
		resourceName = data[0]
		self.cursor.execute("SELECT RESOURCEID FROM TTV_RESOURCE WHERE NAME='%s' AND ISACTIVE=1" % resourceName)
		rows = self.cursor.fetchall()
		if len(rows):
			return rows[0][0]
		else:
			return False
		
	def getNextId(self):
		self.cursor.execute("SELECT WFS.TTV_RESOURCE_SEQ.NEXTVAL FROM DUAL")
		return self.cursor.fetchall()[0][0]
	
	def insert(self, id_, data):
		try:
			resourceTypeId = self.getResourceTypeId(data[1])
			statement = "INSERT INTO TTV_RESOURCE (RESOURCEID, RESOURCETYPEID, NAME, CONNECTIONSTRING, MAXCONCURRENTUSERS, ADMINISTRATIVERESOURCESTATUSID, "\
			"OPERATIONALRESOURCESTATUSID, HEARTBEATCONNECTIONSTRING, HEARTBEATFREQUENCY, ISACTIVE, IGNORETIMEOUT, USER_NAME, FUNCTIONALTYPE) VALUES %s" % self.tupleToStr(
				[id_, resourceTypeId, data[0]] + list(data[3:]))
			print statement 
			self.cursor.execute(statement)
			
			rgm = ResourceGroupMembership.ResourceGroupMembership()
			
			resourceGrps = data[2]
			if resourceGrps is None or not len(resourceGrps):
				return self.commit()
			
			isAddResourceGrpSuccessful = True	
			for resourceGrp in resourceGrps:
				if not rgm.handle(data[0], resourceGrp.replace("\\", ""), False):
					isAddResourceGrpSuccessful = False
			
			if isAddResourceGrpSuccessful:
				return self.commit()
			else:
				return self.rollback()
		except Exception, e:
			print e
			return self.rollback()
		
	def convert(self,val):
		if val is None or val == '':
			return 'NULL'
		return val
	
	def update(self, data):
		try:
#             columnDataMap = [
#                 {"name":"CONNECTIONSTRING","index":"3"},
#                 {"name":"MAXCONCURRENTUSERS","index":"4","notString":true},
#                 {"name":"ADMINISTRATIVERESOURCESTATUSID","index":"5"},
#                 {"name":"OPERATIONALRESOURCESTATUSID","index":"6"},
#                 {"name":"HEARTBEATCONNECTIONSTRING","index":"7"},
#                 {"name":"HEARTBEATFREQUENCY","index":"8"},
#                 {"name":"IGNORETIMEOUT","index":"9"},
#                 {"name":"USER_NAME","index":"104"},
#                 {"name":"FUNCTIONALTYPE","index":"11"}
#             ]
 			resourceTypeId = self.getResourceTypeId(data[1])
 			statement = "UPDATE TTV_RESOURCE SET RESOURCETYPEID=%s, CONNECTIONSTRING='%s', MAXCONCURRENTUSERS=%s, ADMINISTRATIVERESOURCESTATUSID='%s', "\
            "OPERATIONALRESOURCESTATUSID='%s', HEARTBEATCONNECTIONSTRING='%s', HEARTBEATFREQUENCY=%s, IGNORETIMEOUT='%s', USER_NAME='%s', FUNCTIONALTYPE='%s' WHERE NAME='%s' AND ISACTIVE=1" \
            % (resourceTypeId,data[3],data[4],data[5],data[6],data[7],self.convert(data[8]),data[10],data[11],data[12],data[0])
			
#             statement = "UPDATE TTV_RESOURCE SET %s WHERE NAME='%s' AND ISACTIVE=1" \
#              % (resourceTypeId,self.generateUpdateSetClause(data,columnDataMap),data[0])
            
			print statement 
			self.cursor.execute(statement)
			
			rgm = ResourceGroupMembership.ResourceGroupMembership()
			rgm.delete([data[0]])
			
			resourceGrps = data[2]
			if resourceGrps is None or not len(resourceGrps):
				return self.commit()
			
			isAddResourceGrpSuccessful = True	
			for resourceGrp in resourceGrps:
				if not rgm.handle(data[0], resourceGrp.replace("\\", ""), False):
					isAddResourceGrpSuccessful = False
			
			if isAddResourceGrpSuccessful:
				return self.commit()
			else:
				return self.rollback()
		except Exception, e:
			print e
			return self.rollback()

	def delete(self, data):
		""" delete the resource:
		data[0]: resourceName
		"""
		resourceId = self.checkExistence(data)
		if resourceId != False:
			try:
				rgm = ResourceGroupMembership.ResourceGroupMembership()
				rgm.delete([data[0]])
				
				# Delete the log referred to the resource Id which will be delete
				statement = "DELETE FROM JBPM_LOG WHERE RESOURCEID='%s'" % resourceId
				self.cursor.execute(statement)				
				statement = "DELETE FROM TTV_MESSAGELOG  WHERE RESOURCEID='%s'" % resourceId
				self.cursor.execute(statement)
				statement = "UPDATE SITES_SITE SET ASSOCIATED_RESOURCE_ID=NULL WHERE ASSOCIATED_RESOURCE_ID='%s'" % resourceId
				self.cursor.execute(statement)
				statement = "DELETE FROM TTV_RESOURCE WHERE RESOURCEID='%s'" % resourceId
				print statement
				self.cursor.execute(statement)
				self.commit()
			except Exception, e:
				print e
				return self.rollback()

	def getResourceTypeId(self, resourceTypeName):
		self.cursor.execute("SELECT RESOURCETYPEID FROM TTV_RESOURCETYPE WHERE NAME='%s'" % resourceTypeName.replace("\\", ""))
		return self.cursor.fetchall()[0][0]
	
	#args[0] : resource name
	def backUpExisting(self, args):
		resourceStatement = "SELECT R.NAME, RT.NAME AS RESOURCETYPENAME, R.CONNECTIONSTRING, R.MAXCONCURRENTUSERS, R.HEARTBEATCONNECTIONSTRING, R.HEARTBEATFREQUENCY, R.USER_NAME "\
			"FROM TTV_RESOURCE R "\
			"JOIN TTV_RESOURCETYPE RT "\
			"ON (R.RESOURCETYPEID=RT.RESOURCETYPEID) "\
			"WHERE R.NAME='%s'"
		self.cursor.execute(resourceStatement % args[0])
		resourceRows = self.cursor.fetchall()
		resourceGrpStatement = "SELECT RG.NAME FROM TTV_RESOURCE R "\
			"JOIN TTV_RESOURCEGROUPMEMBERSHIP RGM "\
			"ON (R.RESOURCEID=RGM.RESOURCEID) "\
			"JOIN TTV_RESOURCEGROUP RG ON (RGM.RESOURCEGROUPID=RG.RESOURCEGROUPID) "\
			"WHERE R.NAME='%s'"
		self.cursor.execute(resourceGrpStatement % args[0]);
		resourceGrps = self.cursor.fetchall()
		if resourceGrps is None or not len(resourceGrps):
			result = list(resourceRows[0][0:2])+[list("")]+list(resourceRows[0][2:])
		else:
			result = list(resourceRows[0][0:2])+[list(resourceGrps[0])]+list(resourceRows[0][2:])
		return result

def main():
	r = Resources()
	r.add("MDMS45", "AMI", "AMI", "http://10.243.90.45:8300/assets", 2, 2, 2, "http://10.243.90.45:8300/assets", 60, 1, 1, "")
# 	r.export("/tmp/resources.tdf")
	
if __name__ == "__main__":
	main()