#!/usr/bin/env python

import sys
#reload(sys)
#sys.setdefaultencoding("utf-8")
import re
import os
import base64
from urllib import urlencode
from HttpRequestDecorator import HttpRequestDecorator

class RulesetService(object):
    
    def __init__(self):
        self.URI_PATH_EXPORT_RULESET_BY_ID = ""
        self.URI_PATH_EXPORT_RULESET_BY_UUID = ""
        self.URI_PATH_IMPORT_RULESET = ""
        
    def setExportByIdUriPath(self, path):
        self.URI_PATH_EXPORT_RULESET_BY_ID = path
    
    def setExportByUuidUriPath(self, path):
        self.URI_PATH_EXPORT_RULESET_BY_UUID = path
        
    def setImportPath(self, path):
        self.URI_PATH_IMPORT_RULESET = path
        
    def getExportByIdUriPath(self):
        return self.URI_PATH_EXPORT_RULESET_BY_ID
        
    def getExportByUuidUriPath(self):
        return self.URI_PATH_EXPORT_RULESET_BY_UUID
    
    def getImportPath(self):
        return self.URI_PATH_IMPORT_RULESET
    
    def importRulesets(self, xmlPath, username, password):
        if xmlPath is None:
            return
        xml = open(xmlPath, 'rb').read ()
        if xml.find("<ruleSets/>") > -1:
            print "No Rules to import."
            return
        auth = base64.encodestring(username + ':' + password)
        head = { 'Authorization' : 'Basic ' + auth, 'content-type':'application/xml'}
        url = self.getImportPath()
        
        credential = self._buildRulesetEntityHeader(username, password)
        
        nextRuleSetEnd=xml.index('</ruleSet>')
        while nextRuleSetEnd > -1:
            ruleSetXml = credential+xml[xml.index('<ruleSet '):nextRuleSetEnd+10]+"</ruleSetToSave>"
            rulename = ruleSetXml[ruleSetXml.index('<ruleName>')+10:ruleSetXml.index('</ruleName>')]
            
            print rulename
            xml = xml[nextRuleSetEnd+10:]
            self._importRuleset(url, head, ruleSetXml.encode("utf-8"))

            try:
                nextRuleSetEnd=xml.index('</ruleSet>')
            except ValueError:
                nextRuleSetEnd=-1
                
    def exportRulesetById(self, ruleSetId, outputPath, username, password):
        if ruleSetId is None or outputPath is None:
            return
        auth = base64.encodestring(username + ':' + password) 
        head = { 'Authorization' : 'Basic ' + auth, 'content-type':'application/x-www-form-urlencoded'}
        data = {'username':username,'password':password}
        url = self.getExportByIdUriPath() + "?ruleSetIds=%s" % ruleSetId
        self._exportRuleset(url, urlencode(data), head, outputPath)
        
    def exportRulesetByUuid(self, uuid, outputPath, username, password):
        if uuid is None or outputPath is None:
            return
        auth = base64.encodestring(username + ':' + password) 
        head = { 'Authorization' : 'Basic ' + auth, 'content-type':'application/x-www-form-urlencoded'}
        data = {'username':username,'password':password}
        url = self.getExportByUuidUriPath() + "?uuid=%s" % uuid
        self._exportRuleset(url, urlencode(data), head, outputPath)

    
    def _importRuleset(self, url, head, ruleSetXml):
        resp = HttpRequestDecorator.request(url + "?overwrite=TRUE", "POST", ruleSetXml.encode("utf-8"), headers=head)
        if not self._checkIfImportSuccess(resp):
            print resp
            print ruleSetXml
            sys.exit(1)
                    
    def _exportRuleset(self, requestUrl, data, head, outputPath): 
        resp = HttpRequestDecorator.request(requestUrl, "POST", data, headers=head)
        if resp[0]["status"] != '200':
            print resp
            raise RuntimeError('Failed to export rule set')
        rulesetString = resp[1]
        # If rule set found
        if "<ruleName>" in rulesetString:
            f = open(outputPath, 'wb')
            f.write(rulesetString.encode('utf-8'))
            f.close()
                
    def _checkIfImportSuccess(self, resp):
        return resp[0]["status"] == '204' or resp[0]["status"] == '200'
    
    def _buildRulesetEntityHeader(self, username=None, password=None):
        return "<ruleSetToSave><userName>" + username + "</userName><password>" + password + "</password>"
        
class CMS3_X_RulesetService(RulesetService):
    
    def __init__(self):
        self.setExportByIdUriPath("https://localhost:8443/services/resteasy/rulesservice/rulesets/")
        self.setExportByUuidUriPath("https://localhost:8443/services/resteasy/rulesservice/rulesetsbyuuid/")
        self.setImportPath("https://localhost:8443/services/resteasy/rulesservice/ruleset/")
        
class CMS3_0_RulesetService(CMS3_X_RulesetService):
    def __init__(self):
        CMS3_X_RulesetService.__init__() 
        
    def _importRuleset(self, url, head, ruleSetXml):
        resp = HttpRequestDecorator.request(url + "?overwrite=TRUE", "POST", ruleSetXml.encode("utf-8"), headers=head)
        if not self._checkIfImportSuccess(resp):
            print resp
            print ruleSetXml
            sys.exit(1)
                
        enable = ruleSetXml[ruleSetXml.index('<enabled>')+9:ruleSetXml.index('</enabled>')]
        if enable == 'true':
            self.__enableRuleset(rulename)           
        
    def _checkIfImportSuccess(self):
        return resp[0]["status"] == '204' or resp[0]["status"] =='475' 

    def __enableRuleset(self, name):
        from Rulesets import Rulesets
        Rulesets().enable(name)             
        
class CMS4_X_RulesetService(RulesetService):
    
    def __init__(self):
        self.setExportByIdUriPath("https://localhost:8443/services/rulesservice/rulesets/")
        self.setExportByUuidUriPath("https://localhost:8443/services//rulesservice/rulesetsbyuuid/")
        self.setImportPath("https://localhost:8443/services/rulesservice/ruleset/")  
        
class CMS5_X_RulesetService(RulesetService):
    
    def __init__(self):
        self.setExportByIdUriPath("https://localhost:8443/services/rulesservice/getRuleSets/")
        self.setExportByUuidUriPath("https://localhost:8443/services//rulesservice/getRuleSetsByUuid/")
        self.setImportPath("https://localhost:8443/services/rulesservice/saveRuleSet/")  
        
    def _importRuleset(self, url, head, ruleSetXml):
        resp = HttpRequestDecorator.request(url, "POST", ruleSetXml.encode("utf-8"), headers=head)
        if not self._checkIfImportSuccess(resp):
            print resp
            print ruleSetXml
            sys.exit(1)

    def _buildRulesetEntityHeader(self, username=None, password=None):
        return "<ruleSetToSave><overwrite>true</overwrite>"      
                        
    def exportRulesetById(self, ruleSetId, outputPath, username, password):
        if ruleSetId is None or outputPath is None:
            return
        auth = base64.encodestring(username + ':' + password) 
        head = { 'Authorization' : 'Basic ' + auth}
        url = self.getExportByIdUriPath() + "?ruleSetIds=%s" % ruleSetId
        self._exportRuleset(url, None, head, outputPath)
        
    def exportRulesetByUuid(self, uuid, outputPath, username, password):
        if uuid is None or outputPath is None:
            return
        auth = base64.encodestring(username + ':' + password) 
        head = { 'Authorization' : 'Basic ' + auth}
        url = self.getExportByUuidUriPath() + "?uuid=%s" % uuid
        self._exportRuleset(url, None, head, outputPath)                            