#!/usr/bin/env python
import BaseClass
import time
import base64
from xml.etree.ElementTree import ElementTree
from HttpRequestDecorator import HttpRequestDecorator
from CMSVersionDeploymentPolicy import CMSVersionDeploymentPolicy

class Rulesets(BaseClass.BaseClass):
	RULE_SERVICE_LOCATION = "https://localhost:8443/rulesservices/restful-services/rulesutil"
	
	def __init__(self, username="admin", password="admin"):
		BaseClass.BaseClass.__init__(self)
	
		self.username = username
		self.password = password
		
		self.columns = "RULENAME"
		self.table = "TRE_RULESET"
		
		self.setSelectStatement()
		self.selectStatement += " WHERE ENABLED=1"
	
	def checkExistence(self, data):
		ruleName = data[0]
		self.cursor.execute("SELECT RULESETID FROM TRE_RULESET WHERE RULENAME='%s'" % ruleName)
		rows = self.cursor.fetchall()
		if len(rows):
			return rows[0][0]
		else:
			return False
		
	def getNextId(self):
		self.cursor.execute("SELECT MAX(RULESETID) FROM TRE_RULESET")
		try:
			return self.cursor.fetchall()[0][0] + 1
		except:
			return 1
	
	def insert(self, id_, data):
		self.enable(data)
		return False
	
		try:
			statement = ""
			print statement 
			self.cursor.execute(statement)
			
			self.commit()
		except Exception, e:
			print e
			self.rollback()
			
	def enable(self, data):
		ruleName = data[0]
		try:
			statement = "UPDATE TRE_RULESET SET ENABLED=1 WHERE RULENAME='%s'" % ruleName
			print statement
			self.cursor.execute(statement)
			
			self.commit()
		except:
			self.rollback()
		
	def importFromFile(self, tdf):
		"""
		tdf=Tab Delimited File
		First line, which has the header for the columns, is ignored.
		"""
		lines = file(tdf, "r").readlines()[1 : ]
		for line in lines:
			fields = map(lambda s : s.strip(), filter(None, line.split("\t")))
			fields = map(lambda s : ["", s][s != "null"], fields)
			self.enable(tuple(fields))		
		
	# delete all the rule sets
	def delete(self, *data):
		requestUrl = self.RULE_SERVICE_LOCATION + "/deleteallrulesets/?username=" + self.username + "&password=" + self.password
		
		resp = HttpRequestDecorator.request(requestUrl , "POST")
		
		if resp[0]["status"] != '200':
			print resp
			exit(1)
		return
	
	def deleteRulSetsByUuid(self, uuids):
		"""
		This method is intend to delete the ruleSet specified by the uuids
			uuids: an array containing all the uuids of rulesets
		"""
		success = True
		
		if uuids:
			for uuid in uuids:
				success = self.deleteByuuid(uuid)
				
				if not success:
					break
		return success
	
	def deleteById(self, id):
		url = self.RULE_SERVICE_LOCATION + "/deleterulesets/?username=" + self.username + "&password=" + self.password + "&ruleSetIds=%s" %id
		resp = HttpRequestDecorator.request(url, "POST", None, None)
		if resp[0]["status"] != '200':
			print resp
			return False
		return True	
	
	def deleteByuuid(self, uuid):
		url = self.RULE_SERVICE_LOCATION + "/deleterulesetbyuuid/?username=" + self.username + "&password=" + self.password + "&uuid=%s" % uuid
		resp = HttpRequestDecorator.request(url, "POST", None, None)
		if resp[0]["status"] != '200':
			print resp
			return False
		return True	
		
	def getUuidsFromXml(self, path):
		"""
		This method is intend to delete the ruleset by the UUID
			path: the file path of the ruleset xml 
		"""
		tree = ElementTree()
		tree.parse(path)
		ruleSets = tree.getroot().find("ruleSets").getiterator("ruleSet")
		
		uuIds = []
		for ruleSet in ruleSets:
			uuid = ruleSet.find("uuid").text
			uuIds.append(uuid)
		
		return uuIds
		
	def sortByUuids(self, uuids):
		if	uuids:
			requestUrl = Rulesets.RULE_SERVICE_LOCATION + "/sortrulesets"
			header = {'content-type':'application/x-www-form-urlencoded'}
			form_data= "username=%s&password=%s&uuids=%s" % (self.username, self.password, ','.join(uuids))
			resp = HttpRequestDecorator.request(requestUrl , "POST", form_data, headers=header)
			if resp[0]["status"] != '200':
				print resp
				return False
		return True
		
	@staticmethod
	def checkAndWaitRullServiceAvailable(waitForUp = True, interval = 5, timeout = 60):
		timeToWait = timeout
		while waitForUp and timeToWait > 0:
			try:
				resp = HttpRequestDecorator.request(Rulesets.RULE_SERVICE_LOCATION + "/deleterulesetbyuuid" , "GET")
				if resp[0]["status"] == '405':
					print "Rule Service is up"
					return True
				else:
					print "Rule Service is not up yet, wait for " + str(interval) + " seconds to check again."
			except Exception:
				pass
			time.sleep(interval)
			timeToWait = timeToWait -interval
		print "Rule Service is still not up after " + str(timeout) + " seconds. Please check the network."
		return False
		
def main():
	Rulesets.RULE_SERVICE_LOCATION = "https://10.116.5.99:8443/rulesservices/restful-services/rulesutil"
	Rulesets.checkAndWaitRullServiceAvailable()
# 	rs.export("/tmp/rulesets.tdf")
	
if __name__ == "__main__":
	main()