#!/usr/bin/env python
import BaseClass
import Sites

class SiteParameters(BaseClass.BaseClass):
	def __init__(self):
		BaseClass.BaseClass.__init__(self)
		
		self.columns = "SITE_NAME, NAME, VALUE"
		self.table = "SITES_DIST_CONF_PARAMS"
		self.selectStatement = "SELECT S.NAME SITE_NAME, P.NAME, P.VALUE "\
			"FROM SITES_DIST_CONF_PARAMS P "\
			"JOIN SITES_SITE S "\
			"ON (P.SITEID = S.ID_)"	
  	
	def checkExistence(self, data):
		self.siteId = Sites.Sites().checkExistence((data[1],))
		if self.siteId == False:
			return False
		name = data[0]
		self.cursor.execute("SELECT VALUE FROM SITES_DIST_CONF_PARAMS WHERE SITEID=%s AND NAME='%s'" % (self.siteId, name))
		rows = self.cursor.fetchall()
		if len(rows):
			return rows[0][0]
		else:
			return False
		
	def getNextId(self):
		return 1
	
	def insert(self, id_, data):
		try:
			statement = "INSERT INTO SITES_DIST_CONF_PARAMS (SITEID, NAME, VALUE) VALUES %s" % self.tupleToStr([self.siteId] + [data[0],data[2]])
			print statement 
			self.cursor.execute(statement)
			
			self.commit()
		except Exception, e:
			print e
			self.rollback()
			
	def update(self, data):
		try:
			statement = "UPDATE SITES_DIST_CONF_PARAMS SET VALUE='%s' WHERE SITEID=%s AND NAME='%s'" % (data[2],self.siteId,data[0])
			print statement 
			self.cursor.execute(statement)
			
			self.commit()
		except Exception, e:
			print e
			self.rollback()
			
	def delete(self, data):
		"""	delete the site parameter from table 'SITES_DIST_CONF_PARAMS'
		if only site Name specified, all the site parameters under this site
		will be deleted. otherwise, only delete that specified parameter
		
		1. delete all the parameter under the site
		data[1]: siteName
		
		2. only delete one site parameter
		data[0]: parameter name
		data[1]: siteName 
		data[...]: not care
		"""
		parmName = data[0]
		if len(data) != 1:
			siteName = data[1]		
		
		siteId = Sites.Sites().checkExistence((data[1],))
		
		try:
			if siteId != False and parmName != None:
				statement = "DELETE FROM SITES_DIST_CONF_PARAMS WHERE SITEID='%s' AND NAME='%s'" % (siteId, parmName)
			else:
				statement = "DELETE FROM SITES_DIST_CONF_PARAMS WHERE SITEID='%s'" % siteId
			print statement
			self.cursor.execute(statement)
			
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()

	def backUpExisting(self, args):	
		"""
		args[0]: paraName 
		args[1]: siteName
		"""				
		siteOneParametersStatement = "SELECT SP.NAME, SP.VALUE FROM SITES_DIST_CONF_PARAMS SP "\
		  		"JOIN SITES_SITE SS ON (SP.SITEID = SS.ID_) WHERE  SS.NAME='%s' AND  SP.NAME='%s'"
		result = ""
		if(len(args) >= 2 ):
			self.cursor.execute(siteOneParametersStatement % (args[1],args[0]))
			siteParameterRows = self.cursor.fetchall()
			result = siteParameterRows[0]
		return result
    
	def backUpAllExisting(self, args):
		"""
		args: siteName
		"""
		items = []				
		siteAllParametersStatement = "SELECT SP.NAME, SP.VALUE FROM SITES_DIST_CONF_PARAMS SP "\
		  		"JOIN SITES_SITE SS ON (SP.SITEID = SS.ID_) WHERE SS.NAME='%s'"
		
		if(args is not None and len(args)):
			self.cursor.execute(siteAllParametersStatement %args)
			siteParameterRows = self.cursor.fetchall()
			for row in siteParameterRows:
				paraObj = {}
				if row[0] is None:
					paraObj["NAME"] = ""
				else:
					paraObj["NAME"] = row[0]
					
				if row[1] is None:
					paraObj["VALUE"] = ""
				else:
					paraObj["VALUE"] = row[1]
				items.append(paraObj)
		return items
    
def main():
	s = SiteParameters()
	
	s.export("/tmp/siteparameters.tdf")
	
if __name__ == "__main__":
	main()