#!/usr/bin/env python
import BaseClass
import Partners
import Resources
import urllib
import time
from HttpRequestDecorator import HttpRequestDecorator

class Sites(BaseClass.BaseClass):
    SITE_SERVICE_LOCATION = "https://localhost:8443/siteservices/restful-services/siteservices"
    
    def __init__(self):
        BaseClass.BaseClass.__init__(self)
        
        self.columns = "NAME, EXTERNALID, ACTIVE, DISTRIBUTION_OPTION, METADATA_FORMAT, FILE_LOOKUP_KEYS, "\
            "DIST_TEMPLATE_NAME, ALERT_DELAY_PERIOD, TYPE"
        self.table = "SITES_SITE"
        self.setSelectStatement()    
    
    def checkExistence(self, data):
        siteName = data[0]
        self.cursor.execute("SELECT ID_ FROM SITES_SITE WHERE NAME='%s'" % siteName)
        rows = self.cursor.fetchall()
        if len(rows):
            return rows[0][0]
        else:
            return False
        
    def getNextId(self):
        self.cursor.execute("SELECT WFS.SITES_SITE_SEQ.NEXTVAL FROM DUAL")
        return self.cursor.fetchall()[0][0]
    
    def insert(self, id_, data):
        try:
            associateResouceId = 'null'
            if data[9]:
                associateResouceId = Resources.Resources().checkExistence([data[9]])
            statement = "INSERT INTO SITES_SITE (ID_, NAME, EXTERNALID, ACTIVE, DISTRIBUTION_OPTION, METADATA_FORMAT, "\
                "FILE_LOOKUP_KEYS, DIST_TEMPLATE_NAME, ALERT_DELAY_PERIOD, TYPE, ASSOCIATED_RESOURCE_ID) VALUES (%s, '%s', '%s', %s, %s, '%s', '%s', '%s', %s, %s, %s)" % \
                (id_, data[0], data[1],data[2],data[3],data[4],data[5],data[6],data[7],data[8], associateResouceId) 
            print statement 
            self.cursor.execute(statement)
            
            p = Partners.Partners()
            if p.handle("","SITE_%s" % id_, 1, "", "", False):
                self.commit()
            else:
                self.rollback()
        except Exception, e:
            print e
            self.rollback()

    def update(self,data):
        try:
            associateResouceId = 'null'
            if data[9]:
                associateResouceId = Resources.Resources().checkExistence([data[9]])
            statement = "UPDATE SITES_SITE SET EXTERNALID='%s', ACTIVE=%s, DISTRIBUTION_OPTION=%s, METADATA_FORMAT='%s', "\
                "FILE_LOOKUP_KEYS='%s', DIST_TEMPLATE_NAME='%s', ALERT_DELAY_PERIOD=%s, TYPE=%s, ASSOCIATED_RESOURCE_ID=%s WHERE NAME='%s'" \
                % (data[1],data[2],data[3],data[4],data[5],data[6],data[7],data[8],associateResouceId,data[0])
            print statement 
            self.cursor.execute(statement)
            return self.commit()

        except Exception, e:
            print e
            self.rollback()
    
    
    def delete(self, data):
        """ delete the site from table 'SITES_SITE' by site name
        data[0]: Site Name
        """
        siteName = data[0]
        siteId = self.checkExistence(data)
        
        if siteId != False:
            param = urllib.urlencode({'sitename': siteName })
                
            url = self.SITE_SERVICE_LOCATION + "/deletedistributionsite?%s" % param
            resp = HttpRequestDecorator.request(url, "POST")
            if resp[0]["status"] != '200':
                print "Site: " + siteName + " delete failed"
                print resp
                return False
            print "Site: " + siteName + " deleted"
            p = Partners.Partners()
            partnerName = "SITE_" + str(siteId)
            p.deleteDistributionPartner(partnerName, 1)
                
            
    #["NAME","EXTERNALID","ACTIVE","DISTRIBUTION_OPTION","METADATA_FORMAT","FILE_LOOKUP_KEYS","DIST_TEMPLATE_NAME","ALERT_DELAY_PERIOD","TYPE"]     
    def backUpExisting(self, args):    
        """
        args[0]: site name
        """
        siteStatement = "SELECT SS.NAME, SS.EXTERNALID, SS.ACTIVE, SS.DISTRIBUTION_OPTION, SS.METADATA_FORMAT, "\
            "SS.FILE_LOOKUP_KEYS, SS.DIST_TEMPLATE_NAME, SS.ALERT_DELAY_PERIOD, SS.TYPE, TR.NAME " \
            "FROM SITES_SITE SS LEFT OUTER JOIN TTV_RESOURCE TR ON (SS.ASSOCIATED_RESOURCE_ID = TR.RESOURCEID) " \
            "WHERE SS.NAME='%s'"   

        if args[0] is None or not len(args[0]):
            return
        
        self.cursor.execute(siteStatement % args[0])
        siteRows = self.cursor.fetchall()        
        result = siteRows[0]
        return result
    
#    def _export(self):
#        statement = "SELECT ID_, NAME, EXTERNALID, ACTIVE, DISTRIBUTION_OPTION, METADATA_FORMAT, FILE_LOOKUP_KEYS, "\
#            "DIST_TEMPLATE_NAME, ALERT_DELAY_PERIOD, TYPE FROM SITES_SITE"
#        print statement
#        self.cursor.execute(self.statement)
#        rows = self.fetchall()
#        
#        output = self.columns + "\n"
#        for row in rows:
#            output += "\t".join(self.noneToNull(row)) + "\n"
#        
#        return output.strip()
    
    @staticmethod
    def checkAndWaitSiteServiceAvailable(waitForUp = True, interval = 5, timeout = 60):
        timeToWait = timeout
        while waitForUp and timeToWait > 0:
            try:
                resp = HttpRequestDecorator.request(Sites.SITE_SERVICE_LOCATION + "/deletedistributionsite" , "GET")
                if resp[0]["status"] == '405':
                    print "Site Service is up"
                    return True
                else:
                    print "Site Service is not up yet, wait for " + str(interval) + " seconds to check again."
            except Exception:
                pass
            time.sleep(interval)
            timeToWait = timeToWait -interval
        print "Site Service is still not up after " + str(timeout) + " seconds. Please check the network."
        return False
    
def main():
    Sites.SITE_SERVICE_LOCATION = "https://10.116.5.99:8443/siteservices/restful-services/siteservices"
#     s.insert(s.getNextId(), ("MDMS2", "MDMS2", 1, 0, "CableLabsVOD1.1", "BOXCOVER-ORIGINAL,MOVIE-ORIGINAL,POSTER-ORIGINAL,PREVIEW-ORIGINAL", 
#           "Distribution Template", 60, 2, 'Openstream'))
    
#     s.update(("MDMS2", "MDMS2", 1, 0, "CableLabsVOD1.1", "BOXCOVER-ORIGINAL,MOVIE-ORIGINAL,POSTER-ORIGINAL,PREVIEW-ORIGINAL", 
#           "Distribution Template", 60, 2, 'ADI 1.1'))
    Sites.checkAndWaitSiteServiceAvailable()
    
#     s.export("/tmp/sites.tdf")
    
if __name__ == "__main__":
    main()
