try:
    import unittest2 as unittest
except Exception:
    import unittest
import getopt
import sys

def load_tests(loader, tests, pattern):
    ''' Discover and load all unit tests in all files named "*Test.py" under current directory
    '''
    suite = unittest.TestSuite()
    for all_test_suite in unittest.defaultTestLoader.discover('.', pattern='*Test.py'):
        for test_suite in all_test_suite:
            suite.addTests(test_suite)
    return suite

if __name__ == '__main__':
    reportPath = None
    try:
        opts, args = getopt.getopt(sys.argv[1:], "hr:", ["help", "reportPath"])
        for o, a in opts:
            if o in ("-h", "--help"):
                print "UnittestAll.py [-r reportPath]"
                sys.exit(0)
            elif o in ("-r", "--report"):
                reportPath = a
    except getopt.GetoptError as err:
        print "UnittestAll.py [-r reportPath]"
        sys.exit(2)
    if reportPath:
        import xmlrunner
        unittest.main(testRunner=xmlrunner.XMLTestRunner(output=reportPath),argv=['UnittestAll.py'])  
    else:
        unittest.main()