#!/usr/bin/env python
import BaseClass
import os
import xml

from xml.dom.minidom import parseString
from xml.sax.saxutils import unescape

class WatchFolderConfiguration(BaseClass.BaseClass):
    filePath="/opt/tandbergtv/watchpoint/tomcat/webapps/watchfolder/WEB-INF/classes/watchfolder.xml"

    def __init__(self):
        BaseClass.BaseClass.__init__(self)
        pass
    
    def checkExistence(self, data):
        if not os.path.exists(self.filePath):
            return False
        f = file(self.filePath, "r").read()
        try:
            dom = parseString(f)
        except  xml.parsers.expat.ExpatError as err:
            return False
        
        item = filter(lambda element : element.getAttribute("path") == data[0] and self.trim(element.getElementsByTagName("filter")[0].firstChild.nodeValue) == data[1], dom.getElementsByTagName("directory"))
        try:
            return item[0]
        except:
            return False
        
    def getNextId(self):
        return 0
    
    def insert(self, id_, data):
        print "Adding watch folder configuration '%s' filter '%s' to watchfolder.xml..." % (data[0], data[1])
        self.initFileIfNotExists()
        
        fin = file(self.filePath, "r").read()
        dom = parseString(fin)
        
        self.insertDom(dom, data)
        
        fout = file(self.filePath, "w")
        prettyxml = self.prettyxml(dom)
        fout.write(unescape(prettyxml))
        fout.close()
    
    def initFileIfNotExists(self):
        if not os.path.exists(self.filePath):
            self.initFile()
        else:
            f = file(self.filePath, "r").read()
            try:
                dom = parseString(f)
            except  xml.parsers.expat.ExpatError as err:
                self.initFile()
        
    def initFile(self):
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><directories/>"
        self.createFile(self.filePath, xml)
        
    def insertDom(self, dom, data):    
        root = dom.getElementsByTagName("directories")[0]
        
        directoryElement = dom.createElement("directory")
        directoryElement.setAttribute("path", data[0])
        
        filterElement = dom.createElement("filter")
        filterElement.appendChild(dom.createTextNode(data[1]))
        directoryElement.appendChild(filterElement)
        
        frequencyElement = dom.createElement("frequency")
        frequencyElement.appendChild(dom.createTextNode(data[2]))
        directoryElement.appendChild(frequencyElement)
        
        processElement = dom.createElement("process")
        
        classElement = dom.createElement("class")
        classElement.appendChild(dom.createTextNode(data[3]))
        processElement.appendChild(classElement)
        
        parameterListElement = dom.createElement("parameterList")
        
        commandElement = dom.createElement("parameter")
        commandElement.setAttribute("name", "command")
        commandElement.setAttribute("value", "create")
        parameterListElement.appendChild(commandElement)
        
        messageuidElement = dom.createElement("parameter")
        messageuidElement.setAttribute("name", "messageUID")
        messageuidElement.setAttribute("value", data[4])
        parameterListElement.appendChild(messageuidElement)
        
        dateFormatElement = dom.createElement("parameter")
        dateFormatElement.setAttribute("name", "dateFormat")
        dateFormatElement.setAttribute("value", "yyyy-MM-dd HH:mm:ss")
        parameterListElement.appendChild(dateFormatElement)

        '''commandParameter'''
        self.insertParameters(dom, data[5], "commandParameter.", parameterListElement)

        '''messageParameter'''
        self.insertParameters(dom, data[6], "messageParameter.", parameterListElement)
            
        if data[7]:
            routingDirElement = dom.createElement("parameter")
            routingDirElement.setAttribute("name", "routingDir")
            routingDirElement.setAttribute("value", data[7])
            parameterListElement.appendChild(routingDirElement)
            
        if data[8]:
            failureDirElement = dom.createElement("parameter")
            failureDirElement.setAttribute("name", "failureDir")
            failureDirElement.setAttribute("value", data[8])
            parameterListElement.appendChild(failureDirElement)
        
        if data[9]:
            looseFileNamePatternElement = dom.createElement("parameter")
            looseFileNamePatternElement.setAttribute("name", "looseFileNamePattern")
            looseFileNamePatternElement.setAttribute("value", data[9])
            parameterListElement.appendChild(looseFileNamePatternElement)
                        
        processElement.appendChild(parameterListElement)
        
        directoryElement.appendChild(processElement)
        
        eventsElement = dom.createElement("events")
        eventsElement.appendChild(dom.createTextNode(data[10]))
        directoryElement.appendChild(eventsElement)
        
        threadsElement = dom.createElement("threads")
        threadsElement.appendChild(dom.createTextNode(data[11]))
        directoryElement.appendChild(threadsElement)
       
        root.appendChild(directoryElement)
        
    def insertParameters(self, dom, parameters, prefix, parameterListElement):
        notEmptyDit = (type(dict()) == type(parameters)) and len(parameters.keys())!=0        
        if notEmptyDit:
            for parameter in parameters.items():
                parameterElement = dom.createElement("parameter")
                parameterElement.setAttribute("name",prefix+parameter[0]);
                parameterElement.setAttribute("value",parameter[1]);
                parameterListElement.appendChild(parameterElement)
        
        
    def update(self, data):
        print "Updating watch folder configuration '%s' filter '%s' to watchfolder.xml..." % (data[0], data[1])
        
        fin = file(self.filePath, "r").read()
        dom = parseString(fin)
        item = filter(lambda element : element.getAttribute("path") == data[0] and self.trim(element.getElementsByTagName("filter")[0].firstChild.nodeValue) == data[1], dom.getElementsByTagName("directory"))
        
        dom.getElementsByTagName("directories")[0].removeChild(item[0])
        self.insertDom(dom, data)
        
        fout = file(self.filePath, "w")
        prettyxml = self.prettyxml(dom)
        fout.write(unescape(prettyxml))
        fout.close()
        
    def delete(self, data):
        """ delete a watchfolder from the configuration file
        data[0]: watchfolder path
        data[1]: filter        
        """
        print "Delete watch folder configuration '%s' filter '%s' to watchfolder.xml..." % (data[0], data[1])
        
        fin = file(self.filePath, "r").read()
        dom = parseString(fin)
        item = filter(lambda element : element.getAttribute("path") == data[0] and self.trim(element.getElementsByTagName("filter")[0].firstChild.nodeValue) == data[1], dom.getElementsByTagName("directory"))
        
        if item is not None and len(item):
            dom.getElementsByTagName("directories")[0].removeChild(item[0])
        
            fout = file(self.filePath, "w")
            prettyxml = self.prettyxml(dom)
            fout.write(unescape(prettyxml))
            fout.close()

def main():
    cf = WatchFolderConfiguration()
    cf.update(("/content/data/ingest", ".*tar", "10", "com.tandbergtv.watchpoint.watchfolder.processes.DefaultProcess", "120112", "NORMAL", "indemand.com", "JacelTest2", "", "create,delete",  "10"))
    
if __name__ == "__main__":
    main()
