import unittest 
import xml
from xml.dom.minidom import parseString

from mock import Mock
import sys
import os

from UnittestBase import UnittestBase
from WatchFolderConfiguration import WatchFolderConfiguration

#class WatchFolderConfigurationTest(UnittestBase):
class WatchFolderConfigurationTest(UnittestBase):
    WATCHFOLDER_PATH = "res/watchfolder.xml"
    
    def setUp(self):
        UnittestBase.setUp(self)
        self.cf = WatchFolderConfiguration()
        self.cf.filePath = WatchFolderConfigurationTest.WATCHFOLDER_PATH
        
    def tearDown(self):
        os.remove(WatchFolderConfigurationTest.WATCHFOLDER_PATH)
        unittest.TestCase.tearDown(self)

        
    def testInsertCommandParameterAndMessageParameter(self):

        commandParameter = {"priority": "NORMAL"}
        messageParameter = {"providerId": "ericsson.com","isholdfolder": "true","contentClassName": "Showtime_Sample"}
        
        '''wfc.handle(wf["path"],wf["filter"],str(wf["frequency"]),wf["processClass"],wf["messageUID"],commandParameter,messageParameter,routingDir,failureDir, looseFileNamePattern, wf["events"],str(wf["threads"]),self.getIsDelete(wf))'''
        self.cf.insert(1,("/content/data/ingest", ".*tar", "10", "com.tandbergtv.watchpoint.watchfolder.processes.DefaultProcess", "120112", commandParameter, messageParameter, "", "", "", "create,delete",  "10", False))
        
        dom = None
        f = file(WatchFolderConfigurationTest.WATCHFOLDER_PATH, "r").read()
        try:
            dom = parseString(f)
        except  xml.parsers.expat.ExpatError as err:
            return False
        
        parameterList = dom.getElementsByTagName("parameter");
        
        for element in parameterList:
            if element.getAttribute("name") == "commandParameter.priority":
                isPriorityParameterExist = True
                self.assertEqual(element.getAttribute("value"), "NORMAL")
               
            if element.getAttribute("name") == "messageParameter.providerId":
                isProviderIDParameterExist = True
                self.assertEqual(element.getAttribute("value"), "ericsson.com")
                
            if element.getAttribute("name") == "messageParameter.contentClassName":
                isContentClassParameterExist = True
                self.assertEqual(element.getAttribute("value"), "Showtime_Sample")
                
            if element.getAttribute("name") == "messageParameter.isholdfolder":
                isHoldFolderParameterExist = True
                self.assertEqual(element.getAttribute("value"), "true")
            pass
        
        self.assertEqual(isPriorityParameterExist and isProviderIDParameterExist and isContentClassParameterExist and isHoldFolderParameterExist, True)
        
    def testInsertEmptyCommandParameterAndMessageParameter(self):
        commandParameter = {}
        messageParameter = {}
        
        '''wfc.handle(wf["path"],wf["filter"],str(wf["frequency"]),wf["processClass"],wf["messageUID"],commandParameter,messageParameter,routingDir,failureDir, looseFileNamePattern, wf["events"],str(wf["threads"]),self.getIsDelete(wf))'''
        self.cf.insert(1,("/content/data/ingest", ".*tar", "10", "com.tandbergtv.watchpoint.watchfolder.processes.DefaultProcess", "120112", commandParameter, messageParameter, "", "", "", "create,delete",  "10", False))
        
        dom = None
        f = file(WatchFolderConfigurationTest.WATCHFOLDER_PATH, "r").read()
        try:
            dom = parseString(f)
        except  xml.parsers.expat.ExpatError as err:
            return False
        
        parameterList = dom.getElementsByTagName("parameter");
        
        isPriorityParameterExist = False
        isProviderIDParameterExist = False
        isContentClassParameterExist = False
        isHoldFolderParameterExist = False
        
        for element in parameterList:
            if element.getAttribute("name") == "commandParameter.priority":
                isPriorityParameterExist = True
               
            if element.getAttribute("name") == "messageParameter.providerId":
                isProviderIDParameterExist = True
                
            if element.getAttribute("name") == "messageParameter.contentClassName":
                isContentClassParameterExist = True
                
            if element.getAttribute("name") == "messageParameter.isholdfolder":
                isHoldFolderParameterExist = True
                
        self.assertEqual(isPriorityParameterExist, False) 
        self.assertEqual(isProviderIDParameterExist, False)   
        self.assertEqual(isContentClassParameterExist, False) 
        self.assertEqual(isHoldFolderParameterExist, False)    

        
    def testInsertNoneCommandParameterAndMessageParameter(self):
        commandParameter = None
        messageParameter = None
        
        '''wfc.handle(wf["path"],wf["filter"],str(wf["frequency"]),wf["processClass"],wf["messageUID"],commandParameter,messageParameter,routingDir,failureDir, looseFileNamePattern, wf["events"],str(wf["threads"]),self.getIsDelete(wf))'''
        self.cf.insert(1,("/content/data/ingest", ".*tar", "10", "com.tandbergtv.watchpoint.watchfolder.processes.DefaultProcess", "120112", commandParameter, messageParameter, "", "", "", "create,delete",  "10", False))
        
        dom = None
        f = file(WatchFolderConfigurationTest.WATCHFOLDER_PATH, "r").read()
        try:
            dom = parseString(f)
        except  xml.parsers.expat.ExpatError as err:
            return False
        
        parameterList = dom.getElementsByTagName("parameter");
        
        isPriorityParameterExist = False
        isProviderIDParameterExist = False
        isContentClassParameterExist = False
        isHoldFolderParameterExist = False
        
        for element in parameterList:
            if element.getAttribute("name") == "commandParameter.priority":
                isPriorityParameterExist = True
               
            if element.getAttribute("name") == "messageParameter.providerId":
                isProviderIDParameterExist = True
                
            if element.getAttribute("name") == "messageParameter.contentClassName":
                isContentClassParameterExist = True
                
            if element.getAttribute("name") == "messageParameter.isholdfolder":
                isHoldFolderParameterExist = True
                
        self.assertEqual(isPriorityParameterExist, False) 
        self.assertEqual(isProviderIDParameterExist, False)   
        self.assertEqual(isContentClassParameterExist, False) 
        self.assertEqual(isHoldFolderParameterExist, False)           



if __name__ == "__main__":
    unittest.main()  
