import os
from InstallTestBase import InstallTestBase
import unittest
from backup import Backup
from BaseClass import BaseClass
from ReportCategoryConfiguration import ReportCategoryConfiguration
from CMSVersionDeploymentPolicy import CMSVersionDeploymentPolicy

class backupTest(InstallTestBase):
    TEST_TEMP_DIR = "/tmp/backup_test_temp"
    
    def setUp(self):
        self.jreportPath = "/opt/tandbergtv/jreport/deploy"
        InstallTestBase.setUp(self)
    
    def testBackupReports(self):
        CMSVersionDeploymentPolicy.setCMSVersion("3.1.0")
        backup=Backup({})
        backup.backupVersion = "test"
        self._initReportFolder()
        backup.backupReports([])
        self.assertEqual("/opt/tandbergtv/jreport/deploy/", backup.backupItems["fileOrDirToDelete"][0])
        self.assertTrue(os.path.exists(backup.getFileBackupDir() + self.jreportPath + os.sep + "test1"))
        self.assertTrue(os.path.exists(backup.getFileBackupDir() + self.jreportPath + os.sep + "test1" + os.sep + "test1.txt"))
        self.assertTrue(os.path.exists(backup.getFileBackupDir() + self.jreportPath + os.sep + "test2"))
        self.assertFalse(os.path.exists(backup.getFileBackupDir() + os.path.dirname(self.jreportPath) + os.sep + "test2"))
        
    def _initReportFolder(self):
        self._createDir(self.jreportPath)
        self._createDir(self.jreportPath + os.sep + "test1")
        self._createFile(self.jreportPath + os.sep + "test1" + os.sep + "test1.txt", "")
        self._createDir(self.jreportPath + os.sep + "test2")
        self._createDir(os.path.dirname(self.jreportPath) + os.sep + "test2")
    
    def _createDir(self, directory):
        if not os.path.exists(directory):
            os.makedirs(directory)
    
    def _createFile(self,filePath, content):
        dir = os.path.dirname(filePath)
        if not os.path.exists(dir):
            os.makedirs(dir)
        f = file(filePath, "w")
        f.write(content)
        f.close()

if __name__ == "__main__":
    unittest.main() 