'''
Created on Sep 11, 2014

@author: Simon Meng
'''
import json
import os
from distutils.dir_util import copy_tree
from distutils.dir_util import remove_tree
from distutils.file_util import copy_file
from SSHCommander import SSHCommander
from time import sleep

#Define the system directory to avoid deleted accidentally
sysdirs = ['/bin','/boot','/cgroup','/content','/dev','/etc','/home','/lib','/lib64','/media',
           '/mnt','/opt','/proc','/root','/sbin','/selinux','/srv','/sys','/tmp','/usr','/var']

FILE_SYNC_TO_DIR = '/opt/tandbergtv/cms/prepack/filesync/files'
FILE_SYNC_RESULT = '/opt/tandbergtv/cms/prepack/filesync/files/sync-config.json'

class FileSync(object):

    def __init__(self, app_nodes):
        self.app_nodes = app_nodes
        cwd = os.path.dirname(os.path.realpath(__file__))
        if self.getCMSVersion() < 4.1:
            self.jsonconfFile = os.path.dirname(cwd) + os.sep + 'file-sync-config_4.0.json'
        else:
            self.jsonconfFile = os.path.dirname(cwd) + os.sep + 'file-sync-config_4.1.json'
            
        self.jsonconf  = dict()
        self.sync_result = dict()
        self.sync_result["files"] = []
        self.sync_result["files_delete"]  = []
        self.sync_result["symbolicLinks"] = []
        self.sync_result["shared_mountpoints"] = []
        self.__loadconf()
        
    def __loadconf(self):
        fileobj = open(self.jsonconfFile)
        self.jsonconf = json.load(fileobj)
        if self.jsonconf.has_key('shared_mountpoints'):
            self.sync_result["shared_mountpoints"] = self.jsonconf["shared_mountpoints"]
        fileobj.close()
        
    def dosync(self):
        if self.app_nodes:
            self.copyFilesToNFS()
            return self.syncFilesToSlaveNodes()
        return True
        
    def copyFilesToNFS(self):
        if self.jsonconf.has_key('files'):
            for path in self.jsonconf['files']:
                if os.path.exists(path):
                    print 'sync ' + path + ' to ' + FILE_SYNC_TO_DIR + path
                    self.__rmdirOrfile (FILE_SYNC_TO_DIR + path)
                    self.__copyto(path, FILE_SYNC_TO_DIR + path)
                    self.sync_result["files"].append(path)
                else:
                    self.sync_result["files_delete"].append(path)
             
        if self.jsonconf.has_key('symbolicLinks'):
            for path in self.jsonconf['symbolicLinks']:
                if os.path.islink(path):
                    link = dict()
                    link['linkName'] = path
                    link['linkTo'] = os.path.realpath(path)
                    self.sync_result["symbolicLinks"].append(link)
                else:
                    #Not delete symbolic link
                    pass
        with open(FILE_SYNC_RESULT, 'w') as f:
            json.dump(self.sync_result, f, ensure_ascii=False, indent=4)
        print 'sync successfully, result saved:' , FILE_SYNC_RESULT
        
    def syncFilesToSlaveNodes(self):
        retry = 0
        while not os.path.exists('/opt/tandbergtv/cms/prepack/filesync/script/sync.py') and retry < 6:
            retry = retry + 1
            time.sleep(5)
            print '/opt/tandbergtv/cms/prepack/filesync/script/sync.py not found, waitting...'
        
        sync_cmd = "su root -c 'export PATH=$PATH:/sbin; python /opt/tandbergtv/cms/prepack/filesync/script/sync.py'"
        for node in self.app_nodes:
            print 'sync files to ', node['ip'], 'begin...'
            client = SSHCommander(node['ip'], node['user'], node['password'])
            status, output = client.execute_interactive(sync_cmd, node['rootPasswd'])
            print output
            if status != 0:
                print 'Failed to dosync files to ' +  node['ip']
                return False
            print 'sync files to ', node['ip'], 'done'
        return True
           
    def __rmdirOrfile(self,filepath):
        #make sure not delete the system directory
        if filepath not in sysdirs and os.path.exists(filepath):
            if os.path.isdir(filepath):
                remove_tree(filepath)
            elif os.path.isfile(filepath):
                os.remove(filepath)
            else:
                print 'unknown file: ', filepath
        
    def __copyto(self, srcpath, distpath):
        '''copy dir or file to specified location, symblic link will be ignored'''
        if os.path.exists(srcpath):
            if os.path.isdir(srcpath) or os.path.isfile(srcpath):
                parent = os.path.dirname(distpath)
                if not os.path.isdir(parent):
                    os.makedirs(parent)
                
                # use shell command directly to retain the ownership of files
                cp_cmd = 'cp -rp "%s" "%s"' % (srcpath, distpath)
                os.popen(cp_cmd)
            else:
                #ignore symblic link
                print 'symblic link found: ' + srcpath, ', ignored'
    
    def getCMSVersion(self):    
        versionString = os.popen("rpm -qi watchpoint-cms  | grep Version | awk '{print $3}'", "r").read().strip() 
        if versionString is not None and len(versionString) > 0:
            # After 3.1, RPM is used instead of conary to manage CMS package
            return  float(versionString[:3])
        else:
            # If reach this point, it means the cms version is before 3.1
            versionString = os.popen("conary q | grep watchpoint-cms | awk '{print $1}' | cut -d '=' -f2", "r").read().strip()
            return float(versionString[:3])
            
if __name__ == '__main__':
    #node_163 = {"ip":"10.116.5.163", "user":"cms", "password":"cms1234", "rootPasswd":"root1234"}
    cwd = os.path.dirname(os.path.realpath(__file__))
    conf_path = os.path.dirname(cwd) + os.sep + 'sync-files-to-app-nodes-conf.json'
    fileobj = open(conf_path)
    conf = json.load(fileobj)
    fileobj.close()
    
    FileSync(conf['cluster_app_nodes']).dosync()