from InstallTestBase import InstallMock, InstallTestBase, InstallOut
import unittest
import os
from InstallHelper import InstallHelper
from InstallComponentCollector import InstallComponentCollector

class InstallTestTemp(InstallTestBase):
    sequence = 0
    inputsBySequence = []
    
    def _testRawInput(self):
        allowSelect = self.getRawInput("Input: ")
        reselect = allowSelect
        print allowSelect
            
    def _getRawInput(self, message):
        try:
            return raw_input(message)
        except IOError, EOFError:
            return self.getRawInput(message)
        
    def testFreshInstallOnScratch(self):
        installer = self._createInstaller("", "1.1")
        self._resetInputs(["1 2", "1", "1", "1 2", "yes", "yes"])
        self._doInstall(installer)
#         self.assertEqual("1.1", installer.helper.getCurrentPrepackVersion())
#         self.assertTrue(len(installer.helper.getPatchesForCurrentPrepackVersion()) == 0)
#         self.assertEqual(1, len(self._getBackupFolders()))
#         self.assertEqual(1, len(self._getBackupFolderForVersion("1.1")))

        self._doInstall(installer)
   
    def _createInstaller(self, mode, version, backupStart = True, backupFinish = True, deployStart = True, deployFinish = True):
        sysInfoFile = self._constructSysInfoFile(version)
        installer = InstallMock(sysInfoFile, mode, backupStart, backupFinish, deployStart, deployFinish)
        self._mockPrepackDecider(installer)
#         self._mockRawInputForInstaller(installer)
        return installer
   
    def _doInstall(self, installer, preConfiguredFile=None, outputToFile = False):
        logFile = None
        logFileName = ""
        if outputToFile:
            logFileName = self._getInstallLogFileName()
            logFile = InstallOut(logFileName, "a")
        installer.install(preConfiguredFile)
        if logFile:
            logFile._restore_standard_output_()
        return logFileName
   
    def _initComponentSelection(self):
        selections = {
            "selectionItems": [
                "DOWNSTREAMS",
                "DEVICES"
            ],
            
            "DEVICES":{
                "displayName":"Devices",
                "selections" : [
                    "QC",
                    "TRANSCODE",
                    "ENCRYPTION",
                    "COMBINER"
                ]
            },
        
            "QC":{
                "displayName":"QC",
                "selections":[
                    "BATON",
                    "CERIFY",
                    "VERIFIER"
                ]
            },
            
            "TRANSCODE":{
                "displayName":"Transcoder",
                "selections":[
                    "ENVIVIO",
                    "ELEMENTAL",
                    "TITAN",
                    "RHOZET",
                    "DIGITALRAPID"
                ]
            },
            
            "ENCRYPTION":{
                "displayName":"Encryptor",
                "selections":[
                    "VERIMATRIX"
                ]
            },
            
            "COMBINER":{
                "displayName":"Combiner"
            },
            
            "BATON":{
                "displayName":"Baton"
            },
            
            "CERIFY":{
                "displayName":"Cerify"
            },
            
            "VERIFIER":{
                "displayName":"Verifier"
            },
        
            "ENVIVIO":{
                "displayName":"Envivio"
            },
            
            "ELEMENTAL":{
                "displayName":"Elemental"
            },
            
            "TITAN":{
                "displayName":"Titan"
            },
            
            "RHOZET":{
                "displayName":"Rhozet"
            },
            
            "DIGITALRAPID":{
                "displayName":"DigitalRapid"
            },
            
            "VERIMATRIX":{
                "displayName":"Verimatrix"
            },
            
            "DOWNSTREAMS":{
                "displayName":"Downstreams",
                "selections" : [
                    "AMS",
                    "MEDIAROOM",
                    "OTT",
                    "MSMW_MDMS",
                    "MSMW_OS",
                    "XPMP"
                ]
            },
            
            "AMS":{
                "displayName":"AMS",
                "unAvailableComponents":[
                    "DEVICES/COMBINER"
                ],
            },
            
            "MEDIAROOM":{
                "displayName":"Mediaroom"
            },
            
            "OTT":{
                "displayName":"OTT"
            },
            
            "MSMW_MDMS":{
                "displayName":"Msmw with MDMS"
            },
            
            "MSMW_OS":{
                "displayName":"Msmw with Openstream"
            },
            
            "XPMP":{
                "displayName":"XPMP",
                "availableComponents":[
                    "DEVICES/COMBINER",
                    "DEVICES/QC/VERIFIER"
                ],
                "autoSelectComponents":[
                    "DEVICES/COMBINER",
                    "DEVICES/QC/VERIFIER"
                ],
                "singleSelection": True
            },
            
            "BACK":{
                "displayName":"Back To Last"
            }
        }
        selectionFilePath = self.TEST_TEMP_DIR + os.sep + "component-selections.json"
        InstallHelper.writeJsonToFile(selections, selectionFilePath)
        InstallComponentCollector.COMPONENT_SELECTION_CONFIG = selectionFilePath
    
if __name__ == "__main__":
    unittest.main()     