#!/usr/bin/python -Qnew
#
#
#
# Copyright (c) 2009 Ericsson, Inc.  All Rights Reserved.
#
# This module contains unpublished, confidential, proprietary
# material.  The use and dissemination of this material are
# governed by a license.  The above copyright notice does not
# evidence any actual or intended publication of this material.
#
# Author: Michael Jones
# Created: Oct 22, 2012
# Description:
# Out of Box Deployment Script
#
# $Id: deploy_oob.py,v 1.00 2012/10/22 17:43:28 mjones Exp $
#
#
#

import os
import sys
import socket
import re
import dircache
import shutil
import errno
import subprocess
import json
from pprint import pprint
from optparse import OptionParser,OptionGroup
import base64
import urllib
import httplib2
from urllib import urlencode
		

###########################################################################
#
# Main
#
###########################################################################

try:

	# Check and make sure script is run by 'root'
	userlogin = os.environ.get('LOGNAME')
	if userlogin != "root":
		print 'You must run this as user root.'
		print 'Exiting...'
		sys.exit(1)

	#pass as input
	json_data=open('msmw.json')
	config = json.load(json_data)
	json_data.close()

	print "undeploy " + config["name"]
	print config["version"],'\n'
	
	# Generate the full command line for installing all the RPMs	
	RPMCMDLINE = "/bin/rpm -e --nodeps --allmatches"
   	for file in config["rpms"]:
   		RPMCMDLINE = RPMCMDLINE + ' ' + file
   	outputstr = 'command=' + RPMCMDLINE
   	print 'RPM uninstalling.'
   	print outputstr
	os.system(RPMCMDLINE)

	print 'undeploy complete.'

except KeyboardInterrupt:
 	print ''
	print '<CTRL>-C detected...Exiting...'