/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.prepack.license.utils;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;

public class JaxbMapper {
    private static ConcurrentMap<Class, JAXBContext> jaxbContexts = new ConcurrentHashMap<Class, JAXBContext>();
    private static final String CGLIB_CLASS_SEPARATOR = "$$";

    public static String toXml(Object root) throws JAXBException {
        Class<?> clazz = JaxbMapper.getUserClass(root);
        return JaxbMapper.toXml(root, clazz, null);
    }

    public static String toXml(Object root, String encoding) throws JAXBException {
        Class<?> clazz = JaxbMapper.getUserClass(root);
        return JaxbMapper.toXml(root, clazz, encoding);
    }

    public static String toXml(Object root, Class clazz, String encoding) throws JAXBException {
        StringWriter writer = new StringWriter();
        JaxbMapper.createMarshaller(clazz, encoding, false).marshal(root, (Writer)writer);
        return writer.toString();
    }

    public static String toXml(Collection<?> root, String rootName, Class clazz) throws JAXBException {
        return JaxbMapper.toXml(root, rootName, clazz, null);
    }

    public static String toXml(Collection<?> root, String rootName, Class clazz, String encoding) throws JAXBException {
        CollectionWrapper wrapper = new CollectionWrapper();
        wrapper.collection = root;
        JAXBElement wrapperElement = new JAXBElement(new QName(rootName), CollectionWrapper.class, (Object)wrapper);
        StringWriter writer = new StringWriter();
        JaxbMapper.createMarshaller(clazz, encoding, false).marshal((Object)wrapperElement, (Writer)writer);
        return writer.toString();
    }

    public static String toXmlWithFormated(Object root) throws JAXBException {
        Class<?> clazz = JaxbMapper.getUserClass(root);
        StringWriter writer = new StringWriter();
        JaxbMapper.createMarshaller(clazz, null, true).marshal(root, (Writer)writer);
        return writer.toString();
    }

    public static <T> T fromXml(String xmlString, Class<T> clazz) throws JAXBException {
        StringReader reader = new StringReader(xmlString);
        return (T)JaxbMapper.createUnmarshaller(clazz).unmarshal((Reader)reader);
    }

    public static <T> T fromXml(File file, Class<T> clazz) throws JAXBException {
        return (T)JaxbMapper.createUnmarshaller(clazz).unmarshal(file);
    }

    public static Marshaller createMarshaller(Class clazz, String encoding, boolean format) throws JAXBException {
        JAXBContext jaxbContext = JaxbMapper.getJaxbContext(clazz);
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)format);
        if (encoding != null) {
            marshaller.setProperty("jaxb.encoding", (Object)encoding);
        }
        return marshaller;
    }

    protected static Unmarshaller createUnmarshaller(Class clazz) throws JAXBException {
        JAXBContext jaxbContext = JaxbMapper.getJaxbContext(clazz);
        return jaxbContext.createUnmarshaller();
    }

    protected static JAXBContext getJaxbContext(Class clazz) throws JAXBException {
        JAXBContext jaxbContext = (JAXBContext)jaxbContexts.get(clazz);
        if (jaxbContext == null) {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz, CollectionWrapper.class});
            jaxbContexts.putIfAbsent(clazz, jaxbContext);
        }
        return jaxbContext;
    }

    protected static Class<?> getUserClass(Object instance) {
        Class<?> superClass;
        Class<?> clazz = instance.getClass();
        if (clazz != null && clazz.getName().contains(CGLIB_CLASS_SEPARATOR) && (superClass = clazz.getSuperclass()) != null && !Object.class.equals(superClass)) {
            return superClass;
        }
        return clazz;
    }

    protected static class CollectionWrapper {
        protected Collection<?> collection;

        protected CollectionWrapper() {
        }
    }
}

