#!/bin/bash
echo ""
echo "Please Choose Process Mode: "
echo ""
echo "1.SINGLE MODE      2.BATCH MODE      3.BLIND SHOOTING MODE"
read process_mode

woId=
currentProcessingWoId=
woIdList=
woIdArray=
currentTaskName=
completeState=

tokenId=
tokenIdArray=()
blindShootingWoIdArray=()
successWoIds=()
failureWoIds=()
msgUID=

hreatbeatUrl1="http://Content-Management-Additional-Monitor"
hreatbeatUrl2="https://mediafirst-async"
hreatbeatUrl3="http://fabrix-task-monitoring:5929"



function retrieveNotifyParamsByCurrentTask
{
	queryMsg='{"size": "1000","fields":["id","rootTokenId"],"query":{"bool" : {"must" : [{"term" : { "status" : "QUEUED" } },{"term" : { "currentTask" : "{currentTaskName}" } }]}}}'
	queryMsg="${queryMsg/\{currentTaskName\}/$currentTaskName}"
	#tmpRootTokenIds=$(curl -s http://es:9200/wfs/processinstance/_search?pretty -d "$queryMsg"| grep \"rootTokenId\" | awk '{print $4}')
	#tmpWoIds=$(curl -s http://es:9200/wfs/processinstance/_search?pretty -d "$queryMsg"| grep \"id\" | awk '{print $4}')
	
	response=$(curl -s http://es:9200/wfs/processinstance/_search?pretty -d "$queryMsg")
	echo retrieveNotifyParamsByCurrentTask: $response
	tmpRootTokenIds=`echo $response|grep -Po '(?<="rootTokenId" : \[ )[^ \]]*'`
	tmpWoIds=`echo $response|grep -Po '(?<="id" : \[ )[^ \]]*'`
	
	tokenIdArray=($tmpRootTokenIds)
	blindShootingWoIdArray=($tmpWoIds)

	## The $currentTaskName should be quoted, as the value may probably including space
	getMsgUID "$currentTaskName"	
}


###################################################################
#     Get notificaiton necessary parameters through elasticsearch
###################################################################

function retrieveNotifyParamsByWoId
{
	response=$(curl -s http://es:9200/wfs/processinstance/_search?q=id:$1)
	currentTaskName=`echo $response|grep -Po '(?<="currentTask" : ")[^"]*'`
	tokenId=`echo $response|grep -Po '(?<="rootTokenId" : )[^,]*'`

	getMsgUID "$currentTaskName"

}


#####################################################
#     Get message uid basing on current task name
#####################################################
function getMsgUID
{
	if [ "$1" == "Wait for Purge Complete Notification" ];then
		msgUID="MA0168"
	elif [ "$1" == "Wait for workorder Complete" ];then
		msgUID="MA0168"	
	elif [ "$1" == "wait for title completed" ];then
		msgUID="mf0106"
	elif [ "$1" == "Wait For Ingest Complete" ];then
		msgUID="mf0106"
        elif [ "$1" == "Wait for ABR Assets Deleted" ];then
                msgUID="fb0101"
        elif [ "$1" == "Wait for CBR Assets Deleted" ];then
                msgUID="fb0101"
        elif [ "$1" == "Wait for Delete Completion" ];then
                msgUID="fb0101"
	else
		msgUID="MA0168"
	fi	
}

###########################################################
#     Send notification message to activate the waiting node
###########################################################
function sendNotify
{
NOTIFY_MSG='
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:urn="urn:envivio:balancer:1.0">
   <soapenv:Header/>
   <soapenv:Body>
     <WFSMessage RequestKey="{tid}" Type="control" UID="{uid}">
     <Command Name="task-complete">
     </Command>
     <MessageBody>
          <ParameterList>
              <Parameter DataType="String" Name="completeState">
                  <Value>{completeState}</Value>
              </Parameter>
          </ParameterList>
     </MessageBody>
    <Source Name="WFS">
        <URL>{url}</URL>
    </Source>
     </WFSMessage>
   </soapenv:Body>
</soapenv:Envelope>
'

RESOVED_NOTIFY_MSG="${NOTIFY_MSG/\{tid\}/$tokenId}"
RESOVED_NOTIFY_MSG="${RESOVED_NOTIFY_MSG/\{uid\}/$msgUID}"
RESOVED_NOTIFY_MSG="${RESOVED_NOTIFY_MSG/\{completeState\}/$completeState}"


if [ $msgUID == "MA0168" ];then
	RESOVED_NOTIFY_MSG="${RESOVED_NOTIFY_MSG/\{url\}/$hreatbeatUrl1}"
elif [ $msgUID == "mf0106" ];then
	RESOVED_NOTIFY_MSG="${RESOVED_NOTIFY_MSG/\{url\}/$hreatbeatUrl2}"
	RESOVED_NOTIFY_MSG="${RESOVED_NOTIFY_MSG/completeState/titleStatus}"
elif [ $msgUID == "fb0101" ];then
	RESOVED_NOTIFY_MSG="${RESOVED_NOTIFY_MSG/\{url\}/$hreatbeatUrl3}"
	RESOVED_NOTIFY_MSG="${RESOVED_NOTIFY_MSG/completeState/expired}"
else
	echo Invalid message UID: $msgUID
fi


#curl -s http://app:7070/workflow/services/AdaptorService -H 'SOAPAction: ""' -H 'Content-Type: text/xml'  -d "$RESOVED_NOTIFY_MSG" > /dev/null


echo Notification Request: $RESOVED_NOTIFY_MSG
echo ""

notifyResp=$(curl -s http://app:7070/workflow/services/AdaptorService -H 'SOAPAction: ""' -H 'Content-Type: text/xml'  -d "$RESOVED_NOTIFY_MSG")

echo "Notification Response: $notifyResp"
echo ""

notifyResult=`echo $notifyResp|grep -Po '(?<=" Type=")[^"]*'`

if [ "$notifyResult" == "ack" ];then
	successWoIds+=($currentProcessingWoId)
elif [ "$notifyResult" == "nack" ];then
	failureWoIds+=($currentProcessingWoId)
else
	echo Invalid response type: $1
	exit 1
fi
}

function genProcessResult
{
	successNotifyWoIds=
	failureNotifyWoIds=
	for i in "${!successWoIds[@]}"
	do
        if [ $i == 0 ];then
                successNotifyWoIds+=${successWoIds[$i]}
        else
                successNotifyWoIds+=", ${successWoIds[$i]}"
        fi
	done
	
	for j in "${!failureWoIds[@]}"
	do
        if [ $j == 0 ];then
                failureNotifyWoIds+=${failureWoIds[$j]}
        else
                failureNotifyWoIds+=", ${failureWoIds[$j]}"
        fi
	done

	echo ""
	echo "***********************************"	
	echo "*Success Notified Work Orders:    *"
	echo "***********************************"
	echo  $successNotifyWoIds
	
	echo ""	

	echo "***********************************"
	echo "*Failure Notified Work Orders:    *"
	echo "***********************************"
	echo $failureNotifyWoIds

}


if (($process_mode=="1"));then

	echo "Please Enter Work Order Id:"
	read woId
	echo ""
	echo "Please Enter Complete State:"
	read completeState
	echo ""
	
	currentProcessingWoId=$woId
	echo Current Processing Work Order Id: $currentProcessingWoId
	echo ""
	retrieveNotifyParamsByWoId $woId 
	sendNotify
	genProcessResult
	
elif (($process_mode=="2")); then
	echo "Please Enter Workorder Id List Separated by comma:"
	read woIdList
	echo ""
	woIdArray=(${woIdList//,/ })
	echo "Please Enter Complete State:"
	read completeState
	echo ""
	#processCount=${#woIdArray[@]}
	for i in "${woIdArray[@]}"
	do
		#echo "Processing: $i"
		currentProcessingWoId=$i
		echo Current Processing Work Order Id: $currentProcessingWoId
	        echo ""
		retrieveNotifyParamsByWoId $i
		sendNotify
	done
	genProcessResult

elif (($process_mode=="3")); then
	echo "Please Enter Current Task Name:"
	read currentTaskName
	echo ""
	echo "Please Enter Complete State:"
	read completeState

	retrieveNotifyParamsByCurrentTask
	for j in "${!tokenIdArray[@]}"
	do
		tokenId=${tokenIdArray[$j]}
		currentProcessingWoId=${blindShootingWoIdArray[$j]}
		echo Current Processing Work Order Id: $currentProcessingWoId
	        echo ""
		sendNotify
	done
	genProcessResult

else
	echo "Wrong input number"
	exit 1

fi

echo ""
echo "Process Done...."
echo ""
