/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.prepack.license;

import com.ericsson.cms.prepack.license.LicenseLoader;
import com.ericsson.cms.prepack.license.LicenseValidator;
import com.ericsson.cms.prepack.license.exception.LicenseCapacityExceededException;
import com.ericsson.cms.prepack.license.exception.LicenseInvalidException;
import com.ericsson.cms.prepack.license.exception.LicenseNotFoundException;
import com.ericsson.cms.prepack.license.model.CapacityKey;
import com.ericsson.cms.prepack.license.model.License;
import com.ericsson.cms.prepack.license.utils.StringUtils;
import java.io.File;

public class LicenseManager {
    public static final String CMS_CORE_LICENSE_FILE_LOCATION = "/opt/tandbergtv/cms/conf/workflow/license.xml";
    public static final String CMS_CORE_LICENSE_FILE_LOCATION_CMS5X = "/opt/tandbergtv/cms/conf/neptune/license.xml";
    public static final String CMS_PREPACK_LICENSE_FILE_LOCATION = "/opt/tandbergtv/cms/conf/workflow/prepackLicense.xml";
    public static final String CMS_PREPACK_CAPACITY_KEY = "FAT1021122/";

    public static void checkLicense() {
        String featureKeyIds = "";
        LICENSE_STATE licState = LICENSE_STATE.LIC_OK;
        String errMessge = "";
        String errPrifix = "CHECK PREPACK LICENSE ERROR, ";
        try {
            License prepackLic = LicenseLoader.load(CMS_PREPACK_LICENSE_FILE_LOCATION);
            new LicenseValidator("-----BEGIN CERTIFICATE-----\nMIICRzCCAbCgAwIBAgIIbuviEeCeY14wDQYJKoZIhvcNAQEFBQAwZjELMAkGA1UEBhMCU0UxFDASBgNVBAoTC0VyaWNzc29uIEFCMQ0wCwYDVQQLEwRCVVNTMTIwMAYDVQQDEylFcmljc3NvbiBEZXZlbG9wbWVudCBMaWNlbnNlIFRvb2wgUm9vdCBDQTAeFw0xNDA0MTcyMTI2NTZaFw0yNDA0MTQyMTI2NTZaMGYxCzAJBgNVBAYTAlNFMRQwEgYDVQQKEwtFcmljc3NvbiBBQjENMAsGA1UECxMEQlVTUzEyMDAGA1UEAxMpRXJpY3Nzb24gRGV2ZWxvcG1lbnQgTGljZW5zZSBUb29sIFJvb3QgQ0EwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAKJoa2WgWmfSYRbHDko4kEA/hGmdnv1upuYF14b6cUKy1PdWWlHmiVUE1jI9LTt39deYSr6oQ9YeQO5qF8vx0Jihu4BEN+H3pMc7yvp9iW2a8tjn+FjtFRYKH7yZAnno72Ex/DDMGrgGrgulDyITipa6LLY2irmuMPewfig0WIujAgMBAAEwDQYJKoZIhvcNAQEFBQADgYEAmKYlwiVovr/TGDpkoM01PsbupO8Qgo3ojQyPq16DaZDY1i1w3ZGuCKZWZvXcmSU2oIP3EmbW9pQYN5IdsmX2CWfBHEVFUpdUET8k3jZfigWvdhn22eyDf4Pv5RcLkVHBziH2HjtaRLwPK8Gwc7N5QXh2chkDHNTG0c/15UQj4Ho=\n-----END CERTIFICATE-----", "-----BEGIN CERTIFICATE-----\nMIICRzCCAbCgAwIBAgIIbuviEeCeY14wDQYJKoZIhvcNAQEFBQAwZjELMAkGA1UEBhMCU0UxFDASBgNVBAoTC0VyaWNzc29uIEFCMQ0wCwYDVQQLEwRCVVNTMTIwMAYDVQQDEylFcmljc3NvbiBEZXZlbG9wbWVudCBMaWNlbnNlIFRvb2wgUm9vdCBDQTAeFw0xNDA0MTcyMTI2NTZaFw0yNDA0MTQyMTI2NTZaMGYxCzAJBgNVBAYTAlNFMRQwEgYDVQQKEwtFcmljc3NvbiBBQjENMAsGA1UECxMEQlVTUzEyMDAGA1UEAxMpRXJpY3Nzb24gRGV2ZWxvcG1lbnQgTGljZW5zZSBUb29sIFJvb3QgQ0EwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAKJoa2WgWmfSYRbHDko4kEA/hGmdnv1upuYF14b6cUKy1PdWWlHmiVUE1jI9LTt39deYSr6oQ9YeQO5qF8vx0Jihu4BEN+H3pMc7yvp9iW2a8tjn+FjtFRYKH7yZAnno72Ex/DDMGrgGrgulDyITipa6LLY2irmuMPewfig0WIujAgMBAAEwDQYJKoZIhvcNAQEFBQADgYEAmKYlwiVovr/TGDpkoM01PsbupO8Qgo3ojQyPq16DaZDY1i1w3ZGuCKZWZvXcmSU2oIP3EmbW9pQYN5IdsmX2CWfBHEVFUpdUET8k3jZfigWvdhn22eyDf4Pv5RcLkVHBziH2HjtaRLwPK8Gwc7N5QXh2chkDHNTG0c/15UQj4Ho=\n-----END CERTIFICATE-----").validate(prepackLic);
            if (!prepackLic.isApply4CMS3_X()) {
                errPrifix = "CHECK CORE LICENSE ERROR, ";
                License coreLic = null;
                File corelicenseFileAfterCMS50 = new File(CMS_CORE_LICENSE_FILE_LOCATION_CMS5X);
                File corelicenseFileBeforeCMS50 = new File(CMS_CORE_LICENSE_FILE_LOCATION);
                if (corelicenseFileAfterCMS50.exists()) {
                    coreLic = LicenseLoader.load(CMS_CORE_LICENSE_FILE_LOCATION_CMS5X);
                } else if (corelicenseFileBeforeCMS50.exists()) {
                    coreLic = LicenseLoader.load(CMS_CORE_LICENSE_FILE_LOCATION);
                } else {
                    throw new LicenseNotFoundException("Prepack installer cannot found the core license!");
                }
                new LicenseValidator("-----BEGIN CERTIFICATE-----\nMIICRzCCAbCgAwIBAgIIbuviEeCeY14wDQYJKoZIhvcNAQEFBQAwZjELMAkGA1UEBhMCU0UxFDASBgNVBAoTC0VyaWNzc29uIEFCMQ0wCwYDVQQLEwRCVVNTMTIwMAYDVQQDEylFcmljc3NvbiBEZXZlbG9wbWVudCBMaWNlbnNlIFRvb2wgUm9vdCBDQTAeFw0xNDA0MTcyMTI2NTZaFw0yNDA0MTQyMTI2NTZaMGYxCzAJBgNVBAYTAlNFMRQwEgYDVQQKEwtFcmljc3NvbiBBQjENMAsGA1UECxMEQlVTUzEyMDAGA1UEAxMpRXJpY3Nzb24gRGV2ZWxvcG1lbnQgTGljZW5zZSBUb29sIFJvb3QgQ0EwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAKJoa2WgWmfSYRbHDko4kEA/hGmdnv1upuYF14b6cUKy1PdWWlHmiVUE1jI9LTt39deYSr6oQ9YeQO5qF8vx0Jihu4BEN+H3pMc7yvp9iW2a8tjn+FjtFRYKH7yZAnno72Ex/DDMGrgGrgulDyITipa6LLY2irmuMPewfig0WIujAgMBAAEwDQYJKoZIhvcNAQEFBQADgYEAmKYlwiVovr/TGDpkoM01PsbupO8Qgo3ojQyPq16DaZDY1i1w3ZGuCKZWZvXcmSU2oIP3EmbW9pQYN5IdsmX2CWfBHEVFUpdUET8k3jZfigWvdhn22eyDf4Pv5RcLkVHBziH2HjtaRLwPK8Gwc7N5QXh2chkDHNTG0c/15UQj4Ho=\n-----END CERTIFICATE-----", "-----BEGIN CERTIFICATE-----\nMIIDqzCCApOgAwIBAgIBATANBgkqhkiG9w0BAQUFADB1MQswCQYDVQQGEwJTRTEUMBIGA1UEChMLRXJpY3Nzb24gQUIxFzAVBgNVBAsTDkxpY2Vuc2UgQ2VudGVyMTcwNQYDVQQDEy5Sb290IGZvciBzaWduaW5nIGxpY2Vuc2UgZmlsZXMgQ0FYIDEwNiAwMDg0LzU3MCIYDzIwMTQwNTI3MDAwMDAwWhgPMjAzODAxMTgwMDAwMDBaMHUxCzAJBgNVBAYTAlNFMRQwEgYDVQQKEwtFcmljc3NvbiBBQjEXMBUGA1UECxMOTGljZW5zZSBDZW50ZXIxNzA1BgNVBAMTLlJvb3QgZm9yIHNpZ25pbmcgbGljZW5zZSBmaWxlcyBDQVggMTA2IDAwODQvNTcwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDACdyiBUGt3bMwe0wjTjVoq4UnITlXF3fIbX5yaEQ/3/wjcoRAqmWOJKyi/jX8h0iNnndKjZiA0H3lf8Wqw9x+JlyUaA7jmsoZ2+JP3QeGluCnrZIjxeHnS76Ne4by5EP39wWmQon031oWTroCXbR36xFboKWj1S8EfD1ScilUCYi5SJTVjbHkD15dTtpDTXkSIqylglj+PEda/YYFz2HZVYuRZon3kT4HbQtwu5B5J2AUP9NKiVMTWM3Y7wimOzC4LtU6lLMcABgMbRMQ5aHmVNkSeBaTXlmCbNtTwYLsjM0/uPqWiegQbhKhsbsqZGbgh2+yVlQmQ6oMFbzy9WBjAgMBAAGjQjBAMB0GA1UdDgQWBBSkHwuHmaNP+RuwmLYGFqiPleyKDDASBgNVHRMBAf8ECDAGAQH/AgEBMAsGA1UdDwQEAwIBBjANBgkqhkiG9w0BAQUFAAOCAQEAo9pHX2IPT+Ei7ZTWEPa0WCZ3+nOGZN51kGRJ06rqLQE08BQQ0zoc3oPNkMN+WitFhGu6d8oT1+x8q/C5f2NiBplIcLywwFKZkXgcOnzBOrpcGG5tc/7+noCVdR/bUw143fiQ+3gr/f9lbj29RJ8lyzZwUKe+VAevBIgNVSyy0C2i0i+jZnfYexG93CPbfFaZ6edfSQmDil2YKAQwyNauwWYP/5Wr156aaU0XCaAvae8fcVjc+QRJRdG4IGUeEuaE3wqGEAOBdK2QIRmrF9JPJSAzx1B7a7S2I4r7hDenyMo22fZ+eM6jvrHi4RLUeqR5WQ/Ddiau0zr71AjyJ/f2LQ==\n-----END CERTIFICATE-----").validate(coreLic);
                CapacityKey capacityKey = coreLic.getCapacityKeyById(CMS_PREPACK_CAPACITY_KEY);
                if (capacityKey == null) {
                    throw new LicenseCapacityExceededException("Prepack capacity key is not defined!");
                }
                int capacity = Integer.valueOf(capacityKey.getCapacity());
                if (capacity != 0 && capacity < prepackLic.getFeatureIds().size()) {
                    throw new LicenseCapacityExceededException("Prepack capacity is exceeded!");
                }
            }
            featureKeyIds = StringUtils.join(prepackLic.getFeatureIds().iterator(), ",");
        }
        catch (LicenseNotFoundException e) {
            licState = LICENSE_STATE.LIC_NOTFOUND;
            errMessge = errPrifix + e.getMessage();
        }
        catch (LicenseCapacityExceededException e) {
            licState = LICENSE_STATE.LIC_CAPACITY_EXCEEDED;
            errMessge = errPrifix + e.getMessage();
        }
        catch (LicenseInvalidException e) {
            licState = LICENSE_STATE.LIC_INVALID;
            errMessge = errPrifix + e.getMessage();
        }
        catch (Exception e) {
            e.printStackTrace();
            licState = LICENSE_STATE.LIC_INVALID;
            errMessge = errPrifix + e.getMessage();
        }
        System.out.println((Object)licState);
        System.out.println(errMessge);
        System.out.println(featureKeyIds);
    }

    public static void main(String[] args) {
        LicenseManager.checkLicense();
    }

    public static enum LICENSE_STATE {
        LIC_OK,
        LIC_INVALID,
        LIC_NOTFOUND,
        LIC_CAPACITY_EXCEEDED;

    }
}

