<?xml version="1.0" encoding="UTF-8"?>
<specification xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" name="ECMF" converterClass="com.tandbergtv.watchpoint.pmm.title.conf.specs.ADIMetadataConverter">

	<!-- The Specification Title structure -->
	<!-- 
		The Package Title Group
	 -->
	<title>
		<name>PACKAGE</name>
		<alias>package.sectionName</alias>
		<metadata>
			<!-- ======================= Simple Fields ============================ -->
			<variable name="AssetClass" displayName="metadata.assetClass" xsi:type="stringVariableType" >
				<options>
					<option name="metadata.assetClass.optionName.package">package</option>
				</options>
			</variable>
			<variable name="AssetName" displayName="metadata.assetName" xsi:type="stringVariableType" jobParameter="true" />
			<variable name="Verb" displayName="metadata.verb" xsi:type="stringVariableType" />
			<variable name="MetadataSpecVersion" displayName="metadata.metadataSpecVersion" xsi:type="stringVariableType" />
			
			<!-- ======================= Complex Fields ============================ -->			
			
			<!-- ApplicationInfo -->					
			<variable name="ApplicationInfo" displayName="metadata.applicationInfo" xsi:type="complexVariableType" showCollapsed="true" >
				<variable name="Name" displayName="metadata.applicationInfo.name" xsi:type="stringVariableType">
					<options>
						<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.AppTypeOptionProvider</optionProvider>
					</options>
				</variable>
			</variable>

			<!-- Content -->
			<variable name="Content" displayName="metadata.content" xsi:type="complexVariableType">
				<variable name="Expression" displayName="metadata.content.expression" xsi:type="stringVariableType"/>
				<variable name="Default" displayName="metadata.content.default" xsi:type="stringVariableType"/>
				<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
					<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
					<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
					<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
					<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
					<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
					<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
					<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
					<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
						<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
						</variable>
					</variable>
				</variable>
				<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
					<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
					<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
					</variable>
				</variable>
				<variable name="Size" displayName="metadata.size" xsi:type="complexVariableType" >
					<variable name="length" displayName="metadata.size.length" xsi:type="integerVariableType" />
					<variable name="height" displayName="metadata.size.height" xsi:type="integerVariableType" />
					<variable name="width" displayName="metadata.size.width" xsi:type="integerVariableType" />
				</variable>
				<variable name="Checksum" displayName="metadata.content.checkSum" xsi:type="stringVariableType" />
				<variable name="Medium" displayName="metadata.medium" xsi:type="complexVariableType" >
					<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
						<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
						<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
						<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
						<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
						<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
						<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
						<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
					</variable>
					<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
						<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
						</variable>
					</variable>
					<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
					</variable>
				</variable>
				<variable name="MIMEType" displayName="metadata.content.mimeType" xsi:type="stringVariableType"/>
				<variable name="Resolution" displayName="metadata.content.resolution" xsi:type="stringVariableType"/>
				<variable name="FrameRate" displayName="metadata.content.frameRate" xsi:type="stringVariableType"/>
				<variable name="Codec" displayName="metadata.content.codec" xsi:type="stringVariableType"/>
				<variable name="WasPitched" displayName="metadata.content.wasPitched" xsi:type="booleanVariableType"/>
				<variable name="LastPitchDate" displayName="metadata.content.lastPitchDate" xsi:type="dateVariableType"/>
				<variable name="PitchedFilename" displayName="metadata.content.pitchedFilename" xsi:type="stringVariableType"/>
				<variable name="SizeInBytes" displayName="metadata.content.sizeInBytes" xsi:type="integerVariableType"/>
				<variable name="Type" displayName="metadata.content.type" xsi:type="stringVariableType"/>
				<variable name="NetworkType" displayName="metadata.content.networkType" xsi:type="stringVariableType"/>
				<variable name="PlayReady" displayName="metadata.content.playReady" xsi:type="booleanVariableType"/>
				<variable name="WebInitiatorUrl" displayName="metadata.content.webInitiatorUri" xsi:type="stringVariableType"/>
				<variable name="LicenseServerProxyUrl" displayName="metadata.content.licenseServerProxyUrl" xsi:type="stringVariableType"/>
			</variable>
			 
			<!-- Creation Info -->
			<variable name="CreationInfo" displayName="metadata.creationInfo" xsi:type="complexVariableType">
				<variable name="Title" displayName="metadata.title" xsi:type="complexVariableType">
					<variable name="OriginalTitle" displayName="metadata.title.original" xsi:type="complexVariableType">
						<variable name="Value" displayName="metadata.title.original.value" xsi:type="stringVariableType" />
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
					</variable>
					<variable name="DisplayTitle" displayName="metadata.title.display" xsi:type="complexVariableType">
						<variable name="Value" displayName="metadata.title.display.value" xsi:type="stringVariableType" />
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
					</variable>
					<variable name="SortTitle" displayName="metadata.title.sort" xsi:type="complexVariableType">
						<variable name="Value" displayName="metadata.title.sort.value" xsi:type="stringVariableType" />
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
					</variable>
					<variable name="ShortTitle" displayName="metadata.title.short" xsi:type="complexVariableType">
						<variable name="Value" displayName="metadata.title.short.value" xsi:type="stringVariableType" />
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
					</variable>
					<variable name="FeatureTitle" displayName="metadata.title.feature" xsi:type="complexVariableType">
						<variable name="Value" displayName="metadata.title.feature.value" xsi:type="stringVariableType" />
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
					</variable>
				</variable>					
				<variable name="Description" displayName="metadata.description" xsi:type="stringVariableType" longFormat="true" jobParameter="true" />
				<variable name="Sources" displayName="metadata.source" xsi:type="complexVariableType" showCollapsed="true">
					<variable name="Source" displayName="metadata.source" xsi:type="complexVariableType" multiValue="true">
						<variable name="Role" displayName="metadata.source.role" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="Name" displayName="metadata.source.role.name" xsi:type="stringVariableType">
								<options>
									<option name="metadata.source.role.name.optionName.actor">ACTOR</option>
									<option name="metadata.source.role.name.optionName.author">AUTHOR</option>
									<option name="metadata.source.role.name.optionName.creator">CREATOR</option>
									<option name="metadata.source.role.name.optionName.director">DIRECTOR</option>
									<option name="metadata.source.role.name.optionName.executiveproducer">EXECUTIVEPRODUCER</option>
									<option name="metadata.source.role.name.optionName.host">HOST</option>
									<option name="metadata.source.role.name.optionName.gueststar">GUESTSTAR</option>
									<option name="metadata.source.role.name.optionName.organization">ORGANIZATION</option>
									<option name="metadata.source.role.name.optionName.producer">PRODUCER</option>
									<option name="metadata.source.role.name.optionName.publisher">PUBLISHER</option>
									<option name="metadata.source.role.name.optionName.writer">WRITER</option>
								</options>
							</variable>
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="value" displayName="metadata.source.role.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="Contact" displayName="metadata.contact" xsi:type="complexVariableType">
							<variable name="FirstName" displayName="metadata.contact.firstName" xsi:type="stringVariableType" />
							<variable name="LastName" displayName="metadata.contact.lastName" xsi:type="stringVariableType" />
							<variable name="MiddleName" displayName="metadata.contact.middleName" xsi:type="stringVariableType" />
							<variable name="Email" displayName="metadata.contact.email" xsi:type="stringVariableType" />
							<variable name="Address" displayName="metadata.address" xsi:type="complexVariableType">
								<variable name="Line1" displayName="metadata.address.line1" xsi:type="stringVariableType" />
								<variable name="Line2" displayName="metadata.address.line2" xsi:type="stringVariableType" />
								<variable name="Zip" displayName="metadata.address.zip" xsi:type="stringVariableType" />
								<variable name="Place" displayName="metadata.place" xsi:type="complexVariableType" showCollapsed="true" >
									<variable name="Region" displayName="metadata.place.region" xsi:type="stringVariableType" />
									<variable name="Country" displayName="metadata.place.country" xsi:type="stringVariableType" />
									<variable name="Coordiantes" displayName="metadata.place.coordinates" xsi:type="stringVariableType" />
								</variable>
							</variable>
							<variable name="DisplayName" displayName="metadata.contact.displayName" xsi:type="stringVariableType" />
						</variable>
						<variable name="CharacterName" displayName="metadata.source.CharacterName" xsi:type="stringVariableType" />
						<variable name="Popularity" displayName="metadata.source.Popularity" xsi:type="integerVariableType" />
					</variable>
				</variable>
				<variable name="CreateDate" displayName="metadata.creationInfo.createDate" xsi:type="dateVariableType" />
				<variable name="UpdateDate" displayName="metadata.creationInfo.updateDate" xsi:type="dateVariableType" />
				<variable name="Place" displayName="metadata.creationInfo.place" xsi:type="complexVariableType" showCollapsed="true" >
					<variable name="Region" displayName="metadata.creationInfo.place.region" xsi:type="stringVariableType" />
					<variable name="Country" displayName="metadata.creationInfo.place.country" xsi:type="stringVariableType" />
					<variable name="Coordiantes" displayName="metadata.creationInfo.place.coordinates" xsi:type="stringVariableType" />
				</variable>
				<variable name="Tool" displayName="metadata.tool" xsi:type="complexVariableType" >
					<variable name="Name" displayName="metadata.creationInfo.studio.name" xsi:type="stringVariableType" />
					<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
						<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
						<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
						<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
					</variable>
					<variable name="ToolSettings" displayName="metadata.tool.settings" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="ToolSetting" displayName="metadata.tool.setting" xsi:type="complexVariableType" multiValue="true">
							<variable name="Name" displayName="metadata.name" xsi:type="stringVariableType" />
							<variable name="Value" displayName="metadata.value" xsi:type="stringVariableType" />
						</variable>
					</variable>
				</variable>
				<variable name="PublicationDate" displayName="metadata.creationInfo.publicationDate" xsi:type="integerVariableType"  />
				<variable name="Studio" displayName="metadata.creationInfo.studio" xsi:type="complexVariableType" >
					<variable name="DisplayName" displayName="metadata.creationInfo.studio.displayName" xsi:type="stringVariableType">
						<options>
							<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOptionProvider</optionProvider>
						</options>
					</variable>
					<variable name="Name" displayName="metadata.creationInfo.studio.name" xsi:type="stringVariableType">
						<options>
							<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOrgNameOptionProvider</optionProvider>
						</options>
					</variable>
					<variable name="Code" displayName="metadata.creationInfo.studio.code" xsi:type="stringVariableType">
						<options>
							<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOrgCodeOptionProvider</optionProvider>
						</options>
					</variable>
					<variable name="RoyaltyInfo" displayName="metadata.creationInfo.studio.royalty" xsi:type="complexVariableType" showCollapsed="true" >
						<variable name="RoyaltyPercent" displayName="metadata.creationInfo.studio.royalty.percent" xsi:type="floatVariableType"  />
						<variable name="RoyaltyMinimum" displayName="metadata.creationInfo.studio.royalty.minimum" xsi:type="floatVariableType"  />
						<variable name="RoyaltyFlatRate" displayName="metadata.creationInfo.studio.royalty.flatRate" xsi:type="floatVariableType"  />
					</variable>
				</variable>
			</variable>
			
			<!-- Description -->
			<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
				<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
				<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
					<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
				</variable>
			</variable>

			<!-- Identifier -->
			<variable name="Identifier" displayName="metadata.identifier" xsi:type="complexVariableType">
				<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
				<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
				<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" jobParameter="true" />
				<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
				<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
				<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
					<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
					<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
					<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
					<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
					<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
					<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
					<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
					<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
						<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
						</variable>
					</variable>
				</variable>
				<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
					<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
					<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
					</variable>
				</variable>
			</variable>					

			<!-- Original File -->
			<variable name="OriginalFile" displayName="metadata.originalFile" xsi:type="complexVariableType" >
				<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
				<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
				<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
				<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
				<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
				<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
				<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
				<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
					<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
					<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
					</variable>
				</variable>
			</variable>

			<!-- ProductInfo -->
			<variable name="ProductInfo" displayName="metadata.productInfo" xsi:type="complexVariableType" showCollapsed="true">
				<variable name="Name" displayName="metadata.productInfo.name" xsi:type="stringVariableType">
					<options>
						<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.ProductOptionProvider</optionProvider>
					</options>
				</variable>
			</variable>
			
			<!-- ProviderInfo -->
			<variable name="ProviderInfo" displayName="metadata.providerInfo" xsi:type="complexVariableType">
				<!-- Let's add it here, but it will be disabled in GUI. Users are not allowed to edit this value. -->
				<variable name="Name" displayName="metadata.providerInfo.name" xsi:type="stringVariableType" jobParameter="true" />
				<variable name="Identifier" displayName="metadata.providerId" xsi:type="complexVariableType">
					<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
					<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
					<variable name="Id" displayName="metadata.providerId" xsi:type="stringVariableType" jobParameter="true" />
					<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
					<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
					<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
						<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
						<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
						<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
						<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
						<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
						<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
						<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
					</variable>
					<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
						<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
						</variable>
					</variable>
				</variable>
				<variable name="ReferenceIdentifier" displayName="metadata.referenceIdentifier" xsi:type="complexVariableType">
					<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
					<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
					<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
					<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
					<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
					<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
						<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
						<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
						<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
						<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
						<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
						<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
						<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
					</variable>
					<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
						<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
						</variable>
					</variable>
				</variable>
			</variable>

			<!-- Version -->
			<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
				<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
				<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType" jobParameter="true" />
				<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType" jobParameter="true" />
			</variable>

			<!-- ProviderContentTiers -->
			<variable name="ProviderContentTiers" displayName="metadata.providerContentTiers" xsi:type="complexVariableType" showCollapsed="true">
				<variable name="ProviderContentTier" displayName="metadata.providerContentTier" xsi:type="complexVariableType" multiValue="true">
					<variable name="Value" displayName="metadata.providerContentTier.value" xsi:type="stringVariableType" />
					<variable name="TargetMSO" displayName="metadata.providerContentTier.targetMSO" xsi:type="stringVariableType" />
				</variable>
			</variable>

			<!-- Custom Fields -->
			<variable name="CustomFields" displayName="metadata.customFields" xsi:type="complexVariableType">
				<variable name="CustomField[@name=ArchiveType]" displayName="metadata.customFields.archiveType" xsi:type="complexVariableType" showCollapsed="true">
					<variable name="value" displayName="metadata.customFields.archiveType.value" xsi:type="stringVariableType" attribute="true" />
				</variable>
			</variable>
		</metadata>

		<!-- The Package section children -->
		<childTitles>
			<!-- 
				The Title Title Item
			-->
			<title>
				<name>TITLE</name>
				<alias>title.sectionName</alias>
				<metadata>
					<!-- ============================== Simple Fields ============================ -->
					<variable name="AssetClass" displayName="metadata.assetClass" xsi:type="stringVariableType">
						<options>
							<option name="metadata.assetClass.optionName.title">title</option>
						</options>
					</variable>
					<variable name="AssetName" displayName="metadata.assetName" xsi:type="stringVariableType" />
					<variable name="Name" displayName="metadata.name" xsi:type="stringVariableType" />
					<variable name="Verb" displayName="metadata.verb" xsi:type="stringVariableType" />
					<variable name="ISAN" displayName="metadata.isan" xsi:type="stringVariableType"  />
					<variable name="PropagationPriority" displayName="metadata.propagationPriority" xsi:type="integerVariableType"  />
					<variable name="AutoImport" displayName="metadata.autoImport" xsi:type="booleanVariableType"  />
					<variable name="AutoDeploy" displayName="metadata.autoDeploy" xsi:type="booleanVariableType"  />
					<variable name="AutoDelete" displayName="metadata.autoDelete" xsi:type="booleanVariableType"  />
					<variable name="ContentType" displayName="metadata.contentType" xsi:type="stringVariableType"  />
					<variable name="DeviceRestrictionProfileId" displayName="metadata.deviceRestrictionProfileId" xsi:type="stringVariableType"  />
					<variable name="PolicyProfileId" displayName="metadata.policyProfileId" xsi:type="stringVariableType"  />
					<variable name="RdpApp" displayName="metadata.rdpApp" xsi:type="booleanVariableType"  />
					<variable name="RulesApplied" displayName="metadata.rulesApplied" xsi:type="booleanVariableType"  />
					<variable name="ShowType" displayName="metadata.showType" xsi:type="stringVariableType"  />
					<variable name="SongTitle" displayName="metadata.songTitle" xsi:type="stringVariableType"  />
					<variable name="TitleArtist" displayName="metadata.titleArtist" xsi:type="stringVariableType"  />

					<variable name="Flag" displayName="metadata.flag" xsi:type="stringVariableType"  />
					<variable name="Keyword" displayName="metadata.keyword" xsi:type="stringVariableType"  />
					<variable name="ResultFilter" displayName="metadata.resultFilter" xsi:type="stringVariableType"  />
					<variable name="TargetingProfileId" displayName="metadata.targetingProfileId" xsi:type="stringVariableType"  />
					<variable name="AdId" displayName="metadata.adId" xsi:type="stringVariableType"  />
					<variable name="ISCI" displayName="metadata.ISCI" xsi:type="stringVariableType"  />

					<!-- ============================== Complex Fields ============================ -->

					<variable name="ProviderQAContact" displayName="metadata.providerQAContact" xsi:type="complexVariableType" showCollapsed="true" >
						<variable name="Value" displayName="metadata.providerQAContact.value" xsi:type="stringVariableType" />
					</variable>

					<!-- ApplicationInfo -->					
					<variable name="ApplicationInfo" displayName="metadata.applicationInfo" xsi:type="complexVariableType" showCollapsed="true" >
						<variable name="Name" displayName="metadata.applicationInfo.name" xsi:type="stringVariableType">
							<options>
								<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.AppTypeOptionProvider</optionProvider>
							</options>	
						</variable>
					</variable>

					<!-- Awards -->					
					<variable name="Awards" displayName="metadata.awards" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Award" displayName="metadata.award" xsi:type="complexVariableType" multiValue="true" >
							<variable name="Name" displayName="metadata.award.name" xsi:type="stringVariableType" />
							<variable name="Year" displayName="metadata.award.year" xsi:type="integerVariableType" />
							<variable name="Sources" displayName="metadata.source" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="Source" displayName="metadata.source" xsi:type="complexVariableType" multiValue="true">
									<variable name="Role" displayName="metadata.source.role" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="Name" displayName="metadata.source.role.name" xsi:type="stringVariableType">
											<options>
												<option name="metadata.source.role.name.optionName.actor">ACTOR</option>
												<option name="metadata.source.role.name.optionName.author">AUTHOR</option>
												<option name="metadata.source.role.name.optionName.creator">CREATOR</option>
												<option name="metadata.source.role.name.optionName.director">DIRECTOR</option>
												<option name="metadata.source.role.name.optionName.executiveproducer">EXECUTIVEPRODUCER</option>
												<option name="metadata.source.role.name.optionName.host">HOST</option>
												<option name="metadata.source.role.name.optionName.gueststar">GUESTSTAR</option>
												<option name="metadata.source.role.name.optionName.organization">ORGANIZATION</option>
												<option name="metadata.source.role.name.optionName.producer">PRODUCER</option>
												<option name="metadata.source.role.name.optionName.publisher">PUBLISHER</option>
												<option name="metadata.source.role.name.optionName.writer">WRITER</option>
											</options>
										</variable>
										<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
											<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
											<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
											<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
											<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
											<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
											<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
											<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
											<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
												<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
												<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
													<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
												</variable>
											</variable>
										</variable>
										<variable name="value" displayName="metadata.source.role.value" xsi:type="stringVariableType" attribute="true" />
									</variable>
									<variable name="Contact" displayName="metadata.contact" xsi:type="complexVariableType">
										<variable name="FirstName" displayName="metadata.contact.firstName" xsi:type="stringVariableType" />
										<variable name="LastName" displayName="metadata.contact.lastName" xsi:type="stringVariableType" />
										<variable name="MiddleName" displayName="metadata.contact.middleName" xsi:type="stringVariableType" />
										<variable name="Email" displayName="metadata.contact.email" xsi:type="stringVariableType" />
										<variable name="Address" displayName="metadata.address" xsi:type="complexVariableType">
											<variable name="Line1" displayName="metadata.address.line1" xsi:type="stringVariableType" />
											<variable name="Line2" displayName="metadata.address.line2" xsi:type="stringVariableType" />
											<variable name="Zip" displayName="metadata.address.zip" xsi:type="stringVariableType" />
											<variable name="Place" displayName="metadata.place" xsi:type="complexVariableType" showCollapsed="true" >
												<variable name="Region" displayName="metadata.place.region" xsi:type="stringVariableType" />
												<variable name="Country" displayName="metadata.place.country" xsi:type="stringVariableType" />
												<variable name="Coordiantes" displayName="metadata.place.coordinates" xsi:type="stringVariableType" />
											</variable>
										</variable>
										<variable name="DisplayName" displayName="metadata.contact.displayName" xsi:type="stringVariableType" />
									</variable>
									<variable name="CharacterName" displayName="metadata.source.CharacterName" xsi:type="stringVariableType" />
									<variable name="Popularity" displayName="metadata.source.Popularity" xsi:type="integerVariableType" />
								</variable>
							</variable>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
					</variable>
										
					<!-- BillingInfo -->
					<variable name="BillingInfo" displayName="metadata.billing" xsi:type="complexVariableType" >
						<variable name="CreateOffer" displayName="metadata.billing.createOffer" xsi:type="booleanVariableType" />
						<variable name="SuggestedPrice" displayName="metadata.billing.suggestedPrice" xsi:type="complexVariableType" >
							<variable name="Value" displayName="metadata.billing.suggestedPrice.value" xsi:type="floatVariableType" />
							<variable name="Currency" displayName="metadata.currency" xsi:type="stringVariableType" />
						</variable>
						<variable name="AggregatorId" displayName="metadata.aggregatorId" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="ProviderId" displayName="metadata.providerId" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="Identifier" displayName="metadata.identifier" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="AdAvail" displayName="metadata.adAvail" xsi:type="complexVariableType">
							<variable name="Time" displayName="metadata.adAvail.time" xsi:type="stringVariableType" />
							<variable name="DurationInMilliSeconds" displayName="metadata.adAvail.durationInMilliSeconds" xsi:type="integerVariableType" />
							<variable name="Count" displayName="metadata.adAvail.count" xsi:type="integerVariableType" />
							<variable name="Action" displayName="metadata.adAvail.action" xsi:type="stringVariableType" />
						</variable>
						<variable name="ContentReference" displayName="metadata.contentReference" xsi:type="complexVariableType">
							<variable name="AssetId" displayName="metadata.contentReference.assetId" xsi:type="stringVariableType" />
							<variable name="ProviderId" displayName="metadata.contentReference.providerId" xsi:type="stringVariableType" />
						</variable>
					</variable>
					
					<!-- BoxOffice -->
					<variable name="BoxOffice" displayName="metadata.boxoffice" xsi:type="complexVariableType">
						<variable name="Value" displayName="metadata.boxoffice.value" xsi:type="integerVariableType" />
						<variable name="Currency" displayName="metadata.boxoffice.currency" xsi:type="stringVariableType" />
					</variable>
					
					<!-- Caption -->
					<variable name="Caption" displayName="metadata.caption" xsi:type="complexVariableType" >
						<variable name="FieldType" displayName="metadata.caption.fieldType" xsi:type="stringVariableType" />
						<variable name="Value" displayName="metadata.caption.value" xsi:type="booleanVariableType" >
							<options>
								<option name="metadata.booleanOptionName.true">true</option>
								<option name="metadata.booleanOptionName.false">false</option>
							</options>
						</variable>
					</variable>

					<!-- Categorization -->
					<variable name="Categorization" displayName="metadata.categorization" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Category" displayName="metadata.categorization" xsi:type="complexVariableType" multiValue="true" >
							<variable name="Text" displayName="metadata.category.text" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.category.domain" xsi:type="stringVariableType"/>
							<variable name="Scheme" displayName="metadata.category.scheme" xsi:type="stringVariableType"/>
							<variable name="Category" displayName="metadata.categorization" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.category.text" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.category.domain" xsi:type="stringVariableType"/>
								<variable name="Scheme" displayName="metadata.category.scheme" xsi:type="stringVariableType"/>
							</variable>
						</variable>
					</variable>
					
					<!-- CategoryTheme -->
					<variable name="CategoryTheme" displayName="metadata.categoryTheme" xsi:type="complexVariableType">
						<variable name="Name" displayName="metadata.categoryTheme.name" xsi:type="stringVariableType"/>
						<variable name="Themes" displayName="metadata.themes" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="Theme" displayName="metadata.theme" xsi:type="complexVariableType" multiValue="true" >
								<variable name="Name" displayName="metadata.name" xsi:type="stringVariableType" />
								<variable name="Value" displayName="metadata.value" xsi:type="stringVariableType" />
							</variable>
						</variable>
					</variable>

					<!-- Content -->
					<variable name="Content" displayName="metadata.content" xsi:type="complexVariableType">
						<variable name="Expression" displayName="metadata.content.expression" xsi:type="stringVariableType"/>
						<variable name="Default" displayName="metadata.content.default" xsi:type="stringVariableType"/>
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="Size" displayName="metadata.size" xsi:type="complexVariableType" >
							<variable name="length" displayName="metadata.size.length" xsi:type="integerVariableType" />
							<variable name="height" displayName="metadata.size.height" xsi:type="integerVariableType" />
							<variable name="width" displayName="metadata.size.width" xsi:type="integerVariableType" />
						</variable>
						<variable name="Checksum" displayName="metadata.content.checkSum" xsi:type="stringVariableType" />
						<variable name="Medium" displayName="metadata.medium" xsi:type="complexVariableType" >
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="MIMEType" displayName="metadata.content.mimeType" xsi:type="stringVariableType"/>
						<variable name="Resolution" displayName="metadata.content.resolution" xsi:type="stringVariableType"/>
						<variable name="FrameRate" displayName="metadata.content.frameRate" xsi:type="stringVariableType"/>
						<variable name="Codec" displayName="metadata.content.codec" xsi:type="stringVariableType"/>
						<variable name="WasPitched" displayName="metadata.content.wasPitched" xsi:type="booleanVariableType"/>
						<variable name="LastPitchDate" displayName="metadata.content.lastPitchDate" xsi:type="dateVariableType"/>
						<variable name="PitchedFilename" displayName="metadata.content.pitchedFilename" xsi:type="stringVariableType"/>
						<variable name="SizeInBytes" displayName="metadata.content.sizeInBytes" xsi:type="integerVariableType"/>
						<variable name="Type" displayName="metadata.content.type" xsi:type="stringVariableType"/>
						<variable name="NetworkType" displayName="metadata.content.networkType" xsi:type="stringVariableType"/>
						<variable name="PlayReady" displayName="metadata.content.playReady" xsi:type="booleanVariableType"/>
						<variable name="WebInitiatorUrl" displayName="metadata.content.webInitiatorUri" xsi:type="stringVariableType"/>
						<variable name="LicenseServerProxyUrl" displayName="metadata.content.licenseServerProxyUrl" xsi:type="stringVariableType"/>
					</variable>

					<!-- Copyright -->
					<variable name="Copyright" displayName="metadata.copyright" xsi:type="complexVariableType">
						<variable name="Value" displayName="metadata.copyright.value" xsi:type="stringVariableType" />
						<variable name="CopyProtection" displayName="metadata.copyright.protection" xsi:type="booleanVariableType" />
						<variable name="CopyProtectionVerbose" displayName="metadata.copyright.protectionVerbose" xsi:type="booleanVariableType" />
						<variable name="AnalogProtectionSystem" displayName="metadata.copyright.analogProtectionSystem" xsi:type="integerVariableType" />
						<variable name="EncryptionModeIndicator" displayName="metadata.copyright.encryptionModeIndicator" xsi:type="integerVariableType" />
						<variable name="ConstrainedImageTrigger" displayName="metadata.copyright.constrainedImageTrigger" xsi:type="integerVariableType" />
						<variable name="MacroVisionLevel" displayName="metadata.copyright.macroVisionLevel" xsi:type="stringVariableType" />
						<variable name="CGMSA" displayName="metadata.copyright.cgmsa" xsi:type="integerVariableType" />
						<variable name="disableHDCP" displayName="metadata.copyright.disableHDCP" xsi:type="booleanVariableType" />
						<variable name="Provenance" displayName="metadata.copyright.provenance" xsi:type="stringVariableType" />
					</variable>

					<!-- Creation Info -->
					<variable name="CreationInfo" displayName="metadata.creationInfo" xsi:type="complexVariableType">
						<variable name="Title" displayName="metadata.title" xsi:type="complexVariableType">
							<variable name="OriginalTitle" displayName="metadata.title.original" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.original.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="DisplayTitle" displayName="metadata.title.display" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.display.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="SortTitle" displayName="metadata.title.sort" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.sort.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="ShortTitle" displayName="metadata.title.short" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.short.value" xsi:type="stringVariableType" jobParameter="true" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="FeatureTitle" displayName="metadata.title.feature" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.feature.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
						</variable>					
						<variable name="Description" displayName="metadata.description" xsi:type="stringVariableType" longFormat="true" />
						<variable name="Sources" displayName="metadata.source" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="Source" displayName="metadata.source" xsi:type="complexVariableType" multiValue="true">
								<variable name="Role" displayName="metadata.source.role" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="Name" displayName="metadata.source.role.name" xsi:type="stringVariableType">
										<options>
											<option name="metadata.source.role.name.optionName.actor">ACTOR</option>
											<option name="metadata.source.role.name.optionName.author">AUTHOR</option>
											<option name="metadata.source.role.name.optionName.creator">CREATOR</option>
											<option name="metadata.source.role.name.optionName.director">DIRECTOR</option>
											<option name="metadata.source.role.name.optionName.executiveproducer">EXECUTIVEPRODUCER</option>
											<option name="metadata.source.role.name.optionName.host">HOST</option>
											<option name="metadata.source.role.name.optionName.gueststar">GUESTSTAR</option>
											<option name="metadata.source.role.name.optionName.organization">ORGANIZATION</option>
											<option name="metadata.source.role.name.optionName.producer">PRODUCER</option>
											<option name="metadata.source.role.name.optionName.publisher">PUBLISHER</option>
											<option name="metadata.source.role.name.optionName.writer">WRITER</option>
										</options>
									</variable>
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="value" displayName="metadata.source.role.value" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="Contact" displayName="metadata.contact" xsi:type="complexVariableType">
									<variable name="FirstName" displayName="metadata.contact.firstName" xsi:type="stringVariableType" />
									<variable name="LastName" displayName="metadata.contact.lastName" xsi:type="stringVariableType" />
									<variable name="MiddleName" displayName="metadata.contact.middleName" xsi:type="stringVariableType" />
									<variable name="Email" displayName="metadata.contact.email" xsi:type="stringVariableType" />
									<variable name="Address" displayName="metadata.address" xsi:type="complexVariableType">
										<variable name="Line1" displayName="metadata.address.line1" xsi:type="stringVariableType" />
										<variable name="Line2" displayName="metadata.address.line2" xsi:type="stringVariableType" />
										<variable name="Zip" displayName="metadata.address.zip" xsi:type="stringVariableType" />
										<variable name="Place" displayName="metadata.place" xsi:type="complexVariableType" showCollapsed="true" >
											<variable name="Region" displayName="metadata.place.region" xsi:type="stringVariableType" />
											<variable name="Country" displayName="metadata.place.country" xsi:type="stringVariableType" />
											<variable name="Coordiantes" displayName="metadata.place.coordinates" xsi:type="stringVariableType" />
										</variable>
									</variable>
									<variable name="DisplayName" displayName="metadata.contact.displayName" xsi:type="stringVariableType" />
								</variable>
								<variable name="CharacterName" displayName="metadata.source.CharacterName" xsi:type="stringVariableType" />
								<variable name="Popularity" displayName="metadata.source.Popularity" xsi:type="integerVariableType" />
							</variable>
						</variable>
						<variable name="CreateDate" displayName="metadata.creationInfo.createDate" xsi:type="dateVariableType" />
						<variable name="UpdateDate" displayName="metadata.creationInfo.updateDate" xsi:type="dateVariableType" />
						<variable name="Place" displayName="metadata.creationInfo.place" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="Region" displayName="metadata.creationInfo.place.region" xsi:type="stringVariableType" />
							<variable name="Country" displayName="metadata.creationInfo.place.country" xsi:type="stringVariableType" />
							<variable name="Coordiantes" displayName="metadata.creationInfo.place.coordinates" xsi:type="stringVariableType" />
						</variable>
						<variable name="Tool" displayName="metadata.tool" xsi:type="complexVariableType" >
							<variable name="Name" displayName="metadata.creationInfo.studio.name" xsi:type="stringVariableType" />
							<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
								<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
								<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
							</variable>
							<variable name="ToolSettings" displayName="metadata.tool.settings" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="ToolSetting" displayName="metadata.tool.setting" xsi:type="complexVariableType" multiValue="true">
									<variable name="Name" displayName="metadata.name" xsi:type="stringVariableType" />
									<variable name="Value" displayName="metadata.value" xsi:type="stringVariableType" />
								</variable>
							</variable>
						</variable>
						<variable name="PublicationDate" displayName="metadata.creationInfo.publicationDate" xsi:type="integerVariableType"  />
						<variable name="Studio" displayName="metadata.creationInfo.studio" xsi:type="complexVariableType" >
							<variable name="DisplayName" displayName="metadata.creationInfo.studio.displayName" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="Name" displayName="metadata.creationInfo.studio.name" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOrgNameOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="Code" displayName="metadata.creationInfo.studio.code" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOrgCodeOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="RoyaltyInfo" displayName="metadata.creationInfo.studio.royalty" xsi:type="complexVariableType" showCollapsed="true" >
								<variable name="RoyaltyPercent" displayName="metadata.creationInfo.studio.royalty.percent" xsi:type="floatVariableType"  />
								<variable name="RoyaltyMinimum" displayName="metadata.creationInfo.studio.royalty.minimum" xsi:type="floatVariableType"  />
								<variable name="RoyaltyFlatRate" displayName="metadata.creationInfo.studio.royalty.flatRate" xsi:type="floatVariableType"  />
							</variable>
						</variable>
					</variable>
					
					<!-- Distributor -->
					<variable name="Distributor" displayName="metadata.distributor" xsi:type="complexVariableType" >
						<variable name="Name" displayName="metadata.distributor.name" xsi:type="stringVariableType"  />
						<variable name="RoyaltyInfo" displayName="metadata.distributor.royalty" xsi:type="complexVariableType" >
							<variable name="RoyaltyPercent" displayName="metadata.distributor.royalty.percent" xsi:type="floatVariableType"  />
							<variable name="RoyaltyMinimum" displayName="metadata.distributor.royalty.minimum" xsi:type="floatVariableType"  />
							<variable name="RoyaltyFlatRate" displayName="metadata.distributor.royalty.flatRate" xsi:type="floatVariableType"  />
						</variable>
					</variable>
					
					<!-- Description -->
					<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
						<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
						</variable>
					</variable>
					
					<!-- Duration -->
					<variable name="Duration" displayName="metadata.duration" xsi:type="complexVariableType">
						<variable name="DisplayDuration" displayName="metadata.duration.display" xsi:type="stringVariableType" />
						<variable name="StartOffset" displayName="metadata.duration.startOffset" xsi:type="timeVariableType" />
						<variable name="Duration" displayName="metadata.duration.value" xsi:type="timeVariableType" jobParameter="true" />
					</variable>
					
					<!-- Episode -->
					<variable name="Episode" displayName="metadata.episode" xsi:type="complexVariableType" >
						<variable name="Number" displayName="metadata.episode.number" xsi:type="stringVariableType"  />
						<variable name="Name" displayName="metadata.episode.name" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="Value" displayName="metadata.episode.name.value" xsi:type="stringVariableType" />
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="Identifier" displayName="metadata.identifier" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>						
						<variable name="SeasonPremier" displayName="metadata.episode.seasonPremiere" xsi:type="booleanVariableType"  >
							<options>
								<option name="metadata.booleanOptionName.true">true</option>
								<option name="metadata.booleanOptionName.false">false</option>
							</options>
						</variable>
						<variable name="SeasonFinale" displayName="metadata.episode.seasonFinale" xsi:type="booleanVariableType"  >
							<options>
								<option name="metadata.booleanOptionName.true">true</option>
								<option name="metadata.booleanOptionName.false">false</option>
							</options>
						</variable>
					</variable>

					<!-- Identifier -->
					<variable name="Identifier" displayName="metadata.identifier" xsi:type="complexVariableType">
						<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
						<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
						<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
						<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
						<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
					</variable>		

					<!-- Languages -->
					<variable name="Languages" displayName="metadata.Languages" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true" multiValue="true" >
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true"/>
						</variable>
					</variable>

					<!-- Locator -->
					<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
						<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
						<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
						<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
						<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
						<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
						<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
						<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
					</variable>

					<!-- OSVOD -->
					<variable name="OSVOD" displayName="metadata.osvod" xsi:type="complexVariableType">
						<variable name="PackageUsages" displayName="metadata.osvod.packageusages" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="PackageUsage" displayName="metadata.osvod.packageusage" xsi:type="stringVariableType" multiValue="true" />
						</variable>
						<variable name="PackageRefs" displayName="metadata.osvod.packagerefs" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="PackageRef" displayName="metadata.osvod.packageref" xsi:type="stringVariableType" multiValue="true" />
						</variable>
						<variable name="AssociationIds" displayName="metadata.osvod.associationids" xsi:type="complexVariableType" showCollapsed="false">
							<variable name="AssociationId" displayName="metadata.osvod.associationid" xsi:type="stringVariableType" multiValue="true"/>
						</variable>
						<variable name="OnDiskWindowStart" displayName="metadata.osvod.ondiskwindowstart" xsi:type="dateVariableType" />
						<variable name="OnDiskWindowEnd" displayName="metadata.osvod.ondiskwindowend" xsi:type="dateVariableType" />
						<variable name="MinOnDiskDuration" displayName="metadata.osvod.minondiskduration" xsi:type="integerVariableType" />
						<variable name="MaxOnDiskDuration" displayName="metadata.osvod.maxondiskduration" xsi:type="integerVariableType" />
						<variable name="MaxOnDiskDurationAfterView" displayName="metadata.osvod.maxondiskdurationafterview" xsi:type="integerVariableType" />
						<variable name="BurnAllowed" displayName="metadata.osvod.burnallowed" xsi:type="booleanVariableType" />
						<variable name="MaxBurnsAllowed" displayName="metadata.osvod.maxburnsallowed" xsi:type="integerVariableType" />
						<variable name="MaxConcurrentViewsAllowed" displayName="metadata.osvod.maxconcurrentviewsallowed" xsi:type="integerVariableType" />
						<variable name="ViewingWindows" displayName="metadata.osvod.viewingwindows" xsi:type="complexVariableType" showCollapsed="false">
							<variable name="ViewingWindow" displayName="metadata.osvod.viewingwindow" xsi:type="stringVariableType" multiValue="true"/>
						</variable>
						<variable name="CustomSortPriority" displayName="metadata.osvod.customsortpriority" xsi:type="stringVariableType" />
						<variable name="OriginalPrice" displayName="metadata.osvod.originalPrice" xsi:type="stringVariableType" />
						<variable name="BusinessClass" displayName="metadata.osvod.businessClass" xsi:type="stringVariableType" />
					</variable>

					<!-- ProductInfo -->
					<variable name="ProductInfo" displayName="metadata.productInfo" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Name" displayName="metadata.productInfo.name" xsi:type="stringVariableType">
							<options>
								<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.ProductOptionProvider</optionProvider>
							</options>
						</variable>
					</variable>
					
					<!-- ProviderInfo -->
					<variable name="ProviderInfo" displayName="metadata.providerInfo" xsi:type="complexVariableType">
						<!-- Let's add it here, but it will be disabled in GUI. Users are not allowed to edit this value. -->
						<variable name="Name" displayName="metadata.providerInfo.name" xsi:type="stringVariableType" />
						<variable name="Identifier" displayName="metadata.providerId" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.providerId" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="ReferenceIdentifier" displayName="metadata.referenceIdentifier" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
					</variable>

					<!-- Rating -->										
					<variable name="Rating" displayName="metadata.rating" xsi:type="complexVariableType">
						<variable name="RatingValues" displayName="metadata.rating" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="RatingValue" displayName="metadata.rating.value" xsi:type="complexVariableType" multiValue="true">
								<variable name="System" displayName="metadata.rating.system" xsi:type="stringVariableType">
									<options>
										<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.RatingSystemOptionProvider</optionProvider>
									</options>
								</variable>
								<variable name="Value" displayName="metadata.rating.value" xsi:type="stringVariableType" >
									<options>
										<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.RatingOptionProvider</optionProvider>
									</options>
								</variable>
							</variable>
						</variable>
						<variable name="ContentAdvisories" displayName="metadata.rating.advisories" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="ContentAdvisory" displayName="metadata.rating.advisory" xsi:type="stringVariableType" multiValue="true">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.ContentAdvisoryOptionProvider</optionProvider>
								</options>
							</variable>
						</variable>
						<variable name="TargetAudiences" displayName="metadata.rating.audiences" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="TargetAudience" displayName="metadata.rating.audience" xsi:type="stringVariableType" multiValue="true"/>
						</variable>
						<variable name="MSORatings" displayName="metadata.rating.msos" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="MSORating" displayName="metadata.rating.mso" xsi:type="stringVariableType" multiValue="true"/>
						</variable>
						<variable name="Labels" displayName="metadata.rating.labels" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="Label" displayName="metadata.rating.label" xsi:type="stringVariableType" multiValue="true"/>
						</variable>
					</variable>

					<!-- ResourceReference -->										
					<variable name="ResourceReference" displayName="metadata.resourceReference" xsi:type="complexVariableType">
						<variable name="ResourceType" displayName="metadata.resourceReference.resourceType" xsi:type="stringVariableType" />
						<variable name="Relation" displayName="metadata.resourceReference.relation" xsi:type="stringVariableType" />
						<variable name="ExternalIdScope" displayName="metadata.resourceReference.externalIdScope" xsi:type="stringVariableType" />
						<variable name="ExternalId" displayName="metadata.resourceReference.externalId" xsi:type="stringVariableType" />
					</variable>

					<!-- Review -->										
					<variable name="Review" displayName="metadata.review" xsi:type="complexVariableType">
						<variable name="Type" displayName="metadata.review.type" xsi:type="stringVariableType" />
						<variable name="Value" displayName="metadata.review.value" xsi:type="stringVariableType" />
						<variable name="Author" displayName="metadata.review.author" xsi:type="stringVariableType" />
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="Url" displayName="metadata.review.url" xsi:type="stringVariableType" />
					</variable>

					<!-- Rights -->
					<variable name="Rights" displayName="metadata.rights" xsi:type="complexVariableType">
						<variable name="Id" displayName="metadata.rights.id" xsi:type="stringVariableType" />
						<variable name="LicensingWindowStart" displayName="metadata.rights.licensingWindowStart" xsi:type="dateVariableType" jobParameter="true" jobRuleParameter="true" />
						<variable name="LicensingWindowEnd" displayName="metadata.rights.licensingWindowEnd" xsi:type="dateVariableType" jobParameter="true" jobRuleParameter="true" />
						<variable name="AvailabilityWindowStart" displayName="metadata.rights.availabilityWindowStart" xsi:type="dateVariableType" jobParameter="true" />
						<variable name="AvailabilityWindowEnd" displayName="metadata.rights.availabilityWindowEnd" xsi:type="dateVariableType" jobParameter="true" />
						<variable name="NewReleaseWindow" displayName="metadata.rights.newReleaseWindow" xsi:type="integerVariableType"  />
						<variable name="MaxPlayCount" displayName="metadata.rights.maxPlayCount" xsi:type="integerVariableType" />
						<variable name="ViewLimits" displayName="metadata.rights.maxViewLimit" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="ViewLimit" displayName="metadata.rights.maxViewLimit" xsi:type="stringVariableType" multiValue="true" />
						</variable>
						<variable name="MaxViewingLimit" displayName="metadata.rights.maxViewingLimit" xsi:type="integerVariableType"  />
						<variable name="MinViewingLimit" displayName="metadata.rights.minViewingLimit" xsi:type="integerVariableType"  />
						<variable name="MaxView" displayName="metadata.rights.maxView" xsi:type="stringVariableType" />
						<variable name="Contract" displayName="metadata.rights.contract" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="Id" displayName="metadata.identifier" xsi:type="complexVariableType">
								<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
								<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
								<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
								<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
								<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
								<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
									<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
									<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
									<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
									<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
									<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
									<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
									<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>							
							<variable name="Name" displayName="metadata.rights.contract.name" xsi:type="stringVariableType" />
						</variable>
						<variable name="PreviewPeriod" displayName="metadata.rights.previewPeriod" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="DisplayDuration" displayName="metadata.duration.display" xsi:type="stringVariableType" />
							<variable name="StartOffset" displayName="metadata.duration.startOffset" xsi:type="timeVariableType" />
							<variable name="Duration" displayName="metadata.duration.value" xsi:type="timeVariableType" jobParameter="true" />
						</variable>
						<variable name="DisplayAsLastChance" displayName="metadata.rights.displayAsLastChance" xsi:type="integerVariableType" />
						<variable name="HomeVideoWindow" displayName="metadata.rights.homeVideoWindow" xsi:type="integerVariableType"  />
						<variable name="Value" displayName="metadata.rights.value" xsi:type="stringVariableType"  />
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="ViewingCanBeResumed" displayName="metadata.rights.viewingCanBeResumed" xsi:type="booleanVariableType"/>
						<variable name="DaysToLastChance" displayName="metadata.rights.daysToLastChance" xsi:type="integerVariableType"/>
					</variable>

					<!-- Rules -->
					<variable name="Rules" displayName="metadata.rules" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Rule" displayName="metadata.rule" xsi:type="stringVariableType" multiValue="true" />
					</variable>

					<!-- Summary -->
					<variable name="Summary" displayName="metadata.summary" xsi:type="complexVariableType">
						<variable name="ShortSummary" displayName="metadata.summary.short" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="Value" displayName="metadata.summary.short.value" xsi:type="stringVariableType" longFormat="true" />
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
							<variable name="cast" displayName="metadata.summary.cast" xsi:type="booleanVariableType" attribute="true" />
						</variable>
						<variable name="MediumSummary" displayName="metadata.summary.medium" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="Value" displayName="metadata.summary.medium.value" xsi:type="stringVariableType" longFormat="true" />
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
							<variable name="cast" displayName="metadata.summary.cast" xsi:type="booleanVariableType" attribute="true" />
						</variable>
						<variable name="DisplaySummary" displayName="metadata.summary.long" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="Value" displayName="metadata.summary.long.value" xsi:type="stringVariableType" longFormat="true" />
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
							<variable name="cast" displayName="metadata.summary.cast" xsi:type="booleanVariableType" attribute="true" />
						</variable>
						<variable name="Components" displayName="metadata.summary.components" xsi:type="stringVariableType" />
						<variable name="Hierarchy" displayName="metadata.summary.hierarchy" xsi:type="stringVariableType" />
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
					</variable>

					<!-- Title -->
					<variable name="Title" displayName="metadata.title" xsi:type="complexVariableType">
						<variable name="OriginalTitle" displayName="metadata.title.original" xsi:type="complexVariableType">
							<variable name="Value" displayName="metadata.title.original.value" xsi:type="stringVariableType" />
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
							<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
						</variable>
						<variable name="DisplayTitle" displayName="metadata.title.display" xsi:type="complexVariableType">
							<variable name="Value" displayName="metadata.title.display.value" xsi:type="stringVariableType" />
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
							<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
						</variable>
						<variable name="SortTitle" displayName="metadata.title.sort" xsi:type="complexVariableType">
							<variable name="Value" displayName="metadata.title.sort.value" xsi:type="stringVariableType" />
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
							<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
						</variable>
						<variable name="ShortTitle" displayName="metadata.title.short" xsi:type="complexVariableType">
							<variable name="Value" displayName="metadata.title.short.value" xsi:type="stringVariableType" />
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
							<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
						</variable>
						<variable name="FeatureTitle" displayName="metadata.title.feature" xsi:type="complexVariableType">
							<variable name="Value" displayName="metadata.title.feature.value" xsi:type="stringVariableType" />
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
							<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
						</variable>
					</variable>	

					<!-- TSTV -->
					<variable name="TSTV" displayName="metadata.tstv" xsi:type="complexVariableType">
						<variable name="ChannelId" displayName="metadata.tstv.channelid" xsi:type="stringVariableType" />
						<variable name="EndTime" displayName="metadata.tstv.endtime" xsi:type="dateVariableType" />
						<variable name="RecordPriority" displayName="metadata.tstv.recordpriority" xsi:type="integerVariableType" />
						<variable name="ProgramName" displayName="metadata.tstv.programname" xsi:type="stringVariableType" />
						<variable name="ProgramId" displayName="metadata.tstv.programid" xsi:type="stringVariableType" />
						<variable name="Repeat" displayName="metadata.tstv.repeat" xsi:type="booleanVariableType" />
						<variable name="PlaybackWindows" displayName="metadata.tstv.playbackwindows" xsi:type="stringVariableType" />
						<variable name="MaxCopies" displayName="metadata.tstv.maxcopies" xsi:type="integerVariableType" />
						<variable name="DeleteTime" displayName="metadata.tstv.deletetime" xsi:type="dateVariableType" />
						<variable name="RefCount" displayName="metadata.tstv.refcount" xsi:type="integerVariableType" />
						<variable name="CatalogEntry" displayName="metadata.tstv.catalogentry" xsi:type="booleanVariableType" />
						<variable name="PurgeTime" displayName="metadata.tstv.purgetime" xsi:type="dateVariableType" />
						<variable name="ContentType" displayName="metadata.tstv.contenttype" xsi:type="stringVariableType" />
					</variable>

					<!-- TV -->
					<variable name="TV" displayName="metadata.tv" xsi:type="complexVariableType">
						<variable name="Authority" displayName="metadata.tv.authority" xsi:type="stringVariableType" />
						<variable name="SeriesId" displayName="metadata.seriesId" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>		
						<variable name="ProgramId" displayName="metadata.programId" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>		
						<variable name="ShowType" displayName="metadata.showType" xsi:type="stringVariableType" />
					</variable>

					<!-- TVId -->
					<variable name="TvId" displayName="metadata.tvId" xsi:type="complexVariableType">
						<variable name="Authority" displayName="metadata.tvId.authority" xsi:type="stringVariableType" />
						<variable name="ProgramId" displayName="metadata.tvId.programId" xsi:type="stringVariableType" />
						<variable name="StationId" displayName="metadata.tvId.stationId" xsi:type="integerVariableType" />
						<variable name="SeriesId" displayName="metadata.tvId.seriesId" xsi:type="stringVariableType" />
						<variable name="Network" displayName="metadata.tvId.network" xsi:type="stringVariableType" />
						<variable name="CallSign" displayName="metadata.tvId.callSign" xsi:type="stringVariableType" />
						<variable name="LiveServiceId" displayName="metadata.tvId.liveServiceId" xsi:type="stringVariableType" />
						<variable name="ProgramNumber" displayName="metadata.tvId.programNumber" xsi:type="stringVariableType" />
						<variable name="EpisodeSeasonNumber" displayName="metadata.tvId.episodeSeasonNumber" xsi:type="stringVariableType" />
						<variable name="Showtime" displayName="metadata.tvId.showtime" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="OriginalAirDate" displayName="metadata.tvId.showtime.originalAirDate" xsi:type="dateVariableType" />
							<variable name="StartTimeInUtc" displayName="metadata.tvId.showtime.startTimeInUTC" xsi:type="dateVariableType" />
						</variable>
					</variable>

					<!-- Version -->
					<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
						<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
						<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
						<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
					</variable>

					<!-- Categories -->
					<variable name="Categories" displayName="metadata.categories" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Category" displayName="metadata.category" xsi:type="complexVariableType" multiValue="true" >
							<variable name="Text" displayName="metadata.category.text" xsi:type="stringVariableType">
								<options anyValueAllowed="true">
									<optionProvider>com.ericsson.cms.categorymgmt.server.CategoryOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="Domain" displayName="metadata.category.domain" xsi:type="stringVariableType"/>
							<variable name="Scheme" displayName="metadata.category.scheme" xsi:type="stringVariableType"/>
						</variable>
					</variable>

					<!-- Chapters -->
					<variable name="Chapters" displayName="metadata.chapters" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Chapter" displayName="metadata.chapter" xsi:type="stringVariableType" multiValue="true"/>
					</variable>

					<!-- Sources -->
					<variable name="Sources" displayName="metadata.source" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Source" displayName="metadata.source" xsi:type="complexVariableType" multiValue="true">
							<variable name="Role" displayName="metadata.source.role" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="Name" displayName="metadata.source.role.name" xsi:type="stringVariableType">
									<options>
										<option name="metadata.source.role.name.optionName.actor">ACTOR</option>
										<option name="metadata.source.role.name.optionName.author">AUTHOR</option>
										<option name="metadata.source.role.name.optionName.creator">CREATOR</option>
										<option name="metadata.source.role.name.optionName.director">DIRECTOR</option>
										<option name="metadata.source.role.name.optionName.executiveproducer">EXECUTIVEPRODUCER</option>
										<option name="metadata.source.role.name.optionName.host">HOST</option>
										<option name="metadata.source.role.name.optionName.gueststar">GUESTSTAR</option>
										<option name="metadata.source.role.name.optionName.organization">ORGANIZATION</option>
										<option name="metadata.source.role.name.optionName.producer">PRODUCER</option>
										<option name="metadata.source.role.name.optionName.publisher">PUBLISHER</option>
										<option name="metadata.source.role.name.optionName.writer">WRITER</option>
									</options>
								</variable>
								<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
									<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
									<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
									<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
									<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
									<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
									<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
									<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>
								<variable name="value" displayName="metadata.source.role.value" xsi:type="stringVariableType" attribute="true" />
							</variable>
							<variable name="Contact" displayName="metadata.contact" xsi:type="complexVariableType">
								<variable name="FirstName" displayName="metadata.contact.firstName" xsi:type="stringVariableType" />
								<variable name="LastName" displayName="metadata.contact.lastName" xsi:type="stringVariableType" />
								<variable name="MiddleName" displayName="metadata.contact.middleName" xsi:type="stringVariableType" />
								<variable name="Email" displayName="metadata.contact.email" xsi:type="stringVariableType" />
								<variable name="Address" displayName="metadata.address" xsi:type="complexVariableType">
									<variable name="Line1" displayName="metadata.address.line1" xsi:type="stringVariableType" />
									<variable name="Line2" displayName="metadata.address.line2" xsi:type="stringVariableType" />
									<variable name="Zip" displayName="metadata.address.zip" xsi:type="stringVariableType" />
									<variable name="Place" displayName="metadata.place" xsi:type="complexVariableType" showCollapsed="true" >
										<variable name="Region" displayName="metadata.place.region" xsi:type="stringVariableType" />
										<variable name="Country" displayName="metadata.place.country" xsi:type="stringVariableType" />
										<variable name="Coordiantes" displayName="metadata.place.coordinates" xsi:type="stringVariableType" />
									</variable>
								</variable>
								<variable name="DisplayName" displayName="metadata.contact.displayName" xsi:type="stringVariableType" />
							</variable>
							<variable name="CharacterName" displayName="metadata.source.CharacterName" xsi:type="stringVariableType" />
							<variable name="Popularity" displayName="metadata.source.Popularity" xsi:type="integerVariableType" />
						</variable>
					</variable>

					<!-- Genres -->
					<variable name="Genres" displayName="metadata.genres" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Genre" displayName="metadata.genre" xsi:type="complexVariableType" multiValue="true" >
							<variable name="Value" displayName="metadata.genre.value" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.GenreOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="Order" displayName="metadata.genre.order" xsi:type="integerVariableType"/>
						</variable>
					</variable>

					<!-- Custom Fields -->
					<variable name="CustomFields" displayName="metadata.customFields" xsi:type="complexVariableType">
						<variable name="CustomField[@name=AzukiM1]" displayName="metadata.customFields.azukiM1" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM1.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM2]" displayName="metadata.customFields.azukiM2" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM2.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM3]" displayName="metadata.customFields.azukiM3" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM3.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM4]" displayName="metadata.customFields.azukiM4" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM4.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM5]" displayName="metadata.customFields.azukiM5" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM5.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM6]" displayName="metadata.customFields.azukiM6" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM6.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM7]" displayName="metadata.customFields.azukiM7" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM7.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM8]" displayName="metadata.customFields.azukiM8" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM8.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM9]" displayName="metadata.customFields.azukiM9" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM9.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM10]" displayName="metadata.customFields.azukiM10" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM10.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM11]" displayName="metadata.customFields.azukiM11" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM11.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM12]" displayName="metadata.customFields.azukiM12" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM12.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM13]" displayName="metadata.customFields.azukiM13" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM13.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM14]" displayName="metadata.customFields.azukiM14" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM14.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM15]" displayName="metadata.customFields.azukiM15" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM15.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM16]" displayName="metadata.customFields.azukiM16" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM16.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM17]" displayName="metadata.customFields.azukiM17" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM17.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM18]" displayName="metadata.customFields.azukiM18" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM18.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM19]" displayName="metadata.customFields.azukiM19" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM19.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM20]" displayName="metadata.customFields.azukiM20" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM20.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM21]" displayName="metadata.customFields.azukiM21" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM21.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM22]" displayName="metadata.customFields.azukiM22" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM22.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM23]" displayName="metadata.customFields.azukiM23" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM23.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM24]" displayName="metadata.customFields.azukiM24" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM24.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM25]" displayName="metadata.customFields.azukiM25" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM25.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM26]" displayName="metadata.customFields.azukiM26" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM26.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM27]" displayName="metadata.customFields.azukiM27" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM27.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM28]" displayName="metadata.customFields.azukiM28" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM28.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM29]" displayName="metadata.customFields.azukiM29" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM29.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM30]" displayName="metadata.customFields.azukiM30" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM30.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM31]" displayName="metadata.customFields.azukiM31" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM31.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM32]" displayName="metadata.customFields.azukiM32" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM32.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
					</variable>					

				</metadata>
			</title>

			<!-- 
				The Display Title Item
			-->
			<title>
				<name>DISPLAY</name>
				<alias>display.sectionName</alias>
				<metadata>
					<!-- ============================== Simple Fields =============================== -->
					<variable name="AssetClass" displayName="metadata.assetClass" xsi:type="stringVariableType">
						<options>
							<option name="metadata.assetClass.optionName.display">display</option>
						</options>
					</variable>
					<variable name="AssetName" displayName="metadata.assetName" xsi:type="stringVariableType" />					
					<variable name="Verb" displayName="metadata.verb" xsi:type="stringVariableType" />
					<variable name="ISAN" displayName="metadata.isan" xsi:type="stringVariableType" />
					<variable name="PropagationPriority" displayName="metadata.propagationPriority" xsi:type="integerVariableType"  />
					<variable name="AutoImport" displayName="metadata.autoImport" xsi:type="booleanVariableType"  />
					<variable name="AutoDeploy" displayName="metadata.autoDeploy" xsi:type="booleanVariableType"  />
					<variable name="AutoDelete" displayName="metadata.autoDelete" xsi:type="booleanVariableType"  />
					<variable name="Keyword" displayName="metadata.keyword" xsi:type="stringVariableType"  />
					<variable name="ShowType" displayName="metadata.showType" xsi:type="stringVariableType"  />
					<variable name="SongTitle" displayName="metadata.songTitle" xsi:type="stringVariableType"  />
					<variable name="TitleArtist" displayName="metadata.titleArtist" xsi:type="stringVariableType"  />

					<!-- ============================== Complex Fields =============================== -->

					<variable name="ProviderQAContact" displayName="metadata.providerQAContact" xsi:type="complexVariableType" showCollapsed="true" >
						<variable name="Value" displayName="metadata.providerQAContact.value" xsi:type="stringVariableType" />
					</variable>

					<!-- ApplicationInfo -->					
					<variable name="ApplicationInfo" displayName="metadata.applicationInfo" xsi:type="complexVariableType" showCollapsed="true" >
						<variable name="Name" displayName="metadata.applicationInfo.name" xsi:type="stringVariableType">
							<options>
								<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.AppTypeOptionProvider</optionProvider>
							</options>	
						</variable>
					</variable>
	
					<!-- Awards -->					
					<variable name="Awards" displayName="metadata.awards" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Award" displayName="metadata.award" xsi:type="complexVariableType" multiValue="true" >
							<variable name="Name" displayName="metadata.award.name" xsi:type="stringVariableType" />
							<variable name="Year" displayName="metadata.award.year" xsi:type="integerVariableType" />
							<variable name="Sources" displayName="metadata.source" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="Source" displayName="metadata.source" xsi:type="complexVariableType" multiValue="true">
									<variable name="Role" displayName="metadata.source.role" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="Name" displayName="metadata.source.role.name" xsi:type="stringVariableType">
											<options>
												<option name="metadata.source.role.name.optionName.actor">ACTOR</option>
												<option name="metadata.source.role.name.optionName.author">AUTHOR</option>
												<option name="metadata.source.role.name.optionName.creator">CREATOR</option>
												<option name="metadata.source.role.name.optionName.director">DIRECTOR</option>
												<option name="metadata.source.role.name.optionName.executiveproducer">EXECUTIVEPRODUCER</option>
												<option name="metadata.source.role.name.optionName.host">HOST</option>
												<option name="metadata.source.role.name.optionName.gueststar">GUESTSTAR</option>
												<option name="metadata.source.role.name.optionName.organization">ORGANIZATION</option>
												<option name="metadata.source.role.name.optionName.producer">PRODUCER</option>
												<option name="metadata.source.role.name.optionName.publisher">PUBLISHER</option>
												<option name="metadata.source.role.name.optionName.writer">WRITER</option>
											</options>
										</variable>
										<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
											<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
											<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
											<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
											<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
											<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
											<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
											<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
											<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
												<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
												<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
													<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
												</variable>
											</variable>
										</variable>
										<variable name="value" displayName="metadata.source.role.value" xsi:type="stringVariableType" attribute="true" />
									</variable>
									<variable name="Contact" displayName="metadata.contact" xsi:type="complexVariableType">
										<variable name="FirstName" displayName="metadata.contact.firstName" xsi:type="stringVariableType" />
										<variable name="LastName" displayName="metadata.contact.lastName" xsi:type="stringVariableType" />
										<variable name="MiddleName" displayName="metadata.contact.middleName" xsi:type="stringVariableType" />
										<variable name="Email" displayName="metadata.contact.email" xsi:type="stringVariableType" />
										<variable name="Address" displayName="metadata.address" xsi:type="complexVariableType">
											<variable name="Line1" displayName="metadata.address.line1" xsi:type="stringVariableType" />
											<variable name="Line2" displayName="metadata.address.line2" xsi:type="stringVariableType" />
											<variable name="Zip" displayName="metadata.address.zip" xsi:type="stringVariableType" />
											<variable name="Place" displayName="metadata.place" xsi:type="complexVariableType" showCollapsed="true" >
												<variable name="Region" displayName="metadata.place.region" xsi:type="stringVariableType" />
												<variable name="Country" displayName="metadata.place.country" xsi:type="stringVariableType" />
												<variable name="Coordiantes" displayName="metadata.place.coordinates" xsi:type="stringVariableType" />
											</variable>
										</variable>
										<variable name="DisplayName" displayName="metadata.contact.displayName" xsi:type="stringVariableType" />
									</variable>
									<variable name="CharacterName" displayName="metadata.source.CharacterName" xsi:type="stringVariableType" />
									<variable name="Popularity" displayName="metadata.source.Popularity" xsi:type="integerVariableType" />
								</variable>
							</variable>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
					</variable>
					
					<!-- BillingInfo -->
					<variable name="BillingInfo" displayName="metadata.billing" xsi:type="complexVariableType" >
						<variable name="CreateOffer" displayName="metadata.billing.createOffer" xsi:type="booleanVariableType" />
						<variable name="SuggestedPrice" displayName="metadata.billing.suggestedPrice" xsi:type="complexVariableType" >
							<variable name="Value" displayName="metadata.billing.suggestedPrice.value" xsi:type="floatVariableType" />
							<variable name="Currency" displayName="metadata.currency" xsi:type="stringVariableType" />
						</variable>
						<variable name="AggregatorId" displayName="metadata.aggregatorId" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="ProviderId" displayName="metadata.providerId" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="Identifier" displayName="metadata.identifier" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="AdAvail" displayName="metadata.adAvail" xsi:type="complexVariableType">
							<variable name="Time" displayName="metadata.adAvail.time" xsi:type="stringVariableType" />
							<variable name="DurationInMilliSeconds" displayName="metadata.adAvail.durationInMilliSeconds" xsi:type="integerVariableType" />
							<variable name="Count" displayName="metadata.adAvail.count" xsi:type="integerVariableType" />
							<variable name="Action" displayName="metadata.adAvail.action" xsi:type="stringVariableType" />
						</variable>
						<variable name="ContentReference" displayName="metadata.contentReference" xsi:type="complexVariableType">
							<variable name="AssetId" displayName="metadata.contentReference.assetId" xsi:type="stringVariableType" />
							<variable name="ProviderId" displayName="metadata.contentReference.providerId" xsi:type="stringVariableType" />
						</variable>
					</variable>
					
					<!-- BoxOffice -->
					<variable name="BoxOffice" displayName="metadata.boxoffice" xsi:type="complexVariableType">
						<variable name="Value" displayName="metadata.boxoffice.value" xsi:type="integerVariableType" />
						<variable name="Currency" displayName="metadata.boxoffice.currency" xsi:type="stringVariableType" />
					</variable>
					
					<!-- Caption -->
					<variable name="Caption" displayName="metadata.caption" xsi:type="complexVariableType" >
						<variable name="FieldType" displayName="metadata.caption.fieldType" xsi:type="stringVariableType" />
						<variable name="Value" displayName="metadata.caption.value" xsi:type="booleanVariableType" >
							<options>
								<option name="metadata.booleanOptionName.true">true</option>
								<option name="metadata.booleanOptionName.false">false</option>
							</options>
						</variable>
					</variable>
						
					<!-- Content -->
					<variable name="Content" displayName="metadata.content" xsi:type="complexVariableType">
						<variable name="Expression" displayName="metadata.content.expression" xsi:type="stringVariableType"/>
						<variable name="Default" displayName="metadata.content.default" xsi:type="stringVariableType"/>
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="Size" displayName="metadata.size" xsi:type="complexVariableType" >
							<variable name="length" displayName="metadata.size.length" xsi:type="integerVariableType" />
							<variable name="height" displayName="metadata.size.height" xsi:type="integerVariableType" />
							<variable name="width" displayName="metadata.size.width" xsi:type="integerVariableType" />
						</variable>
						<variable name="Checksum" displayName="metadata.content.checkSum" xsi:type="stringVariableType" />
						<variable name="Medium" displayName="metadata.medium" xsi:type="complexVariableType" >
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="MIMEType" displayName="metadata.content.mimeType" xsi:type="stringVariableType"/>
						<variable name="Resolution" displayName="metadata.content.resolution" xsi:type="stringVariableType"/>
						<variable name="FrameRate" displayName="metadata.content.frameRate" xsi:type="stringVariableType"/>
						<variable name="Codec" displayName="metadata.content.codec" xsi:type="stringVariableType"/>
						<variable name="WasPitched" displayName="metadata.content.wasPitched" xsi:type="booleanVariableType"/>
						<variable name="LastPitchDate" displayName="metadata.content.lastPitchDate" xsi:type="dateVariableType"/>
						<variable name="PitchedFilename" displayName="metadata.content.pitchedFilename" xsi:type="stringVariableType"/>
						<variable name="SizeInBytes" displayName="metadata.content.sizeInBytes" xsi:type="integerVariableType"/>
						<variable name="Type" displayName="metadata.content.type" xsi:type="stringVariableType"/>
						<variable name="NetworkType" displayName="metadata.content.networkType" xsi:type="stringVariableType"/>
						<variable name="PlayReady" displayName="metadata.content.playReady" xsi:type="booleanVariableType"/>
						<variable name="WebInitiatorUrl" displayName="metadata.content.webInitiatorUri" xsi:type="stringVariableType"/>
						<variable name="LicenseServerProxyUrl" displayName="metadata.content.licenseServerProxyUrl" xsi:type="stringVariableType"/>
					</variable>
													
					<!-- Creation Info -->
					<variable name="CreationInfo" displayName="metadata.creationInfo" xsi:type="complexVariableType">
						<variable name="Title" displayName="metadata.title" xsi:type="complexVariableType">
							<variable name="OriginalTitle" displayName="metadata.title.original" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.original.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="DisplayTitle" displayName="metadata.title.display" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.display.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="SortTitle" displayName="metadata.title.sort" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.sort.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="ShortTitle" displayName="metadata.title.short" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.short.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="FeatureTitle" displayName="metadata.title.feature" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.feature.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
						</variable>					
						<variable name="Description" displayName="metadata.description" xsi:type="stringVariableType" longFormat="true" />
						<variable name="Sources" displayName="metadata.source" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="Source" displayName="metadata.source" xsi:type="complexVariableType" multiValue="true">
								<variable name="Role" displayName="metadata.source.role" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="Name" displayName="metadata.source.role.name" xsi:type="stringVariableType">
										<options>
											<option name="metadata.source.role.name.optionName.actor">ACTOR</option>
											<option name="metadata.source.role.name.optionName.author">AUTHOR</option>
											<option name="metadata.source.role.name.optionName.creator">CREATOR</option>
											<option name="metadata.source.role.name.optionName.director">DIRECTOR</option>
											<option name="metadata.source.role.name.optionName.executiveproducer">EXECUTIVEPRODUCER</option>
											<option name="metadata.source.role.name.optionName.host">HOST</option>
											<option name="metadata.source.role.name.optionName.gueststar">GUESTSTAR</option>
											<option name="metadata.source.role.name.optionName.organization">ORGANIZATION</option>
											<option name="metadata.source.role.name.optionName.producer">PRODUCER</option>
											<option name="metadata.source.role.name.optionName.publisher">PUBLISHER</option>
											<option name="metadata.source.role.name.optionName.writer">WRITER</option>
										</options>
									</variable>
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="value" displayName="metadata.source.role.value" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="Contact" displayName="metadata.contact" xsi:type="complexVariableType">
									<variable name="FirstName" displayName="metadata.contact.firstName" xsi:type="stringVariableType" />
									<variable name="LastName" displayName="metadata.contact.lastName" xsi:type="stringVariableType" />
									<variable name="MiddleName" displayName="metadata.contact.middleName" xsi:type="stringVariableType" />
									<variable name="Email" displayName="metadata.contact.email" xsi:type="stringVariableType" />
									<variable name="Address" displayName="metadata.address" xsi:type="complexVariableType">
										<variable name="Line1" displayName="metadata.address.line1" xsi:type="stringVariableType" />
										<variable name="Line2" displayName="metadata.address.line2" xsi:type="stringVariableType" />
										<variable name="Zip" displayName="metadata.address.zip" xsi:type="stringVariableType" />
										<variable name="Place" displayName="metadata.place" xsi:type="complexVariableType" showCollapsed="true" >
											<variable name="Region" displayName="metadata.place.region" xsi:type="stringVariableType" />
											<variable name="Country" displayName="metadata.place.country" xsi:type="stringVariableType" />
											<variable name="Coordiantes" displayName="metadata.place.coordinates" xsi:type="stringVariableType" />
										</variable>
									</variable>
									<variable name="DisplayName" displayName="metadata.contact.displayName" xsi:type="stringVariableType" />
								</variable>
								<variable name="CharacterName" displayName="metadata.source.CharacterName" xsi:type="stringVariableType" />
								<variable name="Popularity" displayName="metadata.source.Popularity" xsi:type="integerVariableType" />
							</variable>
						</variable>
						<variable name="CreateDate" displayName="metadata.creationInfo.createDate" xsi:type="dateVariableType" />
						<variable name="UpdateDate" displayName="metadata.creationInfo.updateDate" xsi:type="dateVariableType" />
						<variable name="Place" displayName="metadata.creationInfo.place" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="Region" displayName="metadata.place.region" xsi:type="stringVariableType" />
							<variable name="Country" displayName="metadata.place.country" xsi:type="stringVariableType" />
							<variable name="Coordiantes" displayName="metadata.place.coordinates" xsi:type="stringVariableType" />
						</variable>
						<variable name="Tool" displayName="metadata.tool" xsi:type="complexVariableType" >
							<variable name="Name" displayName="metadata.creationInfo.studio.name" xsi:type="stringVariableType" />
							<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
								<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
								<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
							</variable>
							<variable name="ToolSettings" displayName="metadata.tool" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="ToolSetting" displayName="metadata.tool" xsi:type="complexVariableType" multiValue="true">
									<variable name="Name" displayName="metadata.name" xsi:type="stringVariableType" />
									<variable name="Value" displayName="metadata.value" xsi:type="stringVariableType" />
								</variable>
							</variable>
						</variable>
						<variable name="PublicationDate" displayName="metadata.creationInfo.publicationDate" xsi:type="integerVariableType"  />
						<variable name="Studio" displayName="metadata.creationInfo.studio" xsi:type="complexVariableType" >
							<variable name="DisplayName" displayName="metadata.creationInfo.studio.displayName" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="Name" displayName="metadata.creationInfo.studio.name" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOrgNameOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="Code" displayName="metadata.creationInfo.studio.code" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOrgCodeOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="RoyaltyInfo" displayName="metadata.creationInfo.studio.royalty" xsi:type="complexVariableType" showCollapsed="true" >
								<variable name="RoyaltyPercent" displayName="metadata.creationInfo.studio.royalty.percent" xsi:type="floatVariableType"  />
								<variable name="RoyaltyMinimum" displayName="metadata.creationInfo.studio.royalty.minimum" xsi:type="floatVariableType"  />
								<variable name="RoyaltyFlatRate" displayName="metadata.creationInfo.studio.royalty.flatRate" xsi:type="floatVariableType"  />
							</variable>
						</variable>
					</variable>
					
					<!-- Distributor -->
					<variable name="Distributor" displayName="metadata.distributor" xsi:type="complexVariableType" >
						<variable name="Name" displayName="metadata.distributor.name" xsi:type="stringVariableType"  />
						<variable name="RoyaltyInfo" displayName="metadata.distributor.royalty" xsi:type="complexVariableType" >
							<variable name="RoyaltyPercent" displayName="metadata.distributor.royalty.percent" xsi:type="floatVariableType"  />
							<variable name="RoyaltyMinimum" displayName="metadata.distributor.royalty.minimum" xsi:type="floatVariableType"  />
							<variable name="RoyaltyFlatRate" displayName="metadata.distributor.royalty.flatRate" xsi:type="floatVariableType"  />
						</variable>
					</variable>
					
					<!-- Description -->
					<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
						<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
						</variable>
					</variable>
					
					<!-- Duration -->
					<variable name="Duration" displayName="metadata.duration" xsi:type="complexVariableType">
						<variable name="DisplayDuration" displayName="metadata.duration.display" xsi:type="stringVariableType" />
						<variable name="StartOffset" displayName="metadata.duration.startOffset" xsi:type="timeVariableType" />
						<variable name="Duration" displayName="metadata.duration.value" xsi:type="timeVariableType" jobParameter="true" />
					</variable>
					
					<!-- Episode -->
					<variable name="Episode" displayName="metadata.episode" xsi:type="complexVariableType" >
						<variable name="Number" displayName="metadata.episode.number" xsi:type="stringVariableType"  />
						<variable name="Name" displayName="metadata.episode.name" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="Value" displayName="metadata.episode.name.value" xsi:type="stringVariableType" />
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="Identifier" displayName="metadata.identifier" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>						
						<variable name="SeasonPremier" displayName="metadata.episode.seasonPremiere" xsi:type="booleanVariableType"  >
							<options>
								<option name="metadata.booleanOptionName.true">true</option>
								<option name="metadata.booleanOptionName.false">false</option>
							</options>
						</variable>
						<variable name="SeasonFinale" displayName="metadata.episode.seasonFinale" xsi:type="booleanVariableType"  >
							<options>
								<option name="metadata.booleanOptionName.true">true</option>
								<option name="metadata.booleanOptionName.false">false</option>
							</options>
						</variable>
					</variable>
					
					<!-- Identifier -->
					<variable name="Identifier" displayName="metadata.identifier" xsi:type="complexVariableType">
						<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
						<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
						<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
						<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
						<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
					</variable>		
								
					<!-- Languages -->
					<variable name="Languages" displayName="metadata.Languages" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true" multiValue="true" >
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true"/>
						</variable>
					</variable>

					<!-- OSVOD -->
					<variable name="OSVOD" displayName="metadata.osvod" xsi:type="complexVariableType">
						<variable name="PackageUsages" displayName="metadata.osvod.packageusages" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="PackageUsage" displayName="metadata.osvod.packageusage" xsi:type="stringVariableType" multiValue="true" />
						</variable>
						<variable name="PackageRefs" displayName="metadata.osvod.packagerefs" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="PackageRef" displayName="metadata.osvod.packageref" xsi:type="stringVariableType" multiValue="true" />
						</variable>
						<variable name="AssociationIds" displayName="metadata.osvod.associationids" xsi:type="complexVariableType" showCollapsed="false">
							<variable name="AssociationId" displayName="metadata.osvod.associationid" xsi:type="stringVariableType" multiValue="true"/>
						</variable>
						<variable name="OnDiskWindowStart" displayName="metadata.osvod.ondiskwindowstart" xsi:type="dateVariableType" />
						<variable name="OnDiskWindowEnd" displayName="metadata.osvod.ondiskwindowend" xsi:type="dateVariableType" />
						<variable name="MinOnDiskDuration" displayName="metadata.osvod.minondiskduration" xsi:type="integerVariableType" />
						<variable name="MaxOnDiskDuration" displayName="metadata.osvod.maxondiskduration" xsi:type="integerVariableType" />
						<variable name="MaxOnDiskDurationAfterView" displayName="metadata.osvod.maxondiskdurationafterview" xsi:type="integerVariableType" />
						<variable name="BurnAllowed" displayName="metadata.osvod.burnallowed" xsi:type="booleanVariableType" />
						<variable name="MaxBurnsAllowed" displayName="metadata.osvod.maxburnsallowed" xsi:type="integerVariableType" />
						<variable name="MaxConcurrentViewsAllowed" displayName="metadata.osvod.maxconcurrentviewsallowed" xsi:type="integerVariableType" />
						<variable name="ViewingWindows" displayName="metadata.osvod.viewingwindows" xsi:type="complexVariableType" showCollapsed="false">
							<variable name="ViewingWindow" displayName="metadata.osvod.viewingwindow" xsi:type="stringVariableType" multiValue="true"/>
						</variable>
						<variable name="CustomSortPriority" displayName="metadata.osvod.customsortpriority" xsi:type="stringVariableType" />
						<variable name="OriginalPrice" displayName="metadata.osvod.originalPrice" xsi:type="stringVariableType" />
						<variable name="BusinessClass" displayName="metadata.osvod.businessClass" xsi:type="stringVariableType" />
					</variable>
					
					<!-- ProductInfo -->
					<variable name="ProductInfo" displayName="metadata.productInfo" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Name" displayName="metadata.productInfo.name" xsi:type="stringVariableType">
							<options>
								<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.ProductOptionProvider</optionProvider>
							</options>
						</variable>
					</variable>
					
					<!-- ProviderInfo -->
					<variable name="ProviderInfo" displayName="metadata.providerInfo" xsi:type="complexVariableType">
						<!-- Let's add it here, but it will be disabled in GUI. Users are not allowed to edit this value. -->
						<variable name="Name" displayName="metadata.providerInfo.name" xsi:type="stringVariableType" />
						<variable name="Identifier" displayName="metadata.providerId" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.providerId" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="ReferenceIdentifier" displayName="metadata.referenceIdentifier" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
					</variable>
					
					<!-- Rating -->										
					<variable name="Rating" displayName="metadata.rating" xsi:type="complexVariableType">
						<variable name="RatingValues" displayName="metadata.rating" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="RatingValue" displayName="metadata.rating.value" xsi:type="complexVariableType" multiValue="true">
								<variable name="System" displayName="metadata.rating.system" xsi:type="stringVariableType">
									<options>
										<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.RatingSystemOptionProvider</optionProvider>
									</options>
								</variable>
								<variable name="Value" displayName="metadata.rating.value" xsi:type="stringVariableType">
									<options>
										<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.RatingOptionProvider</optionProvider>
									</options>
								</variable>
							</variable>
						</variable>
						<variable name="ContentAdvisories" displayName="metadata.rating.advisories" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="ContentAdvisory" displayName="metadata.rating.advisory" xsi:type="stringVariableType" multiValue="true">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.ContentAdvisoryOptionProvider</optionProvider>
								</options>
							</variable>
						</variable>
						<variable name="TargetAudiences" displayName="metadata.rating.audiences" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="TargetAudience" displayName="metadata.rating.audience" xsi:type="stringVariableType" multiValue="true"/>
						</variable>
						<variable name="MSORatings" displayName="metadata.rating.msos" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="MSORating" displayName="metadata.rating.mso" xsi:type="stringVariableType" multiValue="true"/>
						</variable>
						<variable name="Labels" displayName="metadata.rating.labels" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="Label" displayName="metadata.rating.label" xsi:type="stringVariableType" multiValue="true"/>
						</variable>
					</variable>
					
					<!-- Rights -->
					<variable name="Rights" displayName="metadata.rights" xsi:type="complexVariableType">
						<variable name="Id" displayName="metadata.rights.id" xsi:type="stringVariableType" />
						<variable name="LicensingWindowStart" displayName="metadata.rights.licensingWindowStart" xsi:type="dateVariableType" jobParameter="true" />
						<variable name="LicensingWindowEnd" displayName="metadata.rights.licensingWindowEnd" xsi:type="dateVariableType" jobParameter="true" />
						<variable name="AvailabilityWindowStart" displayName="metadata.rights.availabilityWindowStart" xsi:type="dateVariableType" jobParameter="true" />
						<variable name="AvailabilityWindowEnd" displayName="metadata.rights.availabilityWindowEnd" xsi:type="dateVariableType" jobParameter="true" />
						<variable name="NewReleaseWindow" displayName="metadata.rights.newReleaseWindow" xsi:type="integerVariableType"  />
						<variable name="MaxPlayCount" displayName="metadata.rights.maxPlayCount" xsi:type="integerVariableType" />
						<variable name="ViewLimits" displayName="metadata.rights.maxViewLimit" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="ViewLimit" displayName="metadata.rights.maxViewLimit" xsi:type="stringVariableType" multiValue="true" />
						</variable>
						<variable name="MaxViewingLimit" displayName="metadata.rights.maxViewingLimit" xsi:type="integerVariableType"  />
						<variable name="MinViewingLimit" displayName="metadata.rights.minViewingLimit" xsi:type="integerVariableType"  />
						<variable name="MaxView" displayName="metadata.rights.maxView" xsi:type="stringVariableType" />
						<variable name="Contract" displayName="metadata.rights.contract" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="Id" displayName="metadata.identifier" xsi:type="complexVariableType">
								<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
								<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
								<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
								<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
								<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
								<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
									<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
									<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
									<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
									<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
									<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
									<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
									<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>							
							<variable name="Name" displayName="metadata.rights.contract.name" xsi:type="stringVariableType" />
						</variable>
						<variable name="PreviewPeriod" displayName="metadata.rights.previewPeriod" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="DisplayDuration" displayName="metadata.duration.display" xsi:type="stringVariableType" />
							<variable name="StartOffset" displayName="metadata.duration.startOffset" xsi:type="timeVariableType" />
							<variable name="Duration" displayName="metadata.duration.value" xsi:type="timeVariableType" jobParameter="true" />
						</variable>
						<variable name="DisplayAsLastChance" displayName="metadata.rights.displayAsLastChance" xsi:type="integerVariableType" />
						<variable name="HomeVideoWindow" displayName="metadata.rights.homeVideoWindow" xsi:type="integerVariableType"  />
						<variable name="Value" displayName="metadata.rights.value" xsi:type="stringVariableType"  />
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="ViewingCanBeResumed" displayName="metadata.rights.viewingCanBeResumed" xsi:type="booleanVariableType"/>
						<variable name="DaysToLastChance" displayName="metadata.rights.daysToLastChance" xsi:type="integerVariableType"/>
					</variable>
					
					<!-- Summary -->
					<variable name="Summary" displayName="metadata.summary" xsi:type="complexVariableType">
						<variable name="ShortSummary" displayName="metadata.summary.short" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="Value" displayName="metadata.summary.short.value" xsi:type="stringVariableType" longFormat="true" />
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
							<variable name="cast" displayName="metadata.summary.cast" xsi:type="booleanVariableType" attribute="true" />
						</variable>
						<variable name="MediumSummary" displayName="metadata.summary.medium" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="Value" displayName="metadata.summary.medium.value" xsi:type="stringVariableType" longFormat="true" />
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
							<variable name="cast" displayName="metadata.summary.cast" xsi:type="booleanVariableType" attribute="true" />
						</variable>
						<variable name="DisplaySummary" displayName="metadata.summary.long" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="Value" displayName="metadata.summary.long.value" xsi:type="stringVariableType" longFormat="true" />
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
							<variable name="cast" displayName="metadata.summary.cast" xsi:type="booleanVariableType" attribute="true" />
						</variable>
						<variable name="Components" displayName="metadata.summary.components" xsi:type="stringVariableType" />
						<variable name="Hierarchy" displayName="metadata.summary.hierarchy" xsi:type="stringVariableType" />
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
					</variable>
					
					<!-- Title -->
					<variable name="Title" displayName="metadata.title" xsi:type="complexVariableType">
						<variable name="OriginalTitle" displayName="metadata.title.original" xsi:type="complexVariableType">
							<variable name="Value" displayName="metadata.title.original.value" xsi:type="stringVariableType" />
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
							<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
						</variable>
						<variable name="DisplayTitle" displayName="metadata.title.display" xsi:type="complexVariableType">
							<variable name="Value" displayName="metadata.title.display.value" xsi:type="stringVariableType" />
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
							<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
						</variable>
						<variable name="SortTitle" displayName="metadata.title.sort" xsi:type="complexVariableType">
							<variable name="Value" displayName="metadata.title.sort.value" xsi:type="stringVariableType" />
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
							<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
						</variable>
						<variable name="ShortTitle" displayName="metadata.title.short" xsi:type="complexVariableType">
							<variable name="Value" displayName="metadata.title.short.value" xsi:type="stringVariableType" />
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
							<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
						</variable>
						<variable name="FeatureTitle" displayName="metadata.title.feature" xsi:type="complexVariableType">
							<variable name="Value" displayName="metadata.title.feature.value" xsi:type="stringVariableType" />
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
							<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
						</variable>
					</variable>					

					<!-- TSTV -->
					<variable name="TSTV" displayName="metadata.tstv" xsi:type="complexVariableType">
						<variable name="ChannelId" displayName="metadata.tstv.channelid" xsi:type="stringVariableType" />
						<variable name="EndTime" displayName="metadata.tstv.endtime" xsi:type="dateVariableType" />
						<variable name="RecordPriority" displayName="metadata.tstv.recordpriority" xsi:type="integerVariableType" />
						<variable name="ProgramName" displayName="metadata.tstv.programname" xsi:type="stringVariableType" />
						<variable name="ProgramId" displayName="metadata.tstv.programid" xsi:type="stringVariableType" />
						<variable name="Repeat" displayName="metadata.tstv.repeat" xsi:type="booleanVariableType" />
						<variable name="PlaybackWindows" displayName="metadata.tstv.playbackwindows" xsi:type="stringVariableType" />
						<variable name="MaxCopies" displayName="metadata.tstv.maxcopies" xsi:type="integerVariableType" />
						<variable name="DeleteTime" displayName="metadata.tstv.deletetime" xsi:type="dateVariableType" />
						<variable name="RefCount" displayName="metadata.tstv.refcount" xsi:type="integerVariableType" />
						<variable name="CatalogEntry" displayName="metadata.tstv.catalogentry" xsi:type="booleanVariableType" />
						<variable name="PurgeTime" displayName="metadata.tstv.purgetime" xsi:type="dateVariableType" />
						<variable name="ContentType" displayName="metadata.tstv.contenttype" xsi:type="stringVariableType" />
					</variable>

					<!-- TVId -->
					<variable name="TvId" displayName="metadata.tvId" xsi:type="complexVariableType">
						<variable name="Authority" displayName="metadata.tvId.authority" xsi:type="stringVariableType" />
						<variable name="ProgramId" displayName="metadata.tvId.programId" xsi:type="stringVariableType" />
						<variable name="StationId" displayName="metadata.tvId.stationId" xsi:type="integerVariableType" />
						<variable name="SeriesId" displayName="metadata.tvId.seriesId" xsi:type="stringVariableType" />
						<variable name="Network" displayName="metadata.tvId.network" xsi:type="stringVariableType" />
						<variable name="CallSign" displayName="metadata.tvId.callSign" xsi:type="stringVariableType" />
						<variable name="LiveServiceId" displayName="metadata.tvId.liveServiceId" xsi:type="stringVariableType" />
						<variable name="ProgramNumber" displayName="metadata.tvId.programNumber" xsi:type="stringVariableType" />
						<variable name="EpisodeSeasonNumber" displayName="metadata.tvId.episodeSeasonNumber" xsi:type="stringVariableType" />
						<variable name="Showtime" displayName="metadata.tvId.showtime" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="OriginalAirDate" displayName="metadata.tvId.showtime.originalAirDate" xsi:type="dateVariableType" />
							<variable name="StartTimeInUtc" displayName="metadata.tvId.showtime.startTimeInUTC" xsi:type="dateVariableType" />
						</variable>
					</variable>
					
					<!-- Version -->
					<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
						<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
						<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
						<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
					</variable>
					
					<!-- Categories -->
					<variable name="Categories" displayName="metadata.categories" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Category" displayName="metadata.category" xsi:type="complexVariableType" multiValue="true" >
							<variable name="Text" displayName="metadata.category.text" xsi:type="stringVariableType">
								<options anyValueAllowed="true">
									<optionProvider>com.ericsson.cms.categorymgmt.server.CategoryOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="Domain" displayName="metadata.category.domain" xsi:type="stringVariableType"/>
							<variable name="Scheme" displayName="metadata.category.scheme" xsi:type="stringVariableType"/>
						</variable>
					</variable>
					
					<!-- Chapters -->
					<variable name="Chapters" displayName="metadata.chapters" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Chapter" displayName="metadata.chapter" xsi:type="stringVariableType" multiValue="true"/>
					</variable>
					
					<!-- Sources -->
					<variable name="Sources" displayName="metadata.source" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Source" displayName="metadata.source" xsi:type="complexVariableType" multiValue="true">
							<variable name="Role" displayName="metadata.source.role" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="Name" displayName="metadata.source.role.name" xsi:type="stringVariableType">
									<options>
										<option name="metadata.source.role.name.optionName.actor">ACTOR</option>
										<option name="metadata.source.role.name.optionName.author">AUTHOR</option>
										<option name="metadata.source.role.name.optionName.creator">CREATOR</option>
										<option name="metadata.source.role.name.optionName.director">DIRECTOR</option>
										<option name="metadata.source.role.name.optionName.executiveproducer">EXECUTIVEPRODUCER</option>
										<option name="metadata.source.role.name.optionName.host">HOST</option>
										<option name="metadata.source.role.name.optionName.gueststar">GUESTSTAR</option>
										<option name="metadata.source.role.name.optionName.organization">ORGANIZATION</option>
										<option name="metadata.source.role.name.optionName.producer">PRODUCER</option>
										<option name="metadata.source.role.name.optionName.publisher">PUBLISHER</option>
										<option name="metadata.source.role.name.optionName.writer">WRITER</option>
									</options>
								</variable>
								<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
									<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
									<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
									<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
									<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
									<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
									<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
									<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>
								<variable name="value" displayName="metadata.source.role.value" xsi:type="stringVariableType" attribute="true" />
							</variable>
							<variable name="Contact" displayName="metadata.contact" xsi:type="complexVariableType">
								<variable name="FirstName" displayName="metadata.contact.firstName" xsi:type="stringVariableType" />
								<variable name="LastName" displayName="metadata.contact.lastName" xsi:type="stringVariableType" />
								<variable name="MiddleName" displayName="metadata.contact.middleName" xsi:type="stringVariableType" />
								<variable name="Email" displayName="metadata.contact.email" xsi:type="stringVariableType" />
								<variable name="Address" displayName="metadata.address" xsi:type="complexVariableType">
									<variable name="Line1" displayName="metadata.address.line1" xsi:type="stringVariableType" />
									<variable name="Line2" displayName="metadata.address.line2" xsi:type="stringVariableType" />
									<variable name="Zip" displayName="metadata.address.zip" xsi:type="stringVariableType" />
									<variable name="Place" displayName="metadata.place" xsi:type="complexVariableType" showCollapsed="true" >
										<variable name="Region" displayName="metadata.place.region" xsi:type="stringVariableType" />
										<variable name="Country" displayName="metadata.place.country" xsi:type="stringVariableType" />
										<variable name="Coordiantes" displayName="metadata.place.coordinates" xsi:type="stringVariableType" />
									</variable>
								</variable>
								<variable name="DisplayName" displayName="metadata.contact.displayName" xsi:type="stringVariableType" />
							</variable>
							<variable name="CharacterName" displayName="metadata.source.CharacterName" xsi:type="stringVariableType" />
							<variable name="Popularity" displayName="metadata.source.Popularity" xsi:type="integerVariableType" />
						</variable>
					</variable>
					
					<!-- Genres -->
					<variable name="Genres" displayName="metadata.genres" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Genre" displayName="metadata.genre" xsi:type="complexVariableType" multiValue="true" >
							<variable name="Value" displayName="metadata.genre.value" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.GenreOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="Order" displayName="metadata.genre.order" xsi:type="integerVariableType"/>
						</variable>
					</variable>

					<!-- Custom Fields -->
					<variable name="CustomFields" displayName="metadata.customFields" xsi:type="complexVariableType">
						<variable name="CustomField[@name=AzukiM1]" displayName="metadata.customFields.azukiM1" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM1.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM2]" displayName="metadata.customFields.azukiM2" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM2.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM3]" displayName="metadata.customFields.azukiM3" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM3.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM4]" displayName="metadata.customFields.azukiM4" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM4.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM5]" displayName="metadata.customFields.azukiM5" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM5.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM6]" displayName="metadata.customFields.azukiM6" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM6.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM7]" displayName="metadata.customFields.azukiM7" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM7.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM8]" displayName="metadata.customFields.azukiM8" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM8.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM9]" displayName="metadata.customFields.azukiM9" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM9.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM10]" displayName="metadata.customFields.azukiM10" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM10.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM11]" displayName="metadata.customFields.azukiM11" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM11.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM12]" displayName="metadata.customFields.azukiM12" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM12.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM13]" displayName="metadata.customFields.azukiM13" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM13.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM14]" displayName="metadata.customFields.azukiM14" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM14.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM15]" displayName="metadata.customFields.azukiM15" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM15.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM16]" displayName="metadata.customFields.azukiM16" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM16.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM17]" displayName="metadata.customFields.azukiM17" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM17.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM18]" displayName="metadata.customFields.azukiM18" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM18.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM19]" displayName="metadata.customFields.azukiM19" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM19.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM20]" displayName="metadata.customFields.azukiM20" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM20.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM21]" displayName="metadata.customFields.azukiM21" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM21.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM22]" displayName="metadata.customFields.azukiM22" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM22.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM23]" displayName="metadata.customFields.azukiM23" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM23.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM24]" displayName="metadata.customFields.azukiM24" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM24.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM25]" displayName="metadata.customFields.azukiM25" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM25.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM26]" displayName="metadata.customFields.azukiM26" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM26.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM27]" displayName="metadata.customFields.azukiM27" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM27.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM28]" displayName="metadata.customFields.azukiM28" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM28.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM29]" displayName="metadata.customFields.azukiM29" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM29.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM30]" displayName="metadata.customFields.azukiM30" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM30.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM31]" displayName="metadata.customFields.azukiM31" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM31.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=AzukiM32]" displayName="metadata.customFields.azukiM32" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.azukiM32.value" xsi:type="stringVariableType" attribute="true" />
						</variable>

					</variable>					
 
				</metadata>
			</title>

			<!-- 
				The Movie Title Item
			 -->
			<title>
				<name>MOVIE</name>
				<alias>movie.sectionName</alias>
				<metadata>
					
					<!-- ==================== Simple Fields ===================== -->
					
					<variable name="AssetClass" displayName="metadata.assetClass" xsi:type="stringVariableType">
						<options>
							<option name="metadata.assetClass.optionName.movie">movie</option>
						</options>
					</variable>
					<variable name="AssetName" displayName="metadata.assetName" xsi:type="stringVariableType"/>
					<variable name="DeviceRestrictionProfileId" displayName="metadata.deviceRestrictionProfileId" xsi:type="stringVariableType" />
					<variable name="Verb" displayName="metadata.verb" xsi:type="stringVariableType" />
					<variable name="PD" displayName="metadata.pd" xsi:type="booleanVariableType" />
					<variable name="PolicyProfileId" displayName="metadata.policyProfileId" xsi:type="stringVariableType" />
					<variable name="Profile" displayName="metadata.profile" xsi:type="stringVariableType" />

					<!-- ==================== Complex Fields ===================== -->
					<!-- ApplicationInfo -->					
					<variable name="ApplicationInfo" displayName="metadata.applicationInfo" xsi:type="complexVariableType" showCollapsed="true" >
						<variable name="Name" displayName="metadata.applicationInfo.name" xsi:type="stringVariableType">
							<options>
								<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.AppTypeOptionProvider</optionProvider>
							</options>	
						</variable>
					</variable>

					<!-- Content -->
					<variable name="Content" displayName="metadata.content" xsi:type="complexVariableType">
						<variable name="Expression" displayName="metadata.content.expression" xsi:type="stringVariableType"/>
						<variable name="Default" displayName="metadata.content.default" xsi:type="stringVariableType"/>
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="Size" displayName="metadata.size" xsi:type="complexVariableType" >
							<variable name="length" displayName="metadata.size.length" xsi:type="integerVariableType" />
							<variable name="height" displayName="metadata.size.height" xsi:type="integerVariableType" />
							<variable name="width" displayName="metadata.size.width" xsi:type="integerVariableType" />
						</variable>
						<variable name="Checksum" displayName="metadata.content.checkSum" xsi:type="stringVariableType" />
						<variable name="Medium" displayName="metadata.medium" xsi:type="complexVariableType" >
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="MIMEType" displayName="metadata.content.mimeType" xsi:type="stringVariableType"/>
						<variable name="Resolution" displayName="metadata.content.resolution" xsi:type="stringVariableType"/>
						<variable name="FrameRate" displayName="metadata.content.frameRate" xsi:type="stringVariableType"/>
						<variable name="Codec" displayName="metadata.content.codec" xsi:type="stringVariableType"/>
						<variable name="WasPitched" displayName="metadata.content.wasPitched" xsi:type="booleanVariableType"/>
						<variable name="LastPitchDate" displayName="metadata.content.lastPitchDate" xsi:type="dateVariableType"/>
						<variable name="PitchedFilename" displayName="metadata.content.pitchedFilename" xsi:type="stringVariableType"/>
						<variable name="SizeInBytes" displayName="metadata.content.sizeInBytes" xsi:type="integerVariableType"/>
						<variable name="Type" displayName="metadata.content.type" xsi:type="stringVariableType"/>
						<variable name="NetworkType" displayName="metadata.content.networkType" xsi:type="stringVariableType"/>
						<variable name="PlayReady" displayName="metadata.content.playReady" xsi:type="booleanVariableType"/>
						<variable name="WebInitiatorUrl" displayName="metadata.content.webInitiatorUri" xsi:type="stringVariableType"/>
						<variable name="LicenseServerProxyUrl" displayName="metadata.content.licenseServerProxyUrl" xsi:type="stringVariableType"/>
					</variable>
					
					<!-- Copyright -->
					<variable name="Copyright" displayName="metadata.copyright" xsi:type="complexVariableType">
						<variable name="Value" displayName="metadata.copyright.value" xsi:type="stringVariableType" />
						<variable name="CopyProtection" displayName="metadata.copyright.protection" xsi:type="booleanVariableType" />
						<variable name="CopyProtectionVerbose" displayName="metadata.copyright.protectionVerbose" xsi:type="booleanVariableType" />
						<variable name="AnalogProtectionSystem" displayName="metadata.copyright.analogProtectionSystem" xsi:type="integerVariableType" />
						<variable name="EncryptionModeIndicator" displayName="metadata.copyright.encryptionModeIndicator" xsi:type="integerVariableType" />
						<variable name="ConstrainedImageTrigger" displayName="metadata.copyright.constrainedImageTrigger" xsi:type="integerVariableType" />
						<variable name="MacroVisionLevel" displayName="metadata.copyright.macroVisionLevel" xsi:type="stringVariableType" />
						<variable name="CGMSA" displayName="metadata.copyright.cgmsa" xsi:type="integerVariableType" />
						<variable name="disableHDCP" displayName="metadata.copyright.disableHDCP" xsi:type="booleanVariableType" />
						<variable name="Provenance" displayName="metadata.copyright.provenance" xsi:type="stringVariableType" />
					</variable>

					<!-- Creation Info -->
					<variable name="CreationInfo" displayName="metadata.creationInfo" xsi:type="complexVariableType">
						<variable name="Title" displayName="metadata.title" xsi:type="complexVariableType">
							<variable name="OriginalTitle" displayName="metadata.title.original" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.original.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="DisplayTitle" displayName="metadata.title.display" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.display.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="SortTitle" displayName="metadata.title.sort" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.sort.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="ShortTitle" displayName="metadata.title.short" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.short.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="FeatureTitle" displayName="metadata.title.feature" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.feature.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
						</variable>					
						<variable name="Description" displayName="metadata.description" xsi:type="stringVariableType" longFormat="true" />
						<variable name="Sources" displayName="metadata.source" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="Source" displayName="metadata.source" xsi:type="complexVariableType" multiValue="true">
								<variable name="Role" displayName="metadata.source.role" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="Name" displayName="metadata.source.role.name" xsi:type="stringVariableType">
										<options>
											<option name="metadata.source.role.name.optionName.actor">ACTOR</option>
											<option name="metadata.source.role.name.optionName.author">AUTHOR</option>
											<option name="metadata.source.role.name.optionName.creator">CREATOR</option>
											<option name="metadata.source.role.name.optionName.director">DIRECTOR</option>
											<option name="metadata.source.role.name.optionName.executiveproducer">EXECUTIVEPRODUCER</option>
											<option name="metadata.source.role.name.optionName.host">HOST</option>
											<option name="metadata.source.role.name.optionName.gueststar">GUESTSTAR</option>
											<option name="metadata.source.role.name.optionName.organization">ORGANIZATION</option>
											<option name="metadata.source.role.name.optionName.producer">PRODUCER</option>
											<option name="metadata.source.role.name.optionName.publisher">PUBLISHER</option>
											<option name="metadata.source.role.name.optionName.writer">WRITER</option>
										</options>
									</variable>
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="value" displayName="metadata.source.role.value" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="Contact" displayName="metadata.contact" xsi:type="complexVariableType">
									<variable name="FirstName" displayName="metadata.contact.firstName" xsi:type="stringVariableType" />
									<variable name="LastName" displayName="metadata.contact.lastName" xsi:type="stringVariableType" />
									<variable name="MiddleName" displayName="metadata.contact.middleName" xsi:type="stringVariableType" />
									<variable name="Email" displayName="metadata.contact.email" xsi:type="stringVariableType" />
									<variable name="Address" displayName="metadata.address" xsi:type="complexVariableType">
										<variable name="Line1" displayName="metadata.address.line1" xsi:type="stringVariableType" />
										<variable name="Line2" displayName="metadata.address.line2" xsi:type="stringVariableType" />
										<variable name="Zip" displayName="metadata.address.zip" xsi:type="stringVariableType" />
										<variable name="Place" displayName="metadata.place" xsi:type="complexVariableType" showCollapsed="true" >
											<variable name="Region" displayName="metadata.place.region" xsi:type="stringVariableType" />
											<variable name="Country" displayName="metadata.place.country" xsi:type="stringVariableType" />
											<variable name="Coordiantes" displayName="metadata.place.coordinates" xsi:type="stringVariableType" />
										</variable>
									</variable>
									<variable name="DisplayName" displayName="metadata.contact.displayName" xsi:type="stringVariableType" />
								</variable>
								<variable name="CharacterName" displayName="metadata.source.CharacterName" xsi:type="stringVariableType" />
								<variable name="Popularity" displayName="metadata.source.Popularity" xsi:type="integerVariableType" />
							</variable>
						</variable>
						<variable name="CreateDate" displayName="metadata.creationInfo.createDate" xsi:type="dateVariableType" />
						<variable name="UpdateDate" displayName="metadata.creationInfo.updateDate" xsi:type="dateVariableType" />
						<variable name="Place" displayName="metadata.creationInfo.place" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="Region" displayName="metadata.creationInfo.place.region" xsi:type="stringVariableType" />
							<variable name="Country" displayName="metadata.creationInfo.place.country" xsi:type="stringVariableType" />
							<variable name="Coordiantes" displayName="metadata.creationInfo.place.coordinates" xsi:type="stringVariableType" />
						</variable>
						<variable name="Tool" displayName="metadata.tool" xsi:type="complexVariableType" >
							<variable name="Name" displayName="metadata.creationInfo.studio.name" xsi:type="stringVariableType" />
							<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
								<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
								<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
							</variable>
							<variable name="ToolSettings" displayName="metadata.tool.settings" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="ToolSetting" displayName="metadata.tool.setting" xsi:type="complexVariableType" multiValue="true">
									<variable name="Name" displayName="metadata.name" xsi:type="stringVariableType" />
									<variable name="Value" displayName="metadata.value" xsi:type="stringVariableType" />
								</variable>
							</variable>
						</variable>
						<variable name="PublicationDate" displayName="metadata.creationInfo.publicationDate" xsi:type="integerVariableType"  />
						<variable name="Studio" displayName="metadata.creationInfo.studio" xsi:type="complexVariableType" >
							<variable name="DisplayName" displayName="metadata.creationInfo.studio.displayName" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="Name" displayName="metadata.creationInfo.studio.name" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOrgNameOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="Code" displayName="metadata.creationInfo.studio.code" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOrgCodeOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="RoyaltyInfo" displayName="metadata.creationInfo.studio.royalty" xsi:type="complexVariableType" showCollapsed="true" >
								<variable name="RoyaltyPercent" displayName="metadata.creationInfo.studio.royalty.percent" xsi:type="floatVariableType"  />
								<variable name="RoyaltyMinimum" displayName="metadata.creationInfo.studio.royalty.minimum" xsi:type="floatVariableType"  />
								<variable name="RoyaltyFlatRate" displayName="metadata.creationInfo.studio.royalty.flatRate" xsi:type="floatVariableType"  />
							</variable>
						</variable>
					</variable>
					
					<!-- Description -->
					<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
						<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
						</variable>
					</variable>
		
					<!-- Duration -->
					<variable name="Duration" displayName="metadata.duration" xsi:type="complexVariableType">
						<variable name="DisplayDuration" displayName="metadata.duration.display" xsi:type="stringVariableType" />
						<variable name="StartOffset" displayName="metadata.duration.startOffset" xsi:type="timeVariableType" />
						<variable name="Duration" displayName="metadata.duration.value" xsi:type="timeVariableType" jobParameter="true" />
					</variable>
		
					<!-- Encryption -->
					<variable name="Encryption" displayName="metadata.encryption" xsi:type="complexVariableType" >
						<variable name="Asset" displayName="metadata.encryption.asset" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>						
						<variable name="Value" displayName="metadata.encryption.value" xsi:type="booleanVariableType" />
						<variable name="Algorithm" displayName="metadata.encryption.algorithm" xsi:type="stringVariableType" />
						<variable name="Date" displayName="metadata.encryption.date" xsi:type="dateVariableType" />
						<variable name="SystemInfo" displayName="metadata.encryption.systemInfo" xsi:type="stringVariableType" />
						<variable name="KeyBlock" displayName="metadata.encryption.keyBlock" xsi:type="stringVariableType" longFormat="true" />
						<variable name="Type" displayName="metadata.encryption.type" xsi:type="stringVariableType" />
						<variable name="Time" displayName="metadata.encryption.time" xsi:type="timeVariableType" />
						<variable name="EncryptionClass" displayName="metadata.encryption.class" xsi:type="stringVariableType" />					
					</variable>
		
					<!-- Identifier -->
					<variable name="Identifier" displayName="metadata.identifier" xsi:type="complexVariableType">
						<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
						<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
						<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" jobParameter="true" />
						<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
						<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
					</variable>					

					<!-- ProductInfo -->
					<variable name="ProductInfo" displayName="metadata.productInfo" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Name" displayName="metadata.productInfo.name" xsi:type="stringVariableType">
							<options>
								<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.ProductOptionProvider</optionProvider>
							</options>
						</variable>
					</variable>
					
					<!-- ProviderInfo -->
					<variable name="ProviderInfo" displayName="metadata.providerInfo" xsi:type="complexVariableType">
						<!-- Let's add it here, but it will be disabled in GUI. Users are not allowed to edit this value. -->
						<variable name="Name" displayName="metadata.providerInfo.name" xsi:type="stringVariableType" />
						<variable name="Identifier" displayName="metadata.providerId" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.providerId" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="ReferenceIdentifier" displayName="metadata.referenceIdentifier" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
					</variable>

					<!-- Derived -->
					<variable name="Derived" displayName="metadata.derived" xsi:type="complexVariableType">
						<variable name="SourceAssetId" displayName="metadata.derived.sourceassetid" xsi:type="stringVariableType" />
						<variable name="SourceProviderId" displayName="metadata.derived.sourceproviderid" xsi:type="stringVariableType" />
					</variable>
					
					<!-- EquipCapabilityProfileList -->
					<variable name="EquipCapabilityProfileList" displayName="metadata.equipCapabilityProfileList" xsi:type="complexVariableType" showCollapsed="false">
						<variable name="EquipCapabilityProfile" displayName="metadata.equipCapabilityProfile" xsi:type="stringVariableType" multiValue="true" />
					</variable>

					<!-- Rating -->										
					<variable name="Rating" displayName="metadata.rating" xsi:type="complexVariableType">
						<variable name="RatingValues" displayName="metadata.rating" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="RatingValue" displayName="metadata.rating.value" xsi:type="complexVariableType" multiValue="true">
								<variable name="System" displayName="metadata.rating.system" xsi:type="stringVariableType">
									<options>
										<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.RatingSystemOptionProvider</optionProvider>
									</options>
								</variable>
								<variable name="Value" displayName="metadata.rating.value" xsi:type="stringVariableType">
									<options>
										<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.RatingOptionProvider</optionProvider>
									</options>
								</variable>
							</variable>
						</variable>
						<variable name="ContentAdvisories" displayName="metadata.rating.advisories" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="ContentAdvisory" displayName="metadata.rating.advisory" xsi:type="stringVariableType" multiValue="true">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.ContentAdvisoryOptionProvider</optionProvider>
								</options>
							</variable>
						</variable>
						<variable name="TargetAudiences" displayName="metadata.rating.audiences" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="TargetAudience" displayName="metadata.rating.audience" xsi:type="stringVariableType" multiValue="true"/>
						</variable>
						<variable name="MSORatings" displayName="metadata.rating.msos" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="MSORating" displayName="metadata.rating.mso" xsi:type="stringVariableType" multiValue="true"/>
						</variable>
						<variable name="Labels" displayName="metadata.rating.labels" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="Label" displayName="metadata.rating.label" xsi:type="stringVariableType" multiValue="true"/>
						</variable>
					</variable>

					<!-- Restriction -->
					<variable name="Restriction" displayName="metadata.restriction" xsi:type="complexVariableType">
						<variable name="Roll" displayName="metadata.restriction.roll" xsi:type="stringVariableType" />
						<variable name="Content" displayName="metadata.restriction.content" xsi:type="stringVariableType" />
					</variable>

					<!-- Rights -->
					<variable name="Rights" displayName="metadata.rights" xsi:type="complexVariableType">
						<variable name="Id" displayName="metadata.rights.id" xsi:type="stringVariableType" />
						<variable name="LicensingWindowStart" displayName="metadata.rights.licensingWindowStart" xsi:type="dateVariableType" jobParameter="true" />
						<variable name="LicensingWindowEnd" displayName="metadata.rights.licensingWindowEnd" xsi:type="dateVariableType" jobParameter="true" />
						<variable name="AvailabilityWindowStart" displayName="metadata.rights.availabilityWindowStart" xsi:type="dateVariableType" jobParameter="true" />
						<variable name="AvailabilityWindowEnd" displayName="metadata.rights.availabilityWindowEnd" xsi:type="dateVariableType" jobParameter="true" />
						<variable name="NewReleaseWindow" displayName="metadata.rights.newReleaseWindow" xsi:type="integerVariableType"  />
						<variable name="MaxPlayCount" displayName="metadata.rights.maxPlayCount" xsi:type="integerVariableType" />
						<variable name="ViewLimits" displayName="metadata.rights.maxViewLimit" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="ViewLimit" displayName="metadata.rights.maxViewLimit" xsi:type="stringVariableType" multiValue="true" />
						</variable>
						<variable name="MaxViewingLimit" displayName="metadata.rights.maxViewingLimit" xsi:type="integerVariableType"  />
						<variable name="MinViewingLimit" displayName="metadata.rights.maxViewingLimit" xsi:type="integerVariableType"  />
						<variable name="MaxView" displayName="metadata.rights.maxView" xsi:type="stringVariableType" />
						<variable name="Contract" displayName="metadata.rights.contract" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="Id" displayName="metadata.identifier" xsi:type="complexVariableType">
								<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
								<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
								<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
								<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
								<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
								<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
									<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
									<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
									<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
									<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
									<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
									<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
									<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>							
							<variable name="Name" displayName="metadata.rights.contract.name" xsi:type="stringVariableType" />
						</variable>
						<variable name="PreviewPeriod" displayName="metadata.rights.previewPeriod" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="DisplayDuration" displayName="metadata.duration.display" xsi:type="stringVariableType" />
							<variable name="StartOffset" displayName="metadata.duration.startOffset" xsi:type="timeVariableType" />
							<variable name="Duration" displayName="metadata.duration.value" xsi:type="timeVariableType" jobParameter="true" />
						</variable>
						<variable name="DisplayAsLastChance" displayName="metadata.rights.displayAsLastChance" xsi:type="integerVariableType" />
						<variable name="HomeVideoWindow" displayName="metadata.rights.homeVideoWindow" xsi:type="integerVariableType"  />
						<variable name="Value" displayName="metadata.rights.value" xsi:type="stringVariableType"  />
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="ViewingCanBeResumed" displayName="metadata.rights.viewingCanBeResumed" xsi:type="booleanVariableType"/>
						<variable name="DaysToLastChance" displayName="metadata.rights.daysToLastChance" xsi:type="integerVariableType"/>
					</variable>

					<!-- Version -->
					<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
						<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
						<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
						<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
					</variable>

					<!-- Video -->
					<variable name="Video" displayName="metadata.video" xsi:type="complexVariableType">
						<variable name="AspectRatio" displayName="metadata.video.aspectRatio" xsi:type="stringVariableType" />
						<variable name="ScreenFormat" displayName="metadata.video.screenFormat" xsi:type="stringVariableType" />
						<variable name="HDContent" displayName="metadata.video.hdContent" xsi:type="booleanVariableType" >
							<options>
								<option name="metadata.booleanOptionName.true">true</option>
								<option name="metadata.booleanOptionName.false">false</option>
							</options>
						</variable>
						<variable name="BitRate" displayName="metadata.video.bitrate" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="value" displayName="metadata.video.bitrate.value" xsi:type="integerVariableType" attribute="true" />
						</variable>
						<variable name="AudioInfos" displayName="metadata.audioInfo" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="AudioInfo" displayName="metadata.audioInfo" xsi:type="complexVariableType" multiValue="true">
								<variable name="ChannelCount" displayName="metadata.audioInfo.channelCount" xsi:type="integerVariableType" />
								<variable name="Preffered" displayName="metadata.audioInfo.preffered" xsi:type="stringVariableType" />
								<variable name="Value" displayName="metadata.type" xsi:type="stringVariableType" />
								<variable name="DefaultTrack" displayName="metadata.audioInfo.defaultTrack" xsi:type="booleanVariableType" />
								<variable name="ContainsDesc" displayName="metadata.audioInfo.containsDesc" xsi:type="booleanVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="PID" displayName="metadata.audioInfo.pid" xsi:type="stringVariableType" />
								<variable name="Codec" displayName="metadata.audioInfo.codec" xsi:type="stringVariableType" />
							</variable>
						</variable>
						<variable name="PrivatePid" displayName="metadata.video.privatePid" xsi:type="stringVariableType" />
						<variable name="PreEncryptionInfo" displayName="metadata.preEncryptionInfo" xsi:type="complexVariableType">
							<variable name="DerivedFrom" displayName="metadata.preEncryptionInfo.derivedFrom" xsi:type="complexVariableType" >
								<variable name="ProviderInfo" displayName="metadata.providerInfo" xsi:type="complexVariableType">
									<!-- Let's add it here, but it will be disabled in GUI. Users are not allowed to edit this value. -->
									<variable name="Name" displayName="metadata.providerInfo.name" xsi:type="stringVariableType" />
									<variable name="Identifier" displayName="metadata.providerId" xsi:type="complexVariableType">
										<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
										<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
										<variable name="Id" displayName="metadata.providerId" xsi:type="stringVariableType" />
										<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
										<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
										<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
											<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
											<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
											<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
											<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
											<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
											<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
											<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
											<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
												<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
												<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
													<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
												</variable>
											</variable>
										</variable>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="ReferenceIdentifier" displayName="metadata.referenceIdentifier" xsi:type="complexVariableType">
										<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
										<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
										<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
										<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
										<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
										<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
											<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
											<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
											<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
											<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
											<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
											<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
											<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
											<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
												<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
												<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
													<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
												</variable>
											</variable>
										</variable>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
								</variable>
								<variable name="AssetId" displayName="metadata.identifier" xsi:type="complexVariableType">
									<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
									<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
									<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
									<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
									<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>					
								<variable name="Start" displayName="metadata.start" xsi:type="timeVariableType" />
								<variable name="End" displayName="metadata.end" xsi:type="timeVariableType" />
								<variable name="AmsValidate" displayName="metadata.image.amsValidate" xsi:type="booleanVariableType" />
								<variable name="ResumeViewAllowed" displayName="metadata.image.resumeViewAllowed" xsi:type="booleanVariableType" />
								<variable name="TrickModeRestrictions" displayName="metadata.trickModeRestrictions" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="TrickModeRestriction" displayName="metadata.trickModeRestrictions" xsi:type="stringVariableType" multiValue="true"/>
								</variable>
							</variable>
							<variable name="EncryptionDate" displayName="metadata.preEncryptionInfo.encryptionDate" xsi:type="dateVariableType" />
							<variable name="FormatAuthority" displayName="metadata.preEncryptionInfo.formatAuthority" xsi:type="stringVariableType" />
							<variable name="TargetVersion" displayName="metadata.preEncryptionInfo.targetVersion" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
								<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
								<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
							</variable>
							<variable name="EncryptionInfo" displayName="metadata.encryption" xsi:type="complexVariableType" >
								<variable name="Asset" displayName="metadata.encryption.asset" xsi:type="complexVariableType">
									<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
									<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
									<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
									<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
									<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>						
								<variable name="Value" displayName="metadata.encryption.value" xsi:type="booleanVariableType" />
								<variable name="Algorithm" displayName="metadata.encryption.algorithm" xsi:type="stringVariableType" />
								<variable name="Date" displayName="metadata.encryption.date" xsi:type="dateVariableType" />
								<variable name="SystemInfo" displayName="metadata.encryption.systemInfo" xsi:type="stringVariableType" />
								<variable name="KeyBlock" displayName="metadata.encryption.keyBlock" xsi:type="stringVariableType" longFormat="true" />
								<variable name="Type" displayName="metadata.encryption.type" xsi:type="stringVariableType" />
								<variable name="Time" displayName="metadata.encryption.time" xsi:type="timeVariableType" />
								<variable name="EncryptionClass" displayName="metadata.encryption.class" xsi:type="stringVariableType" />					
							</variable>
						</variable>
						<variable name="StreamFormat" displayName="metadata.video.streamFormat" xsi:type="stringVariableType" />
						<variable name="ThreeDContent" displayName="metadata.video.3dContent" xsi:type="booleanVariableType" />
						<variable name="AVContainer" displayName="metadata.video.avContainer" xsi:type="stringVariableType" />
						<variable name="AlternateBitRateResolutionList" displayName="metadata.video.alternateBitRateResolutionList" xsi:type="complexVariableType" showCollapsed="false">
							<variable name="AlternateBitRateResolution" displayName="metadata.video.alternateBitRateResolution" xsi:type="stringVariableType" multiValue="true"/>
						</variable>	
					</variable>
			
					<!-- Trick Modes Restrictions -->
					<variable name="TrickModeRestrictions" displayName="metadata.trickModeRestrictions" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="TrickModeRestriction" displayName="metadata.trickModeRestrictions.trickModeRestriction" xsi:type="stringVariableType" multiValue="true" />
					</variable>
			
					<!-- Avails -->
					<variable name="Avails" displayName="metadata.avails" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Avail" displayName="metadata.avail" xsi:type="complexVariableType" multiValue="true">
							<variable name="TimeCodeOne" displayName="metadata.avail.timeCodeOne" xsi:type="timeVariableType" />
							<variable name="TimeCodeTwo" displayName="metadata.avail.timeCodeTwo" xsi:type="timeVariableType" />
							<variable name="TimeCodeThree" displayName="metadata.avail.timeCodeThree" xsi:type="timeVariableType" />
							<variable name="TimeCodeFour" displayName="metadata.avail.timeCodeFour" xsi:type="timeVariableType" />
							<variable name="Id" displayName="metadata.avail.id" xsi:type="stringVariableType" />
							<variable name="Scope" displayName="metadata.avail.scope" xsi:type="stringVariableType" />
							<variable name="Type" displayName="metadata.avail.type" xsi:type="stringVariableType" />
							<variable name="Position" displayName="metadata.avail.position" xsi:type="stringVariableType" />
						</variable>
					</variable>

					<!-- Categories -->
					<variable name="Categories" displayName="metadata.categories" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Category" displayName="metadata.category" xsi:type="complexVariableType" multiValue="true" >
							<variable name="Text" displayName="metadata.category.text" xsi:type="stringVariableType">
								<options anyValueAllowed="true">
									<optionProvider>com.ericsson.cms.categorymgmt.server.CategoryOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="Domain" displayName="metadata.category.domain" xsi:type="stringVariableType"/>
							<variable name="Scheme" displayName="metadata.category.scheme" xsi:type="stringVariableType"/>
						</variable>
					</variable>

					<!-- Languages -->
					<variable name="Languages" displayName="metadata.Languages" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true" multiValue="true" >
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true"/>
						</variable>
					</variable>

					<!-- Subtitle Languages -->
					<variable name="SubTitleLanguages" displayName="metadata.subtitleLanguages" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="SubTitleLanguage" displayName="metadata.subtitleLanguage" xsi:type="complexVariableType" showCollapsed="true" multiValue="true" >
							<variable name="value" displayName="metadata.subtitleLanguage.name" xsi:type="stringVariableType" attribute="true"/>
						</variable>
					</variable>
					
					<!-- Dubbed Languages -->
					<variable name="DubbedLanguages" displayName="metadata.dubbedLanguages" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="DubbedLanguage" displayName="metadata.dubbedLanguage" xsi:type="complexVariableType" showCollapsed="true" multiValue="true" >
							<variable name="value" displayName="metadata.dubbedLanguage.name" xsi:type="stringVariableType" attribute="true"/>
						</variable>
					</variable>

					<!-- Custom Fields -->
					<variable name="CustomFields" displayName="metadata.customFields" xsi:type="complexVariableType">
						<variable name="CustomField[@name=Reencode]" displayName="metadata.customFields.reencode" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.reencode.value" xsi:type="booleanVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=ReencodeProfile]" displayName="metadata.customFields.reencodeProfile" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.reencodeProfile.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=Transcode]" displayName="metadata.customFields.transcode" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.transcode.value" xsi:type="booleanVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=TranscodeProfile]" displayName="metadata.customFields.transcodeProfile" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.transcodeProfile.value" xsi:type="stringVariableType" attribute="true" />
						</variable>

						<variable name="CustomField[@name=TranscodeFormat]" displayName="metadata.customFields.transcodeFormat" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.transcodeFormat.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
					</variable>					
				</metadata>

				<!-- The Movie section children -->
				<childTitles>
					<!-- 
						The Logical Clip Title Item
					 -->
					<title>
						<name>LOGICALCLIP</name>
						<alias>logicalclip.sectionName</alias>
						<metadata>
							<!-- ========================== Simple Fields ======================== -->
							<variable name="AssetClass" displayName="metadata.assetClass" xsi:type="stringVariableType">
								<options>
									<option name="metadata.assetClass.optionName.logicalClip">logical clip</option>
								</options>
							</variable>
							<variable name="AssetName" displayName="metadata.assetName" xsi:type="stringVariableType"/>
							<variable name="Verb" displayName="metadata.verb" xsi:type="stringVariableType" />
							
							<!-- ========================== Complex Fields ======================== -->
							
							<!-- ApplicationInfo -->					
							<variable name="ApplicationInfo" displayName="metadata.applicationInfo" xsi:type="complexVariableType" showCollapsed="true" >
								<variable name="Name" displayName="metadata.applicationInfo.name" xsi:type="stringVariableType">
									<options>
										<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.AppTypeOptionProvider</optionProvider>
									</options>	
								</variable>
							</variable>
				
							<!-- Content -->
							<variable name="Content" displayName="metadata.content" xsi:type="complexVariableType">
								<variable name="Expression" displayName="metadata.content.expression" xsi:type="stringVariableType"/>
								<variable name="Default" displayName="metadata.content.default" xsi:type="stringVariableType"/>
								<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
									<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
									<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
									<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
									<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
									<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
									<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
									<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
								<variable name="Size" displayName="metadata.size" xsi:type="complexVariableType" >
									<variable name="length" displayName="metadata.size.length" xsi:type="integerVariableType" />
									<variable name="height" displayName="metadata.size.height" xsi:type="integerVariableType" />
									<variable name="width" displayName="metadata.size.width" xsi:type="integerVariableType" />
								</variable>
								<variable name="Checksum" displayName="metadata.content.checkSum" xsi:type="stringVariableType" />
								<variable name="Medium" displayName="metadata.medium" xsi:type="complexVariableType" >
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
								<variable name="MIMEType" displayName="metadata.content.mimeType" xsi:type="stringVariableType"/>
								<variable name="Resolution" displayName="metadata.content.resolution" xsi:type="stringVariableType"/>
								<variable name="FrameRate" displayName="metadata.content.frameRate" xsi:type="stringVariableType"/>
								<variable name="Codec" displayName="metadata.content.codec" xsi:type="stringVariableType"/>
								<variable name="WasPitched" displayName="metadata.content.wasPitched" xsi:type="booleanVariableType"/>
								<variable name="LastPitchDate" displayName="metadata.content.lastPitchDate" xsi:type="dateVariableType"/>
								<variable name="PitchedFilename" displayName="metadata.content.pitchedFilename" xsi:type="stringVariableType"/>
								<variable name="SizeInBytes" displayName="metadata.content.sizeInBytes" xsi:type="integerVariableType"/>
								<variable name="Type" displayName="metadata.content.type" xsi:type="stringVariableType"/>
								<variable name="NetworkType" displayName="metadata.content.networkType" xsi:type="stringVariableType"/>
								<variable name="PlayReady" displayName="metadata.content.playReady" xsi:type="booleanVariableType"/>
								<variable name="WebInitiatorUrl" displayName="metadata.content.webInitiatorUri" xsi:type="stringVariableType"/>
								<variable name="LicenseServerProxyUrl" displayName="metadata.content.licenseServerProxyUrl" xsi:type="stringVariableType"/>
							</variable>
				
							<!-- Creation Info -->
							<variable name="CreationInfo" displayName="metadata.creationInfo" xsi:type="complexVariableType">
								<variable name="Title" displayName="metadata.title" xsi:type="complexVariableType">
									<variable name="OriginalTitle" displayName="metadata.title.original" xsi:type="complexVariableType">
										<variable name="Value" displayName="metadata.title.original.value" xsi:type="stringVariableType" />
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
										<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
									</variable>
									<variable name="DisplayTitle" displayName="metadata.title.display" xsi:type="complexVariableType">
										<variable name="Value" displayName="metadata.title.display.value" xsi:type="stringVariableType" />
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
										<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
									</variable>
									<variable name="SortTitle" displayName="metadata.title.sort" xsi:type="complexVariableType">
										<variable name="Value" displayName="metadata.title.sort.value" xsi:type="stringVariableType" />
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
										<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
									</variable>
									<variable name="ShortTitle" displayName="metadata.title.short" xsi:type="complexVariableType">
										<variable name="Value" displayName="metadata.title.short.value" xsi:type="stringVariableType" />
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
										<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
									</variable>
									<variable name="FeatureTitle" displayName="metadata.title.feature" xsi:type="complexVariableType">
										<variable name="Value" displayName="metadata.title.feature.value" xsi:type="stringVariableType" />
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
										<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
									</variable>
								</variable>					
								<variable name="Description" displayName="metadata.description" xsi:type="stringVariableType" longFormat="true" />
								<variable name="Sources" displayName="metadata.source" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="Source" displayName="metadata.source" xsi:type="complexVariableType" multiValue="true">
										<variable name="Role" displayName="metadata.source.role" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="Name" displayName="metadata.source.role.name" xsi:type="stringVariableType">
												<options>
													<option name="metadata.source.role.name.optionName.actor">ACTOR</option>
													<option name="metadata.source.role.name.optionName.author">AUTHOR</option>
													<option name="metadata.source.role.name.optionName.creator">CREATOR</option>
													<option name="metadata.source.role.name.optionName.director">DIRECTOR</option>
													<option name="metadata.source.role.name.optionName.executiveproducer">EXECUTIVEPRODUCER</option>
													<option name="metadata.source.role.name.optionName.host">HOST</option>
													<option name="metadata.source.role.name.optionName.gueststar">GUESTSTAR</option>
													<option name="metadata.source.role.name.optionName.organization">ORGANIZATION</option>
													<option name="metadata.source.role.name.optionName.producer">PRODUCER</option>
													<option name="metadata.source.role.name.optionName.publisher">PUBLISHER</option>
													<option name="metadata.source.role.name.optionName.writer">WRITER</option>
												</options>
											</variable>
											<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
												<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
												<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
												<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
												<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
												<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
												<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
												<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
												<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
													<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
													<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
														<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
													</variable>
												</variable>
											</variable>
											<variable name="value" displayName="metadata.source.role.value" xsi:type="stringVariableType" attribute="true" />
										</variable>
										<variable name="Contact" displayName="metadata.contact" xsi:type="complexVariableType">
											<variable name="FirstName" displayName="metadata.contact.firstName" xsi:type="stringVariableType" />
											<variable name="LastName" displayName="metadata.contact.lastName" xsi:type="stringVariableType" />
											<variable name="MiddleName" displayName="metadata.contact.middleName" xsi:type="stringVariableType" />
											<variable name="Email" displayName="metadata.contact.email" xsi:type="stringVariableType" />
											<variable name="Address" displayName="metadata.address" xsi:type="complexVariableType">
												<variable name="Line1" displayName="metadata.address.line1" xsi:type="stringVariableType" />
												<variable name="Line2" displayName="metadata.address.line2" xsi:type="stringVariableType" />
												<variable name="Zip" displayName="metadata.address.zip" xsi:type="stringVariableType" />
												<variable name="Place" displayName="metadata.place" xsi:type="complexVariableType" showCollapsed="true" >
													<variable name="Region" displayName="metadata.place.region" xsi:type="stringVariableType" />
													<variable name="Country" displayName="metadata.place.country" xsi:type="stringVariableType" />
													<variable name="Coordiantes" displayName="metadata.place.coordinates" xsi:type="stringVariableType" />
												</variable>
											</variable>
											<variable name="DisplayName" displayName="metadata.contact.displayName" xsi:type="stringVariableType" />
										</variable>
										<variable name="CharacterName" displayName="metadata.source.CharacterName" xsi:type="stringVariableType" />
										<variable name="Popularity" displayName="metadata.source.Popularity" xsi:type="integerVariableType" />
									</variable>
								</variable>
								<variable name="CreateDate" displayName="metadata.creationInfo.createDate" xsi:type="dateVariableType" />
								<variable name="UpdateDate" displayName="metadata.creationInfo.updateDate" xsi:type="dateVariableType" />
								<variable name="Place" displayName="metadata.creationInfo.place" xsi:type="complexVariableType" showCollapsed="true" >
									<variable name="Region" displayName="metadata.creationInfo.place.region" xsi:type="stringVariableType" />
									<variable name="Country" displayName="metadata.creationInfo.place.country" xsi:type="stringVariableType" />
									<variable name="Coordiantes" displayName="metadata.creationInfo.place.coordinates" xsi:type="stringVariableType" />
								</variable>
								<variable name="Tool" displayName="metadata.tool" xsi:type="complexVariableType" >
									<variable name="Name" displayName="metadata.creationInfo.studio.name" xsi:type="stringVariableType" />
									<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
										<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
										<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
										<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
									</variable>
									<variable name="ToolSettings" displayName="metadata.tool.settings" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="ToolSetting" displayName="metadata.tool.setting" xsi:type="complexVariableType" multiValue="true">
											<variable name="Name" displayName="metadata.name" xsi:type="stringVariableType" />
											<variable name="Value" displayName="metadata.value" xsi:type="stringVariableType" />
										</variable>
									</variable>
								</variable>
								<variable name="PublicationDate" displayName="metadata.creationInfo.publicationDate" xsi:type="integerVariableType"  />
								<variable name="Studio" displayName="metadata.creationInfo.studio" xsi:type="complexVariableType" >
									<variable name="DisplayName" displayName="metadata.creationInfo.studio.displayName" xsi:type="stringVariableType">
										<options>
											<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOptionProvider</optionProvider>
										</options>
									</variable>
									<variable name="Name" displayName="metadata.creationInfo.studio.name" xsi:type="stringVariableType">
										<options>
											<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOrgNameOptionProvider</optionProvider>
										</options>
									</variable>
									<variable name="Code" displayName="metadata.creationInfo.studio.code" xsi:type="stringVariableType">
										<options>
											<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOrgCodeOptionProvider</optionProvider>
										</options>
									</variable>
									<variable name="RoyaltyInfo" displayName="metadata.creationInfo.studio.royalty" xsi:type="complexVariableType" showCollapsed="true" >
										<variable name="RoyaltyPercent" displayName="metadata.creationInfo.studio.royalty.percent" xsi:type="floatVariableType"  />
										<variable name="RoyaltyMinimum" displayName="metadata.creationInfo.studio.royalty.minimum" xsi:type="floatVariableType"  />
										<variable name="RoyaltyFlatRate" displayName="metadata.creationInfo.studio.royalty.flatRate" xsi:type="floatVariableType"  />
									</variable>
								</variable>
							</variable>
							
							<!-- Description -->
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
				
							<!-- Identifier -->
							<variable name="Identifier" displayName="metadata.identifier" xsi:type="complexVariableType">
								<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
								<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
								<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
								<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
								<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
								<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
									<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
									<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
									<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
									<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
									<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
									<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
									<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>					
							
							<!-- Mark -->
							<variable name="Mark" displayName="metadata.mark" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="In" displayName="metadata.mark.in" xsi:type="timeVariableType"/>
								<variable name="Out" displayName="metadata.mark.out" xsi:type="timeVariableType"/>
							</variable>
							
							<!-- ProductInfo -->
							<variable name="ProductInfo" displayName="metadata.productInfo" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="Name" displayName="metadata.productInfo.name" xsi:type="stringVariableType">
									<options>
										<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.ProductOptionProvider</optionProvider>
									</options>
								</variable>
							</variable>
							
							<!-- ProviderInfo -->
							<variable name="ProviderInfo" displayName="metadata.providerInfo" xsi:type="complexVariableType">
								<!-- Let's add it here, but it will be disabled in GUI. Users are not allowed to edit this value. -->
								<variable name="Name" displayName="metadata.providerInfo.name" xsi:type="stringVariableType" />
								<variable name="Identifier" displayName="metadata.providerId" xsi:type="complexVariableType">
									<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
									<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
									<variable name="Id" displayName="metadata.providerId" xsi:type="stringVariableType" />
									<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
									<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>
								<variable name="ReferenceIdentifier" displayName="metadata.referenceIdentifier" xsi:type="complexVariableType">
									<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
									<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
									<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
									<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
									<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>
							</variable>
		
							<!-- Derived -->
							<variable name="Derived" displayName="metadata.derived" xsi:type="complexVariableType">
								<variable name="SourceAssetId" displayName="metadata.derived.sourceassetid" xsi:type="stringVariableType" />
								<variable name="SourceProviderId" displayName="metadata.derived.sourceproviderid" xsi:type="stringVariableType" />
							</variable>

							<!-- Title -->
							<variable name="Title" displayName="metadata.title" xsi:type="complexVariableType">
								<variable name="OriginalTitle" displayName="metadata.title.original" xsi:type="complexVariableType">
									<variable name="Value" displayName="metadata.title.original.value" xsi:type="stringVariableType" />
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
									<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
								</variable>
								<variable name="DisplayTitle" displayName="metadata.title.display" xsi:type="complexVariableType">
									<variable name="Value" displayName="metadata.title.display.value" xsi:type="stringVariableType" />
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
									<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
								</variable>
								<variable name="SortTitle" displayName="metadata.title.sort" xsi:type="complexVariableType">
									<variable name="Value" displayName="metadata.title.sort.value" xsi:type="stringVariableType" />
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
									<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
								</variable>
								<variable name="ShortTitle" displayName="metadata.title.short" xsi:type="complexVariableType">
									<variable name="Value" displayName="metadata.title.short.value" xsi:type="stringVariableType" />
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
									<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
								</variable>
								<variable name="FeatureTitle" displayName="metadata.title.feature" xsi:type="complexVariableType">
									<variable name="Value" displayName="metadata.title.feature.value" xsi:type="stringVariableType" />
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
									<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
								</variable>
							</variable>					
		
							<!-- Version -->
							<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
								<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
								<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
							</variable>
							
						</metadata>
					</title>
				</childTitles>

			</title>


			<!-- 
				The Preview Title Item
			 -->
			<title>
				<name>PREVIEW</name>
				<alias>preview.sectionName</alias>
				<metadata>
					<!-- ========================= Simple Fields ============================ -->
					<variable name="AssetClass" displayName="metadata.assetClass" xsi:type="stringVariableType">
						<options>
							<option name="metadata.assetClass.optionName.preview">preview</option>
						</options>
					</variable>
					<variable name="AssetName" displayName="metadata.assetName" xsi:type="stringVariableType"/>
					<variable name="DeviceRestrictionProfileId" displayName="metadata.deviceRestrictionProfileId" xsi:type="stringVariableType" />
					<variable name="Verb" displayName="metadata.verb" xsi:type="stringVariableType" />
					<variable name="PD" displayName="metadata.pd" xsi:type="booleanVariableType" />
					<variable name="PolicyProfileId" displayName="metadata.policyProfileId" xsi:type="stringVariableType" />
					<variable name="Profile" displayName="metadata.profile" xsi:type="stringVariableType" />

					<!-- ========================= Complex Fields ============================ -->
					
					<!-- ApplicationInfo -->					
					<variable name="ApplicationInfo" displayName="metadata.applicationInfo" xsi:type="complexVariableType" showCollapsed="true" >
						<variable name="Name" displayName="metadata.applicationInfo.name" xsi:type="stringVariableType">
							<options>
								<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.AppTypeOptionProvider</optionProvider>
							</options>	
						</variable>
					</variable>

					<!-- Content -->
					<variable name="Content" displayName="metadata.content" xsi:type="complexVariableType">
						<variable name="Expression" displayName="metadata.content.expression" xsi:type="stringVariableType"/>
						<variable name="Default" displayName="metadata.content.default" xsi:type="stringVariableType"/>
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="Size" displayName="metadata.size" xsi:type="complexVariableType" >
							<variable name="length" displayName="metadata.size.length" xsi:type="integerVariableType" />
							<variable name="height" displayName="metadata.size.height" xsi:type="integerVariableType" />
							<variable name="width" displayName="metadata.size.width" xsi:type="integerVariableType" />
						</variable>
						<variable name="Checksum" displayName="metadata.content.checkSum" xsi:type="stringVariableType" />
						<variable name="Medium" displayName="metadata.medium" xsi:type="complexVariableType" >
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="MIMEType" displayName="metadata.content.mimeType" xsi:type="stringVariableType"/>
						<variable name="Resolution" displayName="metadata.content.resolution" xsi:type="stringVariableType"/>
						<variable name="FrameRate" displayName="metadata.content.frameRate" xsi:type="stringVariableType"/>
						<variable name="Codec" displayName="metadata.content.codec" xsi:type="stringVariableType"/>
						<variable name="WasPitched" displayName="metadata.content.wasPitched" xsi:type="booleanVariableType"/>
						<variable name="LastPitchDate" displayName="metadata.content.lastPitchDate" xsi:type="dateVariableType"/>
						<variable name="PitchedFilename" displayName="metadata.content.pitchedFilename" xsi:type="stringVariableType"/>
						<variable name="SizeInBytes" displayName="metadata.content.sizeInBytes" xsi:type="integerVariableType"/>
						<variable name="Type" displayName="metadata.content.type" xsi:type="stringVariableType"/>
						<variable name="NetworkType" displayName="metadata.content.networkType" xsi:type="stringVariableType"/>
						<variable name="PlayReady" displayName="metadata.content.playReady" xsi:type="booleanVariableType"/>
						<variable name="WebInitiatorUrl" displayName="metadata.content.webInitiatorUri" xsi:type="stringVariableType"/>
						<variable name="LicenseServerProxyUrl" displayName="metadata.content.licenseServerProxyUrl" xsi:type="stringVariableType"/>
					</variable>
				
					<!-- Copyright -->
					<variable name="Copyright" displayName="metadata.copyright" xsi:type="complexVariableType">
						<variable name="Value" displayName="metadata.copyright.value" xsi:type="stringVariableType" />
						<variable name="CopyProtection" displayName="metadata.copyright.protection" xsi:type="booleanVariableType" />
						<variable name="CopyProtectionVerbose" displayName="metadata.copyright.protectionVerbose" xsi:type="booleanVariableType" />
						<variable name="AnalogProtectionSystem" displayName="metadata.copyright.analogProtectionSystem" xsi:type="integerVariableType" />
						<variable name="EncryptionModeIndicator" displayName="metadata.copyright.encryptionModeIndicator" xsi:type="integerVariableType" />
						<variable name="ConstrainedImageTrigger" displayName="metadata.copyright.constrainedImageTrigger" xsi:type="integerVariableType" />
						<variable name="MacroVisionLevel" displayName="metadata.copyright.macroVisionLevel" xsi:type="stringVariableType" />
						<variable name="CGMSA" displayName="metadata.copyright.cgmsa" xsi:type="integerVariableType" />
						<variable name="disableHDCP" displayName="metadata.copyright.disableHDCP" xsi:type="booleanVariableType" />
						<variable name="Provenance" displayName="metadata.copyright.provenance" xsi:type="stringVariableType" />
					</variable>
					
					<!-- Creation Info -->
					<variable name="CreationInfo" displayName="metadata.creationInfo" xsi:type="complexVariableType">
						<variable name="Title" displayName="metadata.title" xsi:type="complexVariableType">
							<variable name="OriginalTitle" displayName="metadata.title.original" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.original.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="DisplayTitle" displayName="metadata.title.display" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.display.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="SortTitle" displayName="metadata.title.sort" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.sort.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="ShortTitle" displayName="metadata.title.short" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.short.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="FeatureTitle" displayName="metadata.title.feature" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.feature.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
						</variable>					
						<variable name="Description" displayName="metadata.description" xsi:type="stringVariableType" longFormat="true" />
						<variable name="Sources" displayName="metadata.source" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="Source" displayName="metadata.source" xsi:type="complexVariableType" multiValue="true">
								<variable name="Role" displayName="metadata.source.role" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="Name" displayName="metadata.source.role.name" xsi:type="stringVariableType">
										<options>
											<option name="metadata.source.role.name.optionName.actor">ACTOR</option>
											<option name="metadata.source.role.name.optionName.author">AUTHOR</option>
											<option name="metadata.source.role.name.optionName.creator">CREATOR</option>
											<option name="metadata.source.role.name.optionName.director">DIRECTOR</option>
											<option name="metadata.source.role.name.optionName.executiveproducer">EXECUTIVEPRODUCER</option>
											<option name="metadata.source.role.name.optionName.host">HOST</option>
											<option name="metadata.source.role.name.optionName.gueststar">GUESTSTAR</option>
											<option name="metadata.source.role.name.optionName.organization">ORGANIZATION</option>
											<option name="metadata.source.role.name.optionName.producer">PRODUCER</option>
											<option name="metadata.source.role.name.optionName.publisher">PUBLISHER</option>
											<option name="metadata.source.role.name.optionName.writer">WRITER</option>
										</options>
									</variable>
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="value" displayName="metadata.source.role.value" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="Contact" displayName="metadata.contact" xsi:type="complexVariableType">
									<variable name="FirstName" displayName="metadata.contact.firstName" xsi:type="stringVariableType" />
									<variable name="LastName" displayName="metadata.contact.lastName" xsi:type="stringVariableType" />
									<variable name="MiddleName" displayName="metadata.contact.middleName" xsi:type="stringVariableType" />
									<variable name="Email" displayName="metadata.contact.email" xsi:type="stringVariableType" />
									<variable name="Address" displayName="metadata.address" xsi:type="complexVariableType">
										<variable name="Line1" displayName="metadata.address.line1" xsi:type="stringVariableType" />
										<variable name="Line2" displayName="metadata.address.line2" xsi:type="stringVariableType" />
										<variable name="Zip" displayName="metadata.address.zip" xsi:type="stringVariableType" />
										<variable name="Place" displayName="metadata.place" xsi:type="complexVariableType" showCollapsed="true" >
											<variable name="Region" displayName="metadata.place.region" xsi:type="stringVariableType" />
											<variable name="Country" displayName="metadata.place.country" xsi:type="stringVariableType" />
											<variable name="Coordiantes" displayName="metadata.place.coordinates" xsi:type="stringVariableType" />
										</variable>
									</variable>
									<variable name="DisplayName" displayName="metadata.contact.displayName" xsi:type="stringVariableType" />
								</variable>
								<variable name="CharacterName" displayName="metadata.source.CharacterName" xsi:type="stringVariableType" />
								<variable name="Popularity" displayName="metadata.source.Popularity" xsi:type="integerVariableType" />
							</variable>
						</variable>
						<variable name="CreateDate" displayName="metadata.creationInfo.createDate" xsi:type="dateVariableType" />
						<variable name="UpdateDate" displayName="metadata.creationInfo.updateDate" xsi:type="dateVariableType" />
						<variable name="Place" displayName="metadata.creationInfo.place" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="Region" displayName="metadata.creationInfo.place.region" xsi:type="stringVariableType" />
							<variable name="Country" displayName="metadata.creationInfo.place.country" xsi:type="stringVariableType" />
							<variable name="Coordiantes" displayName="metadata.creationInfo.place.coordinates" xsi:type="stringVariableType" />
						</variable>
						<variable name="Tool" displayName="metadata.tool" xsi:type="complexVariableType" >
							<variable name="Name" displayName="metadata.creationInfo.studio.name" xsi:type="stringVariableType" />
							<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
								<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
								<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
							</variable>
							<variable name="ToolSettings" displayName="metadata.tool.settings" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="ToolSetting" displayName="metadata.tool.setting" xsi:type="complexVariableType" multiValue="true">
									<variable name="Name" displayName="metadata.name" xsi:type="stringVariableType" />
									<variable name="Value" displayName="metadata.value" xsi:type="stringVariableType" />
								</variable>
							</variable>
						</variable>
						<variable name="PublicationDate" displayName="metadata.creationInfo.publicationDate" xsi:type="integerVariableType"  />
						<variable name="Studio" displayName="metadata.creationInfo.studio" xsi:type="complexVariableType" >
							<variable name="DisplayName" displayName="metadata.creationInfo.studio.displayName" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="Name" displayName="metadata.creationInfo.studio.name" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOrgNameOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="Code" displayName="metadata.creationInfo.studio.code" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOrgCodeOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="RoyaltyInfo" displayName="metadata.creationInfo.studio.royalty" xsi:type="complexVariableType" showCollapsed="true" >
								<variable name="RoyaltyPercent" displayName="metadata.creationInfo.studio.royalty.percent" xsi:type="floatVariableType"  />
								<variable name="RoyaltyMinimum" displayName="metadata.creationInfo.studio.royalty.minimum" xsi:type="floatVariableType"  />
								<variable name="RoyaltyFlatRate" displayName="metadata.creationInfo.studio.royalty.flatRate" xsi:type="floatVariableType"  />
							</variable>
						</variable>
					</variable>
					
					<!-- Description -->
					<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
						<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
						</variable>
					</variable>
		
					<!-- Duration -->
					<variable name="Duration" displayName="metadata.duration" xsi:type="complexVariableType">
						<variable name="DisplayDuration" displayName="metadata.duration.display" xsi:type="stringVariableType" />
						<variable name="StartOffset" displayName="metadata.duration.startOffset" xsi:type="timeVariableType" />
						<variable name="Duration" displayName="metadata.duration.value" xsi:type="timeVariableType" jobParameter="true" />
					</variable>
		
					<!-- Encryption -->
					<variable name="Encryption" displayName="metadata.encryption" xsi:type="complexVariableType" >
						<variable name="Asset" displayName="metadata.encryption.asset" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>						
						<variable name="Value" displayName="metadata.encryption.value" xsi:type="booleanVariableType" />
						<variable name="Algorithm" displayName="metadata.encryption.algorithm" xsi:type="stringVariableType" />
						<variable name="Date" displayName="metadata.encryption.date" xsi:type="dateVariableType" />
						<variable name="SystemInfo" displayName="metadata.encryption.systemInfo" xsi:type="stringVariableType" />
						<variable name="KeyBlock" displayName="metadata.encryption.keyBlock" xsi:type="stringVariableType" longFormat="true" />
						<variable name="Type" displayName="metadata.encryption.type" xsi:type="stringVariableType" />
						<variable name="Time" displayName="metadata.encryption.time" xsi:type="timeVariableType" />
						<variable name="EncryptionClass" displayName="metadata.encryption.class" xsi:type="stringVariableType" />					
					</variable>
		
					<!-- Identifier -->
					<variable name="Identifier" displayName="metadata.identifier" xsi:type="complexVariableType">
						<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
						<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
						<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" jobParameter="true" />
						<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
						<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
					</variable>					

					<!-- ProductInfo -->
					<variable name="ProductInfo" displayName="metadata.productInfo" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Name" displayName="metadata.productInfo.name" xsi:type="stringVariableType">
							<options>
								<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.ProductOptionProvider</optionProvider>
							</options>
						</variable>
					</variable>
					
					<!-- ProviderInfo -->
					<variable name="ProviderInfo" displayName="metadata.providerInfo" xsi:type="complexVariableType">
						<!-- Let's add it here, but it will be disabled in GUI. Users are not allowed to edit this value. -->
						<variable name="Name" displayName="metadata.providerInfo.name" xsi:type="stringVariableType" />
						<variable name="Identifier" displayName="metadata.providerId" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.providerId" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="ReferenceIdentifier" displayName="metadata.referenceIdentifier" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
					</variable>
			
					<!-- Derived -->
					<variable name="Derived" displayName="metadata.derived" xsi:type="complexVariableType">
						<variable name="SourceAssetId" displayName="metadata.derived.sourceassetid" xsi:type="stringVariableType" />
						<variable name="SourceProviderId" displayName="metadata.derived.sourceproviderid" xsi:type="stringVariableType" />
					</variable>

					<!-- EquipCapabilityProfileList -->
					<variable name="EquipCapabilityProfileList" displayName="metadata.equipCapabilityProfileList" xsi:type="complexVariableType" showCollapsed="false">
						<variable name="EquipCapabilityProfile" displayName="metadata.equipCapabilityProfile" xsi:type="stringVariableType" multiValue="true" />
					</variable>

					<!-- Rating -->										
					<variable name="Rating" displayName="metadata.rating" xsi:type="complexVariableType">
						<variable name="RatingValues" displayName="metadata.rating" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="RatingValue" displayName="metadata.rating.value" xsi:type="complexVariableType" multiValue="true">
								<variable name="System" displayName="metadata.rating.system" xsi:type="stringVariableType">
									<options>
										<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.RatingSystemOptionProvider</optionProvider>
									</options>
								</variable>
								<variable name="Value" displayName="metadata.rating.value" xsi:type="stringVariableType">
									<options>
										<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.RatingOptionProvider</optionProvider>
									</options>
								</variable>
							</variable>
						</variable>
						<variable name="ContentAdvisories" displayName="metadata.rating.advisories" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="ContentAdvisory" displayName="metadata.rating.advisory" xsi:type="stringVariableType" multiValue="true">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.ContentAdvisoryOptionProvider</optionProvider>
								</options>
							</variable>
						</variable>
						<variable name="TargetAudiences" displayName="metadata.rating.audiences" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="TargetAudience" displayName="metadata.rating.audience" xsi:type="stringVariableType" multiValue="true"/>
						</variable>
						<variable name="MSORatings" displayName="metadata.rating.msos" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="MSORating" displayName="metadata.rating.mso" xsi:type="stringVariableType" multiValue="true"/>
						</variable>
						<variable name="Labels" displayName="metadata.rating.labels" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="Label" displayName="metadata.rating.label" xsi:type="stringVariableType" multiValue="true"/>
						</variable>
					</variable>

					<!-- Restriction -->
					<variable name="Restriction" displayName="metadata.restriction" xsi:type="complexVariableType">
						<variable name="Roll" displayName="metadata.restriction.roll" xsi:type="stringVariableType" />
						<variable name="Content" displayName="metadata.restriction.content" xsi:type="stringVariableType" />
					</variable>

					<!-- Rights -->
					<variable name="Rights" displayName="metadata.rights" xsi:type="complexVariableType">
						<variable name="Id" displayName="metadata.rights.id" xsi:type="stringVariableType" />
						<variable name="LicensingWindowStart" displayName="metadata.rights.licensingWindowStart" xsi:type="dateVariableType" jobParameter="true" />
						<variable name="LicensingWindowEnd" displayName="metadata.rights.licensingWindowEnd" xsi:type="dateVariableType" jobParameter="true" />
						<variable name="AvailabilityWindowStart" displayName="metadata.rights.availabilityWindowStart" xsi:type="dateVariableType" jobParameter="true" />
						<variable name="AvailabilityWindowEnd" displayName="metadata.rights.availabilityWindowEnd" xsi:type="dateVariableType" jobParameter="true" />
						<variable name="NewReleaseWindow" displayName="metadata.rights.newReleaseWindow" xsi:type="integerVariableType"  />
						<variable name="MaxPlayCount" displayName="metadata.rights.maxPlayCount" xsi:type="integerVariableType" />
						<variable name="ViewLimits" displayName="metadata.rights.maxViewLimit" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="ViewLimit" displayName="metadata.rights.maxViewLimit" xsi:type="stringVariableType" multiValue="true" />
						</variable>
						<variable name="MaxViewingLimit" displayName="metadata.rights.maxViewingLimit" xsi:type="integerVariableType"  />
						<variable name="MinViewingLimit" displayName="metadata.rights.maxViewingLimit" xsi:type="integerVariableType"  />
						<variable name="MaxView" displayName="metadata.rights.maxView" xsi:type="stringVariableType" />
						<variable name="Contract" displayName="metadata.rights.contract" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="Id" displayName="metadata.identifier" xsi:type="complexVariableType">
								<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
								<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
								<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
								<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
								<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
								<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
									<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
									<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
									<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
									<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
									<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
									<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
									<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>							
							<variable name="Name" displayName="metadata.rights.contract.name" xsi:type="stringVariableType" />
						</variable>
						<variable name="PreviewPeriod" displayName="metadata.rights.previewPeriod" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="DisplayDuration" displayName="metadata.duration.display" xsi:type="stringVariableType" />
							<variable name="StartOffset" displayName="metadata.duration.startOffset" xsi:type="timeVariableType" />
							<variable name="Duration" displayName="metadata.duration.value" xsi:type="timeVariableType" jobParameter="true" />
						</variable>
						<variable name="DisplayAsLastChance" displayName="metadata.rights.displayAsLastChance" xsi:type="integerVariableType" />
						<variable name="HomeVideoWindow" displayName="metadata.rights.homeVideoWindow" xsi:type="integerVariableType"  />
						<variable name="Value" displayName="metadata.rights.value" xsi:type="stringVariableType"  />
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="ViewingCanBeResumed" displayName="metadata.rights.viewingCanBeResumed" xsi:type="booleanVariableType"/>
						<variable name="DaysToLastChance" displayName="metadata.rights.daysToLastChance" xsi:type="integerVariableType"/>
					</variable>

					<!-- Version -->
					<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
						<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
						<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
						<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
					</variable>

					<!-- Video -->
					<variable name="Video" displayName="metadata.video" xsi:type="complexVariableType">
						<variable name="AspectRatio" displayName="metadata.video.aspectRatio" xsi:type="stringVariableType" />
						<variable name="ScreenFormat" displayName="metadata.video.screenFormat" xsi:type="stringVariableType" />
						<variable name="HDContent" displayName="metadata.video.hdContent" xsi:type="booleanVariableType" >
							<options>
								<option name="metadata.booleanOptionName.true">true</option>
								<option name="metadata.booleanOptionName.false">false</option>
							</options>
						</variable>
						<variable name="BitRate" displayName="metadata.video.bitrate" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="value" displayName="metadata.video.bitrate.value" xsi:type="integerVariableType" attribute="true" />
						</variable>
						<variable name="AudioInfos" displayName="metadata.audioInfo" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="AudioInfo" displayName="metadata.audioInfo" xsi:type="complexVariableType" multiValue="true">
								<variable name="ChannelCount" displayName="metadata.audioInfo.channelCount" xsi:type="integerVariableType" />
								<variable name="Preffered" displayName="metadata.audioInfo.preffered" xsi:type="stringVariableType" />
								<variable name="Value" displayName="metadata.type" xsi:type="stringVariableType" />
								<variable name="DefaultTrack" displayName="metadata.audioInfo.defaultTrack" xsi:type="booleanVariableType" />
								<variable name="ContainsDesc" displayName="metadata.audioInfo.containsDesc" xsi:type="booleanVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="PID" displayName="metadata.audioInfo.pid" xsi:type="stringVariableType" />
								<variable name="Codec" displayName="metadata.audioInfo.codec" xsi:type="stringVariableType" />
							</variable>
						</variable>
						<variable name="PrivatePid" displayName="metadata.video.privatePid" xsi:type="stringVariableType" />
						<variable name="PreEncryptionInfo" displayName="metadata.preEncryptionInfo" xsi:type="complexVariableType">
							<variable name="DerivedFrom" displayName="metadata.preEncryptionInfo.derivedFrom" xsi:type="complexVariableType" >
								<variable name="ProviderInfo" displayName="metadata.providerInfo" xsi:type="complexVariableType">
									<!-- Let's add it here, but it will be disabled in GUI. Users are not allowed to edit this value. -->
									<variable name="Name" displayName="metadata.providerInfo.name" xsi:type="stringVariableType" />
									<variable name="Identifier" displayName="metadata.providerId" xsi:type="complexVariableType">
										<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
										<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
										<variable name="Id" displayName="metadata.providerId" xsi:type="stringVariableType" />
										<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
										<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
										<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
											<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
											<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
											<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
											<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
											<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
											<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
											<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
											<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
												<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
												<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
													<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
												</variable>
											</variable>
										</variable>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="ReferenceIdentifier" displayName="metadata.referenceIdentifier" xsi:type="complexVariableType">
										<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
										<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
										<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
										<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
										<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
										<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
											<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
											<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
											<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
											<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
											<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
											<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
											<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
											<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
												<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
												<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
													<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
												</variable>
											</variable>
										</variable>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
								</variable>
								<variable name="AssetId" displayName="metadata.identifier" xsi:type="complexVariableType">
									<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
									<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
									<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
									<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
									<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>					
								<variable name="Start" displayName="metadata.start" xsi:type="timeVariableType" />
								<variable name="End" displayName="metadata.end" xsi:type="timeVariableType" />
								<variable name="AmsValidate" displayName="metadata.image.amsValidate" xsi:type="booleanVariableType" />
								<variable name="ResumeViewAllowed" displayName="metadata.image.resumeViewAllowed" xsi:type="booleanVariableType" />
								<variable name="TrickModeRestrictions" displayName="metadata.trickModeRestrictions" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="TrickModeRestriction" displayName="metadata.trickModeRestrictions" xsi:type="stringVariableType" multiValue="true"/>
								</variable>
							</variable>
							<variable name="EncryptionDate" displayName="metadata.preEncryptionInfo.encryptionDate" xsi:type="dateVariableType" />
							<variable name="FormatAuthority" displayName="metadata.preEncryptionInfo.formatAuthority" xsi:type="stringVariableType" />
							<variable name="TargetVersion" displayName="metadata.preEncryptionInfo.targetVersion" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
								<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
								<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
							</variable>
							<variable name="EncryptionInfo" displayName="metadata.encryption" xsi:type="complexVariableType" >
								<variable name="Asset" displayName="metadata.encryption.asset" xsi:type="complexVariableType">
									<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
									<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
									<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
									<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
									<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>						
								<variable name="Value" displayName="metadata.encryption.value" xsi:type="booleanVariableType" />
								<variable name="Algorithm" displayName="metadata.encryption.algorithm" xsi:type="stringVariableType" />
								<variable name="Date" displayName="metadata.encryption.date" xsi:type="dateVariableType" />
								<variable name="SystemInfo" displayName="metadata.encryption.systemInfo" xsi:type="stringVariableType" />
								<variable name="KeyBlock" displayName="metadata.encryption.keyBlock" xsi:type="stringVariableType" longFormat="true" />
								<variable name="Type" displayName="metadata.encryption.type" xsi:type="stringVariableType" />
								<variable name="Time" displayName="metadata.encryption.time" xsi:type="timeVariableType" />
								<variable name="EncryptionClass" displayName="metadata.encryption.class" xsi:type="stringVariableType" />					
							</variable>
						</variable>
						<variable name="StreamFormat" displayName="metadata.video.streamFormat" xsi:type="stringVariableType" />
						<variable name="ThreeDContent" displayName="metadata.video.3dContent" xsi:type="booleanVariableType" />
						<variable name="AVContainer" displayName="metadata.video.avContainer" xsi:type="stringVariableType" />
						<variable name="AlternateBitRateResolutionList" displayName="metadata.video.alternateBitRateResolutionList" xsi:type="complexVariableType" showCollapsed="false">
							<variable name="AlternateBitRateResolution" displayName="metadata.video.alternateBitRateResolution" xsi:type="stringVariableType" multiValue="true"/>
						</variable>	
					</variable>
			
					<!-- Trick Modes Restrictions -->
					<variable name="TrickModeRestrictions" displayName="metadata.trickModeRestrictions" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="TrickModeRestriction" displayName="metadata.trickModeRestrictions.trickModeRestriction" xsi:type="stringVariableType" multiValue="true" />
					</variable>
			
					<!-- Avails -->
					<variable name="Avails" displayName="metadata.avails" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Avail" displayName="metadata.avail" xsi:type="complexVariableType" multiValue="true">
							<variable name="TimeCodeOne" displayName="metadata.avail.timeCodeOne" xsi:type="timeVariableType" />
							<variable name="TimeCodeTwo" displayName="metadata.avail.timeCodeTwo" xsi:type="timeVariableType" />
							<variable name="TimeCodeThree" displayName="metadata.avail.timeCodeThree" xsi:type="timeVariableType" />
							<variable name="TimeCodeFour" displayName="metadata.avail.timeCodeFour" xsi:type="timeVariableType" />
							<variable name="Id" displayName="metadata.avail.id" xsi:type="stringVariableType" />
							<variable name="Scope" displayName="metadata.avail.scope" xsi:type="stringVariableType" />
							<variable name="Type" displayName="metadata.avail.type" xsi:type="stringVariableType" />
							<variable name="Position" displayName="metadata.avail.position" xsi:type="stringVariableType" />
						</variable>
					</variable>	

					<!-- Languages -->
					<variable name="Languages" displayName="metadata.Languages" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true" multiValue="true" >
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true"/>
						</variable>
					</variable>

					<!-- Subtitle Languages -->
					<variable name="SubTitleLanguages" displayName="metadata.subtitleLanguages" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="SubTitleLanguage" displayName="metadata.subtitleLanguage" xsi:type="complexVariableType" showCollapsed="true" multiValue="true" >
							<variable name="value" displayName="metadata.subtitleLanguage.name" xsi:type="stringVariableType" attribute="true"/>
						</variable>
					</variable>
					
					<!-- Dubbed Languages -->
					<variable name="DubbedLanguages" displayName="metadata.dubbedLanguages" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="DubbedLanguage" displayName="metadata.dubbedLanguage" xsi:type="complexVariableType" showCollapsed="true" multiValue="true" >
							<variable name="value" displayName="metadata.dubbedLanguage.name" xsi:type="stringVariableType" attribute="true"/>
						</variable>
					</variable>

					<!-- Custom Fields -->
					<variable name="CustomFields" displayName="metadata.customFields" xsi:type="complexVariableType">
						<variable name="CustomField[@name=Reencode]" displayName="metadata.customFields.reencode" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.reencode.value" xsi:type="booleanVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=ReencodeProfile]" displayName="metadata.customFields.reencodeProfile" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.reencodeProfile.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=Transcode]" displayName="metadata.customFields.transcode" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.transcode.value" xsi:type="booleanVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=TranscodeProfile]" displayName="metadata.customFields.transcodeProfile" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.transcodeProfile.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
						<variable name="CustomField[@name=TranscodeFormat]" displayName="metadata.customFields.transcodeFormat" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.customFields.transcodeFormat.value" xsi:type="stringVariableType" attribute="true" />
						</variable>
					</variable>					
				</metadata>

				<!-- The Preview section children -->
				<childTitles>
					<!-- 
						The Logical Clip Title Item
					 -->
					<title>
						<name>LOGICALCLIP</name>
						<alias>logicalclip.sectionName</alias>
						<metadata>
							<!-- ========================== Simple Fields ======================== -->
							<variable name="AssetClass" displayName="metadata.assetClass" xsi:type="stringVariableType">
								<options>
									<option name="metadata.assetClass.optionName.logicalClip">logical clip</option>
								</options>
							</variable>
							<variable name="AssetName" displayName="metadata.assetName" xsi:type="stringVariableType"/>
							<variable name="Verb" displayName="metadata.verb" xsi:type="stringVariableType" />
							
							<!-- ========================== Complex Fields ======================== -->
							
							<!-- ApplicationInfo -->					
							<variable name="ApplicationInfo" displayName="metadata.applicationInfo" xsi:type="complexVariableType" showCollapsed="true" >
								<variable name="Name" displayName="metadata.applicationInfo.name" xsi:type="stringVariableType">
									<options>
										<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.AppTypeOptionProvider</optionProvider>
									</options>	
								</variable>
							</variable>
				
							<!-- Content -->
							<variable name="Content" displayName="metadata.content" xsi:type="complexVariableType">
								<variable name="Expression" displayName="metadata.content.expression" xsi:type="stringVariableType"/>
								<variable name="Default" displayName="metadata.content.default" xsi:type="stringVariableType"/>
								<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
									<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
									<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
									<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
									<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
									<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
									<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
									<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
								<variable name="Size" displayName="metadata.size" xsi:type="complexVariableType" >
									<variable name="length" displayName="metadata.size.length" xsi:type="integerVariableType" />
									<variable name="height" displayName="metadata.size.height" xsi:type="integerVariableType" />
									<variable name="width" displayName="metadata.size.width" xsi:type="integerVariableType" />
								</variable>
								<variable name="Checksum" displayName="metadata.content.checkSum" xsi:type="stringVariableType" />
								<variable name="Medium" displayName="metadata.medium" xsi:type="complexVariableType" >
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
								<variable name="MIMEType" displayName="metadata.content.mimeType" xsi:type="stringVariableType"/>
								<variable name="Resolution" displayName="metadata.content.resolution" xsi:type="stringVariableType"/>
								<variable name="FrameRate" displayName="metadata.content.frameRate" xsi:type="stringVariableType"/>
								<variable name="Codec" displayName="metadata.content.codec" xsi:type="stringVariableType"/>
								<variable name="WasPitched" displayName="metadata.content.wasPitched" xsi:type="booleanVariableType"/>
								<variable name="LastPitchDate" displayName="metadata.content.lastPitchDate" xsi:type="dateVariableType"/>
								<variable name="PitchedFilename" displayName="metadata.content.pitchedFilename" xsi:type="stringVariableType"/>
								<variable name="SizeInBytes" displayName="metadata.content.sizeInBytes" xsi:type="integerVariableType"/>
								<variable name="Type" displayName="metadata.content.type" xsi:type="stringVariableType"/>
								<variable name="NetworkType" displayName="metadata.content.networkType" xsi:type="stringVariableType"/>
								<variable name="PlayReady" displayName="metadata.content.playReady" xsi:type="booleanVariableType"/>
								<variable name="WebInitiatorUrl" displayName="metadata.content.webInitiatorUri" xsi:type="stringVariableType"/>
								<variable name="LicenseServerProxyUrl" displayName="metadata.content.licenseServerProxyUrl" xsi:type="stringVariableType"/>
							</variable>
				
							<!-- Creation Info -->
							<variable name="CreationInfo" displayName="metadata.creationInfo" xsi:type="complexVariableType">
								<variable name="Title" displayName="metadata.title" xsi:type="complexVariableType">
									<variable name="OriginalTitle" displayName="metadata.title.original" xsi:type="complexVariableType">
										<variable name="Value" displayName="metadata.title.original.value" xsi:type="stringVariableType" />
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
										<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
									</variable>
									<variable name="DisplayTitle" displayName="metadata.title.display" xsi:type="complexVariableType">
										<variable name="Value" displayName="metadata.title.display.value" xsi:type="stringVariableType" />
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
										<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
									</variable>
									<variable name="SortTitle" displayName="metadata.title.sort" xsi:type="complexVariableType">
										<variable name="Value" displayName="metadata.title.sort.value" xsi:type="stringVariableType" />
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
										<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
									</variable>
									<variable name="ShortTitle" displayName="metadata.title.short" xsi:type="complexVariableType">
										<variable name="Value" displayName="metadata.title.short.value" xsi:type="stringVariableType" />
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
										<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
									</variable>
									<variable name="FeatureTitle" displayName="metadata.title.feature" xsi:type="complexVariableType">
										<variable name="Value" displayName="metadata.title.feature.value" xsi:type="stringVariableType" />
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
										<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
									</variable>
								</variable>					
								<variable name="Description" displayName="metadata.description" xsi:type="stringVariableType" longFormat="true" />
								<variable name="Sources" displayName="metadata.source" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="Source" displayName="metadata.source" xsi:type="complexVariableType" multiValue="true">
										<variable name="Role" displayName="metadata.source.role" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="Name" displayName="metadata.source.role.name" xsi:type="stringVariableType">
												<options>
													<option name="metadata.source.role.name.optionName.actor">ACTOR</option>
													<option name="metadata.source.role.name.optionName.author">AUTHOR</option>
													<option name="metadata.source.role.name.optionName.creator">CREATOR</option>
													<option name="metadata.source.role.name.optionName.director">DIRECTOR</option>
													<option name="metadata.source.role.name.optionName.executiveproducer">EXECUTIVEPRODUCER</option>
													<option name="metadata.source.role.name.optionName.host">HOST</option>
													<option name="metadata.source.role.name.optionName.gueststar">GUESTSTAR</option>
													<option name="metadata.source.role.name.optionName.organization">ORGANIZATION</option>
													<option name="metadata.source.role.name.optionName.producer">PRODUCER</option>
													<option name="metadata.source.role.name.optionName.publisher">PUBLISHER</option>
													<option name="metadata.source.role.name.optionName.writer">WRITER</option>
												</options>
											</variable>
											<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
												<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
												<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
												<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
												<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
												<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
												<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
												<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
												<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
													<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
													<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
														<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
													</variable>
												</variable>
											</variable>
											<variable name="value" displayName="metadata.source.role.value" xsi:type="stringVariableType" attribute="true" />
										</variable>
										<variable name="Contact" displayName="metadata.contact" xsi:type="complexVariableType">
											<variable name="FirstName" displayName="metadata.contact.firstName" xsi:type="stringVariableType" />
											<variable name="LastName" displayName="metadata.contact.lastName" xsi:type="stringVariableType" />
											<variable name="MiddleName" displayName="metadata.contact.middleName" xsi:type="stringVariableType" />
											<variable name="Email" displayName="metadata.contact.email" xsi:type="stringVariableType" />
											<variable name="Address" displayName="metadata.address" xsi:type="complexVariableType">
												<variable name="Line1" displayName="metadata.address.line1" xsi:type="stringVariableType" />
												<variable name="Line2" displayName="metadata.address.line2" xsi:type="stringVariableType" />
												<variable name="Zip" displayName="metadata.address.zip" xsi:type="stringVariableType" />
												<variable name="Place" displayName="metadata.place" xsi:type="complexVariableType" showCollapsed="true" >
													<variable name="Region" displayName="metadata.place.region" xsi:type="stringVariableType" />
													<variable name="Country" displayName="metadata.place.country" xsi:type="stringVariableType" />
													<variable name="Coordiantes" displayName="metadata.place.coordinates" xsi:type="stringVariableType" />
												</variable>
											</variable>
											<variable name="DisplayName" displayName="metadata.contact.displayName" xsi:type="stringVariableType" />
										</variable>
										<variable name="CharacterName" displayName="metadata.source.CharacterName" xsi:type="stringVariableType" />
										<variable name="Popularity" displayName="metadata.source.Popularity" xsi:type="integerVariableType" />
									</variable>
								</variable>
								<variable name="CreateDate" displayName="metadata.creationInfo.createDate" xsi:type="dateVariableType" />
								<variable name="UpdateDate" displayName="metadata.creationInfo.updateDate" xsi:type="dateVariableType" />
								<variable name="Place" displayName="metadata.creationInfo.place" xsi:type="complexVariableType" showCollapsed="true" >
									<variable name="Region" displayName="metadata.creationInfo.place.region" xsi:type="stringVariableType" />
									<variable name="Country" displayName="metadata.creationInfo.place.country" xsi:type="stringVariableType" />
									<variable name="Coordiantes" displayName="metadata.creationInfo.place.coordinates" xsi:type="stringVariableType" />
								</variable>
								<variable name="Tool" displayName="metadata.tool" xsi:type="complexVariableType" >
									<variable name="Name" displayName="metadata.creationInfo.studio.name" xsi:type="stringVariableType" />
									<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
										<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
										<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
										<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
									</variable>
									<variable name="ToolSettings" displayName="metadata.tool.settings" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="ToolSetting" displayName="metadata.tool.setting" xsi:type="complexVariableType" multiValue="true">
											<variable name="Name" displayName="metadata.name" xsi:type="stringVariableType" />
											<variable name="Value" displayName="metadata.value" xsi:type="stringVariableType" />
										</variable>
									</variable>
								</variable>
								<variable name="PublicationDate" displayName="metadata.creationInfo.publicationDate" xsi:type="integerVariableType"  />
								<variable name="Studio" displayName="metadata.creationInfo.studio" xsi:type="complexVariableType" >
									<variable name="DisplayName" displayName="metadata.creationInfo.studio.displayName" xsi:type="stringVariableType">
										<options>
											<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOptionProvider</optionProvider>
										</options>
									</variable>
									<variable name="Name" displayName="metadata.creationInfo.studio.name" xsi:type="stringVariableType">
										<options>
											<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOrgNameOptionProvider</optionProvider>
										</options>
									</variable>
									<variable name="Code" displayName="metadata.creationInfo.studio.code" xsi:type="stringVariableType">
										<options>
											<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOrgCodeOptionProvider</optionProvider>
										</options>
									</variable>
									<variable name="RoyaltyInfo" displayName="metadata.creationInfo.studio.royalty" xsi:type="complexVariableType" showCollapsed="true" >
										<variable name="RoyaltyPercent" displayName="metadata.creationInfo.studio.royalty.percent" xsi:type="floatVariableType"  />
										<variable name="RoyaltyMinimum" displayName="metadata.creationInfo.studio.royalty.minimum" xsi:type="floatVariableType"  />
										<variable name="RoyaltyFlatRate" displayName="metadata.creationInfo.studio.royalty.flatRate" xsi:type="floatVariableType"  />
									</variable>
								</variable>
							</variable>
							
							<!-- Description -->
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
				
							<!-- Identifier -->
							<variable name="Identifier" displayName="metadata.identifier" xsi:type="complexVariableType">
								<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
								<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
								<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
								<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
								<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
								<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
									<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
									<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
									<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
									<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
									<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
									<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
									<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>					
							
							<!-- Mark -->
							<variable name="Mark" displayName="metadata.mark" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="In" displayName="metadata.mark.in" xsi:type="timeVariableType"/>
								<variable name="Out" displayName="metadata.mark.out" xsi:type="timeVariableType"/>
							</variable>
							
							<!-- ProductInfo -->
							<variable name="ProductInfo" displayName="metadata.productInfo" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="Name" displayName="metadata.productInfo.name" xsi:type="stringVariableType">
									<options>
										<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.ProductOptionProvider</optionProvider>
									</options>
								</variable>
							</variable>
							
							<!-- ProviderInfo -->
							<variable name="ProviderInfo" displayName="metadata.providerInfo" xsi:type="complexVariableType">
								<!-- Let's add it here, but it will be disabled in GUI. Users are not allowed to edit this value. -->
								<variable name="Name" displayName="metadata.providerInfo.name" xsi:type="stringVariableType" />
								<variable name="Identifier" displayName="metadata.providerId" xsi:type="complexVariableType">
									<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
									<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
									<variable name="Id" displayName="metadata.providerId" xsi:type="stringVariableType" />
									<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
									<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>
								<variable name="ReferenceIdentifier" displayName="metadata.referenceIdentifier" xsi:type="complexVariableType">
									<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
									<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
									<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
									<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
									<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>
							</variable>

							<!-- Derived -->
							<variable name="Derived" displayName="metadata.derived" xsi:type="complexVariableType">
								<variable name="SourceAssetId" displayName="metadata.derived.sourceassetid" xsi:type="stringVariableType" />
								<variable name="SourceProviderId" displayName="metadata.derived.sourceproviderid" xsi:type="stringVariableType" />
							</variable>

							<!-- Title -->
							<variable name="Title" displayName="metadata.title" xsi:type="complexVariableType">
								<variable name="OriginalTitle" displayName="metadata.title.original" xsi:type="complexVariableType">
									<variable name="Value" displayName="metadata.title.original.value" xsi:type="stringVariableType" />
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
									<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
								</variable>
								<variable name="DisplayTitle" displayName="metadata.title.display" xsi:type="complexVariableType">
									<variable name="Value" displayName="metadata.title.display.value" xsi:type="stringVariableType" />
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
									<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
								</variable>
								<variable name="SortTitle" displayName="metadata.title.sort" xsi:type="complexVariableType">
									<variable name="Value" displayName="metadata.title.sort.value" xsi:type="stringVariableType" />
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
									<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
								</variable>
								<variable name="ShortTitle" displayName="metadata.title.short" xsi:type="complexVariableType">
									<variable name="Value" displayName="metadata.title.short.value" xsi:type="stringVariableType" />
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
									<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
								</variable>
								<variable name="FeatureTitle" displayName="metadata.title.feature" xsi:type="complexVariableType">
									<variable name="Value" displayName="metadata.title.feature.value" xsi:type="stringVariableType" />
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
									<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
								</variable>
							</variable>					
		
							<!-- Version -->
							<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
								<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
								<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
							</variable>
							
						</metadata>
					</title>
				</childTitles>

			</title>

			<!-- 
				The Movie Segement Group Title Item
			 -->
			<title>
				<name>MOVIESEGMENTGROUP</name>
				<alias>moviesegmentgroup.sectionName</alias>
				<metadata>
					<!-- ========================= Simple Fields ============================= -->
					<variable name="AssetClass" displayName="metadata.assetClass" xsi:type="stringVariableType">
						<options>
							<option name="metadata.assetClass.optionName.movieSegmentGroup">movie segment group</option>
						</options>
					</variable>
					<variable name="AssetName" displayName="metadata.assetName" xsi:type="stringVariableType"/>
					<variable name="Verb" displayName="metadata.verb" xsi:type="stringVariableType" />
					<variable name="SegmentGroupUsage" displayName="metadata.segmentGroupUsage" xsi:type="stringVariableType" />	
					<variable name="VodPlaylistId" displayName="metadata.vodPlaylistId" xsi:type="stringVariableType" />
					
					<!-- ========================= Complex Fields ============================= -->

					<!-- ApplicationInfo -->					
					<variable name="ApplicationInfo" displayName="metadata.applicationInfo" xsi:type="complexVariableType" showCollapsed="true" >
						<variable name="Name" displayName="metadata.applicationInfo.name" xsi:type="stringVariableType">
							<options>
								<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.AppTypeOptionProvider</optionProvider>
							</options>	
						</variable>
					</variable>
					<!-- CreationInfo -->
					<variable name="CreationInfo" displayName="metadata.creationInfo" xsi:type="complexVariableType">
						<variable name="CreateDate" displayName="metadata.creationInfo.createDate" xsi:type="dateVariableType" />
					</variable>
					
					<!-- Content -->
					<variable name="Content" displayName="metadata.content" xsi:type="complexVariableType">
						<variable name="Expression" displayName="metadata.content.expression" xsi:type="stringVariableType"/>
						<variable name="Default" displayName="metadata.content.default" xsi:type="stringVariableType"/>
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="Size" displayName="metadata.size" xsi:type="complexVariableType" >
							<variable name="length" displayName="metadata.size.length" xsi:type="integerVariableType" />
							<variable name="height" displayName="metadata.size.height" xsi:type="integerVariableType" />
							<variable name="width" displayName="metadata.size.width" xsi:type="integerVariableType" />
						</variable>
						<variable name="Checksum" displayName="metadata.content.checkSum" xsi:type="stringVariableType" />
						<variable name="Medium" displayName="metadata.medium" xsi:type="complexVariableType" >
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="MIMEType" displayName="metadata.content.mimeType" xsi:type="stringVariableType"/>
						<variable name="Resolution" displayName="metadata.content.resolution" xsi:type="stringVariableType"/>
						<variable name="FrameRate" displayName="metadata.content.frameRate" xsi:type="stringVariableType"/>
						<variable name="Codec" displayName="metadata.content.codec" xsi:type="stringVariableType"/>
						<variable name="WasPitched" displayName="metadata.content.wasPitched" xsi:type="booleanVariableType"/>
						<variable name="LastPitchDate" displayName="metadata.content.lastPitchDate" xsi:type="dateVariableType"/>
						<variable name="PitchedFilename" displayName="metadata.content.pitchedFilename" xsi:type="stringVariableType"/>
						<variable name="SizeInBytes" displayName="metadata.content.sizeInBytes" xsi:type="integerVariableType"/>
						<variable name="Type" displayName="metadata.content.type" xsi:type="stringVariableType"/>
						<variable name="NetworkType" displayName="metadata.content.networkType" xsi:type="stringVariableType"/>
						<variable name="PlayReady" displayName="metadata.content.playReady" xsi:type="booleanVariableType"/>
						<variable name="WebInitiatorUrl" displayName="metadata.content.webInitiatorUri" xsi:type="stringVariableType"/>
						<variable name="LicenseServerProxyUrl" displayName="metadata.content.licenseServerProxyUrl" xsi:type="stringVariableType"/>
					</variable>
					
					<!-- Description -->
					<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
						<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
						</variable>
					</variable>
					<!-- Identifier -->
					<variable name="Identifier" displayName="metadata.identifier" xsi:type="complexVariableType">
						<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
						<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
						<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
						<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
						<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
					</variable>
					
					<!-- ProductInfo -->
					<variable name="ProductInfo" displayName="metadata.productInfo" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Name" displayName="metadata.productInfo.name" xsi:type="stringVariableType">
							<options>
								<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.ProductOptionProvider</optionProvider>
							</options>
						</variable>
					</variable>
					
					<!-- ProviderInfo -->
					<variable name="ProviderInfo" displayName="metadata.providerInfo" xsi:type="complexVariableType">
						<!-- Let's add it here, but it will be disabled in GUI. Users are not allowed to edit this value. -->
						<variable name="Name" displayName="metadata.providerInfo.name" xsi:type="stringVariableType" />
						<variable name="Identifier" displayName="metadata.providerId" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.providerId" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="ReferenceIdentifier" displayName="metadata.referenceIdentifier" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
					</variable>

					<!-- Version -->
					<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
						<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
						<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
						<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
					</variable>
					
					<!-- EquipCapabilityProfileList -->
					<variable name="EquipCapabilityProfileList" displayName="metadata.equipCapabilityProfileList" xsi:type="complexVariableType" showCollapsed="false">
						<variable name="EquipCapabilityProfile" displayName="metadata.equipCapabilityProfile" xsi:type="stringVariableType" multiValue="true" />
					</variable>
				</metadata>
			</title>

			<!-- 
				The Preview Segment Group Title Item
			 -->
			<title>
				<name>PREVIEWSEGMENTGROUP</name>
				<alias>previewsegmentgroup.sectionName</alias>
				<metadata>
					<!-- ========================= Simple Fields ============================= -->
					<variable name="AssetClass" displayName="metadata.assetClass" xsi:type="stringVariableType">
						<options>
							<option name="metadata.assetClass.optionName.previewSegmentGroup">preview segment group</option>
						</options>
					</variable>
					<variable name="AssetName" displayName="metadata.assetName" xsi:type="stringVariableType"/>
					<variable name="Verb" displayName="metadata.verb" xsi:type="stringVariableType" />
					<variable name="SegmentGroupUsage" displayName="metadata.segmentGroupUsage" xsi:type="stringVariableType" />	
					<variable name="SegmentGroupType" displayName="metadata.segmentGroupType" xsi:type="stringVariableType" />	
					<variable name="VodPlaylistId" displayName="metadata.vodPlaylistId" xsi:type="stringVariableType" />
					
					<!-- ========================= Complex Fields ============================= -->

					<!-- ApplicationInfo -->					
					<variable name="ApplicationInfo" displayName="metadata.applicationInfo" xsi:type="complexVariableType" showCollapsed="true" >
						<variable name="Name" displayName="metadata.applicationInfo.name" xsi:type="stringVariableType">
							<options>
								<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.AppTypeOptionProvider</optionProvider>
							</options>	
						</variable>
					</variable>
										
					<!-- Content -->
					<variable name="Content" displayName="metadata.content" xsi:type="complexVariableType">
						<variable name="Expression" displayName="metadata.content.expression" xsi:type="stringVariableType"/>
						<variable name="Default" displayName="metadata.content.default" xsi:type="stringVariableType"/>
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="Size" displayName="metadata.size" xsi:type="complexVariableType" >
							<variable name="length" displayName="metadata.size.length" xsi:type="integerVariableType" />
							<variable name="height" displayName="metadata.size.height" xsi:type="integerVariableType" />
							<variable name="width" displayName="metadata.size.width" xsi:type="integerVariableType" />
						</variable>
						<variable name="Checksum" displayName="metadata.content.checkSum" xsi:type="stringVariableType" />
						<variable name="Medium" displayName="metadata.medium" xsi:type="complexVariableType" >
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="MIMEType" displayName="metadata.content.mimeType" xsi:type="stringVariableType"/>
						<variable name="Resolution" displayName="metadata.content.resolution" xsi:type="stringVariableType"/>
						<variable name="FrameRate" displayName="metadata.content.frameRate" xsi:type="stringVariableType"/>
						<variable name="Codec" displayName="metadata.content.codec" xsi:type="stringVariableType"/>
						<variable name="WasPitched" displayName="metadata.content.wasPitched" xsi:type="booleanVariableType"/>
						<variable name="LastPitchDate" displayName="metadata.content.lastPitchDate" xsi:type="dateVariableType"/>
						<variable name="PitchedFilename" displayName="metadata.content.pitchedFilename" xsi:type="stringVariableType"/>
						<variable name="SizeInBytes" displayName="metadata.content.sizeInBytes" xsi:type="integerVariableType"/>
						<variable name="Type" displayName="metadata.content.type" xsi:type="stringVariableType"/>
						<variable name="NetworkType" displayName="metadata.content.networkType" xsi:type="stringVariableType"/>
						<variable name="PlayReady" displayName="metadata.content.playReady" xsi:type="booleanVariableType"/>
						<variable name="WebInitiatorUrl" displayName="metadata.content.webInitiatorUri" xsi:type="stringVariableType"/>
						<variable name="LicenseServerProxyUrl" displayName="metadata.content.licenseServerProxyUrl" xsi:type="stringVariableType"/>
					</variable>

					<!-- CreationInfo -->
					<variable name="CreationInfo" displayName="metadata.creationInfo" xsi:type="complexVariableType">
						<variable name="CreateDate" displayName="metadata.creationInfo.createDate" xsi:type="dateVariableType" />
					</variable>
					
					<!-- Description -->
					<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
						<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
						</variable>
					</variable>
					<!-- Identifier -->
					<variable name="Identifier" displayName="metadata.identifier" xsi:type="complexVariableType">
						<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
						<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
						<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
						<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
						<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
					</variable>
					<!-- ProductInfo -->
					<variable name="ProductInfo" displayName="metadata.productInfo" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Name" displayName="metadata.productInfo.name" xsi:type="stringVariableType">
							<options>
								<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.ProductOptionProvider</optionProvider>
							</options>
						</variable>
					</variable>
					<!-- ProviderInfo -->
					<variable name="ProviderInfo" displayName="metadata.providerInfo" xsi:type="complexVariableType">
						<!-- Let's add it here, but it will be disabled in GUI. Users are not allowed to edit this value. -->
						<variable name="Name" displayName="metadata.providerInfo.name" xsi:type="stringVariableType" />
						<variable name="Identifier" displayName="metadata.providerId" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.providerId" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="ReferenceIdentifier" displayName="metadata.referenceIdentifier" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
					</variable>

					<!-- Version -->
					<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
						<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
						<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
						<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
					</variable>

					<!-- EquipCapabilityProfileList -->
					<variable name="EquipCapabilityProfileList" displayName="metadata.equipCapabilityProfileList" xsi:type="complexVariableType" showCollapsed="false">
						<variable name="EquipCapabilityProfile" displayName="metadata.equipCapabilityProfile" xsi:type="stringVariableType" multiValue="true" />
					</variable>
				</metadata>
			</title>

			<!-- 
				The Game Title Item
			 -->
			<title>
				<name>GAME</name>
				<alias>game.sectionName</alias>
				<metadata>
					<!-- ================================ Simple ============================= -->
					<variable name="AssetClass" displayName="metadata.assetClass" xsi:type="stringVariableType">
						<options>
							<option name="metadata.assetClass.optionName.game">game</option>
						</options>
					</variable>
					<variable name="AssetName" displayName="metadata.assetName" xsi:type="stringVariableType"/>
					<variable name="Verb" displayName="metadata.verb" xsi:type="stringVariableType" />
					
					<!-- ================================ Complex =================================== -->

					<!-- ApplicationInfo -->
					<variable name="ApplicationInfo" displayName="metadata.applicationInfo" xsi:type="complexVariableType" showCollapsed="true" >
						<variable name="Name" displayName="metadata.applicationInfo.name" xsi:type="stringVariableType">
							<options>
								<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.AppTypeOptionProvider</optionProvider>
							</options>	
						</variable>
					</variable>

					<!-- Description -->
					<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
						<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
						</variable>
					</variable>

					<!-- Duration -->
					<variable name="Duration" displayName="metadata.duration" xsi:type="complexVariableType">
						<variable name="DisplayDuration" displayName="metadata.duration.display" xsi:type="stringVariableType" />
						<variable name="StartOffset" displayName="metadata.duration.startOffset" xsi:type="timeVariableType" />
						<variable name="Duration" displayName="metadata.duration.value" xsi:type="timeVariableType" jobParameter="true" />
					</variable>

					<!-- Identifier -->
					<variable name="Identifier" displayName="metadata.identifier" xsi:type="complexVariableType">
						<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
						<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
						<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
						<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
						<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
					</variable>

					<!-- ProductInfo -->
					<variable name="ProductInfo" displayName="metadata.productInfo" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Name" displayName="metadata.productInfo.name" xsi:type="stringVariableType">
							<options>
								<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.ProductOptionProvider</optionProvider>
							</options>
						</variable>
					</variable>

					<!-- ProviderInfo -->
					<variable name="ProviderInfo" displayName="metadata.providerInfo" xsi:type="complexVariableType">
						<!-- Let's add it here, but it will be disabled in GUI. Users are not allowed to edit this value. -->
						<variable name="Name" displayName="metadata.providerInfo.name" xsi:type="stringVariableType" />						
						<variable name="Identifier" displayName="metadata.providerId" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.providerId" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="ReferenceIdentifier" displayName="metadata.referenceIdentifier" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
					</variable>

					<!-- Version -->
					<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
						<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
						<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
						<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
					</variable>

					<!-- GameInfo -->
					<variable name="GameInfo" displayName="metadata.gameInfo" xsi:type="complexVariableType">
						<variable name="Codec" displayName="metadata.gameInfo.codec" xsi:type="stringVariableType"/>
						<variable name="ExecutionPlatform" displayName="metadata.gameInfo.executionPlatform" xsi:type="stringVariableType"/>
					</variable>

					<!-- Content -->
					<variable name="Content" displayName="metadata.content" xsi:type="complexVariableType">
						<variable name="Expression" displayName="metadata.content.expression" xsi:type="stringVariableType"/>
						<variable name="Default" displayName="metadata.content.default" xsi:type="stringVariableType"/>
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="Size" displayName="metadata.size" xsi:type="complexVariableType" >
							<variable name="length" displayName="metadata.size.length" xsi:type="integerVariableType" />
							<variable name="height" displayName="metadata.size.height" xsi:type="integerVariableType" />
							<variable name="width" displayName="metadata.size.width" xsi:type="integerVariableType" />
						</variable>
						<variable name="Checksum" displayName="metadata.content.checkSum" xsi:type="stringVariableType" />
						<variable name="Medium" displayName="metadata.medium" xsi:type="complexVariableType" >
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="MIMEType" displayName="metadata.content.mimeType" xsi:type="stringVariableType"/>
						<variable name="Resolution" displayName="metadata.content.resolution" xsi:type="stringVariableType"/>
						<variable name="FrameRate" displayName="metadata.content.frameRate" xsi:type="stringVariableType"/>
						<variable name="Codec" displayName="metadata.content.codec" xsi:type="stringVariableType"/>
						<variable name="WasPitched" displayName="metadata.content.wasPitched" xsi:type="booleanVariableType"/>
						<variable name="LastPitchDate" displayName="metadata.content.lastPitchDate" xsi:type="dateVariableType"/>
						<variable name="PitchedFilename" displayName="metadata.content.pitchedFilename" xsi:type="stringVariableType"/>
						<variable name="SizeInBytes" displayName="metadata.content.sizeInBytes" xsi:type="integerVariableType"/>
						<variable name="Type" displayName="metadata.content.type" xsi:type="stringVariableType"/>
						<variable name="NetworkType" displayName="metadata.content.networkType" xsi:type="stringVariableType"/>
						<variable name="PlayReady" displayName="metadata.content.playReady" xsi:type="booleanVariableType"/>
						<variable name="WebInitiatorUrl" displayName="metadata.content.webInitiatorUri" xsi:type="stringVariableType"/>
						<variable name="LicenseServerProxyUrl" displayName="metadata.content.licenseServerProxyUrl" xsi:type="stringVariableType"/>
					</variable>
					
					<!-- Video -->
					<variable name="Video" displayName="metadata.video" xsi:type="complexVariableType">
						<variable name="AspectRatio" displayName="metadata.video.aspectRatio" xsi:type="stringVariableType" />
						<variable name="ScreenFormat" displayName="metadata.video.screenFormat" xsi:type="stringVariableType" />
						<variable name="HDContent" displayName="metadata.video.hdContent" xsi:type="booleanVariableType" >
							<options>
								<option name="metadata.booleanOptionName.true">true</option>
								<option name="metadata.booleanOptionName.false">false</option>
							</options>
						</variable>
						<variable name="BitRate" displayName="metadata.video.bitrate" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="value" displayName="metadata.video.bitrate.value" xsi:type="integerVariableType" attribute="true" />
						</variable>
						<variable name="AudioInfos" displayName="metadata.audioInfo" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="AudioInfo" displayName="metadata.audioInfo" xsi:type="complexVariableType">
								<variable name="ChannelCount" displayName="metadata.audioInfo.channelCount" xsi:type="integerVariableType" />
								<variable name="Preffered" displayName="metadata.audioInfo.preffered" xsi:type="stringVariableType" />
								<variable name="Value" displayName="metadata.type" xsi:type="stringVariableType" />
								<variable name="DefaultTrack" displayName="metadata.audioInfo.defaultTrack" xsi:type="booleanVariableType" />
								<variable name="ContainsDesc" displayName="metadata.audioInfo.containsDesc" xsi:type="booleanVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="PID" displayName="metadata.audioInfo.pid" xsi:type="stringVariableType" />
								<variable name="Codec" displayName="metadata.audioInfo.codec" xsi:type="stringVariableType" />
							</variable>
						</variable>
						<variable name="PrivatePid" displayName="metadata.video.privatePid" xsi:type="stringVariableType" />
						<variable name="PreEncryptionInfo" displayName="metadata.preEncryptionInfo" xsi:type="complexVariableType">
							<variable name="DerivedFrom" displayName="metadata.preEncryptionInfo.derivedFrom" xsi:type="complexVariableType" >
								<variable name="ProviderInfo" displayName="metadata.providerInfo" xsi:type="complexVariableType">
									<!-- Let's add it here, but it will be disabled in GUI. Users are not allowed to edit this value. -->
									<variable name="Name" displayName="metadata.providerInfo.name" xsi:type="stringVariableType" />
									<variable name="Identifier" displayName="metadata.providerId" xsi:type="complexVariableType">
										<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
										<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
										<variable name="Id" displayName="metadata.providerId" xsi:type="stringVariableType" />
										<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
										<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
										<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
											<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
											<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
											<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
											<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
											<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
											<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
											<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
											<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
												<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
												<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
													<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
												</variable>
											</variable>
										</variable>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="ReferenceIdentifier" displayName="metadata.referenceIdentifier" xsi:type="complexVariableType">
										<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
										<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
										<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
										<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
										<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
										<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
											<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
											<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
											<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
											<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
											<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
											<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
											<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
											<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
												<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
												<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
													<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
												</variable>
											</variable>
										</variable>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
								</variable>
								<variable name="AssetId" displayName="metadata.identifier" xsi:type="complexVariableType">
									<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
									<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
									<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
									<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
									<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>					
								<variable name="Start" displayName="metadata.start" xsi:type="timeVariableType" />
								<variable name="End" displayName="metadata.end" xsi:type="timeVariableType" />
								<variable name="AmsValidate" displayName="metadata.image.amsValidate" xsi:type="booleanVariableType" />
								<variable name="ResumeViewAllowed" displayName="metadata.image.resumeViewAllowed" xsi:type="booleanVariableType" />
								<variable name="TrickModeRestrictions" displayName="metadata.trickModeRestrictions" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="TrickModeRestriction" displayName="metadata.trickModeRestrictions" xsi:type="stringVariableType" multiValue="true"/>
								</variable>
							</variable>
							<variable name="EncryptionDate" displayName="metadata.preEncryptionInfo.encryptionDate" xsi:type="dateVariableType" />
							<variable name="FormatAuthority" displayName="metadata.preEncryptionInfo.formatAuthority" xsi:type="stringVariableType" />
							<variable name="TargetVersion" displayName="metadata.preEncryptionInfo.targetVersion" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
								<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
								<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
							</variable>
							<variable name="EncryptionInfo" displayName="metadata.encryption" xsi:type="complexVariableType" >
								<variable name="Asset" displayName="metadata.encryption.asset" xsi:type="complexVariableType">
									<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
									<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
									<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
									<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
									<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>						
								<variable name="Value" displayName="metadata.encryption.value" xsi:type="booleanVariableType" />
								<variable name="Algorithm" displayName="metadata.encryption.algorithm" xsi:type="stringVariableType" />
								<variable name="Date" displayName="metadata.encryption.date" xsi:type="dateVariableType" />
								<variable name="SystemInfo" displayName="metadata.encryption.systemInfo" xsi:type="stringVariableType" />
								<variable name="KeyBlock" displayName="metadata.encryption.keyBlock" xsi:type="stringVariableType" longFormat="true" />
								<variable name="Type" displayName="metadata.encryption.type" xsi:type="stringVariableType" />
								<variable name="Time" displayName="metadata.encryption.time" xsi:type="timeVariableType" />
								<variable name="EncryptionClass" displayName="metadata.encryption.class" xsi:type="stringVariableType" />					
							</variable>
						</variable>
						<variable name="StreamFormat" displayName="metadata.video.streamFormat" xsi:type="stringVariableType" />
						<variable name="ThreeDContent" displayName="metadata.video.3dContent" xsi:type="booleanVariableType" />
						<variable name="AVContainer" displayName="metadata.video.avContainer" xsi:type="stringVariableType" />
						<variable name="AlternateBitRateResolutionList" displayName="metadata.video.alternateBitRateResolutionList" xsi:type="complexVariableType" showCollapsed="false">
							<variable name="AlternateBitRateResolution" displayName="metadata.video.alternateBitRateResolution" xsi:type="stringVariableType" multiValue="true"/>
						</variable>	
					</variable>
				</metadata>
			</title>

			<!--
				The Poster Title Item 
			-->
			<title>
				<name>POSTER</name>
				<alias>poster.sectionName</alias>
				<metadata>
					<!-- ==================== Simple Fields ======================== -->
					<variable name="AssetClass" displayName="metadata.assetClass" xsi:type="stringVariableType">
						<options>
							<option name="metadata.assetClass.optionName.poster">poster</option>
						</options>
					</variable>
					<variable name="AssetName" displayName="metadata.assetName" xsi:type="stringVariableType"/>
					<variable name="DeviceRestrictionProfileId" displayName="metadata.deviceRestrictionProfileId" xsi:type="stringVariableType" />
					<variable name="Verb" displayName="metadata.verb" xsi:type="stringVariableType" />
					<variable name="PolicyProfileId" displayName="metadata.policyProfileId" xsi:type="stringVariableType" />
					<variable name="Profile" displayName="metadata.profile" xsi:type="stringVariableType" />
					
					<!-- ==================== Complex Fields ======================== -->

					<!-- ApplicationInfo -->					
					<variable name="ApplicationInfo" displayName="metadata.applicationInfo" xsi:type="complexVariableType" showCollapsed="true" >
						<variable name="Name" displayName="metadata.applicationInfo.name" xsi:type="stringVariableType">
							<options>
								<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.AppTypeOptionProvider</optionProvider>
							</options>	
						</variable>
					</variable>

					<!-- Content -->
					<variable name="Content" displayName="metadata.content" xsi:type="complexVariableType">
						<variable name="Expression" displayName="metadata.content.expression" xsi:type="stringVariableType"/>
						<variable name="Default" displayName="metadata.content.default" xsi:type="stringVariableType"/>
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="Size" displayName="metadata.size" xsi:type="complexVariableType" >
							<variable name="length" displayName="metadata.size.length" xsi:type="integerVariableType" />
							<variable name="height" displayName="metadata.size.height" xsi:type="integerVariableType" />
							<variable name="width" displayName="metadata.size.width" xsi:type="integerVariableType" />
						</variable>
						<variable name="Checksum" displayName="metadata.content.checkSum" xsi:type="stringVariableType" />
						<variable name="Medium" displayName="metadata.medium" xsi:type="complexVariableType" >
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="MIMEType" displayName="metadata.content.mimeType" xsi:type="stringVariableType"/>
						<variable name="Resolution" displayName="metadata.content.resolution" xsi:type="stringVariableType"/>
						<variable name="FrameRate" displayName="metadata.content.frameRate" xsi:type="stringVariableType"/>
						<variable name="Codec" displayName="metadata.content.codec" xsi:type="stringVariableType"/>
						<variable name="WasPitched" displayName="metadata.content.wasPitched" xsi:type="booleanVariableType"/>
						<variable name="LastPitchDate" displayName="metadata.content.lastPitchDate" xsi:type="dateVariableType"/>
						<variable name="PitchedFilename" displayName="metadata.content.pitchedFilename" xsi:type="stringVariableType"/>
						<variable name="SizeInBytes" displayName="metadata.content.sizeInBytes" xsi:type="integerVariableType"/>
						<variable name="Type" displayName="metadata.content.type" xsi:type="stringVariableType"/>
						<variable name="NetworkType" displayName="metadata.content.networkType" xsi:type="stringVariableType"/>
						<variable name="PlayReady" displayName="metadata.content.playReady" xsi:type="booleanVariableType"/>
						<variable name="WebInitiatorUrl" displayName="metadata.content.webInitiatorUri" xsi:type="stringVariableType"/>
						<variable name="LicenseServerProxyUrl" displayName="metadata.content.licenseServerProxyUrl" xsi:type="stringVariableType"/>
					</variable>

					<!-- Copyright -->
					<variable name="Copyright" displayName="metadata.copyright" xsi:type="complexVariableType">
						<variable name="Value" displayName="metadata.copyright.value" xsi:type="stringVariableType" />
						<variable name="CopyProtection" displayName="metadata.copyright.protection" xsi:type="booleanVariableType" />
						<variable name="CopyProtectionVerbose" displayName="metadata.copyright.protectionVerbose" xsi:type="booleanVariableType" />
						<variable name="AnalogProtectionSystem" displayName="metadata.copyright.analogProtectionSystem" xsi:type="integerVariableType" />
						<variable name="EncryptionModeIndicator" displayName="metadata.copyright.encryptionModeIndicator" xsi:type="integerVariableType" />
						<variable name="ConstrainedImageTrigger" displayName="metadata.copyright.constrainedImageTrigger" xsi:type="integerVariableType" />
						<variable name="MacroVisionLevel" displayName="metadata.copyright.macroVisionLevel" xsi:type="stringVariableType" />
						<variable name="CGMSA" displayName="metadata.copyright.cgmsa" xsi:type="integerVariableType" />
						<variable name="disableHDCP" displayName="metadata.copyright.disableHDCP" xsi:type="booleanVariableType" />
						<variable name="Provenance" displayName="metadata.copyright.provenance" xsi:type="stringVariableType" />
					</variable>

					<!-- Creation Info -->
					<variable name="CreationInfo" displayName="metadata.creationInfo" xsi:type="complexVariableType">
						<variable name="Title" displayName="metadata.title" xsi:type="complexVariableType">
							<variable name="OriginalTitle" displayName="metadata.title.original" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.original.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="DisplayTitle" displayName="metadata.title.display" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.display.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="SortTitle" displayName="metadata.title.sort" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.sort.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="ShortTitle" displayName="metadata.title.short" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.short.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="FeatureTitle" displayName="metadata.title.feature" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.feature.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
						</variable>					
						<variable name="Description" displayName="metadata.description" xsi:type="stringVariableType" longFormat="true" />
						<variable name="Sources" displayName="metadata.source" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="Source" displayName="metadata.source" xsi:type="complexVariableType" multiValue="true">
								<variable name="Role" displayName="metadata.source.role" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="Name" displayName="metadata.source.role.name" xsi:type="stringVariableType">
										<options>
											<option name="metadata.source.role.name.optionName.actor">ACTOR</option>
											<option name="metadata.source.role.name.optionName.author">AUTHOR</option>
											<option name="metadata.source.role.name.optionName.creator">CREATOR</option>
											<option name="metadata.source.role.name.optionName.director">DIRECTOR</option>
											<option name="metadata.source.role.name.optionName.executiveproducer">EXECUTIVEPRODUCER</option>
											<option name="metadata.source.role.name.optionName.host">HOST</option>
											<option name="metadata.source.role.name.optionName.gueststar">GUESTSTAR</option>
											<option name="metadata.source.role.name.optionName.organization">ORGANIZATION</option>
											<option name="metadata.source.role.name.optionName.producer">PRODUCER</option>
											<option name="metadata.source.role.name.optionName.publisher">PUBLISHER</option>
											<option name="metadata.source.role.name.optionName.writer">WRITER</option>
										</options>
									</variable>
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="value" displayName="metadata.source.role.value" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="Contact" displayName="metadata.contact" xsi:type="complexVariableType">
									<variable name="FirstName" displayName="metadata.contact.firstName" xsi:type="stringVariableType" />
									<variable name="LastName" displayName="metadata.contact.lastName" xsi:type="stringVariableType" />
									<variable name="MiddleName" displayName="metadata.contact.middleName" xsi:type="stringVariableType" />
									<variable name="Email" displayName="metadata.contact.email" xsi:type="stringVariableType" />
									<variable name="Address" displayName="metadata.address" xsi:type="complexVariableType">
										<variable name="Line1" displayName="metadata.address.line1" xsi:type="stringVariableType" />
										<variable name="Line2" displayName="metadata.address.line2" xsi:type="stringVariableType" />
										<variable name="Zip" displayName="metadata.address.zip" xsi:type="stringVariableType" />
										<variable name="Place" displayName="metadata.place" xsi:type="complexVariableType" showCollapsed="true" >
											<variable name="Region" displayName="metadata.place.region" xsi:type="stringVariableType" />
											<variable name="Country" displayName="metadata.place.country" xsi:type="stringVariableType" />
											<variable name="Coordiantes" displayName="metadata.place.coordinates" xsi:type="stringVariableType" />
										</variable>
									</variable>
									<variable name="DisplayName" displayName="metadata.contact.displayName" xsi:type="stringVariableType" />
								</variable>
								<variable name="CharacterName" displayName="metadata.source.CharacterName" xsi:type="stringVariableType" />
								<variable name="Popularity" displayName="metadata.source.Popularity" xsi:type="integerVariableType" />
							</variable>
						</variable>
						<variable name="CreateDate" displayName="metadata.creationInfo.createDate" xsi:type="dateVariableType" />
						<variable name="UpdateDate" displayName="metadata.creationInfo.updateDate" xsi:type="dateVariableType" />
						<variable name="Place" displayName="metadata.creationInfo.place" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="Region" displayName="metadata.creationInfo.place.region" xsi:type="stringVariableType" />
							<variable name="Country" displayName="metadata.creationInfo.place.country" xsi:type="stringVariableType" />
							<variable name="Coordiantes" displayName="metadata.creationInfo.place.coordinates" xsi:type="stringVariableType" />
						</variable>
						<variable name="Tool" displayName="metadata.tool" xsi:type="complexVariableType" >
							<variable name="Name" displayName="metadata.creationInfo.studio.name" xsi:type="stringVariableType" />
							<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
								<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
								<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
							</variable>
							<variable name="ToolSettings" displayName="metadata.tool.settings" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="ToolSetting" displayName="metadata.tool.setting" xsi:type="complexVariableType" multiValue="true">
									<variable name="Name" displayName="metadata.name" xsi:type="stringVariableType" />
									<variable name="Value" displayName="metadata.value" xsi:type="stringVariableType" />
								</variable>
							</variable>
						</variable>
						<variable name="PublicationDate" displayName="metadata.creationInfo.publicationDate" xsi:type="integerVariableType"  />
						<variable name="Studio" displayName="metadata.creationInfo.studio" xsi:type="complexVariableType" >
							<variable name="DisplayName" displayName="metadata.creationInfo.studio.displayName" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="Name" displayName="metadata.creationInfo.studio.name" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOrgNameOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="Code" displayName="metadata.creationInfo.studio.code" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOrgCodeOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="RoyaltyInfo" displayName="metadata.creationInfo.studio.royalty" xsi:type="complexVariableType" showCollapsed="true" >
								<variable name="RoyaltyPercent" displayName="metadata.creationInfo.studio.royalty.percent" xsi:type="floatVariableType"  />
								<variable name="RoyaltyMinimum" displayName="metadata.creationInfo.studio.royalty.minimum" xsi:type="floatVariableType"  />
								<variable name="RoyaltyFlatRate" displayName="metadata.creationInfo.studio.royalty.flatRate" xsi:type="floatVariableType"  />
							</variable>
						</variable>
					</variable>

					<!-- Description -->
					<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
						<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
						</variable>
					</variable>
		
					<!-- Duration -->
					<variable name="Duration" displayName="metadata.duration" xsi:type="complexVariableType">
						<variable name="DisplayDuration" displayName="metadata.duration.display" xsi:type="stringVariableType" />
						<variable name="StartOffset" displayName="metadata.duration.startOffset" xsi:type="timeVariableType" />
						<variable name="Duration" displayName="metadata.duration.value" xsi:type="timeVariableType" jobParameter="true" />
					</variable>

					<!-- Image -->
					<variable name="Image" displayName="metadata.image" xsi:type="complexVariableType" >
						<variable name="AspectRatio" displayName="metadata.image.aspectRatio" xsi:type="stringVariableType"/>
						<variable name="ContentPointer" displayName="metadata.contentPointer" xsi:type="complexVariableType" >
							<variable name="ProviderInfo" displayName="metadata.providerInfo" xsi:type="complexVariableType">
								<!-- Let's add it here, but it will be disabled in GUI. Users are not allowed to edit this value. -->
								<variable name="Name" displayName="metadata.providerInfo.name" xsi:type="stringVariableType" />
								<variable name="Identifier" displayName="metadata.providerId" xsi:type="complexVariableType">
									<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
									<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
									<variable name="Id" displayName="metadata.providerId" xsi:type="stringVariableType" />
									<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
									<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>
								<variable name="ReferenceIdentifier" displayName="metadata.referenceIdentifier" xsi:type="complexVariableType">
									<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
									<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
									<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
									<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
									<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>
							</variable>
							<variable name="AssetId" displayName="metadata.identifier" xsi:type="complexVariableType">
								<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
								<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
								<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
								<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
								<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
								<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
									<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
									<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
									<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
									<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
									<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
									<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
									<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>					
							<variable name="Start" displayName="metadata.start" xsi:type="timeVariableType" />
							<variable name="End" displayName="metadata.end" xsi:type="timeVariableType" />
							<variable name="AmsValidate" displayName="metadata.image.amsValidate" xsi:type="booleanVariableType" />
							<variable name="ResumeViewAllowed" displayName="metadata.image.resumeViewAllowed" xsi:type="booleanVariableType" />
							<variable name="TrickModeRestrictions" displayName="metadata.trickModeRestrictions" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="TrickModeRestriction" displayName="metadata.trickModeRestrictions" xsi:type="stringVariableType" multiValue="true"/>
							</variable>
						</variable>
						<variable name="PixelInfo" displayName="metadata.pixel" xsi:type="complexVariableType">
							<variable name="AspectRatio" displayName="metadata.pixel.aspectRatio" xsi:type="stringVariableType" />
							<variable name="BitsPer" displayName="metadata.pixel.bitsPer" xsi:type="integerVariableType" />
							<variable name="HorizontalPixelCount" displayName="metadata.pixel.horizontalPixelCount" xsi:type="integerVariableType" />
							<variable name="VerticalPixelCount" displayName="metadata.pixel.verticalPixelCount" xsi:type="integerVariableType" />
							<variable name="Value" displayName="metadata.pixel.value" xsi:type="stringVariableType" />
						</variable>
					</variable>

					<!-- Identifier -->
					<variable name="Identifier" displayName="metadata.identifier" xsi:type="complexVariableType">
						<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
						<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
						<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" jobParameter="true" />
						<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
						<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
					</variable>					

					<!-- ProductInfo -->
					<variable name="ProductInfo" displayName="metadata.productInfo" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Name" displayName="metadata.productInfo.name" xsi:type="stringVariableType">
							<options>
								<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.ProductOptionProvider</optionProvider>
							</options>
						</variable>
					</variable>
					
					<!-- ProviderInfo -->
					<variable name="ProviderInfo" displayName="metadata.providerInfo" xsi:type="complexVariableType">
						<!-- Let's add it here, but it will be disabled in GUI. Users are not allowed to edit this value. -->
						<variable name="Name" displayName="metadata.providerInfo.name" xsi:type="stringVariableType" />
						<variable name="Identifier" displayName="metadata.providerId" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.providerId" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="ReferenceIdentifier" displayName="metadata.referenceIdentifier" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
					</variable>
			
					<!-- Derived -->
					<variable name="Derived" displayName="metadata.derived" xsi:type="complexVariableType">
						<variable name="SourceAssetId" displayName="metadata.derived.sourceassetid" xsi:type="stringVariableType" />
						<variable name="SourceProviderId" displayName="metadata.derived.sourceproviderid" xsi:type="stringVariableType" />
					</variable>

					<!-- EquipCapabilityProfileList -->
					<variable name="EquipCapabilityProfileList" displayName="metadata.equipCapabilityProfileList" xsi:type="complexVariableType" showCollapsed="false">
						<variable name="EquipCapabilityProfile" displayName="metadata.equipCapabilityProfile" xsi:type="stringVariableType" multiValue="true" />
					</variable>

					<!-- Rating -->										
					<variable name="Rating" displayName="metadata.rating" xsi:type="complexVariableType">
						<variable name="RatingValues" displayName="metadata.rating" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="RatingValue" displayName="metadata.rating.value" xsi:type="complexVariableType" multiValue="true">
								<variable name="System" displayName="metadata.rating.system" xsi:type="stringVariableType">
									<options>
										<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.RatingSystemOptionProvider</optionProvider>
									</options>
								</variable>
								<variable name="Value" displayName="metadata.rating.value" xsi:type="stringVariableType">
									<options>
										<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.RatingOptionProvider</optionProvider>
									</options>
								</variable>
							</variable>
						</variable>
						<variable name="ContentAdvisories" displayName="metadata.rating.advisories" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="ContentAdvisory" displayName="metadata.rating.advisory" xsi:type="stringVariableType" multiValue="true">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.ContentAdvisoryOptionProvider</optionProvider>
								</options>
							</variable>
						</variable>
						<variable name="TargetAudiences" displayName="metadata.rating.audiences" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="TargetAudience" displayName="metadata.rating.audience" xsi:type="stringVariableType" multiValue="true"/>
						</variable>
						<variable name="MSORatings" displayName="metadata.rating.msos" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="MSORating" displayName="metadata.rating.mso" xsi:type="stringVariableType" multiValue="true"/>
						</variable>
						<variable name="Labels" displayName="metadata.rating.labels" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="Label" displayName="metadata.rating.label" xsi:type="stringVariableType" multiValue="true"/>
						</variable>
					</variable>

					<!-- Version -->
					<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
						<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
						<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
						<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
					</variable>

					<!-- Video -->
					<variable name="Video" displayName="metadata.video" xsi:type="complexVariableType">
						<variable name="AspectRatio" displayName="metadata.video.aspectRatio" xsi:type="stringVariableType" />
						<variable name="ScreenFormat" displayName="metadata.video.screenFormat" xsi:type="stringVariableType" />
						<variable name="HDContent" displayName="metadata.video.hdContent" xsi:type="booleanVariableType" >
							<options>
								<option name="metadata.booleanOptionName.true">true</option>
								<option name="metadata.booleanOptionName.false">false</option>
							</options>
						</variable>
						<variable name="BitRate" displayName="metadata.video.bitrate" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="value" displayName="metadata.video.bitrate.value" xsi:type="integerVariableType" attribute="true" />
						</variable>
						<variable name="AudioInfos" displayName="metadata.audioInfo" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="AudioInfo" displayName="metadata.audioInfo" xsi:type="complexVariableType" multiValue="true">
								<variable name="ChannelCount" displayName="metadata.audioInfo.channelCount" xsi:type="integerVariableType" />
								<variable name="Preffered" displayName="metadata.audioInfo.preffered" xsi:type="stringVariableType" />
								<variable name="Value" displayName="metadata.type" xsi:type="stringVariableType" />
								<variable name="DefaultTrack" displayName="metadata.audioInfo.defaultTrack" xsi:type="booleanVariableType" />
								<variable name="ContainsDesc" displayName="metadata.audioInfo.containsDesc" xsi:type="booleanVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="PID" displayName="metadata.audioInfo.pid" xsi:type="stringVariableType" />
								<variable name="Codec" displayName="metadata.audioInfo.codec" xsi:type="stringVariableType" />
							</variable>
						</variable>
						<variable name="PrivatePid" displayName="metadata.video.privatePid" xsi:type="stringVariableType" />
						<variable name="PreEncryptionInfo" displayName="metadata.preEncryptionInfo" xsi:type="complexVariableType">
							<variable name="DerivedFrom" displayName="metadata.preEncryptionInfo.derivedFrom" xsi:type="complexVariableType" >
								<variable name="ProviderInfo" displayName="metadata.providerInfo" xsi:type="complexVariableType">
									<!-- Let's add it here, but it will be disabled in GUI. Users are not allowed to edit this value. -->
									<variable name="Name" displayName="metadata.providerInfo.name" xsi:type="stringVariableType" />
									<variable name="Identifier" displayName="metadata.providerId" xsi:type="complexVariableType">
										<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
										<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
										<variable name="Id" displayName="metadata.providerId" xsi:type="stringVariableType" />
										<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
										<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
										<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
											<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
											<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
											<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
											<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
											<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
											<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
											<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
											<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
												<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
												<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
													<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
												</variable>
											</variable>
										</variable>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="ReferenceIdentifier" displayName="metadata.referenceIdentifier" xsi:type="complexVariableType">
										<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
										<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
										<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
										<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
										<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
										<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
											<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
											<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
											<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
											<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
											<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
											<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
											<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
											<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
												<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
												<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
													<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
												</variable>
											</variable>
										</variable>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
								</variable>
								<variable name="AssetId" displayName="metadata.identifier" xsi:type="complexVariableType">
									<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
									<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
									<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
									<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
									<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>					
								<variable name="Start" displayName="metadata.start" xsi:type="timeVariableType" />
								<variable name="End" displayName="metadata.end" xsi:type="timeVariableType" />
								<variable name="AmsValidate" displayName="metadata.image.amsValidate" xsi:type="booleanVariableType" />
								<variable name="ResumeViewAllowed" displayName="metadata.image.resumeViewAllowed" xsi:type="booleanVariableType" />
								<variable name="TrickModeRestrictions" displayName="metadata.trickModeRestrictions" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="TrickModeRestriction" displayName="metadata.trickModeRestrictions" xsi:type="stringVariableType" multiValue="true"/>
								</variable>
							</variable>
							<variable name="EncryptionDate" displayName="metadata.preEncryptionInfo.encryptionDate" xsi:type="dateVariableType" />
							<variable name="FormatAuthority" displayName="metadata.preEncryptionInfo.formatAuthority" xsi:type="stringVariableType" />
							<variable name="TargetVersion" displayName="metadata.preEncryptionInfo.targetVersion" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
								<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
								<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
							</variable>
							<variable name="EncryptionInfo" displayName="metadata.encryption" xsi:type="complexVariableType" >
								<variable name="Asset" displayName="metadata.encryption.asset" xsi:type="complexVariableType">
									<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
									<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
									<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
									<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
									<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>						
								<variable name="Value" displayName="metadata.encryption.value" xsi:type="booleanVariableType" />
								<variable name="Algorithm" displayName="metadata.encryption.algorithm" xsi:type="stringVariableType" />
								<variable name="Date" displayName="metadata.encryption.date" xsi:type="dateVariableType" />
								<variable name="SystemInfo" displayName="metadata.encryption.systemInfo" xsi:type="stringVariableType" />
								<variable name="KeyBlock" displayName="metadata.encryption.keyBlock" xsi:type="stringVariableType" longFormat="true" />
								<variable name="Type" displayName="metadata.encryption.type" xsi:type="stringVariableType" />
								<variable name="Time" displayName="metadata.encryption.time" xsi:type="timeVariableType" />
								<variable name="EncryptionClass" displayName="metadata.encryption.class" xsi:type="stringVariableType" />					
							</variable>
						</variable>
						<variable name="StreamFormat" displayName="metadata.video.streamFormat" xsi:type="stringVariableType" />
						<variable name="ThreeDContent" displayName="metadata.video.3dContent" xsi:type="booleanVariableType" />
						<variable name="AVContainer" displayName="metadata.video.avContainer" xsi:type="stringVariableType" />
						<variable name="AlternateBitRateResolutionList" displayName="metadata.video.alternateBitRateResolutionList" xsi:type="complexVariableType" showCollapsed="false">
							<variable name="AlternateBitRateResolution" displayName="metadata.video.alternateBitRateResolution" xsi:type="stringVariableType" multiValue="true"/>
						</variable>	
					</variable>
					
					<!-- Languages -->
					<variable name="Languages" displayName="metadata.Languages" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true" multiValue="true" >
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true"/>
						</variable>
					</variable>
					
				</metadata>
			</title>


			<!--
				The Box Cover Title Item 
			-->
			<title>
				<name>BOXCOVER</name>
				<alias>boxcover.sectionName</alias>
				<metadata>
					<!-- ======================= Simple Fields ========================== -->
					<variable name="AssetClass" displayName="metadata.assetClass" xsi:type="stringVariableType">
						<options>
							<option name="metadata.assetClass.optionName.boxCover">box cover</option>
						</options>
					</variable>
					<variable name="AssetName" displayName="metadata.assetName" xsi:type="stringVariableType"/>
					<variable name="Verb" displayName="metadata.verb" xsi:type="stringVariableType" />
					
					<!-- ======================= Complex Fields ========================== -->
					
					<!-- ApplicationInfo -->					
					<variable name="ApplicationInfo" displayName="metadata.applicationInfo" xsi:type="complexVariableType" showCollapsed="true" >
						<variable name="Name" displayName="metadata.applicationInfo.name" xsi:type="stringVariableType">
							<options>
								<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.AppTypeOptionProvider</optionProvider>
							</options>	
						</variable>
					</variable>
					
					<!-- Content -->
					<variable name="Content" displayName="metadata.content" xsi:type="complexVariableType">
						<variable name="Expression" displayName="metadata.content.expression" xsi:type="stringVariableType"/>
						<variable name="Default" displayName="metadata.content.default" xsi:type="stringVariableType"/>
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="Size" displayName="metadata.size" xsi:type="complexVariableType" >
							<variable name="length" displayName="metadata.size.length" xsi:type="integerVariableType" />
							<variable name="height" displayName="metadata.size.height" xsi:type="integerVariableType" />
							<variable name="width" displayName="metadata.size.width" xsi:type="integerVariableType" />
						</variable>
						<variable name="Checksum" displayName="metadata.content.checkSum" xsi:type="stringVariableType" />
						<variable name="Medium" displayName="metadata.medium" xsi:type="complexVariableType" >
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="MIMEType" displayName="metadata.content.mimeType" xsi:type="stringVariableType"/>
						<variable name="Resolution" displayName="metadata.content.resolution" xsi:type="stringVariableType"/>
						<variable name="FrameRate" displayName="metadata.content.frameRate" xsi:type="stringVariableType"/>
						<variable name="Codec" displayName="metadata.content.codec" xsi:type="stringVariableType"/>
						<variable name="WasPitched" displayName="metadata.content.wasPitched" xsi:type="booleanVariableType"/>
						<variable name="LastPitchDate" displayName="metadata.content.lastPitchDate" xsi:type="dateVariableType"/>
						<variable name="PitchedFilename" displayName="metadata.content.pitchedFilename" xsi:type="stringVariableType"/>
						<variable name="SizeInBytes" displayName="metadata.content.sizeInBytes" xsi:type="integerVariableType"/>
						<variable name="Type" displayName="metadata.content.type" xsi:type="stringVariableType"/>
						<variable name="NetworkType" displayName="metadata.content.networkType" xsi:type="stringVariableType"/>
						<variable name="PlayReady" displayName="metadata.content.playReady" xsi:type="booleanVariableType"/>
						<variable name="WebInitiatorUrl" displayName="metadata.content.webInitiatorUri" xsi:type="stringVariableType"/>
						<variable name="LicenseServerProxyUrl" displayName="metadata.content.licenseServerProxyUrl" xsi:type="stringVariableType"/>
					</variable>
					
					<!-- Creation Info -->
					<variable name="CreationInfo" displayName="metadata.creationInfo" xsi:type="complexVariableType">
						<variable name="Title" displayName="metadata.title" xsi:type="complexVariableType">
							<variable name="OriginalTitle" displayName="metadata.title.original" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.original.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="DisplayTitle" displayName="metadata.title.display" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.display.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="SortTitle" displayName="metadata.title.sort" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.sort.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="ShortTitle" displayName="metadata.title.short" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.short.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="FeatureTitle" displayName="metadata.title.feature" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.feature.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
						</variable>					
						<variable name="Description" displayName="metadata.description" xsi:type="stringVariableType" longFormat="true" />
						<variable name="Sources" displayName="metadata.source" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="Source" displayName="metadata.source" xsi:type="complexVariableType" multiValue="true">
								<variable name="Role" displayName="metadata.source.role" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="Name" displayName="metadata.source.role.name" xsi:type="stringVariableType">
										<options>
											<option name="metadata.source.role.name.optionName.actor">ACTOR</option>
											<option name="metadata.source.role.name.optionName.author">AUTHOR</option>
											<option name="metadata.source.role.name.optionName.creator">CREATOR</option>
											<option name="metadata.source.role.name.optionName.director">DIRECTOR</option>
											<option name="metadata.source.role.name.optionName.executiveproducer">EXECUTIVEPRODUCER</option>
											<option name="metadata.source.role.name.optionName.host">HOST</option>
											<option name="metadata.source.role.name.optionName.gueststar">GUESTSTAR</option>
											<option name="metadata.source.role.name.optionName.organization">ORGANIZATION</option>
											<option name="metadata.source.role.name.optionName.producer">PRODUCER</option>
											<option name="metadata.source.role.name.optionName.publisher">PUBLISHER</option>
											<option name="metadata.source.role.name.optionName.writer">WRITER</option>
										</options>
									</variable>
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="value" displayName="metadata.source.role.value" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="Contact" displayName="metadata.contact" xsi:type="complexVariableType">
									<variable name="FirstName" displayName="metadata.contact.firstName" xsi:type="stringVariableType" />
									<variable name="LastName" displayName="metadata.contact.lastName" xsi:type="stringVariableType" />
									<variable name="MiddleName" displayName="metadata.contact.middleName" xsi:type="stringVariableType" />
									<variable name="Email" displayName="metadata.contact.email" xsi:type="stringVariableType" />
									<variable name="Address" displayName="metadata.address" xsi:type="complexVariableType">
										<variable name="Line1" displayName="metadata.address.line1" xsi:type="stringVariableType" />
										<variable name="Line2" displayName="metadata.address.line2" xsi:type="stringVariableType" />
										<variable name="Zip" displayName="metadata.address.zip" xsi:type="stringVariableType" />
										<variable name="Place" displayName="metadata.place" xsi:type="complexVariableType" showCollapsed="true" >
											<variable name="Region" displayName="metadata.place.region" xsi:type="stringVariableType" />
											<variable name="Country" displayName="metadata.place.country" xsi:type="stringVariableType" />
											<variable name="Coordiantes" displayName="metadata.place.coordinates" xsi:type="stringVariableType" />
										</variable>
									</variable>
									<variable name="DisplayName" displayName="metadata.contact.displayName" xsi:type="stringVariableType" />
								</variable>
								<variable name="CharacterName" displayName="metadata.source.CharacterName" xsi:type="stringVariableType" />
								<variable name="Popularity" displayName="metadata.source.Popularity" xsi:type="integerVariableType" />
							</variable>
						</variable>
						<variable name="CreateDate" displayName="metadata.creationInfo.createDate" xsi:type="dateVariableType" />
						<variable name="UpdateDate" displayName="metadata.creationInfo.updateDate" xsi:type="dateVariableType" />
						<variable name="Place" displayName="metadata.creationInfo.place" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="Region" displayName="metadata.creationInfo.place.region" xsi:type="stringVariableType" />
							<variable name="Country" displayName="metadata.creationInfo.place.country" xsi:type="stringVariableType" />
							<variable name="Coordiantes" displayName="metadata.creationInfo.place.coordinates" xsi:type="stringVariableType" />
						</variable>
						<variable name="Tool" displayName="metadata.tool" xsi:type="complexVariableType" >
							<variable name="Name" displayName="metadata.creationInfo.studio.name" xsi:type="stringVariableType" />
							<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
								<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
								<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
							</variable>
							<variable name="ToolSettings" displayName="metadata.tool.settings" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="ToolSetting" displayName="metadata.tool.setting" xsi:type="complexVariableType" multiValue="true">
									<variable name="Name" displayName="metadata.name" xsi:type="stringVariableType" />
									<variable name="Value" displayName="metadata.value" xsi:type="stringVariableType" />
								</variable>
							</variable>
						</variable>
						<variable name="PublicationDate" displayName="metadata.creationInfo.publicationDate" xsi:type="integerVariableType"  />
						<variable name="Studio" displayName="metadata.creationInfo.studio" xsi:type="complexVariableType" >
							<variable name="DisplayName" displayName="metadata.creationInfo.studio.displayName" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="Name" displayName="metadata.creationInfo.studio.name" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOrgNameOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="Code" displayName="metadata.creationInfo.studio.code" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOrgCodeOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="RoyaltyInfo" displayName="metadata.creationInfo.studio.royalty" xsi:type="complexVariableType" showCollapsed="true" >
								<variable name="RoyaltyPercent" displayName="metadata.creationInfo.studio.royalty.percent" xsi:type="floatVariableType"  />
								<variable name="RoyaltyMinimum" displayName="metadata.creationInfo.studio.royalty.minimum" xsi:type="floatVariableType"  />
								<variable name="RoyaltyFlatRate" displayName="metadata.creationInfo.studio.royalty.flatRate" xsi:type="floatVariableType"  />
							</variable>
						</variable>
					</variable>

					<!-- Description -->
					<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
						<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
						</variable>
					</variable>

					<!-- Image -->
					<variable name="Image" displayName="metadata.image" xsi:type="complexVariableType" >
						<variable name="AspectRatio" displayName="metadata.image.aspectRatio" xsi:type="stringVariableType"/>
						<variable name="ContentPointer" displayName="metadata.contentPointer" xsi:type="complexVariableType" >
							<variable name="ProviderInfo" displayName="metadata.providerInfo" xsi:type="complexVariableType">
								<!-- Let's add it here, but it will be disabled in GUI. Users are not allowed to edit this value. -->
								<variable name="Name" displayName="metadata.providerInfo.name" xsi:type="stringVariableType" />
								<variable name="Identifier" displayName="metadata.providerId" xsi:type="complexVariableType">
									<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
									<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
									<variable name="Id" displayName="metadata.providerId" xsi:type="stringVariableType" />
									<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
									<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>
								<variable name="ReferenceIdentifier" displayName="metadata.referenceIdentifier" xsi:type="complexVariableType">
									<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
									<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
									<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
									<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
									<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>
							</variable>
							<variable name="AssetId" displayName="metadata.identifier" xsi:type="complexVariableType">
								<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
								<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
								<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
								<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
								<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
								<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
									<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
									<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
									<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
									<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
									<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
									<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
									<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>					
							<variable name="Start" displayName="metadata.start" xsi:type="timeVariableType" />
							<variable name="End" displayName="metadata.end" xsi:type="timeVariableType" />
							<variable name="AmsValidate" displayName="metadata.image.amsValidate" xsi:type="booleanVariableType" />
							<variable name="ResumeViewAllowed" displayName="metadata.image.resumeViewAllowed" xsi:type="booleanVariableType" />
							<variable name="TrickModeRestrictions" displayName="metadata.trickModeRestrictions" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="TrickModeRestriction" displayName="metadata.trickModeRestrictions" xsi:type="stringVariableType" multiValue="true"/>
							</variable>
						</variable>
						<variable name="PixelInfo" displayName="metadata.pixel" xsi:type="complexVariableType">
							<variable name="AspectRatio" displayName="metadata.pixel.aspectRatio" xsi:type="stringVariableType" />
							<variable name="BitsPer" displayName="metadata.pixel.bitsPer" xsi:type="integerVariableType" />
							<variable name="HorizontalPixelCount" displayName="metadata.pixel.horizontalPixelCount" xsi:type="integerVariableType" />
							<variable name="VerticalPixelCount" displayName="metadata.pixel.verticalPixelCount" xsi:type="integerVariableType" />
							<variable name="Value" displayName="metadata.pixel.value" xsi:type="stringVariableType" />
						</variable>
					</variable>
										
					<!-- Identifier -->
					<variable name="Identifier" displayName="metadata.identifier" xsi:type="complexVariableType">
						<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
						<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
						<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" jobParameter="true" />
						<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
						<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
					</variable>
					
					<!-- ProductInfo -->
					<variable name="ProductInfo" displayName="metadata.productInfo" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Name" displayName="metadata.productInfo.name" xsi:type="stringVariableType">
							<options>
								<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.ProductOptionProvider</optionProvider>
							</options>
						</variable>
					</variable>
					
					<!-- ProviderInfo -->
					<variable name="ProviderInfo" displayName="metadata.providerInfo" xsi:type="complexVariableType">
						<!-- Let's add it here, but it will be disabled in GUI. Users are not allowed to edit this value. -->
						<variable name="Name" displayName="metadata.providerInfo.name" xsi:type="stringVariableType" />
						<variable name="Identifier" displayName="metadata.providerId" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.providerId" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="ReferenceIdentifier" displayName="metadata.referenceIdentifier" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
					</variable>

					<!-- Derived -->
					<variable name="Derived" displayName="metadata.derived" xsi:type="complexVariableType">
						<variable name="SourceAssetId" displayName="metadata.derived.sourceassetid" xsi:type="stringVariableType" />
						<variable name="SourceProviderId" displayName="metadata.derived.sourceproviderid" xsi:type="stringVariableType" />
					</variable>

					<!-- EquipCapabilityProfileList -->
					<variable name="EquipCapabilityProfileList" displayName="metadata.equipCapabilityProfileList" xsi:type="complexVariableType" showCollapsed="false">
						<variable name="EquipCapabilityProfile" displayName="metadata.equipCapabilityProfile" xsi:type="stringVariableType" multiValue="true" />
					</variable>

					<!-- Version -->
					<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
						<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
						<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
						<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
					</variable>
					
					<!-- Languages -->
					<variable name="Languages" displayName="metadata.Languages" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true" multiValue="true" >
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true"/>
						</variable>
					</variable>
				</metadata>
			</title>


			<!--
				The TrickFile Title Item 
			-->
			<title>
				<name>TRICK</name>
				<alias>trickfile.sectionName</alias>
				<metadata>
					<!-- ====================== Simple Fields ====================== -->
					
					<variable name="AssetClass" displayName="metadata.assetClass" xsi:type="stringVariableType">
						<options>
							<option name="metadata.assetClass.optionName.trick">trickfile</option>
						</options>
					</variable>
					<variable name="AssetName" displayName="metadata.assetName" xsi:type="stringVariableType"/>
					<variable name="Verb" displayName="metadata.verb" xsi:type="stringVariableType" />
					<variable name="TrickMode" displayName="metadata.trickMode" xsi:type="stringVariableType"/>
					
					<!-- ====================== Complex Fields ====================== -->
					
					<!-- ApplicationInfo -->					
					<variable name="ApplicationInfo" displayName="metadata.applicationInfo" xsi:type="complexVariableType" showCollapsed="true" >
						<variable name="Name" displayName="metadata.applicationInfo.name" xsi:type="stringVariableType">
							<options>
								<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.AppTypeOptionProvider</optionProvider>
							</options>	
						</variable>
					</variable>
					
					<!-- Content -->
					<variable name="Content" displayName="metadata.content" xsi:type="complexVariableType">
						<variable name="Expression" displayName="metadata.content.expression" xsi:type="stringVariableType"/>
						<variable name="Default" displayName="metadata.content.default" xsi:type="stringVariableType"/>
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="Size" displayName="metadata.size" xsi:type="complexVariableType" >
							<variable name="length" displayName="metadata.size.length" xsi:type="integerVariableType" />
							<variable name="height" displayName="metadata.size.height" xsi:type="integerVariableType" />
							<variable name="width" displayName="metadata.size.width" xsi:type="integerVariableType" />
						</variable>
						<variable name="Checksum" displayName="metadata.content.checkSum" xsi:type="stringVariableType" />
						<variable name="Medium" displayName="metadata.medium" xsi:type="complexVariableType" >
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="MIMEType" displayName="metadata.content.mimeType" xsi:type="stringVariableType"/>
						<variable name="Resolution" displayName="metadata.content.resolution" xsi:type="stringVariableType"/>
						<variable name="FrameRate" displayName="metadata.content.frameRate" xsi:type="stringVariableType"/>
						<variable name="Codec" displayName="metadata.content.codec" xsi:type="stringVariableType"/>
						<variable name="WasPitched" displayName="metadata.content.wasPitched" xsi:type="booleanVariableType"/>
						<variable name="LastPitchDate" displayName="metadata.content.lastPitchDate" xsi:type="dateVariableType"/>
						<variable name="PitchedFilename" displayName="metadata.content.pitchedFilename" xsi:type="stringVariableType"/>
						<variable name="SizeInBytes" displayName="metadata.content.sizeInBytes" xsi:type="integerVariableType"/>
						<variable name="Type" displayName="metadata.content.type" xsi:type="stringVariableType"/>
						<variable name="NetworkType" displayName="metadata.content.networkType" xsi:type="stringVariableType"/>
						<variable name="PlayReady" displayName="metadata.content.playReady" xsi:type="booleanVariableType"/>
						<variable name="WebInitiatorUrl" displayName="metadata.content.webInitiatorUri" xsi:type="stringVariableType"/>
						<variable name="LicenseServerProxyUrl" displayName="metadata.content.licenseServerProxyUrl" xsi:type="stringVariableType"/>
					</variable>

					<!-- Creation Info -->
					<variable name="CreationInfo" displayName="metadata.creationInfo" xsi:type="complexVariableType">
						<variable name="Title" displayName="metadata.title" xsi:type="complexVariableType">
							<variable name="OriginalTitle" displayName="metadata.title.original" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.original.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="DisplayTitle" displayName="metadata.title.display" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.display.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="SortTitle" displayName="metadata.title.sort" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.sort.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="ShortTitle" displayName="metadata.title.short" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.short.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="FeatureTitle" displayName="metadata.title.feature" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.feature.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
						</variable>					
						<variable name="Description" displayName="metadata.description" xsi:type="stringVariableType" longFormat="true" />
						<variable name="Sources" displayName="metadata.source" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="Source" displayName="metadata.source" xsi:type="complexVariableType" multiValue="true">
								<variable name="Role" displayName="metadata.source.role" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="Name" displayName="metadata.source.role.name" xsi:type="stringVariableType">
										<options>
											<option name="metadata.source.role.name.optionName.actor">ACTOR</option>
											<option name="metadata.source.role.name.optionName.author">AUTHOR</option>
											<option name="metadata.source.role.name.optionName.creator">CREATOR</option>
											<option name="metadata.source.role.name.optionName.director">DIRECTOR</option>
											<option name="metadata.source.role.name.optionName.executiveproducer">EXECUTIVEPRODUCER</option>
											<option name="metadata.source.role.name.optionName.host">HOST</option>
											<option name="metadata.source.role.name.optionName.gueststar">GUESTSTAR</option>
											<option name="metadata.source.role.name.optionName.organization">ORGANIZATION</option>
											<option name="metadata.source.role.name.optionName.producer">PRODUCER</option>
											<option name="metadata.source.role.name.optionName.publisher">PUBLISHER</option>
											<option name="metadata.source.role.name.optionName.writer">WRITER</option>
										</options>
									</variable>
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="value" displayName="metadata.source.role.value" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="Contact" displayName="metadata.contact" xsi:type="complexVariableType">
									<variable name="FirstName" displayName="metadata.contact.firstName" xsi:type="stringVariableType" />
									<variable name="LastName" displayName="metadata.contact.lastName" xsi:type="stringVariableType" />
									<variable name="MiddleName" displayName="metadata.contact.middleName" xsi:type="stringVariableType" />
									<variable name="Email" displayName="metadata.contact.email" xsi:type="stringVariableType" />
									<variable name="Address" displayName="metadata.address" xsi:type="complexVariableType">
										<variable name="Line1" displayName="metadata.address.line1" xsi:type="stringVariableType" />
										<variable name="Line2" displayName="metadata.address.line2" xsi:type="stringVariableType" />
										<variable name="Zip" displayName="metadata.address.zip" xsi:type="stringVariableType" />
										<variable name="Place" displayName="metadata.place" xsi:type="complexVariableType" showCollapsed="true" >
											<variable name="Region" displayName="metadata.place.region" xsi:type="stringVariableType" />
											<variable name="Country" displayName="metadata.place.country" xsi:type="stringVariableType" />
											<variable name="Coordiantes" displayName="metadata.place.coordinates" xsi:type="stringVariableType" />
										</variable>
									</variable>
									<variable name="DisplayName" displayName="metadata.contact.displayName" xsi:type="stringVariableType" />
								</variable>
								<variable name="CharacterName" displayName="metadata.source.CharacterName" xsi:type="stringVariableType" />
								<variable name="Popularity" displayName="metadata.source.Popularity" xsi:type="integerVariableType" />
							</variable>
						</variable>
						<variable name="CreateDate" displayName="metadata.creationInfo.createDate" xsi:type="dateVariableType" />
						<variable name="UpdateDate" displayName="metadata.creationInfo.updateDate" xsi:type="dateVariableType" />
						<variable name="Place" displayName="metadata.creationInfo.place" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="Region" displayName="metadata.creationInfo.place.region" xsi:type="stringVariableType" />
							<variable name="Country" displayName="metadata.creationInfo.place.country" xsi:type="stringVariableType" />
							<variable name="Coordiantes" displayName="metadata.creationInfo.place.coordinates" xsi:type="stringVariableType" />
						</variable>
						<variable name="Tool" displayName="metadata.tool" xsi:type="complexVariableType" >
							<variable name="Name" displayName="metadata.creationInfo.studio.name" xsi:type="stringVariableType" />
							<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
								<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
								<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
							</variable>
							<variable name="ToolSettings" displayName="metadata.tool.settings" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="ToolSetting" displayName="metadata.tool.setting" xsi:type="complexVariableType" multiValue="true">
									<variable name="Name" displayName="metadata.name" xsi:type="stringVariableType" />
									<variable name="Value" displayName="metadata.value" xsi:type="stringVariableType" />
								</variable>
							</variable>
						</variable>
						<variable name="PublicationDate" displayName="metadata.creationInfo.publicationDate" xsi:type="integerVariableType"  />
						<variable name="Studio" displayName="metadata.creationInfo.studio" xsi:type="complexVariableType" >
							<variable name="DisplayName" displayName="metadata.creationInfo.studio.displayName" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="Name" displayName="metadata.creationInfo.studio.name" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOrgNameOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="Code" displayName="metadata.creationInfo.studio.code" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOrgCodeOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="RoyaltyInfo" displayName="metadata.creationInfo.studio.royalty" xsi:type="complexVariableType" showCollapsed="true" >
								<variable name="RoyaltyPercent" displayName="metadata.creationInfo.studio.royalty.percent" xsi:type="floatVariableType"  />
								<variable name="RoyaltyMinimum" displayName="metadata.creationInfo.studio.royalty.minimum" xsi:type="floatVariableType"  />
								<variable name="RoyaltyFlatRate" displayName="metadata.creationInfo.studio.royalty.flatRate" xsi:type="floatVariableType"  />
							</variable>
						</variable>
					</variable>
					
					<!-- Description -->
					<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
						<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
						</variable>
					</variable>

					<!-- Duration -->
					<variable name="Duration" displayName="metadata.duration" xsi:type="complexVariableType">
						<variable name="DisplayDuration" displayName="metadata.duration.display" xsi:type="stringVariableType" />
						<variable name="StartOffset" displayName="metadata.duration.startOffset" xsi:type="timeVariableType" />
						<variable name="Duration" displayName="metadata.duration.value" xsi:type="timeVariableType" jobParameter="true" />
					</variable>

					<!-- Identifier -->
					<variable name="Identifier" displayName="metadata.identifier" xsi:type="complexVariableType">
						<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
						<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
						<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
						<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
						<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
					</variable>					

					<!-- ProductInfo -->
					<variable name="ProductInfo" displayName="metadata.productInfo" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Name" displayName="metadata.productInfo.name" xsi:type="stringVariableType">
							<options>
								<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.ProductOptionProvider</optionProvider>
							</options>
						</variable>
					</variable>

					<!-- ProviderInfo -->
					<variable name="ProviderInfo" displayName="metadata.providerInfo" xsi:type="complexVariableType">
						<!-- Let's add it here, but it will be disabled in GUI. Users are not allowed to edit this value. -->
						<variable name="Name" displayName="metadata.providerInfo.name" xsi:type="stringVariableType" />
						<variable name="Identifier" displayName="metadata.providerId" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.providerId" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="ReferenceIdentifier" displayName="metadata.referenceIdentifier" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
					</variable>

					<!-- Vendor -->
					<variable name="Vendor" displayName="metadata.vendor" xsi:type="complexVariableType">
						<variable name="Name" displayName="metadata.vendor.name" xsi:type="stringVariableType" />
						<variable name="Product" displayName="metadata.vendor.product" xsi:type="stringVariableType" />
						<variable name="ForVersion" displayName="metadata.vendor.forVersion" xsi:type="stringVariableType" />
					</variable>

					<!-- Version -->
					<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
						<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
						<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
						<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
					</variable>

					<!-- Video -->
					<variable name="Video" displayName="metadata.video" xsi:type="complexVariableType">
						<variable name="AspectRatio" displayName="metadata.video.aspectRatio" xsi:type="stringVariableType" />
						<variable name="ScreenFormat" displayName="metadata.video.screenFormat" xsi:type="stringVariableType" />
						<variable name="HDContent" displayName="metadata.video.hdContent" xsi:type="booleanVariableType" >
							<options>
								<option name="metadata.booleanOptionName.true">true</option>
								<option name="metadata.booleanOptionName.false">false</option>
							</options>
						</variable>
						<variable name="BitRate" displayName="metadata.video.bitrate" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="value" displayName="metadata.video.bitrate.value" xsi:type="integerVariableType" attribute="true" />
						</variable>
						<variable name="AudioInfos" displayName="metadata.audioInfo" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="AudioInfo" displayName="metadata.audioInfo" xsi:type="complexVariableType" multiValue="true">
								<variable name="ChannelCount" displayName="metadata.audioInfo.channelCount" xsi:type="integerVariableType" />
								<variable name="Preffered" displayName="metadata.audioInfo.preffered" xsi:type="stringVariableType" />
								<variable name="Value" displayName="metadata.type" xsi:type="stringVariableType" />
								<variable name="DefaultTrack" displayName="metadata.audioInfo.defaultTrack" xsi:type="booleanVariableType" />
								<variable name="ContainsDesc" displayName="metadata.audioInfo.containsDesc" xsi:type="booleanVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="PID" displayName="metadata.audioInfo.pid" xsi:type="stringVariableType" />
								<variable name="Codec" displayName="metadata.audioInfo.codec" xsi:type="stringVariableType" />
							</variable>
						</variable>
						<variable name="PrivatePid" displayName="metadata.video.privatePid" xsi:type="stringVariableType" />
						<variable name="PreEncryptionInfo" displayName="metadata.preEncryptionInfo" xsi:type="complexVariableType">
							<variable name="DerivedFrom" displayName="metadata.preEncryptionInfo.derivedFrom" xsi:type="complexVariableType" >
								<variable name="ProviderInfo" displayName="metadata.providerInfo" xsi:type="complexVariableType">
									<!-- Let's add it here, but it will be disabled in GUI. Users are not allowed to edit this value. -->
									<variable name="Name" displayName="metadata.providerInfo.name" xsi:type="stringVariableType" />
									<variable name="Identifier" displayName="metadata.providerId" xsi:type="complexVariableType">
										<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
										<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
										<variable name="Id" displayName="metadata.providerId" xsi:type="stringVariableType" />
										<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
										<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
										<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
											<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
											<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
											<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
											<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
											<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
											<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
											<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
											<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
												<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
												<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
													<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
												</variable>
											</variable>
										</variable>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="ReferenceIdentifier" displayName="metadata.referenceIdentifier" xsi:type="complexVariableType">
										<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
										<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
										<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
										<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
										<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
										<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
											<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
											<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
											<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
											<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
											<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
											<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
											<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
											<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
												<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
												<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
													<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
												</variable>
											</variable>
										</variable>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
								</variable>
								<variable name="AssetId" displayName="metadata.identifier" xsi:type="complexVariableType">
									<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
									<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
									<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
									<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
									<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>					
								<variable name="Start" displayName="metadata.start" xsi:type="timeVariableType" />
								<variable name="End" displayName="metadata.end" xsi:type="timeVariableType" />
								<variable name="AmsValidate" displayName="metadata.image.amsValidate" xsi:type="booleanVariableType" />
								<variable name="ResumeViewAllowed" displayName="metadata.image.resumeViewAllowed" xsi:type="booleanVariableType" />
								<variable name="TrickModeRestrictions" displayName="metadata.trickModeRestrictions" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="TrickModeRestriction" displayName="metadata.trickModeRestrictions" xsi:type="stringVariableType" multiValue="true"/>
								</variable>
							</variable>
							<variable name="EncryptionDate" displayName="metadata.preEncryptionInfo.encryptionDate" xsi:type="dateVariableType" />
							<variable name="FormatAuthority" displayName="metadata.preEncryptionInfo.formatAuthority" xsi:type="stringVariableType" />
							<variable name="TargetVersion" displayName="metadata.preEncryptionInfo.targetVersion" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
								<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
								<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
							</variable>
							<variable name="EncryptionInfo" displayName="metadata.encryption" xsi:type="complexVariableType" >
								<variable name="Asset" displayName="metadata.encryption.asset" xsi:type="complexVariableType">
									<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
									<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
									<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
									<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
									<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>						
								<variable name="Value" displayName="metadata.encryption.value" xsi:type="booleanVariableType" />
								<variable name="Algorithm" displayName="metadata.encryption.algorithm" xsi:type="stringVariableType" />
								<variable name="Date" displayName="metadata.encryption.date" xsi:type="dateVariableType" />
								<variable name="SystemInfo" displayName="metadata.encryption.systemInfo" xsi:type="stringVariableType" />
								<variable name="KeyBlock" displayName="metadata.encryption.keyBlock" xsi:type="stringVariableType" longFormat="true" />
								<variable name="Type" displayName="metadata.encryption.type" xsi:type="stringVariableType" />
								<variable name="Time" displayName="metadata.encryption.time" xsi:type="timeVariableType" />
								<variable name="EncryptionClass" displayName="metadata.encryption.class" xsi:type="stringVariableType" />					
							</variable>
						</variable>
						<variable name="StreamFormat" displayName="metadata.video.streamFormat" xsi:type="stringVariableType" />
						<variable name="ThreeDContent" displayName="metadata.video.3dContent" xsi:type="booleanVariableType" />
						<variable name="AVContainer" displayName="metadata.video.avContainer" xsi:type="stringVariableType" />
						<variable name="AlternateBitRateResolutionList" displayName="metadata.video.alternateBitRateResolutionList" xsi:type="complexVariableType" showCollapsed="false">
							<variable name="AlternateBitRateResolution" displayName="metadata.video.alternateBitRateResolution" xsi:type="stringVariableType" multiValue="true"/>
						</variable>	
					</variable>

				</metadata>
			</title>


			<!--
				The Barker Title Item 
			-->
			<title>
				<name>BARKER</name>
				<alias>barker.sectionName</alias>
				<metadata>
					<!-- ====================== Simple Fields ====================== -->
					<variable name="AssetClass" displayName="metadata.assetClass" xsi:type="stringVariableType">
						<options>
							<option name="metadata.assetClass.optionName.barker">barker</option>
						</options>
					</variable>
					<variable name="AssetName" displayName="metadata.assetName" xsi:type="stringVariableType"/>
					<variable name="Verb" displayName="metadata.verb" xsi:type="stringVariableType" />

					<!-- ====================== Complex Fields ====================== -->
					
					<!-- ApplicationInfo -->					
					<variable name="ApplicationInfo" displayName="metadata.applicationInfo" xsi:type="complexVariableType" showCollapsed="true" >
						<variable name="Name" displayName="metadata.applicationInfo.name" xsi:type="stringVariableType">
							<options>
								<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.AppTypeOptionProvider</optionProvider>
							</options>	
						</variable>
					</variable>
					
					<!-- Content -->
					<variable name="Content" displayName="metadata.content" xsi:type="complexVariableType">
						<variable name="Expression" displayName="metadata.content.expression" xsi:type="stringVariableType"/>
						<variable name="Default" displayName="metadata.content.default" xsi:type="stringVariableType"/>
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="Size" displayName="metadata.size" xsi:type="complexVariableType" >
							<variable name="length" displayName="metadata.size.length" xsi:type="integerVariableType" />
							<variable name="height" displayName="metadata.size.height" xsi:type="integerVariableType" />
							<variable name="width" displayName="metadata.size.width" xsi:type="integerVariableType" />
						</variable>
						<variable name="Checksum" displayName="metadata.content.checkSum" xsi:type="stringVariableType" />
						<variable name="Medium" displayName="metadata.medium" xsi:type="complexVariableType" >
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="MIMEType" displayName="metadata.content.mimeType" xsi:type="stringVariableType"/>
						<variable name="Resolution" displayName="metadata.content.resolution" xsi:type="stringVariableType"/>
						<variable name="FrameRate" displayName="metadata.content.frameRate" xsi:type="stringVariableType"/>
						<variable name="Codec" displayName="metadata.content.codec" xsi:type="stringVariableType"/>
						<variable name="WasPitched" displayName="metadata.content.wasPitched" xsi:type="booleanVariableType"/>
						<variable name="LastPitchDate" displayName="metadata.content.lastPitchDate" xsi:type="dateVariableType"/>
						<variable name="PitchedFilename" displayName="metadata.content.pitchedFilename" xsi:type="stringVariableType"/>
						<variable name="SizeInBytes" displayName="metadata.content.sizeInBytes" xsi:type="integerVariableType"/>
						<variable name="Type" displayName="metadata.content.type" xsi:type="stringVariableType"/>
						<variable name="NetworkType" displayName="metadata.content.networkType" xsi:type="stringVariableType"/>
						<variable name="PlayReady" displayName="metadata.content.playReady" xsi:type="booleanVariableType"/>
						<variable name="WebInitiatorUrl" displayName="metadata.content.webInitiatorUri" xsi:type="stringVariableType"/>
						<variable name="LicenseServerProxyUrl" displayName="metadata.content.licenseServerProxyUrl" xsi:type="stringVariableType"/>
					</variable>
					
					<!-- Creation Info -->
					<variable name="CreationInfo" displayName="metadata.creationInfo" xsi:type="complexVariableType">
						<variable name="Title" displayName="metadata.title" xsi:type="complexVariableType">
							<variable name="OriginalTitle" displayName="metadata.title.original" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.original.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="DisplayTitle" displayName="metadata.title.display" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.display.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="SortTitle" displayName="metadata.title.sort" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.sort.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="ShortTitle" displayName="metadata.title.short" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.short.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="FeatureTitle" displayName="metadata.title.feature" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.feature.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
						</variable>					
						<variable name="Description" displayName="metadata.description" xsi:type="stringVariableType" longFormat="true" />
						<variable name="Sources" displayName="metadata.source" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="Source" displayName="metadata.source" xsi:type="complexVariableType" multiValue="true">
								<variable name="Role" displayName="metadata.source.role" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="Name" displayName="metadata.source.role.name" xsi:type="stringVariableType">
										<options>
											<option name="metadata.source.role.name.optionName.actor">ACTOR</option>
											<option name="metadata.source.role.name.optionName.author">AUTHOR</option>
											<option name="metadata.source.role.name.optionName.creator">CREATOR</option>
											<option name="metadata.source.role.name.optionName.director">DIRECTOR</option>
											<option name="metadata.source.role.name.optionName.executiveproducer">EXECUTIVEPRODUCER</option>
											<option name="metadata.source.role.name.optionName.host">HOST</option>
											<option name="metadata.source.role.name.optionName.gueststar">GUESTSTAR</option>
											<option name="metadata.source.role.name.optionName.organization">ORGANIZATION</option>
											<option name="metadata.source.role.name.optionName.producer">PRODUCER</option>
											<option name="metadata.source.role.name.optionName.publisher">PUBLISHER</option>
											<option name="metadata.source.role.name.optionName.writer">WRITER</option>
										</options>
									</variable>
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="value" displayName="metadata.source.role.value" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="Contact" displayName="metadata.contact" xsi:type="complexVariableType">
									<variable name="FirstName" displayName="metadata.contact.firstName" xsi:type="stringVariableType" />
									<variable name="LastName" displayName="metadata.contact.lastName" xsi:type="stringVariableType" />
									<variable name="MiddleName" displayName="metadata.contact.middleName" xsi:type="stringVariableType" />
									<variable name="Email" displayName="metadata.contact.email" xsi:type="stringVariableType" />
									<variable name="Address" displayName="metadata.address" xsi:type="complexVariableType">
										<variable name="Line1" displayName="metadata.address.line1" xsi:type="stringVariableType" />
										<variable name="Line2" displayName="metadata.address.line2" xsi:type="stringVariableType" />
										<variable name="Zip" displayName="metadata.address.zip" xsi:type="stringVariableType" />
										<variable name="Place" displayName="metadata.place" xsi:type="complexVariableType" showCollapsed="true" >
											<variable name="Region" displayName="metadata.place.region" xsi:type="stringVariableType" />
											<variable name="Country" displayName="metadata.place.country" xsi:type="stringVariableType" />
											<variable name="Coordiantes" displayName="metadata.place.coordinates" xsi:type="stringVariableType" />
										</variable>
									</variable>
									<variable name="DisplayName" displayName="metadata.contact.displayName" xsi:type="stringVariableType" />
								</variable>
								<variable name="CharacterName" displayName="metadata.source.CharacterName" xsi:type="stringVariableType" />
								<variable name="Popularity" displayName="metadata.source.Popularity" xsi:type="integerVariableType" />
							</variable>
						</variable>
						<variable name="CreateDate" displayName="metadata.creationInfo.createDate" xsi:type="dateVariableType" />
						<variable name="UpdateDate" displayName="metadata.creationInfo.updateDate" xsi:type="dateVariableType" />
						<variable name="Place" displayName="metadata.creationInfo.place" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="Region" displayName="metadata.creationInfo.place.region" xsi:type="stringVariableType" />
							<variable name="Country" displayName="metadata.creationInfo.place.country" xsi:type="stringVariableType" />
							<variable name="Coordiantes" displayName="metadata.creationInfo.place.coordinates" xsi:type="stringVariableType" />
						</variable>
						<variable name="Tool" displayName="metadata.tool" xsi:type="complexVariableType" >
							<variable name="Name" displayName="metadata.creationInfo.studio.name" xsi:type="stringVariableType" />
							<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
								<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
								<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
							</variable>
							<variable name="ToolSettings" displayName="metadata.tool.settings" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="ToolSetting" displayName="metadata.tool.setting" xsi:type="complexVariableType" multiValue="true">
									<variable name="Name" displayName="metadata.name" xsi:type="stringVariableType" />
									<variable name="Value" displayName="metadata.value" xsi:type="stringVariableType" />
								</variable>
							</variable>
						</variable>
						<variable name="PublicationDate" displayName="metadata.creationInfo.publicationDate" xsi:type="integerVariableType"  />
						<variable name="Studio" displayName="metadata.creationInfo.studio" xsi:type="complexVariableType" >
							<variable name="DisplayName" displayName="metadata.creationInfo.studio.displayName" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="Name" displayName="metadata.creationInfo.studio.name" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOrgNameOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="Code" displayName="metadata.creationInfo.studio.code" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOrgCodeOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="RoyaltyInfo" displayName="metadata.creationInfo.studio.royalty" xsi:type="complexVariableType" showCollapsed="true" >
								<variable name="RoyaltyPercent" displayName="metadata.creationInfo.studio.royalty.percent" xsi:type="floatVariableType"  />
								<variable name="RoyaltyMinimum" displayName="metadata.creationInfo.studio.royalty.minimum" xsi:type="floatVariableType"  />
								<variable name="RoyaltyFlatRate" displayName="metadata.creationInfo.studio.royalty.flatRate" xsi:type="floatVariableType"  />
							</variable>
						</variable>
					</variable>					
					
					<!-- Description -->
					<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
						<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
						</variable>
					</variable>
					
					<!-- Duration -->
					<variable name="Duration" displayName="metadata.duration" xsi:type="complexVariableType">
						<variable name="DisplayDuration" displayName="metadata.duration.display" xsi:type="stringVariableType" />
						<variable name="StartOffset" displayName="metadata.duration.startOffset" xsi:type="timeVariableType" />
						<variable name="Duration" displayName="metadata.duration.value" xsi:type="timeVariableType" jobParameter="true" />
					</variable>
										
					<!-- ID -->
					<variable name="Identifier" displayName="metadata.identifier" xsi:type="complexVariableType">
						<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
						<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
						<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
						<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
						<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
					</variable>
											
					<!-- ProductInfo -->
					<variable name="ProductInfo" displayName="metadata.productInfo" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Name" displayName="metadata.productInfo.name" xsi:type="stringVariableType">
							<options>
								<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.ProductOptionProvider</optionProvider>
							</options>
						</variable>
					</variable>
					
					<!-- ProviderInfo -->
					<variable name="ProviderInfo" displayName="metadata.providerInfo" xsi:type="complexVariableType">
						<!-- Let's add it here, but it will be disabled in GUI. Users are not allowed to edit this value. -->
						<variable name="Name" displayName="metadata.providerInfo.name" xsi:type="stringVariableType" />
						<variable name="Identifier" displayName="metadata.providerId" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.providerId" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="ReferenceIdentifier" displayName="metadata.referenceIdentifier" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
					</variable>
					
					<!-- Version -->
					<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
						<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
						<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
						<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
					</variable>

					<!-- Video -->
					<variable name="Video" displayName="metadata.video" xsi:type="complexVariableType">
						<variable name="AspectRatio" displayName="metadata.video.aspectRatio" xsi:type="stringVariableType" />
						<variable name="ScreenFormat" displayName="metadata.video.screenFormat" xsi:type="stringVariableType" />
						<variable name="HDContent" displayName="metadata.video.hdContent" xsi:type="booleanVariableType" >
							<options>
								<option name="metadata.booleanOptionName.true">true</option>
								<option name="metadata.booleanOptionName.false">false</option>
							</options>
						</variable>
						<variable name="BitRate" displayName="metadata.video.bitrate" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="value" displayName="metadata.video.bitrate.value" xsi:type="integerVariableType" attribute="true" />
						</variable>
						<variable name="AudioInfos" displayName="metadata.audioInfo" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="AudioInfo" displayName="metadata.audioInfo" xsi:type="complexVariableType" multiValue="true">
								<variable name="ChannelCount" displayName="metadata.audioInfo.channelCount" xsi:type="integerVariableType" />
								<variable name="Preffered" displayName="metadata.audioInfo.preffered" xsi:type="stringVariableType" />
								<variable name="Value" displayName="metadata.type" xsi:type="stringVariableType" />
								<variable name="DefaultTrack" displayName="metadata.audioInfo.defaultTrack" xsi:type="booleanVariableType" />
								<variable name="ContainsDesc" displayName="metadata.audioInfo.containsDesc" xsi:type="booleanVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="PID" displayName="metadata.audioInfo.pid" xsi:type="stringVariableType" />
								<variable name="Codec" displayName="metadata.audioInfo.codec" xsi:type="stringVariableType" />
							</variable>
						</variable>
						<variable name="PrivatePid" displayName="metadata.video.privatePid" xsi:type="stringVariableType" />
						<variable name="PreEncryptionInfo" displayName="metadata.preEncryptionInfo" xsi:type="complexVariableType">
							<variable name="DerivedFrom" displayName="metadata.preEncryptionInfo.derivedFrom" xsi:type="complexVariableType" >
								<variable name="ProviderInfo" displayName="metadata.providerInfo" xsi:type="complexVariableType">
									<!-- Let's add it here, but it will be disabled in GUI. Users are not allowed to edit this value. -->
									<variable name="Name" displayName="metadata.providerInfo.name" xsi:type="stringVariableType" />
									<variable name="Identifier" displayName="metadata.providerId" xsi:type="complexVariableType">
										<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
										<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
										<variable name="Id" displayName="metadata.providerId" xsi:type="stringVariableType" />
										<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
										<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
										<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
											<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
											<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
											<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
											<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
											<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
											<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
											<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
											<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
												<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
												<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
													<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
												</variable>
											</variable>
										</variable>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="ReferenceIdentifier" displayName="metadata.referenceIdentifier" xsi:type="complexVariableType">
										<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
										<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
										<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
										<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
										<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
										<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
											<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
											<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
											<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
											<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
											<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
											<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
											<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
											<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
												<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
												<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
													<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
												</variable>
											</variable>
										</variable>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
								</variable>
								<variable name="AssetId" displayName="metadata.identifier" xsi:type="complexVariableType">
									<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
									<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
									<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
									<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
									<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>					
								<variable name="Start" displayName="metadata.start" xsi:type="timeVariableType" />
								<variable name="End" displayName="metadata.end" xsi:type="timeVariableType" />
								<variable name="AmsValidate" displayName="metadata.image.amsValidate" xsi:type="booleanVariableType" />
								<variable name="ResumeViewAllowed" displayName="metadata.image.resumeViewAllowed" xsi:type="booleanVariableType" />
								<variable name="TrickModeRestrictions" displayName="metadata.trickModeRestrictions" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="TrickModeRestriction" displayName="metadata.trickModeRestrictions" xsi:type="stringVariableType" multiValue="true"/>
								</variable>
							</variable>
							<variable name="EncryptionDate" displayName="metadata.preEncryptionInfo.encryptionDate" xsi:type="dateVariableType" />
							<variable name="FormatAuthority" displayName="metadata.preEncryptionInfo.formatAuthority" xsi:type="stringVariableType" />
							<variable name="TargetVersion" displayName="metadata.preEncryptionInfo.targetVersion" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
								<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
								<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
							</variable>
							<variable name="EncryptionInfo" displayName="metadata.encryption" xsi:type="complexVariableType" >
								<variable name="Asset" displayName="metadata.encryption.asset" xsi:type="complexVariableType">
									<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
									<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
									<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
									<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
									<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>						
								<variable name="Value" displayName="metadata.encryption.value" xsi:type="booleanVariableType" />
								<variable name="Algorithm" displayName="metadata.encryption.algorithm" xsi:type="stringVariableType" />
								<variable name="Date" displayName="metadata.encryption.date" xsi:type="dateVariableType" />
								<variable name="SystemInfo" displayName="metadata.encryption.systemInfo" xsi:type="stringVariableType" />
								<variable name="KeyBlock" displayName="metadata.encryption.keyBlock" xsi:type="stringVariableType" longFormat="true" />
								<variable name="Type" displayName="metadata.encryption.type" xsi:type="stringVariableType" />
								<variable name="Time" displayName="metadata.encryption.time" xsi:type="timeVariableType" />
								<variable name="EncryptionClass" displayName="metadata.encryption.class" xsi:type="stringVariableType" />					
							</variable>
						</variable>
						<variable name="StreamFormat" displayName="metadata.video.streamFormat" xsi:type="stringVariableType" />
						<variable name="ThreeDContent" displayName="metadata.video.3dContent" xsi:type="booleanVariableType" />
						<variable name="AVContainer" displayName="metadata.video.avContainer" xsi:type="stringVariableType" />
						<variable name="AlternateBitRateResolutionList" displayName="metadata.video.alternateBitRateResolutionList" xsi:type="complexVariableType" showCollapsed="false">
							<variable name="AlternateBitRateResolution" displayName="metadata.video.alternateBitRateResolution" xsi:type="stringVariableType" multiValue="true"/>
						</variable>	
					</variable>
					
					<!-- SubTitleLanguages -->
					<variable name="SubTitleLanguages" displayName="metadata.subtitleLanguages" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="SubTitleLanguage" displayName="metadata.subtitleLanguage" xsi:type="complexVariableType" showCollapsed="true" multiValue="true">
							<variable name="value" displayName="metadata.subtitleLanguage.name" xsi:type="stringVariableType" attribute="true"/>
						</variable>
					</variable>
					
					<!-- Languages -->
					<variable name="Languages" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true" >
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true" multiValue="true" >
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true"/>
						</variable>
					</variable>
					
					<!-- DubbedLanguages -->
					<variable name="DubbedLanguages" displayName="metadata.dubbedLanguages" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="DubbedLanguage" displayName="metadata.dubbedLanguage" xsi:type="complexVariableType" showCollapsed="true" multiValue="true">
							<variable name="value" displayName="metadata.dubbedLanguage.name" xsi:type="stringVariableType" attribute="true"/>
						</variable>
					</variable>
				</metadata>
			</title>

			<!--
				The Encrypted Title Item 
			-->
			<title>
				<name>ENCRYPTED</name>
				<alias>encrypted.sectionName</alias>
				<metadata>
					<!-- ==================== Simple Fields ====================== -->
					<variable name="AssetClass" displayName="metadata.assetClass" xsi:type="stringVariableType">
						<options>
							<option name="metadata.assetClass.optionName.encrypted">encrypted</option>
						</options>
					</variable>
					<variable name="AssetName" displayName="metadata.assetName" xsi:type="stringVariableType"/>
					<variable name="Verb" displayName="metadata.verb" xsi:type="stringVariableType" />

					<!-- ==================== Complex Fields ====================== -->
					<!-- ApplicationInfo -->					
					<variable name="ApplicationInfo" displayName="metadata.applicationInfo" xsi:type="complexVariableType" showCollapsed="true" >
						<variable name="Name" displayName="metadata.applicationInfo.name" xsi:type="stringVariableType">
							<options>
								<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.AppTypeOptionProvider</optionProvider>
							</options>	
						</variable>
					</variable>

					<!-- Content -->
					<variable name="Content" displayName="metadata.content" xsi:type="complexVariableType">
						<variable name="Expression" displayName="metadata.content.expression" xsi:type="stringVariableType"/>
						<variable name="Default" displayName="metadata.content.default" xsi:type="stringVariableType"/>
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="Size" displayName="metadata.size" xsi:type="complexVariableType" >
							<variable name="length" displayName="metadata.size.length" xsi:type="integerVariableType" />
							<variable name="height" displayName="metadata.size.height" xsi:type="integerVariableType" />
							<variable name="width" displayName="metadata.size.width" xsi:type="integerVariableType" />
						</variable>
						<variable name="Checksum" displayName="metadata.content.checkSum" xsi:type="stringVariableType" />
						<variable name="Medium" displayName="metadata.medium" xsi:type="complexVariableType" >
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
						<variable name="MIMEType" displayName="metadata.content.mimeType" xsi:type="stringVariableType"/>
						<variable name="Resolution" displayName="metadata.content.resolution" xsi:type="stringVariableType"/>
						<variable name="FrameRate" displayName="metadata.content.frameRate" xsi:type="stringVariableType"/>
						<variable name="Codec" displayName="metadata.content.codec" xsi:type="stringVariableType"/>
						<variable name="WasPitched" displayName="metadata.content.wasPitched" xsi:type="booleanVariableType"/>
						<variable name="LastPitchDate" displayName="metadata.content.lastPitchDate" xsi:type="dateVariableType"/>
						<variable name="PitchedFilename" displayName="metadata.content.pitchedFilename" xsi:type="stringVariableType"/>
						<variable name="SizeInBytes" displayName="metadata.content.sizeInBytes" xsi:type="integerVariableType"/>
						<variable name="Type" displayName="metadata.content.type" xsi:type="stringVariableType"/>
						<variable name="NetworkType" displayName="metadata.content.networkType" xsi:type="stringVariableType"/>
						<variable name="PlayReady" displayName="metadata.content.playReady" xsi:type="booleanVariableType"/>
						<variable name="WebInitiatorUrl" displayName="metadata.content.webInitiatorUri" xsi:type="stringVariableType"/>
						<variable name="LicenseServerProxyUrl" displayName="metadata.content.licenseServerProxyUrl" xsi:type="stringVariableType"/>
					</variable>

					<!-- Creation Info -->
					<variable name="CreationInfo" displayName="metadata.creationInfo" xsi:type="complexVariableType">
						<variable name="Title" displayName="metadata.title" xsi:type="complexVariableType">
							<variable name="OriginalTitle" displayName="metadata.title.original" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.original.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="DisplayTitle" displayName="metadata.title.display" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.display.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="SortTitle" displayName="metadata.title.sort" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.sort.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="ShortTitle" displayName="metadata.title.short" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.short.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
							<variable name="FeatureTitle" displayName="metadata.title.feature" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.title.feature.value" xsi:type="stringVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="maxLength" displayName="metadata.title.maxLength" xsi:type="integerVariableType" attribute="true" />			
							</variable>
						</variable>					
						<variable name="Description" displayName="metadata.description" xsi:type="stringVariableType" longFormat="true" />
						<variable name="Sources" displayName="metadata.source" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="Source" displayName="metadata.source" xsi:type="complexVariableType" multiValue="true">
								<variable name="Role" displayName="metadata.source.role" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="Name" displayName="metadata.source.role.name" xsi:type="stringVariableType">
										<options>
											<option name="metadata.source.role.name.optionName.actor">ACTOR</option>
											<option name="metadata.source.role.name.optionName.author">AUTHOR</option>
											<option name="metadata.source.role.name.optionName.creator">CREATOR</option>
											<option name="metadata.source.role.name.optionName.director">DIRECTOR</option>
											<option name="metadata.source.role.name.optionName.executiveproducer">EXECUTIVEPRODUCER</option>
											<option name="metadata.source.role.name.optionName.host">HOST</option>
											<option name="metadata.source.role.name.optionName.gueststar">GUESTSTAR</option>
											<option name="metadata.source.role.name.optionName.organization">ORGANIZATION</option>
											<option name="metadata.source.role.name.optionName.producer">PRODUCER</option>
											<option name="metadata.source.role.name.optionName.publisher">PUBLISHER</option>
											<option name="metadata.source.role.name.optionName.writer">WRITER</option>
										</options>
									</variable>
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="value" displayName="metadata.source.role.value" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="Contact" displayName="metadata.contact" xsi:type="complexVariableType">
									<variable name="FirstName" displayName="metadata.contact.firstName" xsi:type="stringVariableType" />
									<variable name="LastName" displayName="metadata.contact.lastName" xsi:type="stringVariableType" />
									<variable name="MiddleName" displayName="metadata.contact.middleName" xsi:type="stringVariableType" />
									<variable name="Email" displayName="metadata.contact.email" xsi:type="stringVariableType" />
									<variable name="Address" displayName="metadata.address" xsi:type="complexVariableType">
										<variable name="Line1" displayName="metadata.address.line1" xsi:type="stringVariableType" />
										<variable name="Line2" displayName="metadata.address.line2" xsi:type="stringVariableType" />
										<variable name="Zip" displayName="metadata.address.zip" xsi:type="stringVariableType" />
										<variable name="Place" displayName="metadata.place" xsi:type="complexVariableType" showCollapsed="true" >
											<variable name="Region" displayName="metadata.place.region" xsi:type="stringVariableType" />
											<variable name="Country" displayName="metadata.place.country" xsi:type="stringVariableType" />
											<variable name="Coordiantes" displayName="metadata.place.coordinates" xsi:type="stringVariableType" />
										</variable>
									</variable>
									<variable name="DisplayName" displayName="metadata.contact.displayName" xsi:type="stringVariableType" />
								</variable>
								<variable name="CharacterName" displayName="metadata.source.CharacterName" xsi:type="stringVariableType" />
								<variable name="Popularity" displayName="metadata.source.Popularity" xsi:type="integerVariableType" />
							</variable>
						</variable>
						<variable name="CreateDate" displayName="metadata.creationInfo.createDate" xsi:type="dateVariableType" />
						<variable name="UpdateDate" displayName="metadata.creationInfo.updateDate" xsi:type="dateVariableType" />
						<variable name="Place" displayName="metadata.creationInfo.place" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="Region" displayName="metadata.creationInfo.place.region" xsi:type="stringVariableType" />
							<variable name="Country" displayName="metadata.creationInfo.place.country" xsi:type="stringVariableType" />
							<variable name="Coordiantes" displayName="metadata.creationInfo.place.coordinates" xsi:type="stringVariableType" />
						</variable>
						<variable name="Tool" displayName="metadata.tool" xsi:type="complexVariableType" >
							<variable name="Name" displayName="metadata.creationInfo.studio.name" xsi:type="stringVariableType" />
							<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
								<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
								<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
							</variable>
							<variable name="ToolSettings" displayName="metadata.tool.settings" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="ToolSetting" displayName="metadata.tool.setting" xsi:type="complexVariableType" multiValue="true">
									<variable name="Name" displayName="metadata.name" xsi:type="stringVariableType" />
									<variable name="Value" displayName="metadata.value" xsi:type="stringVariableType" />
								</variable>
							</variable>
						</variable>
						<variable name="PublicationDate" displayName="metadata.creationInfo.publicationDate" xsi:type="integerVariableType"  />
						<variable name="Studio" displayName="metadata.creationInfo.studio" xsi:type="complexVariableType" >
							<variable name="DisplayName" displayName="metadata.creationInfo.studio.displayName" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="Name" displayName="metadata.creationInfo.studio.name" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOrgNameOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="Code" displayName="metadata.creationInfo.studio.code" xsi:type="stringVariableType">
								<options>
									<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOrgCodeOptionProvider</optionProvider>
								</options>
							</variable>
							<variable name="RoyaltyInfo" displayName="metadata.creationInfo.studio.royalty" xsi:type="complexVariableType" showCollapsed="true" >
								<variable name="RoyaltyPercent" displayName="metadata.creationInfo.studio.royalty.percent" xsi:type="floatVariableType"  />
								<variable name="RoyaltyMinimum" displayName="metadata.creationInfo.studio.royalty.minimum" xsi:type="floatVariableType"  />
								<variable name="RoyaltyFlatRate" displayName="metadata.creationInfo.studio.royalty.flatRate" xsi:type="floatVariableType"  />
							</variable>
						</variable>
					</variable>
					
					<!-- Description -->
					<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
						<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
						<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
						</variable>
					</variable>
					
					<!-- Duration -->
					<variable name="Duration" displayName="metadata.duration" xsi:type="complexVariableType">
						<variable name="DisplayDuration" displayName="metadata.duration.display" xsi:type="stringVariableType" />
						<variable name="StartOffset" displayName="metadata.duration.startOffset" xsi:type="timeVariableType" />
						<variable name="Duration" displayName="metadata.duration.value" xsi:type="timeVariableType" jobParameter="true" />
					</variable>
					
					<!-- Encryption -->
					<variable name="Encryption" displayName="metadata.encryption" xsi:type="complexVariableType" >
						<variable name="Asset" displayName="metadata.encryption.asset" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>						
						<variable name="Value" displayName="metadata.encryption.value" xsi:type="booleanVariableType" />
						<variable name="Algorithm" displayName="metadata.encryption.algorithm" xsi:type="stringVariableType" />
						<variable name="Date" displayName="metadata.encryption.date" xsi:type="dateVariableType" />
						<variable name="SystemInfo" displayName="metadata.encryption.systemInfo" xsi:type="stringVariableType" />
						<variable name="KeyBlock" displayName="metadata.encryption.keyBlock" xsi:type="stringVariableType" longFormat="true" />
						<variable name="Type" displayName="metadata.encryption.type" xsi:type="stringVariableType" />
						<variable name="Time" displayName="metadata.encryption.time" xsi:type="timeVariableType" />
						<variable name="EncryptionClass" displayName="metadata.encryption.class" xsi:type="stringVariableType" />					
					</variable>
					
					<!-- Identifier -->
					<variable name="Identifier" displayName="metadata.identifier" xsi:type="complexVariableType">
						<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
						<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
						<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
						<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
						<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
						<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
							<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
							<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
							<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
							<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
							<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
							<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
							<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
							<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
							<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
								<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
							</variable>
						</variable>
					</variable>					

					<!-- ProductInfo -->
					<variable name="ProductInfo" displayName="metadata.productInfo" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Name" displayName="metadata.productInfo.name" xsi:type="stringVariableType">
							<options>
								<optionProvider>com.tandbergtv.watchpoint.pmm.metadataconfig.ProductOptionProvider</optionProvider>
							</options>
						</variable>
					</variable>

					<!-- ProviderInfo -->
					<variable name="ProviderInfo" displayName="metadata.providerInfo" xsi:type="complexVariableType">
						<!-- Let's add it here, but it will be disabled in GUI. Users are not allowed to edit this value. -->
						<variable name="Name" displayName="metadata.providerInfo.name" xsi:type="stringVariableType" />
						<variable name="Identifier" displayName="metadata.providerId" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.providerId" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
						<variable name="ReferenceIdentifier" displayName="metadata.referenceIdentifier" xsi:type="complexVariableType">
							<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
							<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
							<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
							<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
							<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
							<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
								<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
								<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
								<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
								<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
								<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
								<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
								<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
								<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
									<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
									<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
										<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
									</variable>
								</variable>
							</variable>
							<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
								<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
							</variable>
						</variable>
					</variable>

					<!-- Derived -->
					<variable name="Derived" displayName="metadata.derived" xsi:type="complexVariableType">
						<variable name="SourceAssetId" displayName="metadata.derived.sourceassetid" xsi:type="stringVariableType" />
						<variable name="SourceProviderId" displayName="metadata.derived.sourceproviderid" xsi:type="stringVariableType" />
					</variable>

					<!-- EquipCapabilityProfileList -->
					<variable name="EquipCapabilityProfileList" displayName="metadata.equipCapabilityProfileList" xsi:type="complexVariableType" showCollapsed="false">
						<variable name="EquipCapabilityProfile" displayName="metadata.equipCapabilityProfile" xsi:type="stringVariableType" multiValue="true" />
					</variable>

					<!-- Receiver -->
					<variable name="Receiver" displayName="metadata.receiver" xsi:type="complexVariableType">
						<variable name="Type" displayName="metadata.receiver.type" xsi:type="stringVariableType"/>
						<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
							<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
							<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
							<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
						</variable>
					</variable>

					<!-- Restriction -->
					<variable name="Restriction" displayName="metadata.restriction" xsi:type="complexVariableType">
						<variable name="Roll" displayName="metadata.restriction.roll" xsi:type="stringVariableType" />
						<variable name="Content" displayName="metadata.restriction.content" xsi:type="stringVariableType" />
					</variable>

					<!-- Vendor -->
					<variable name="Vendor" displayName="metadata.vendor" xsi:type="complexVariableType">
						<variable name="Name" displayName="metadata.vendor.name" xsi:type="stringVariableType" />
						<variable name="Product" displayName="metadata.vendor.product" xsi:type="stringVariableType" />
						<variable name="ForVersion" displayName="metadata.vendor.forVersion" xsi:type="stringVariableType" />
					</variable>

					<!-- Version -->
					<variable name="Version" displayName="metadata.version" xsi:type="complexVariableType">
						<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
						<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
						<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
					</variable>

					<!-- Video -->
					<variable name="Video" displayName="metadata.video" xsi:type="complexVariableType">
						<variable name="AspectRatio" displayName="metadata.video.aspectRatio" xsi:type="stringVariableType" />
						<variable name="ScreenFormat" displayName="metadata.video.screenFormat" xsi:type="stringVariableType" />
						<variable name="HDContent" displayName="metadata.video.hdContent" xsi:type="booleanVariableType" >
							<options>
								<option name="metadata.booleanOptionName.true">true</option>
								<option name="metadata.booleanOptionName.false">false</option>
							</options>
						</variable>
						<variable name="BitRate" displayName="metadata.video.bitrate" xsi:type="complexVariableType" showCollapsed="true" >
							<variable name="value" displayName="metadata.video.bitrate.value" xsi:type="integerVariableType" attribute="true" />
						</variable>
						<variable name="AudioInfos" displayName="metadata.audioInfo" xsi:type="complexVariableType" showCollapsed="true">
							<variable name="AudioInfo" displayName="metadata.audioInfo" xsi:type="complexVariableType" multiValue="true">
								<variable name="ChannelCount" displayName="metadata.audioInfo.channelCount" xsi:type="integerVariableType" />
								<variable name="Preffered" displayName="metadata.audioInfo.preffered" xsi:type="stringVariableType" />
								<variable name="Value" displayName="metadata.type" xsi:type="stringVariableType" />
								<variable name="DefaultTrack" displayName="metadata.audioInfo.defaultTrack" xsi:type="booleanVariableType" />
								<variable name="ContainsDesc" displayName="metadata.audioInfo.containsDesc" xsi:type="booleanVariableType" />
								<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
								</variable>
								<variable name="PID" displayName="metadata.audioInfo.pid" xsi:type="stringVariableType" />
								<variable name="Codec" displayName="metadata.audioInfo.codec" xsi:type="stringVariableType" />
							</variable>
						</variable>
						<variable name="PrivatePid" displayName="metadata.video.privatePid" xsi:type="stringVariableType" />
						<variable name="PreEncryptionInfo" displayName="metadata.preEncryptionInfo" xsi:type="complexVariableType">
							<variable name="DerivedFrom" displayName="metadata.preEncryptionInfo.derivedFrom" xsi:type="complexVariableType" >
								<variable name="ProviderInfo" displayName="metadata.providerInfo" xsi:type="complexVariableType">
									<!-- Let's add it here, but it will be disabled in GUI. Users are not allowed to edit this value. -->
									<variable name="Name" displayName="metadata.providerInfo.name" xsi:type="stringVariableType" />
									<variable name="Identifier" displayName="metadata.providerId" xsi:type="complexVariableType">
										<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
										<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
										<variable name="Id" displayName="metadata.providerId" xsi:type="stringVariableType" />
										<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
										<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
										<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
											<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
											<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
											<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
											<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
											<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
											<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
											<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
											<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
												<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
												<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
													<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
												</variable>
											</variable>
										</variable>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="ReferenceIdentifier" displayName="metadata.referenceIdentifier" xsi:type="complexVariableType">
										<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
										<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
										<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
										<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
										<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
										<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType">
											<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
											<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
											<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
											<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
											<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
											<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
											<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
											<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
												<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
												<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
													<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
												</variable>
											</variable>
										</variable>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
								</variable>
								<variable name="AssetId" displayName="metadata.identifier" xsi:type="complexVariableType">
									<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
									<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
									<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
									<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
									<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>					
								<variable name="Start" displayName="metadata.start" xsi:type="timeVariableType" />
								<variable name="End" displayName="metadata.end" xsi:type="timeVariableType" />
								<variable name="AmsValidate" displayName="metadata.image.amsValidate" xsi:type="booleanVariableType" />
								<variable name="ResumeViewAllowed" displayName="metadata.image.resumeViewAllowed" xsi:type="booleanVariableType" />
								<variable name="TrickModeRestrictions" displayName="metadata.trickModeRestrictions" xsi:type="complexVariableType" showCollapsed="true">
									<variable name="TrickModeRestriction" displayName="metadata.trickModeRestrictions" xsi:type="stringVariableType" multiValue="true"/>
								</variable>
							</variable>
							<variable name="EncryptionDate" displayName="metadata.preEncryptionInfo.encryptionDate" xsi:type="dateVariableType" />
							<variable name="FormatAuthority" displayName="metadata.preEncryptionInfo.formatAuthority" xsi:type="stringVariableType" />
							<variable name="TargetVersion" displayName="metadata.preEncryptionInfo.targetVersion" xsi:type="complexVariableType">
								<variable name="Value" displayName="metadata.version.value" xsi:type="floatVariableType"/>
								<variable name="Major" displayName="metadata.version.major" xsi:type="integerVariableType"/>
								<variable name="Minor" displayName="metadata.version.minor" xsi:type="integerVariableType"/>
							</variable>
							<variable name="EncryptionInfo" displayName="metadata.encryption" xsi:type="complexVariableType" >
								<variable name="Asset" displayName="metadata.encryption.asset" xsi:type="complexVariableType">
									<variable name="PublicId" displayName="metadata.identifier.publicId" xsi:type="stringVariableType" />
									<variable name="PrivateId" displayName="metadata.identifier.privateId" xsi:type="stringVariableType" />
									<variable name="Id" displayName="metadata.identifier.id" xsi:type="stringVariableType" />
									<variable name="Organization" displayName="metadata.identifier.organization" xsi:type="stringVariableType" />
									<variable name="FieldType" displayName="metadata.identifier.fieldType" xsi:type="stringVariableType" />
									<variable name="Locator" displayName="metadata.locator" xsi:type="complexVariableType" >
										<variable name="Uri" displayName="metadata.locator.uri" xsi:type="stringVariableType"/>
										<variable name="PipUri" displayName="metadata.locator.pipUri" xsi:type="stringVariableType"/>
										<variable name="Domain" displayName="metadata.locator.domain" xsi:type="stringVariableType"/>
										<variable name="Port" displayName="metadata.locator.port" xsi:type="stringVariableType"/>
										<variable name="RegisterProcedure" displayName="metadata.locator.registerProcedure" xsi:type="stringVariableType"/>
										<variable name="Path" displayName="metadata.locator.path" xsi:type="stringVariableType"/>
										<variable name="Protocol" displayName="metadata.locator.protocol" xsi:type="stringVariableType"/>
										<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
											<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
											<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
												<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
											</variable>
										</variable>
									</variable>
									<variable name="Description" displayName="metadata.description" xsi:type="complexVariableType">
										<variable name="Text" displayName="metadata.description.text" xsi:type="stringVariableType" longFormat="true"/>
										<variable name="Language" displayName="metadata.language" xsi:type="complexVariableType" showCollapsed="true">
											<variable name="value" displayName="metadata.language.name" xsi:type="stringVariableType" attribute="true" />
										</variable>
									</variable>
								</variable>						
								<variable name="Value" displayName="metadata.encryption.value" xsi:type="booleanVariableType" />
								<variable name="Algorithm" displayName="metadata.encryption.algorithm" xsi:type="stringVariableType" />
								<variable name="Date" displayName="metadata.encryption.date" xsi:type="dateVariableType" />
								<variable name="SystemInfo" displayName="metadata.encryption.systemInfo" xsi:type="stringVariableType" />
								<variable name="KeyBlock" displayName="metadata.encryption.keyBlock" xsi:type="stringVariableType" longFormat="true" />
								<variable name="Type" displayName="metadata.encryption.type" xsi:type="stringVariableType" />
								<variable name="Time" displayName="metadata.encryption.time" xsi:type="timeVariableType" />
								<variable name="EncryptionClass" displayName="metadata.encryption.class" xsi:type="stringVariableType" />					
							</variable>
						</variable>
						<variable name="StreamFormat" displayName="metadata.video.streamFormat" xsi:type="stringVariableType" />
						<variable name="ThreeDContent" displayName="metadata.video.3dContent" xsi:type="booleanVariableType" />
						<variable name="AVContainer" displayName="metadata.video.avContainer" xsi:type="stringVariableType" />
						<variable name="AlternateBitRateResolutionList" displayName="metadata.video.alternateBitRateResolutionList" xsi:type="complexVariableType" showCollapsed="false">
							<variable name="AlternateBitRateResolution" displayName="metadata.video.alternateBitRateResolution" xsi:type="stringVariableType" multiValue="true"/>
						</variable>	
					</variable>

					<!-- Avail -->
					<variable name="Avails" displayName="metadata.avails" xsi:type="complexVariableType" showCollapsed="true">
						<variable name="Avail" displayName="metadata.avail" xsi:type="complexVariableType" multiValue="true">
							<variable name="TimeCodeOne" displayName="metadata.avail.timeCodeOne" xsi:type="timeVariableType" />
							<variable name="TimeCodeTwo" displayName="metadata.avail.timeCodeTwo" xsi:type="timeVariableType" />
							<variable name="TimeCodeThree" displayName="metadata.avail.timeCodeThree" xsi:type="timeVariableType" />
							<variable name="TimeCodeFour" displayName="metadata.avail.timeCodeFour" xsi:type="timeVariableType" />
							<variable name="Id" displayName="metadata.avail.id" xsi:type="stringVariableType" />
							<variable name="Scope" displayName="metadata.avail.scope" xsi:type="stringVariableType" />
							<variable name="Type" displayName="metadata.avail.type" xsi:type="stringVariableType" />
							<variable name="Position" displayName="metadata.avail.position" xsi:type="stringVariableType" />
						</variable>
					</variable>
				</metadata>
			</title>

		</childTitles> <!-- End of package children -->
	</title> <!-- End of package -->

	<autofillProviders>
		<provider name="autofillProviders.AssetIdGenerator" javaClass="com.tandbergtv.metadata.cablelabsvod11.ui.AssetIdGenerator" />
	</autofillProviders>

</specification>
