#!/bin/sh

[ -d ../scripts ] || {
    echo "../scripts: No such file or directory. Maybe you are not under the correct directory."
    exit 1
}
INSTALL_PYTHON_SCRIPT_PATH=`cd ../scripts; pwd`

init_script_file=/etc/profile.d/cms_python.sh
[ -e $init_script_file ] && rm -f $init_script_file

# Append $INSTALL_PYTHON_SCRIPT_PATH to PYTHONPATH
echo "[ -z \"\$PYTHONPATH\" ] && PYTHONPATH=$INSTALL_PYTHON_SCRIPT_PATH || PYTHONPATH=$INSTALL_PYTHON_SCRIPT_PATH:\$PYTHONPATH" >> $init_script_file
echo "export PYTHONPATH" >> $init_script_file

source $init_script_file

