/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.prepack.license.model;

import com.ericsson.cms.prepack.license.LicenseType;
import com.ericsson.cms.prepack.license.exception.LicenseInvalidException;
import com.ericsson.cms.prepack.license.model.Body;
import com.ericsson.cms.prepack.license.model.CapacityKey;
import com.ericsson.cms.prepack.license.model.Certificatechain;
import com.ericsson.cms.prepack.license.model.FeatureKey;
import com.ericsson.cms.prepack.license.model.PKIsignature;
import java.io.File;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@XmlRootElement(name="licFile")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class License {
    public static final String DEV_PRINT = "00000000000000000000000000000000";
    public static final String LAB_PRINT = "11111111111111111111111111111111";
    public static final String CMS3_PRINT = "22222222222222222222222222222222";
    public static final String EXPIRE_DATE_FORMAT = "yyyy-MM-dd";
    public static final String PRODUCT_TYPE_CMS3X = "CMS3.X";
    public static final String PRODUCT_TYPE_CMS40 = "CMS4.0";
    private Certificatechain certificatechain;
    @XmlElement(name="PKIsignature")
    private PKIsignature pkiSignature;
    private Body body;
    @XmlTransient
    private String bodyContent;
    @XmlTransient
    private String filePath;

    public License() {
    }

    public License(Certificatechain certificatechain, PKIsignature pkiSignature, Body body) {
        this.certificatechain = certificatechain;
        this.pkiSignature = pkiSignature;
        this.body = body;
    }

    public Certificatechain getCertificatechain() {
        return this.certificatechain;
    }

    public void setCertificatechain(Certificatechain certificatechain) {
        this.certificatechain = certificatechain;
    }

    public PKIsignature getPkiSignature() {
        return this.pkiSignature;
    }

    public void setPkiSignature(PKIsignature pkiSignature) {
        this.pkiSignature = pkiSignature;
    }

    public Body getBody() {
        return this.body;
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.bodyContent = null;
        this.filePath = filePath;
    }

    public boolean isApply4CMS3_X() {
        return PRODUCT_TYPE_CMS3X.equals(this.getBody().getSwlt().getProductType());
    }

    public LicenseType getLicenseType() {
        String print = this.getFingerprint();
        if (DEV_PRINT.equals(print) || CMS3_PRINT.equals(print)) {
            return LicenseType.DEV;
        }
        if (LAB_PRINT.equals(print)) {
            return LicenseType.LAB;
        }
        return LicenseType.PRODUCTION;
    }

    public List<FeatureKey> getFeatureKeys() {
        return this.getBody().getSwlt().getFingerprint().getFeatureKeys();
    }

    public Set<String> getFeatureIds() {
        HashSet<String> ids = new HashSet<String>();
        for (FeatureKey key : this.getFeatureKeys()) {
            ids.add(key.getId());
        }
        return ids;
    }

    public String getFingerprint() {
        return this.getBody().getSwlt().getFingerprint().getPrint();
    }

    public CapacityKey getCapacityKeyById(String id) {
        for (CapacityKey c : this.getBody().getSwlt().getFingerprint().getCapacityKeys()) {
            if (!c.getId().startsWith(id) && !c.getId().equals(id.substring(0, id.length() - 1))) continue;
            return c;
        }
        return null;
    }

    public Date getExpireDate() throws LicenseInvalidException {
        List<FeatureKey> features = this.getFeatureKeys();
        if (features != null && !features.isEmpty()) {
            String stop = features.get(0).getStop();
            if (stop == null) {
                return null;
            }
            try {
                return new SimpleDateFormat(EXPIRE_DATE_FORMAT).parse(stop);
            }
            catch (ParseException e) {
                throw new LicenseInvalidException("Expire date format is invalid," + e.getMessage(), e);
            }
        }
        return null;
    }

    public String getBodyContent() throws LicenseInvalidException {
        if (this.bodyContent == null) {
            try {
                File xmlFile = new File(this.filePath);
                DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = docBuilder.parse(xmlFile);
                XPath xPath = XPathFactory.newInstance().newXPath();
                Node bodyNode = (Node)xPath.evaluate("/licFile/body", doc, XPathConstants.NODE);
                DOMSource domSource = new DOMSource(bodyNode);
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(writer);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.transform(domSource, result);
                return writer.toString();
            }
            catch (Exception e) {
                throw new LicenseInvalidException("Failed to get license body. " + e.getMessage(), e);
            }
        }
        return this.bodyContent;
    }
}

