#!/bin/sh
#
# Copyright (c) 2013 Ericsson, Inc.  All Rights Reserved.
#
# This module contains unpublished, confidential, proprietary
# material.  The use and dissemination of this material are
# governed by a license.  The above copyright notice does not
# evidence any actual or intended publication of this material.
#
# Author: Brandon Cox
# Created: Apr 22, 2013
# Description:
# Sets up the sftpuser and chroot environment for SFTP upload from the UI.
#

echo "Configuring SFTP upload..."
JAILPATH=$1
if [ -z "$JAILPATH" ]; then
	echo "No JAILPATH passed in.  Assuming /content."
	JAILPATH=/content
else
	echo "JAILPATH is set to $JAILPATH."
fi

echo "Creating $JAILPATH/lib $JAILPATH/lib64 $JAILPATH/bin $JAILPATH/sbin $JAILPATH/usr/bin $JAILPATH/uploaded directories..."
mkdir -p $JAILPATH/lib $JAILPATH/lib64 $JAILPATH/bin $JAILPATH/sbin $JAILPATH/usr/bin $JAILPATH/uploaded

echo "Copying necessary applications into jailroot..."
APPS="/bin/bash /bin/cp /usr/bin/dircolors /bin/ls /bin/mkdir /bin/mv /bin/rm /bin/rmdir /bin/sh /bin/su /usr/bin/groups /usr/bin/id /usr/bin/rsync /usr/bin/ssh /usr/bin/scp /sbin/unix_chkpwd"
for app in $APPS; do
	cp -n $app "${JAILPATH}${app}";
done

echo "Copying libs into jailroot..."
cp -rn /lib64/* ${JAILPATH}/lib64

echo "Creating 'black hole' in jailroot..." 
mkdir -p $JAILPATH/dev
touch $JAILPATH/dev/null
chmod 0777 $JAILPATH/dev/*

echo "Creating/copying configuration files..."
mkdir -p $JAILPATH/etc
cp -rn /etc/pam.d /etc/security $JAILPATH/etc
cp -n /etc/profile /etc/login.defs $JAILPATH/etc

grep ^root /etc/passwd > $JAILPATH/etc/passwd
sed -i "s#501::/uploaded:/bin/bash#65533::$JAILPATH/uploaded:/bin/chroot-shell#" /etc/passwd
grep ^sftpuser /etc/passwd | sed "s#$JAILPATH/uploaded:/bin/chroot-shell#/uploaded:/bin/sh#" >> $JAILPATH/etc/passwd

grep ^root /etc/group > $JAILPATH/etc/group
grep ^users /etc/group  >> $JAILPATH/etc/group
grep ^nobody /etc/group >> $JAILPATH/etc/group
grep ^nfsnobody /etc/group  >> $JAILPATH/etc/group
sed -i 's/sftpuser:x:501:/sftpuser:x:65533:/' /etc/group
grep ^sftpuser /etc/group >> $JAILPATH/etc/group

grep ^sftpuser /etc/shadow > $JAILPATH/etc/shadow


grep -e "^\s*Chroot" /etc/ssh/sshd_config > /dev/null 2>&1
if [ "$?" -eq "0" ]; then
	echo "Copying out bad line in sshd_config and restarting sshd service..."
	sed -r -i -e 's/^(\s)\1+ChrootDirectory/#\1ChrootDirectory/g' /etc/ssh/sshd_config
	service sshd restart
fi

if [ ! -f "/bin/chroot-shell" ]; then
	echo "Creating /bin/chroot-shell file..."
	echo '#!/bin/sh' > /bin/chroot-shell
	echo "umask 0002" >> /bin/chroot-shell
	echo "`which sudo` `which chroot` $JAILPATH /bin/su - \$USER" \"\$@\" >> /bin/chroot-shell
	chmod 755 /bin/chroot-shell
fi

grep sftpuser /etc/sudoers > /dev/null 2>&1
if [ ! "$?" -eq "0" ]; then
	if [ -f "/etc/sudoers.tmp" ]; then
		echo "/etc/sudoers.tmp file already exists.  Either someone is modifying /etc/sudoers or this finally needs to be removed manually..."
		echo "Exiting with error code 1."
		exit 1;
	fi
	echo "Adding sftpuser entry into /etc/sudoers..."
   	touch /etc/sudoers.tmp
	cp /etc/sudoers /tmp/sudoers.new
	echo -e "\n\nsftpuser     ALL=NOPASSWD: /usr/sbin/chroot, /bin/su - sftpuser, /usr/sbin/chroot $JAILROOT /bin/su - sftpuser\n" >> /tmp/sudoers.new
	visudo -c -f /tmp/sudoers.new
	if [ "$?" -eq "0" ]; then
		cp /tmp/sudoers.new /etc/sudoers;
	fi
	rm -f /etc/sudoers.tmp
fi

echo "SFTP upload configuration complete."