import unittest
import os
import json
from Monitor import FileMonitor, DataMonitor
from Monitor import FileExculdeDifferentSet
from Monitor import DbItemExcludeDifferentSet
from UnittestBase import UnittestBase

class MonitorTest(UnittestBase):
    def _testExportMd5OfImportedTemplates(self):
        jsonFilePath = '/tmp/test-cms_imported_templates_info.json'
        FileMonitor.exportMd5OfImportedTemplates(jsonFilePath)
        self.assertTrue(os.path.isfile(jsonFilePath))
        
        json_data = open(jsonFilePath)
        org_data = json.load(json_data)
        org_files_md5 = org_data['filesMD5']
        org_directory = org_data['directory']
        org_excludefilters = org_data['excludeFilters']
        json_data.close()
        
        self.assertEqual(org_directory, '/opt/tandbergtv/cms/workflow/imported')
        self.assertEqual(org_excludefilters, ["*.par"])
    
    def _testCompareImportedTemplates(self):
        jsonFilePath = '/tmp/test-cms_imported_templates_info.json'
        FileMonitor.compareImportedTemplates(jsonFilePath)
        self.assertTrue(True)  # should go here without Exception
        
    def testFileSetSolveDifferentWithNoDifferences(self):
        new_files = []
        del_files = []
        upd_files = []
        fileExcludeDifferentSet=FileExculdeDifferentSet()
        self.assertFalse(fileExcludeDifferentSet.solveDifferentWithExcludeSet(new_files, del_files, upd_files))
        
    def testFileSetSolveDifferentWithDifferencesButNoExculdeSet(self):
        new_files = ["/opt/tandbergtv/cms/workflow/plugins/subsystems/Baton/abc.txt"]
        del_files = []
        upd_files = []
        fileExcludeDifferentSet=FileExculdeDifferentSet()
        self.assertTrue(fileExcludeDifferentSet.solveDifferentWithExcludeSet(new_files, del_files, upd_files))
        
    def testFileSetSolveDifferentWithNoDifferencesByExculdeSet(self):
        new_files = ["/opt/tandbergtv/cms/workflow/plugins/subsystems/Baton/abc.txt"]
        del_files = []
        upd_files = ["/opt/tandbergtv/cms/workflow/plugins/subsystems/Cerify/abc.txt"]
        config = {
            "UPD":[
                "/opt/tandbergtv/cms/workflow/plugins/subsystems/Cerify/*"
            ],
            "NEW":[
                "/opt/tandbergtv/cms/workflow/plugins/subsystems/Baton/abc.txt"
            ]
        }
        fileExcludeDifferentSet=FileExculdeDifferentSet(config)
        self.assertFalse(fileExcludeDifferentSet.solveDifferentWithExcludeSet(new_files, del_files, upd_files))
        
    def testFileSetSolveDifferentWithDifferencesAndExculdeSet(self):
        new_files = ["/opt/tandbergtv/cms/workflow/plugins/subsystems/Baton/abc.txt"]
        del_files = []
        upd_files = ["/opt/tandbergtv/cms/workflow/plugins/subsystems/Cerify/abc.txt", "/opt/tandbergtv/cms/workflow/plugins/subsystems/Baton/abc1.txt"]
        config = {
            "UPD":[
                "/opt/tandbergtv/cms/workflow/plugins/subsystems/Cerify/*"
            ],
            "NEW":[
                "/opt/tandbergtv/cms/workflow/plugins/subsystems/Baton/abc.txt"
            ]
        }
        fileExcludeDifferentSet=FileExculdeDifferentSet(config)
        self.assertTrue(fileExcludeDifferentSet.solveDifferentWithExcludeSet(new_files, del_files, upd_files))
        
    def testDbItemSetSolveDifferentWithNoDifferences(self):
        new_ids = []
        del_ids = []
        upd_ids = []
        dbItemExcludeDifferentSet=DbItemExcludeDifferentSet()
        self.assertFalse(dbItemExcludeDifferentSet.solveDifferentWithExcludeSet("", new_ids, del_ids, upd_ids))
        
    def testDbItemSetSolveDifferentWithDifferencesButNoExculdeSet(self):
        new_ids = [DataMonitor.ID_DELIMETER.join(["1","2"])]
        del_ids = []
        upd_ids = []
        dbItemExcludeDifferentSet=DbItemExcludeDifferentSet()
        self.assertTrue(dbItemExcludeDifferentSet.solveDifferentWithExcludeSet("RESOURCE_GROUP", new_ids, del_ids, upd_ids))
        
    def testDbItemSetSolveDifferentWithNoDifferencesByExculdeSet(self):
        new_ids = [DataMonitor.ID_DELIMETER.join(["1","2"])]
        del_ids = [DataMonitor.ID_DELIMETER.join(["3","4"])]
        upd_ids = []
        config = {
            "NEW":[
                {"TABLE":"RESOURCE_GROUP","ID_COLUMN_VALUES":["1","2"]}
            ],
            "DEL":[
                {"TABLE":"RESOURCE_GROUP","ID_COLUMN_VALUES":["3","4"]}
            ]
        }
        dbItemExcludeDifferentSet=DbItemExcludeDifferentSet(config)
        self.assertFalse(dbItemExcludeDifferentSet.solveDifferentWithExcludeSet("RESOURCE_GROUP", new_ids, del_ids, upd_ids))
        
    def testDbItemSetSolveDifferentWithDifferencesAndExculdeSet(self):
        new_ids = [DataMonitor.ID_DELIMETER.join(["1","2"])]
        del_ids = [DataMonitor.ID_DELIMETER.join(["3","4"])]
        upd_ids = [DataMonitor.ID_DELIMETER.join(["6","7"])]
        config = {
            "NEW":[
                {"TABLE":"RESOURCE_GROUP","ID_COLUMN_VALUES":["1","2"]}
            ],
            "DEL":[
                {"TABLE":"RESOURCE_GROUP","ID_COLUMN_VALUES":["3","4"]}
            ],
            "UPD":[
                {"TABLE":"RESOURCE_GROUP_1","ID_COLUMN_VALUES":["5","6"]}
            ]
        }
        dbItemExcludeDifferentSet=DbItemExcludeDifferentSet(config)
        self.assertTrue(dbItemExcludeDifferentSet.solveDifferentWithExcludeSet("RESOURCE_GROUP", new_ids, del_ids, upd_ids))
if __name__ == "__main__":
    unittest.main()